/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/****************************************************************************
                  INTERNATIONAL AVS CENTER
        (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

 AUTHOR : Lawrence Berkeley Laboratory
******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce write_reg.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  write_reg.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  write_reg.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     write_reg.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
write_reg.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>

AVSinit_modules()
{
    int write_reg();
    AVSmodule_from_desc(write_reg);
}

write_reg()
{
    int write_reg_f();
    int p;

    AVSset_module_name("write reg",MODULE_RENDER);
    AVScreate_input_port("Input","field uniform",REQUIRED);
    p = AVSadd_parameter("File Name","string",NULL,NULL,NULL);
    AVSconnect_widget(p,"browser");
    AVSset_compute_proc(write_reg_f);
}

write_reg_f(fld,fn)
AVSfield *fld;
char *fn;
{
    FILE *f;
    int i,j,k,vecl,npts,nspace;
    float *data,**pts;
    
    if (fn == NULL || *fn == '\0')
	return(0);
    if (!AVSparameter_changed("File Name"))
	return(0);
    if ((f=fopen(fn,"w"))==NULL)
    {
	AVSwarning(" can't open file name <%s>.",fn);
	return(0);
    }

    /* do error checking on field structure . */
    if (fld->uniform != UNIFORM)
    {
	AVSwarning(" field is not an regular field.\n");
	return(0);
    }
    if (fld->type != AVS_TYPE_REAL)
    {
	AVSwarning(" input field must be in FLOAT format.\n");
	return(0);
    }
    
    /* write out header info. */
    nspace = fld->nspace;
/*    fprintf(f,"%d\n",fld->nspace);  /* num coord dims */
    fprintf(f,"%d\n",fld->ndim);    /* num data dims. */
    for (npts=1,i=0;i<fld->ndim;i++)
    {
	npts *= fld->dimensions[i];
	fprintf(f,"%d\n",fld->dimensions[i]); /* length of each data dim. */
    }
    vecl = fld->veclen;
    fprintf(f,"%d\n",vecl); /* data vector length */

    pts = (float **)malloc(sizeof(float *)*nspace);  /* array of float ptrs */
    for (i=0;i<nspace;i++)
	*(pts+i) = fld->points + (i*npts);
    
    data = fld->field_data_float;
    for (i=0;i<npts;i++)
    {
	
#if 0
	/* write out coord info. */
	for (j=0;j<nspace;j++)
	{
	    fprintf(f," %f ",*(*(pts+j)+i));
	}
#endif
	
	/* write out data */
	for(j=0;j<vecl;j++)
	    fprintf(f," %f ",*data++);

	fprintf(f,"\n");
    }
    fclose(f);
    return(1);
}
