#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int vand_desc ()
{
   int in_port, out_port, param;
   extern int vand_compute();

   AVSset_module_name("vand",MODULE_FILTER);

   AVScreate_input_port("Input Image #1","field 2D",REQUIRED);
   AVScreate_input_port("Input Image #2","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");

   AVSset_compute_proc(vand_compute);
   return(1);
}

int vlshift_desc ()
{
   int in_port, out_port, param;
   extern int vlshift_compute();

   AVSset_module_name("vlshift",MODULE_FILTER);

   AVScreate_input_port("Input Image   ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");
   AVScreate_input_port("Masking Image ","field 2D",OPTIONAL);
   AVSadd_parameter("shift","integer",1,0,32);

   AVSset_compute_proc(vlshift_compute);
   return(1);
}

int vor_desc ()
{
   int in_port, out_port, param;
   extern int vor_compute();

   AVSset_module_name("vor",MODULE_FILTER);

   AVScreate_input_port("Input Image #1","field 2D",REQUIRED);
   AVScreate_input_port("Input Image #2","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");

   AVSset_compute_proc(vor_compute);
   return(1);
}

int vreplace_desc ()
{
   int in_port, out_port, param;
   extern int vreplace_compute();

   AVSset_module_name("vreplace",MODULE_FILTER);

   AVScreate_input_port("Input Image #1","field 2D",REQUIRED);
   AVScreate_input_port("Input Image #2","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");
   AVScreate_input_port("Masking Image ","field 2D",REQUIRED);

   AVSset_compute_proc(vreplace_compute);
   return(1);
}

int vrshift_desc ()
{
   int in_port, out_port, param;
   extern int vrshift_compute();

   AVSset_module_name("vrshift",MODULE_FILTER);

   AVScreate_input_port("Input Image   ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");
   AVScreate_input_port("Masking Image ","field 2D",OPTIONAL);
   AVSadd_parameter("shift","integer",1,0,32);

   AVSset_compute_proc(vrshift_compute);
   return(1);
}

int vxor_desc ()
{
   int in_port, out_port, param;
   extern int vxor_compute();

   AVSset_module_name("vxor",MODULE_FILTER);

   AVScreate_input_port("Input Image #1","field 2D",REQUIRED);
   AVScreate_input_port("Input Image #2","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");

   AVSset_compute_proc(vxor_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int vand_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvand(ki1,ki2);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vlshift_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,int param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ki2;
   char *program="vlshift";
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
   {
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
        (void) match_num_images(program,ki1,ki2,TRUE); 
        (void) match_num_bands(program,ki1,ki2,TRUE); 
        (void) match_map_enable(program,ki1,ki2,TRUE); 
        (void) matchsize(program,ki1,ki2,TRUE); 
        (void) matchtype(program,ki1,ki2,TRUE);
   }


   value=(int)lvlshift(ki1,ki2,MAP(ki2),param1);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vor_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvor(ki1,ki2);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vreplace_compute (AVSfield *i1,AVSfield *i2,AVSfield *i3,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
   struct xvimage *ki3;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i3)
      if ((ki3=(struct xvimage *)field_to_viff(i3))==NULL) return(0);

   value=(int)lvreplace(ki1,ki2,ki3);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vrshift_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,int param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ki2;
   char *program="vrshift";
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   (void) proper_num_images(program,ki1,1,TRUE); 
   (void) proper_map_enable(program,ki1,VFF_MAP_OPTIONAL,TRUE);

   if (i2)
   {
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
      (void) match_num_images(program,ki1,ki2,TRUE); 
      (void) match_num_bands(program,ki1,ki2,TRUE); 
      (void) match_map_enable(program,ki1,ki2,TRUE); 
      (void) matchsize(program,ki1,ki2,TRUE); 
      (void) matchtype(program,ki1,ki2,TRUE);
   }

   value=(int)lvrshift(ki1,ki2,MAP(ki2),param1);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vxor_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvxor(ki1,ki2);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   vand_desc,
   vlshift_desc,
   vor_desc,
   vreplace_desc,
   vrshift_desc,
   vxor_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

