 /*
  * Khoros: $Id: lvoffset.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvoffset.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvoffset.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvoffset.c
 >>>>
 >>>>      Program Name: voffset
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:59:13 1991 
 >>>>
 >>>>          Routines: lvoffset - the library call for voffset
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvoffset - library call for voffset
*
* Purpose:
*    
*    Add a specified offset to each pixel in the input image.
*    
*    
* Input:
*    
*         1. img1 -- input xvimage structure
*         2. img2 -- mask image, xvimage structure
*         3. mflg -- if set, use img2 as a mask image
*         4. offset -- the amount to add to each pixel in img1
*    
*         The inputs must be of the same data type and size.
*    
*    
* Output:
*    
*         1. img1 -- output xvimage structure img1 is  used  for  both
*         the  input  xvimage  structure and the output result xvimage
*         structure.  This is done to save  space,  but  you  must  be
*         careful not to overwrite important data.
*         lvoffset returns a zero upon failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Marcelo Teran, John Rasure, Tom Sauer
*    
*    26-Feb-91 Jeremy Worley added  processing  for  double  precision
*    data sets.
*    
*    
****************************************************************/


extern float offset_param;

/* -library_def */
int
lvoffset(img1,img2,mflg)
struct xvimage *img1,*img2;
int  mflg;
/* -library_def_end */

/* -library_code */
{
    float  offset=offset_param;
    int    i, j, k;
    int    *i1,*i2;
    short  *s1,*s2;
    float  *f1,*f2;
    double *d1,*d2;
    unsigned char *c1,*c2;

    k = img1->row_size*img1->col_size*img1->num_data_bands;          /* Normal operation count */
    switch (img1->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvoffset: Don't know how to offset a BIT image!\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          c1 = (unsigned char *)(img1->imagedata);
          if (mflg) c2 = (unsigned char *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  i = *c1 + offset;
                  if (i > 255) i = 255;
                  else if (i < 0) i = 0;
                  *c1++ = i;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*c2++)
                    {
                      i = *c1 + offset;
                      if (i > 255) i = 255;
                      else if ( i < 0)  i = 0;
                      *c1++ = i;
                    }
                  else c1++;
                }
            }
          break;
        case VFF_TYP_2_BYTE :
          s1 = (short *)(img1->imagedata);
          if (mflg) s2 = (short *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) 
	      {
		*s1 += offset;
		s1++;
	      }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*s2++) *s1 += offset;
                  s1++;
                }
            }
          break;
        case VFF_TYP_4_BYTE :
          i1 = (int *)(img1->imagedata);
          if (mflg) i2 = (int *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) 
	      {
		*i1 += offset;
		i1++;
              }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*i2++) *i1 += offset;
                  i1++;
                }
            }
          break;
        case VFF_TYP_FLOAT :
          f1 = (float *)(img1->imagedata);
          if (mflg) f2 = (float *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) 
	      {
		*f1 += offset;
		f1++;
	      }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*f2++) *f1 += offset;
                  f1++;
                }
            }
          break;
        case VFF_TYP_DOUBLE :
          d1 = (double *)(img1->imagedata);
          if (mflg) d2 = (double *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) 
	      {
		*d1 += (double)offset;
		d1++;
	      }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*d2++) *d1 += (double)offset;
                  d1++;
                }
            }
          break;
        case VFF_TYP_COMPLEX :
        case VFF_TYP_DCOMPLEX :
          fprintf(stderr,"lvoffset: Don't know how to offset a COMPLEX image!\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvoffset: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      return(1);
}
/* -library_code_end */
