#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int lrfclass_desc ()
{
   int in_port, out_port, param;
   extern int lrfclass_compute();

   AVSset_module_name("lrfclass",MODULE_FILTER);

   AVScreate_input_port("Input image","field 2D",REQUIRED);
   AVScreate_input_port("Cluster Center image  ","field 2D",REQUIRED);
   AVScreate_input_port("Cluster Variance image","field 2D",REQUIRED);
   AVScreate_input_port("Weight image","field 2D",REQUIRED);
   AVScreate_output_port("Classified image","field 2D");
   AVSadd_parameter("border width","integer",0,0,100);

   AVSset_compute_proc(lrfclass_compute);
   return(1);
}

int lrftrain_desc ()
{
   int in_port, out_port, param;
   extern int lrftrain_compute();

   AVSset_module_name("lrftrain",MODULE_FILTER);

   AVScreate_input_port("Input image","field 2D",REQUIRED);
   AVScreate_input_port("cluster center image  ","field 2D",REQUIRED);
   AVScreate_input_port("cluster variance image","field 2D",REQUIRED);
   AVScreate_input_port("cluster number image  ","field 2D",REQUIRED);
   AVScreate_output_port("weight image","field 2D");

   param=AVSadd_parameter("training statistics","string",NULL,NULL,NULL);
   AVSconnect_widget(param,"file_browser");

   AVSadd_parameter("MSE interval","integer",0,0,10000);
   AVSadd_float_parameter("convergence",2.000000,0.100000,2.000000);
   AVSadd_float_parameter("weight update",0.500000,0.000000,1.000000);
   AVSadd_parameter("max iterations","integer",2,2,10000);
   AVSadd_float_parameter("Min delta MSE",2.0,0.0,1000000.0);
   AVSadd_parameter("Border Width","integer",0,0,100);

   AVSset_compute_proc(lrftrain_compute);
   return(1);
}

int viso2_desc ()
{
   int in_port, out_port, param;
   extern int viso2_compute();

   AVSset_module_name("viso2",MODULE_FILTER);

   AVScreate_input_port("Input Image","field 2D",REQUIRED);
   AVScreate_input_port("Input CC Image","field 2D",OPTIONAL);

   AVScreate_output_port("Output VCC Image","field 2D");
   AVScreate_output_port("Output CC Image","field 2D");
   AVScreate_output_port("Output Variance Image","field 2D");

   param=AVSadd_parameter("Kmeans Statistics","string",NULL,NULL,NULL);
   AVSconnect_widget(param,"file_browser");

   ISLIDE(AVSadd_parameter("min samples/cluster","integer",1,0,1000));
   SLIDE(AVSadd_float_parameter("splitting factor",10000.0,0.0,10000.0));
   SLIDE(AVSadd_float_parameter("merging factor",0.0,0.0,10000.0));
   ISLIDE(AVSadd_parameter("max cl allowed","integer",5,0,10000));
   ISLIDE(AVSadd_parameter("init clusters","integer",5,0,10000));
   ISLIDE(AVSadd_parameter("iter for kmeans","integer",1,1,10000));
   ISLIDE(AVSadd_parameter("iter for iso2","integer",1,1,10000));
   ISLIDE(AVSadd_parameter("border width","integer",0,0,10000));
   SLIDE(AVSadd_float_parameter("placement",0.0,0.0,10000.0));
   SLIDE(AVSadd_float_parameter("split converge",1.0,0.0,10000.0));
   SLIDE(AVSadd_float_parameter("merge converge",1.0,0.0,10000.0));

/* Forcing Cluster Centers to come from images */

   AVSset_compute_proc(viso2_compute);
   return(1);
}

int vkmeans_desc ()
{
   int in_port, out_port, param;
   extern int vkmeans_compute();

   AVSset_module_name("vkmeans",MODULE_FILTER);

   AVScreate_input_port("Input Image","field 2D",REQUIRED);
   AVScreate_output_port("Cluster Image","field 2D");
   AVScreate_output_port("CC Image","field 2D");
   AVScreate_output_port("CV Image","field 2D");

   param=AVSadd_parameter("kmeans statistics","string",NULL,NULL,NULL);
   AVSconnect_widget(param,"file_browser");

   AVSadd_parameter("max iterate","integer",100000,1,100000);
   AVSadd_parameter("num clusters","integer",2,0,1000000);
   AVSadd_parameter("border width","integer",0,0,1000000);

   AVSset_compute_proc(vkmeans_compute);
   return(1);
}

int vlabel_desc ()
{
   int in_port, out_port, param;
   extern int vlabel_compute();

   AVSset_module_name("vlabel",MODULE_FILTER);

   AVScreate_input_port("Initial Image","field 2D",OPTIONAL);
   AVScreate_input_port("Cluster Center Image","field 2D",OPTIONAL);
   AVScreate_input_port("Cluster Number Image","field 2D",OPTIONAL);
   AVScreate_output_port("Output Labelled Image","field 2D");

   AVSadd_parameter("merge","boolean",0,0,1);

   AVSadd_parameter("distance","choice","Euclidean","Euclidean|City Block","|");
   AVSadd_parameter("connectivity","choice","4 connectivity","4 connectivity|8 connectivity","|");

   ISLIDE(AVSadd_parameter("num regions","integer",2,2,2500));
   SLIDE(AVSadd_float_parameter("Fineness Factor",0.0,0.0,1.0));

   ADD_FILE;

   ISLIDE(AVSadd_parameter("border width","integer",0,0,1000));
   SLIDE(AVSadd_float_parameter("label min pixels",0.0,0.0,100.0));

   AVSadd_parameter("Converge","boolean",0,0,1);
   AVSadd_parameter("typ","choice","multi-mono","multi-mono|cluster|m/m & clust","|");

   AVSset_compute_proc(vlabel_compute);
   return(1);
}

int vmindis_desc ()
{
   int in_port, out_port, param;
   extern int vmindis_compute();

   AVSset_module_name("vmindis",MODULE_FILTER);

   AVScreate_input_port("Input Image             ","field 2D",REQUIRED);
   AVScreate_input_port("Input Center/Class Image","field 2D",REQUIRED);
   AVScreate_output_port("Output Classified Image ","field 2D");
   AVSadd_parameter("border width","integer",0,0,100);

   AVSset_compute_proc(vmindis_compute);
   return(1);
}

int vqerr_desc ()
{
   int in_port, out_port, param;
   extern int vqerr_compute();

   AVSset_module_name("vqerr",MODULE_FILTER);

   AVScreate_input_port("Quantized image","field 2D",REQUIRED);
   AVScreate_input_port("Original image","field 2D",REQUIRED);
   AVScreate_input_port("Masking Image","field 2D",OPTIONAL);

   param=AVSadd_parameter("rms","string",NULL,NULL,NULL);
   AVSconnect_widget(param,"string_block");

   AVSset_compute_proc(vqerr_compute);
   return(1);
}

int vquant_desc ()
{
   int in_port, out_port, param;
   extern int vquant_compute();

   AVSset_module_name("vquant",MODULE_FILTER);

   AVScreate_input_port("Input Image   ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");
   AVScreate_output_port("CC Output Image","field 2D");
   AVScreate_output_port("CV Output Image","field 2D");
   AVSadd_parameter("Vectors","integer",1,1,1000);
   AVSadd_parameter("sp","choice","mid-span","mid-span|mean","|");
   AVSadd_parameter("split-axis","choice","max-span",
	"max-span|max-variance|princ eigen","|");
   AVSset_compute_proc(vquant_compute);
   return(1);
}

int vwmdd_desc ()
{
   int in_port, out_port, param;
   extern int vwmdd_compute();

   AVSset_module_name("vwmdd",MODULE_FILTER);

   AVScreate_input_port("Input Image             ","field 2D",REQUIRED);
   AVScreate_input_port("Input Center/Class Image","field 2D",REQUIRED);
   AVScreate_input_port("Input Variance Image    ","field 2D",REQUIRED);
   AVScreate_output_port("Output Classified Image ","field 2D");
   AVSadd_float_parameter("scaling factor",1.0,0.0,1000000.0);
   AVSadd_parameter("border width","integer",0,0,100);
   AVSadd_parameter("Summed Method","boolean",0,0,1);

   AVSset_compute_proc(vwmdd_compute);
   return(1);
}


/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int lrfclass_compute (AVSfield *i1,AVSfield *i2,AVSfield *i3,AVSfield *i4,
			AVSfield **o1,int param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ki3;
   struct xvimage *ki4;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i3)
      if ((ki3=(struct xvimage *)field_to_viff(i3))==NULL) return(0);
   if (i4)
      if ((ki4=(struct xvimage *)field_to_viff(i4))==NULL) return(0);

   value=(int)llrfclass(ki1,ki2,ki3,ki4,&ko1,param1);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int lrftrain_compute (AVSfield *i1,AVSfield *i2,
			AVSfield *i3,AVSfield *i4,
			AVSfield **o1,int param1,char *stats,
			int param2,float *param3,float *param4,
			int param5,float *param6,int param7)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ki3;
   struct xvimage *ki4;
   struct xvimage *ko1;
   struct xvimage *ko2;
 
   FILE *fp;

   FILE_OPEN(fp,stats);

   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i3)
      if ((ki3=(struct xvimage *)field_to_viff(i3))==NULL) return(0);
   if (i4)
      if ((ki4=(struct xvimage *)field_to_viff(i4))==NULL) return(0);

   value=(int)llrftrain(ki1,ki2,ki3,ki4,&ko1,*param3,*param4,param7,
			param5,param2,*param6,fp);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);

   FILE_CLOSE(fp,stats)

   return (value);
}
 
int viso2_compute (AVSfield *i1,AVSfield *i2, AVSfield **o1,AVSfield **o2,AVSfield **o3, char *stats, int param1, float *param2,float *param3, int param4,int param5, int param6,int param7,int param8, float *param9,float *param10,float *param11)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
   struct xvimage *ko2;
   struct xvimage *ko3;
 
   FILE *fp;

   FILE_OPEN(fp,stats)

   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lviso2(ki1,&ko2,&ko3,param1,
		param5,param4,
		*param2,*param3,
	 	*param9,*param10,*param11,	
		param6,param7,
		param8,
		NULL,
		1,ki2,fp);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
   if (((*o3)=(AVSfield *)viff_to_field(ko3))==NULL) return (0);
 
   FILE_CLOSE(fp,stats)

   return (value);
}
 
int vkmeans_compute (	AVSfield *i1,
			AVSfield **o1,AVSfield **o2,AVSfield **o3,
			char *stats,
			int param1,int param2,int param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ko2;
   struct xvimage *ko3;
 
   FILE *fp;

   FILE_OPEN(fp,stats)

   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvkmeans(ki1,ko1,1,ko2,1,param2,param1,param3,NULL,fp,1,0,ko3);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
   if (((*o3)=(AVSfield *)viff_to_field(ko3))==NULL) return (0);
 
   FILE_CLOSE(fp,stats)

   return (value);
}
 
int vlabel_compute (	AVSfield *i1,AVSfield *i2,AVSfield *i3,
			AVSfield **o1,
			int merge,
			char *param2,char *param3,
			int reg_num,float *split,char *results,
			int bord,float *surf,int opt_auto,
			char *tmp)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ki3;
   struct xvimage *ko1;
 
   FILE *fp;

   FILE_OPEN(fp,results);

   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i3)
      if ((ki3=(struct xvimage *)field_to_viff(i3))==NULL) return(0);

   value=(int)lvlabel(ki1,ki2,ki3,
			AVSchoice_number("typ"),
			AVSchoice_number("distance")+1,
			AVSchoice_number("connectivity")+1,
			bord,
			ko1,
			*surf,
			opt_auto,
			reg_num,
			*split,
			merge,
			fp);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   FILE_CLOSE(fp,results);

   return (value);
}
 
int vmindis_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,int param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvmindis(ki1,ki2,param1);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vqerr_compute (AVSfield *i1,AVSfield *i2,AVSfield *i3,char *o1)
{
   int value;
   double ko1;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ki3;
   char string[10];
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i3)
      if ((ki3=(struct xvimage *)field_to_viff(i3))==NULL) return(0);

   value=(int)lvqerr(ki1,ki2,ki3,MAP(ki3),&ko1);
 
   sprintf(string,"%f",(float)ko1);

   AVSmodify_parameter("rms",AVS_VALUE,string,NULL,NULL);
   return (value);
}
 
int vquant_compute (AVSfield *i1,AVSfield **o1,AVSfield **o2,AVSfield **o3,int vectors,char *sp,char *axis)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ko2;
   struct xvimage *ko3;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvquant(ki1,vectors,0,&ko2,1,&ko3,1,AVSchoice_number("sp"),
	AVSchoice_number("split-axis"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
   if (((*o3)=(AVSfield *)viff_to_field(ko3))==NULL) return (0);
 
   return (value);
}
 
int vwmdd_compute (AVSfield *i1,AVSfield *i2,AVSfield *i3,AVSfield **o1,float *param1,int param2,int param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ki3;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i3)
      if ((ki3=(struct xvimage *)field_to_viff(i3))==NULL) return(0);

   value=(int)lvwmdd(ki1,ki2,ki3,param2,param3,*param1);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   lrfclass_desc,
   lrftrain_desc,
   vkmeans_desc,
   vlabel_desc,
   vmindis_desc,
   vqerr_desc,
   vquant_desc,
   viso2_desc,
   vwmdd_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}
