#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int band2vect_desc ()
{
   int in_port, out_port, param;
   extern int band2vect_compute();

   AVSset_module_name("band2vect",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");

   AVSset_compute_proc(band2vect_compute);
   return(1);
}

int vbandcomb_desc ()
{
   int in_port, out_port, param;
   extern int vbandcomb_compute();

   AVSset_module_name("vbandcomb",MODULE_FILTER);

   AVScreate_input_port("Input Image 1","field 2D",REQUIRED);
   AVScreate_input_port("Input Image 2","field 2D",REQUIRED);
   AVScreate_input_port("Input Image 3","field 2D",OPTIONAL);
   AVScreate_input_port("Input Image 4","field 2D",OPTIONAL);
   AVScreate_input_port("Input Image 5","field 2D",OPTIONAL);
   AVScreate_input_port("Input Image 6","field 2D",OPTIONAL);
   AVScreate_input_port("Input Image 7","field 2D",OPTIONAL);
   AVScreate_input_port("Input Image 8","field 2D",OPTIONAL);
   AVScreate_input_port("Input Image 9","field 2D",OPTIONAL);
   AVScreate_input_port("Input Image 10","field 2D",OPTIONAL);
   AVScreate_output_port("Output Image ","field 2D");

/* khoros to avs currently ignores maps !! */
/* AVSadd_parameter("ignore maps","integer",0,0,0); */
/* AVSadd_parameter("map data through map","integer",0,0,0); */
/* AVSadd_parameter("transfer maps","integer",0,0,0); */

   AVSadd_parameter("color","choice","None",
"ntscRGB,ntscCMY,ntscYIQ,HSV,HLS,IHS,cieRGB,cieXYZ,cieUVW,cieucsUVW,cieucsSOW,cieucsLab,cieucsLuv,GENERIC,genericRGB",",");

   AVSset_compute_proc(vbandcomb_compute);
   return(1);
}

int vbandspt1_desc ()
{
   int in_port, out_port, param;
   extern int vbandspt1_compute();

   AVSset_module_name("vbandspt1",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("extract band","integer",1,1,1000);

   AVSset_compute_proc(vbandspt1_compute);
   return(1);
}

int vbandspt3_desc ()
{
   int in_port, out_port, param;
   extern int vbandspt3_compute();

   AVSset_module_name("vbandspt3",MODULE_FILTER);

   AVScreate_input_port("Input Image      ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image 1","field 2D");
   AVScreate_output_port("Output Image 2","field 2D");
   AVScreate_output_port("Output Image 3","field 2D");
   AVSadd_parameter("extract band","integer",1,INT_UNBOUND,INT_UNBOUND);

   AVSset_compute_proc(vbandspt3_compute);
   return(1);
}

int vcast_desc ()
{
   int in_port, out_port, param;
   extern int vcast_compute();

   AVSset_module_name("vcast",MODULE_FILTER);

   AVScreate_input_port("Input Image 1","field 2D",REQUIRED);
   AVScreate_input_port("Input Image 2","field 2D",REQUIRED);
   AVScreate_input_port("Input Image 3","field 2D",OPTIONAL);
   AVScreate_input_port("Input Image 4","field 2D",OPTIONAL);
   AVScreate_input_port("Input Image 5","field 2D",OPTIONAL);
   AVScreate_output_port("Output Image 1","field 2D");
   AVScreate_output_port("Output Image 2","field 2D");
   AVScreate_output_port("Output Image 3","field 2D");
   AVScreate_output_port("Output Image 4","field 2D");
   AVScreate_output_port("Output Image 5","field 2D");
   AVSadd_parameter("cast type","choice","byte","byte,short,int,float,complex,double",",");

   AVSset_compute_proc(vcast_compute);
   return(1);
}

int vconvert_desc ()
{
   int in_port, out_port, param;
   extern int vconvert_compute();

   AVSset_module_name("vconvert",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_float_parameter("normalization",255.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("scale",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("cast type","choice","byte","byte,short,int,float,complex,double",",");
   AVSadd_parameter("indep. bands","boolean",0,0,1);

   AVSset_compute_proc(vconvert_compute);
   return(1);
}

int vctor_desc ()
{
   int in_port, out_port, param;
   extern int vctor_compute();

   AVSset_module_name("vctor",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("conversion","choice","real","real,imaginary,magnitude,phase",",");

   AVSset_compute_proc(vctor_compute);
   return(1);
}

int vect2band_desc ()
{
   int in_port, out_port, param;
   extern int vect2band_compute();

   AVSset_module_name("vect2band",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");

   AVSset_compute_proc(vect2band_compute);
   return(1);
}

int vect2row_desc ()
{
   int in_port, out_port, param;
   extern int vect2row_compute();

   AVSset_module_name("vect2row",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("one vector","boolean",0,0,1);
   AVSadd_parameter("x-coordinate","integer",0,INT_UNBOUND,INT_UNBOUND);
   AVSadd_parameter("y-coordinate","integer",0,INT_UNBOUND,INT_UNBOUND);

   AVSset_compute_proc(vect2row_compute);
   return(1);
}

int vmos2band_desc ()
{
   int in_port, out_port, param;
   extern int vmos2band_compute();

   AVSset_module_name("vmos2band",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("rows/subimage","integer",1,1,512);
   AVSadd_parameter("cols/subimage","integer",1,1,512);
   AVSadd_parameter("inner border","integer",1,1,512);
   AVSadd_parameter("outer border","integer",1,1,512);
   AVSadd_parameter("x index","integer",1,1,512);
   AVSadd_parameter("y index","integer",1,1,512);
   AVSadd_parameter("skip","integer",1,1,512);
   AVSadd_parameter("subimages/band","integer",1,1,512);

   AVSset_compute_proc(vmos2band_compute);
   return(1);
}

int vrect2pol_desc ()
{
   int in_port, out_port, param;
   extern int vrect2pol_compute();

   AVSset_module_name("vrect2pol",MODULE_FILTER);

   AVScreate_input_port("Input file ","field 2D",REQUIRED);
   AVScreate_output_port("Output file","field 2D");
   AVSadd_parameter("conversion","choice","rect 2 pol","rect 2 pol,pol 2 rect",",");
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(vrect2pol_compute);
   return(1);
}

int vrtoc_desc ()
{
   int in_port, out_port, param;
   extern int vrtoc_compute();

   AVSset_module_name("vrtoc",MODULE_FILTER);

   AVScreate_input_port("Input Image 1  ","field 2D",REQUIRED);
   AVScreate_input_port("Input Image 2","field 2D",OPTIONAL);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("conversion","choice","real","real,imaginary,magnitude,phase",",");

   AVSset_compute_proc(vrtoc_compute);
   return(1);
}

int band2vect_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lband2vect(ki1);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vbandcomb_compute (AVSfield *i1,AVSfield *i2,AVSfield *i3,AVSfield *i4,AVSfield *i5,AVSfield *i6,AVSfield *i7,AVSfield *i8,AVSfield *i9,AVSfield *i10,AVSfield **o1,char *color)
{
   int value,num,i;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ki3;
   struct xvimage *ki4;
   struct xvimage *ki5;
   struct xvimage *ki6;
   struct xvimage *ki7;
   struct xvimage *ki8;
   struct xvimage *ki9;
   struct xvimage *ki10;
   struct xvimage *ko1;
   struct xvimage **images;
   char *program="vbandcomb";
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i3)
      if ((ki3=(struct xvimage *)field_to_viff(i3))==NULL) return(0);
   if (i4)
      if ((ki4=(struct xvimage *)field_to_viff(i4))==NULL) return(0);
   if (i5)
      if ((ki5=(struct xvimage *)field_to_viff(i5))==NULL) return(0);
   if (i6)
      if ((ki6=(struct xvimage *)field_to_viff(i6))==NULL) return(0);
   if (i7)
      if ((ki7=(struct xvimage *)field_to_viff(i7))==NULL) return(0);
   if (i8)
      if ((ki8=(struct xvimage *)field_to_viff(i8))==NULL) return(0);
   if (i9)
      if ((ki9=(struct xvimage *)field_to_viff(i9))==NULL) return(0);
   if (i10)
      if ((ki10=(struct xvimage *)field_to_viff(i10))==NULL) return(0);

   num = 0;

   /* get space for image structures */
   images = (struct xvimage **) malloc(sizeof(struct xvimage *) * (num + 10));  
   if (images == NULL)
   {
      (void) fprintf(stderr,"%s: Unable to malloc space for image structures\n",program);
      return(0);
   }

   if (i1) num++;

   if (i2) num++;

   /* Find out how many images there are. */
   /* must have at least two input images */

   /* Now count the optional images */

   if (i3) num++;
   if (i4) num++;
   if (i5) num++;
   if (i6) num++;
   if (i7) num++;
   if (i8) num++;
   if (i9) num++;
   if (i10) num++;

   /* Error checking: 
    *  Ensure that at least two images are input to vbandcomb.
    */

   if (num < 2)
   {
      (void) fprintf(stderr,"%s: Requires at least two input images.\n", program);
      return(0);
   }

   /* Read in first image, so we may match other images to the first. */ 
   if ((images[0] = ki1) == NULL)
   {
      (void) fprintf(stderr, "%s: Can not read the input image\n", program);
      return(0);  /* Quit if bad image */
   }

   (void) proper_num_images(program, images[0], 1, TRUE);

   /* if the any option arguments i3 - i10 were entered, then read the */
   /* image and check it against the first image */

   /* Ensure that data type is BYTE if data is to be mapped
    * through the color maps.
   if (vbandcomb->m_toggle == 1) 
      propertype(program,images[0],VFF_TYP_1_BYTE,TRUE);
MAPS ARE BEING IGNORED IN AVS PORT !    
*/

   /* Loop through all remaining file names and read input images.
    */
   num=0;
   if (i2) images[++num]=ki2;
   if (i3) images[++num]=ki3;
   if (i4) images[++num]=ki4;
   if (i5) images[++num]=ki5;
   if (i6) images[++num]=ki6;
   if (i7) images[++num]=ki7;
   if (i8) images[++num]=ki8;
   if (i9) images[++num]=ki9;
   if (i10) images[++num]=ki10;

   for (i=1;i<=num;i++)
   {
      if ( (match_num_images(program,images[0],images[i],FALSE) == 0) || (matchsize(program,images[0],images[i],FALSE) == 0) )
      {
         (void) fprintf(stderr,"%s: The image did not match the size of first image\n", program);
         return(1);
      }
   }
          
   /* Call lvcast to upcast input images to same data type */
   if (! lvcast(images, num, -1) )
   {
      (void) fprintf(stderr, "lvcast failed: could not upcast images.\n");
      return(0);
   }

   if(!lvbandcomb(&ko1, images, num, 0,AVSchoice_number("color",color)))
   {
      (void) fprintf(stderr, "lvbandcomb Failed\n");
      return(0);
   }

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vbandspt1_compute (AVSfield *i1,AVSfield **o1,int param1)
{
   int value;
   struct xvimage *image, **images_list, **create_images_list();
 
   if (i1)
      if ((image=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   /* If only 1 band, dont continue */
   if (image->num_data_bands == 1)
   {
      (void) fprintf(stderr,"Input image only contains ONE data band!\n");
      return(0);
   }

   proper_num_images("vbandspt1",image,1,TRUE);

   if ( param1 > image->num_data_bands) 
   {
      fprintf(stderr, "%s: Cannot extract out data band number %d,", "vbandspt1",param1);
      fprintf(stderr," input image\nonly contains %d data bands.\n", image->num_data_bands );
      return(0);
   }

   /* create a list of pointers to xvimage structures, the
      number in the list will be the number of data bands */

   images_list = create_images_list(image->num_data_bands);
   if ( images_list == NULL)
   {
      (void) fprintf(stderr, "create_images_list Failed\n");
      return(0);
   }

   if(! lvbandsprt(image, images_list, NULL, TRUE))
   {
      (void) fprintf(stderr, "lvbandsprt Failed\n");
      return(0);
   }

/* since we can only extract one band, extract the band number
   specified by the -b option */

   image = images_list[param1];

   if (((*o1)=(AVSfield *)viff_to_field(image))==NULL) return (0);
 
   return (1);
}
 
int vbandspt3_compute (AVSfield *i1,AVSfield **o1,AVSfield **o2,AVSfield **o3,int param1)
{
   int value;
   struct xvimage *ko1;
   struct xvimage *ko2;
   struct xvimage *ko3;
   char *program="vbandspt3";
   struct xvimage *image, **images_list, **create_images_list();
 
   if (i1)
      if ((image=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   /* can only have one image in the input file */
   (void) proper_num_images(program,image,1,TRUE);

   /* Make sure that there are enough data bands available in the
      input image. if -b option + 3 must be greater than
      the total number of data bands */

   if ( (param1 + 3)  > image->num_data_bands) 
   {
      (void) fprintf(stderr, "%s: Cannot extract out 3 data bands starting with data band %d,", 
			program,param1);
      (void) fprintf(stderr,"\ninput image only contains %d data bands\n", image->num_data_bands );
      return(0);
   }

   images_list = create_images_list(image->num_data_bands);
   if ( images_list == NULL)
   {
      (void) fprintf(stderr, "create_images_list Failed\n");
      return(0);
   }

   /* seprate out all bands into seprate images */

   if(! lvbandsprt(image, images_list, NULL, TRUE))
   {
      (void) fprintf(stderr, "lvbandspt3 Failed\n");
      return(0);
   }

   /* since we can only extract 3 bands, extract 3 bands starting
      with the band specified by the -b option */

   ko1 = images_list[(param1)];
   ko2 = images_list[param1+1];
   ko3 = images_list[param1+2];

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
   if (((*o3)=(AVSfield *)viff_to_field(ko3))==NULL) return (0);
 
   return (value);
}
 
int vcast_compute (AVSfield *i1,AVSfield *i2,AVSfield *i3,AVSfield *i4,AVSfield *i5,AVSfield **o1,AVSfield **o2,AVSfield **o3,AVSfield **o4,AVSfield **o5, char *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ki3;
   struct xvimage *ki4;
   struct xvimage *ki5;
   struct xvimage *ko1;
   struct xvimage *ko2;
   struct xvimage *ko3;
   struct xvimage *ko4;
   struct xvimage *ko5;
   struct xvimage **images;
   int  i, num_images, type;
   char *program="cast";

   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i3)
      if ((ki3=(struct xvimage *)field_to_viff(i3))==NULL) return(0);
   if (i4)
      if ((ki4=(struct xvimage *)field_to_viff(i4))==NULL) return(0);
   if (i5)
      if ((ki5=(struct xvimage *)field_to_viff(i5))==NULL) return(0);

   i=0;

   /*
    * If the optional type selection is used 
    *  then get the appropriate data type.
    */
    if (!vget_type(&type,AVSchoice_number("cast type",param1)))
    {
       (void)fprintf(stderr, "vcast: unknown data type!\n");
       return(0);
    }

                       	   /* Find out how many images there are. */
    num_images = 2;        /* must have at least two input images */
    if (i3)  		   /* now count the optional images */
       	num_images++;
    if (i4) 
	num_images++;
    if (i5)
        num_images++;
       	                   /* get space for image structures */

    images=(struct xvimage **)malloc(sizeof(struct xvimage *)*num_images);  
    if (images == NULL)
    {
       (void) fprintf(stderr,"vcast: Unable to malloc space for image structures\n");
       return(0);
    }

    if (ki1 == NULL)
    {
       (void) fprintf(stderr,"vcast: Can not read input image #1\n");
       return(0);
    }
    images[i++] = ki1;

    if (ki2 == NULL)
    {
     (void) fprintf(stderr,"vcast: Can not read input image #2\n");
      return(0);                    
    }
    images[i++] = ki2;

    (void) proper_num_images(program, ki1, 1, TRUE);

    (void) match_num_images(program,ki1,ki2,TRUE);

   /* Now check for optional input images */
   if ( i3 )
   {
      if (ki3 == NULL)
      {
         (void) fprintf(stderr,"vcast: Can not read input image #3\n");
         return(0);
      }
      images[i++] = ki3;
      (void) match_num_images(program,ki1,ki3,TRUE);

   }

   if ( i4 )
   {
      if (ki4 == NULL)
      {
         (void) fprintf(stderr,"vcast: Can not read input image #4\n");
         return(0);                    
      }
      images[i++] = ki4;
      (void) match_num_images(program,ki1,ki4,TRUE);

   }

   if ( i5 )
   {
      if (ki5 == NULL)
      {
         (void) fprintf(stderr,"vcast: Can not read input image #5\n");
         return(0);
      }
      images[i] = ki5;
      (void) match_num_images(program,ki1,ki5,TRUE);

   }

   if(! lvcast(images, num_images, type) )
   {
      (void) fprintf(stderr, "lvcast Failed\n");
      return(0);
   }

   *o1=(AVSfield *)viff_to_field(ko1);
   *o2=(AVSfield *)viff_to_field(ko2);
   *o3=(AVSfield *)viff_to_field(ko3);
   *o4=(AVSfield *)viff_to_field(ko4);
   *o5=(AVSfield *)viff_to_field(ko5);
 
   return (value);
}
 
int vconvert_compute (AVSfield *i1,AVSfield **o1,float *param1,float *param2,char *param3,int param4)
{
   int value,type;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   if (!vget_type(&type,AVSchoice_number("cast type", param3)))
   {
      (void)fprintf(stderr,"vconvert: unknown data type!\n");
      return(0);
   }

   if(! lvconvert(ki1,type,1,1,*param1,*param2,param4))
   {
      (void) fprintf(stderr, "lvconvert Failed\n");
      return(0);
   }

   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (1);
}
 
int vctor_compute (AVSfield *i1,AVSfield **o1,char *conv)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
int temp;

   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

temp = AVSchoice_number("conversion",conv);

   if(! lvctor(ki1, temp+1))
   {
      (void) fprintf(stderr, "lvctor Failed\\n");
      return(0);
   }

   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (1);
}
 
int vect2band_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvect2band(ki1);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vect2row_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,int param3)
{
   int process_dir;
   struct xvimage *image;
   struct xvimage *ko1;
 
   if (i1)
      if ((image=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   process_dir = 0;        /* DSP_VECTOR */

   /*
    * If input image has only one band, exit.
    */
   if ( image->num_data_bands < 2 )
   {
      (void)fprintf(stderr,"vect2row:  Cannot operate on images with less ");
      (void)fprintf(stderr,"than 2 data bands\n");
      return(0);
    }

   /*
    * Make sure row offset and col offset are within range
    */
   if ( param1 && ( (param3 >= image->col_size) || 
                       (param2 >= image->row_size) ) )
   {
      (void) fprintf(stderr,"vect2row: row or column offset out of range\n");
      return(0);
   }

   if(! lvect2row ( image, param1, param3, param2, process_dir ) )
   {
      (void) fprintf(stderr, "lvect2row Failed\n");
      return(0);
   }
   
   ko1=image;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (1);
}
 
int vmos2band_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,int param3,int param4,int param5,int param6,int param7,int param8)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   if (!(lvmos2band(ki1, &ko1,param1,param2,param3,param4,param5,param6,param7,1,param8)) )
   {
     (void) fprintf(stderr, "lvmos2band Failed\n");
     return(0);
   }
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vrect2pol_compute (AVSfield *i1,AVSfield **o1,char *param1,char *param2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvrect2pol(ki1,AVSchoice_number("conversion", param1),
			AVSchoice_number("direction",param2));

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vrtoc_compute (AVSfield *i1, AVSfield *i2, AVSfield **o1, char *conv)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvrtoc(ki1,ki2,AVSchoice_number("conversion",conv));

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int ((*mod_list[])()) = {
   band2vect_desc,
   vbandcomb_desc,
   vbandspt1_desc,
   vbandspt3_desc,
   vcast_desc,
   vconvert_desc,
   vctor_desc,
   vect2band_desc,
   vect2row_desc,
   vmos2band_desc,
   vrect2pol_desc,
   vrtoc_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

