#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"
#include "geomanip.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int vexpand_desc ()
{
   int in_port, out_port, param;
   extern int vexpand_compute();

   AVSset_module_name("vexpand",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("scale","integer",2,1,512);

   AVSset_compute_proc(vexpand_compute);
   return(1);
}

int vflip_desc ()
{
   int in_port, out_port, param;
   extern int vflip_compute();

   AVSset_module_name("vflip",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("top-for-bottom","boolean",0,0,1);
   AVSadd_parameter("right-for-left","boolean",0,0,1);

   AVSset_compute_proc(vflip_compute);
   return(1);
}

int vresize_desc ()
{
   int in_port, out_port, param;
   extern int vresize_compute();

   AVSset_module_name("vresize",MODULE_FILTER);

   AVScreate_input_port("Input Image","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_float_parameter("x center",0.0,0.0,512.0);
   AVSadd_float_parameter("y center",0.0,0.0,512.0);
   AVSadd_float_parameter("x mag",5.0,0.0,100.0);
   AVSadd_float_parameter("y mag",5.0,0.0,100.0);

   AVSset_compute_proc(vresize_compute);
   return(1);
}

int vrotate_desc ()
{
   int in_port, out_port, param;
   extern int vrotate_compute();

   AVSset_module_name("vrotate",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_float_parameter("rotation",45.000000,0.000000,360.000000);
   AVSadd_parameter("X center","integer",0,0,512);
   AVSadd_parameter("Y center","integer",0,0,512);

   AVSset_compute_proc(vrotate_compute);
   return(1);
}

int vshrink_desc ()
{
   int in_port, out_port, param;
   extern int vshrink_compute();

   AVSset_module_name("vshrink",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("shrink factor","integer",2,1,2000);

   AVSset_compute_proc(vshrink_compute);
   return(1);
}

int vtranslat_desc ()
{
   int in_port, out_port, param;
   extern int vtranslat_compute();

   AVSset_module_name("vtranslat",MODULE_FILTER);

   AVScreate_input_port("Input Image  ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image ","field 2D");
   AVSadd_parameter("x trans","integer",0,INT_UNBOUND,INT_UNBOUND);
   AVSadd_parameter("y trans","integer",0,INT_UNBOUND,INT_UNBOUND);
   AVSadd_parameter("wraporpad","choice","pad","pad|wrap","|");
   AVSadd_float_parameter("paddingvalue",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);

   AVSset_compute_proc(vtranslat_compute);
   return(1);
}

int vtranspos_desc ()
{
   int in_port, out_port, param;
   extern int vtranspos_compute();

   AVSset_module_name("vtranspos",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");

   AVSset_compute_proc(vtranspos_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int vexpand_compute (AVSfield *i1,AVSfield **o1,int param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvexpand(ki1,param1);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vflip_compute (AVSfield *i1,AVSfield **o1,int param1,int param2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvflip(ki1,param1,param2);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vresize_compute (AVSfield *i1,AVSfield **o1,float *param1,float *param2,float *param3,float *param4)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   if (*param1==0) *param1=(MAXX(i1)-1) / 2.0;
   if (*param2==0) *param2=(MAXY(i1)-1) / 2.0;

   value=(int)lvresize(ki1,*param3,*param4,*param1,*param2);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
float ang;

int vrotate_compute (AVSfield *i1,AVSfield **o1,float *param1,int param2,int param3)
{
   int value;
   struct xvimage *ki1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   /* SET MAP FLAG TO VFF_MAP OPTIONAL */
   ki1->map_enable=(unsigned long)VFF_MAP_OPTIONAL;

   (void) proper_num_images(program,ki1,1,TRUE); 
   (void) proper_map_enable(program,ki1,VFF_MAP_OPTIONAL,TRUE); 
   (void) proper_loc_type(program,ki1,VFF_LOC_IMPLICIT,TRUE);

   if (param2==0) param2=(int)(MAXX(i1)/2);
   if (param3==0) param3=(int)(MAXY(i1)/2);

   ang= *param1;

   ki1=(struct xvimage *)lvrotate(ki1,(float)*param1,(int)param2,(int)param3);
 
   if (((*o1)=(AVSfield *)viff_to_field(ki1))==NULL) return (0);
 
   return (1);
}
 
int vshrink_compute (AVSfield *i1,AVSfield **o1,int param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvshrink(ki1,param1);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vtranslat_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,char *param3,float *param4)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvtranslat(ki1,param2,param1,
		AVSchoice_number("wraporpad"),*param4);
   
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vtranspos_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvtranspos(ki1);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   vexpand_desc,
   vflip_desc,
   vresize_desc,
   vrotate_desc,
   vshrink_desc,
   vtranslat_desc,
   vtranspos_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

