#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int venhance_desc ()
{
   int in_port, out_port, param;
   extern int venhance_compute();

   AVSset_module_name("venhance",MODULE_FILTER);

   AVScreate_input_port("Input Image   ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");
   AVSadd_parameter("window width","integer",3,1,100);
   AVSadd_parameter("window heigh","integer",3,1,100);
   AVSadd_float_parameter("Tuning",0.5,0.0,1.0);
   AVSadd_float_parameter("Min Std Dev",1,0,2000);

   AVSset_compute_proc(venhance_compute);
   return(1);
}

int venhpatch_desc ()
{
   int in_port, out_port, param;
   extern int venhpatch_compute();

   AVSset_module_name("venhpatch",MODULE_FILTER);

   AVScreate_input_port("Input Image","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("xoffset","integer",0,0,500);
   AVSadd_parameter("yoffset","integer",0,0,500);
   AVSadd_parameter("width","integer",20,1,256);
   AVSadd_parameter("height","integer",20,1,256);
   AVSadd_parameter("copy map","choice","copy","copy,no copy",",");

   AVSset_compute_proc(venhpatch_compute);
   return(1);
}

int vheq_desc ()
{
   int in_port, out_port, param;
   extern int vheq_compute();

   AVSset_module_name("vheq",MODULE_FILTER);

   AVScreate_input_port("Input Image","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("invert","choice","photoPOSITIVE","photoPOSITIVE,photoNEGATIVE",",");

   AVSset_compute_proc(vheq_compute);
   return(1);
}

int vhisto_desc ()
{
   int in_port, out_port, param;
   extern int vhisto_compute();

   AVSset_module_name("vhisto",MODULE_FILTER);

   AVScreate_input_port("Input Image","field 2D",REQUIRED);
   AVScreate_input_port("Mask Image","field 2D",OPTIONAL);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_float_parameter("lower bound",0.0,0.0,256.0);
   AVSadd_float_parameter("upper bound",256.0,0.0,256.0);
   AVSadd_parameter("number of bins","integer",2,2,256);
   AVSadd_parameter("log","choice","log","log,no log",",");
   AVSadd_parameter("which","choice","total","total,percent",",");

   AVSset_compute_proc(vhisto_compute);
   return(1);
}

int vhsee_desc ()
{
   int in_port, out_port, param;
   extern int vhsee_compute();

   AVSset_module_name("vhsee",MODULE_FILTER);

   AVScreate_input_port("Input Image   ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");
   AVSadd_parameter("invert","choice","photoPOSITIVE","photoPOSITIVE,photoNEGATIVE",",");
   AVSadd_parameter("format","choice","image","image,plot",",");

   AVSset_compute_proc(vhsee_compute);
   return(1);
}

int vhstr_desc ()
{
   int in_port, out_port, param;
   extern int vhstr_compute();

   AVSset_module_name("vhstr",MODULE_FILTER);

   AVScreate_input_port("Input Image","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("invert","choice","photoPOSITIVE","photoPOSITIVE,photoNEGATIVE",",");

   AVSset_compute_proc(vhstr_compute);
   return(1);
}

int vhxray_desc ()
{
   int in_port, out_port, param;
   extern int vhxray_compute();

   AVSset_module_name("vhxray",MODULE_FILTER);

   AVScreate_input_port("Input Image   ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");
   AVSadd_parameter("width","integer",5,1,32);
   AVSadd_parameter("height","integer",5,1,32);
   AVSadd_parameter("stretch","choice","stretch","stretch,equalize",",");

   AVSset_compute_proc(vhxray_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int venhance_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,float *param3,float *param4)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvenhance(ki1,param1,param2,*param3,*param4);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int venhpatch_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,int param3, int param4,char *param5)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvextract(ki1,&ko1,param4,param3,param2,param1,AVSchoice_number("copy map"));
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vheq_compute (AVSfield *i1,AVSfield **o1,char *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvheq(ki1, AVSchoice_number("invert"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vhisto_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,float *param1,float *param2,int param3,char *param4,char *param5)
{
   int value;
   int mflag;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *dummy;
   float *hist; /* not sure this right !!!!**/
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i2) mflag=1;
   else mflag=0;


   if (i2) {
        value=(int)lvhisto(ki1,hist,*param1,*param2,param3,mflag,ki2,AVSchoice_number("log"),AVSchoice_number("which"));
           }
    else   { 
        value=(int)lvhisto(ki1,hist,*param1,*param2,param3,mflag,dummy,AVSchoice_number("log"),AVSchoice_number("which"));
          }


/*   NB!! What is really   output here is float *hist; contains histo array */



   if (((*o1)=(AVSfield *)viff_to_field(ki1))==NULL) return (0);
 
   return (value);
}
 
int vhsee_compute (AVSfield *i1,AVSfield **o1,char *param1,char *param2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage **ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvhsee(ki1,ko1,AVSchoice_number("invert"),AVSchoice_number("format"));
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vhstr_compute (AVSfield *i1,AVSfield **o1,char *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvhstr(ki1,AVSchoice_number("invert"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vhxray_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,char *param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvhxray(ki1,AVSchoice_number("stretch"),param1,param2);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   venhance_desc,
   venhpatch_desc,
   vheq_desc,
   vhisto_desc,
   vhsee_desc,
   vhstr_desc,
   vhxray_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

