#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"

#include "avskhoros.h"

#include "utils.h"


/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int dgexpon_desc ()
{
   int in_port, out_port, param;
   extern int dgexpon_compute();

   AVSset_module_name("dgexpon",MODULE_FILTER);

   AVScreate_output_port("Output File  ","field 2D");
   AVSadd_parameter("vectors","integer",1,1,25);
   AVSadd_parameter("points","integer",128,1,256);
   AVSadd_float_parameter("variance",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("data","choice","float","float,complex",",");
   AVSadd_parameter("Processing","choice","Vectors","Vectors,Bands",",");

   AVSset_compute_proc(dgexpon_compute);
   return(1);
}

int dggauss_desc ()
{
   int in_port, out_port, param;
   extern int dggauss_compute();

   AVSset_module_name("dggauss",MODULE_FILTER);

   AVScreate_output_port("Output File  ","field 2D");
   AVSadd_parameter("vectors","integer",1,1,25);
   AVSadd_parameter("points","integer",128,1,256);
   AVSadd_float_parameter("mean",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("variance",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("data","choice","float","float,complex",",");
   AVSadd_parameter("direction","choice","across bands","down vectors,across bands",",");

   AVSset_compute_proc(dggauss_compute);
   return(1);
}

int dgpoiss_desc ()
{
   int in_port, out_port, param;
   extern int dgpoiss_compute();

   AVSset_module_name("dgpoiss",MODULE_FILTER);

   AVScreate_output_port("Output File  ","field 2D");
   AVSadd_parameter("vectors","integer",1,1,25);
   AVSadd_parameter("points","integer",128,1,256);
   AVSadd_float_parameter("variance",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("time",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("data","choice","float","float,complex",",");
   AVSadd_parameter("direction","choice","across bands","down vectors,across bands",",");

   AVSset_compute_proc(dgpoiss_compute);
   return(1);
}

int dgpwl_desc ()
{
   int in_port, out_port, param;
   extern int dgpwl_compute();

   AVSset_module_name("dgpwl",MODULE_FILTER);

   AVScreate_output_port("Output Image ","field 2D");
   AVSadd_parameter("vectors","integer",1,1,25);
   AVSadd_parameter("points","integer",128,1,256);
   AVSadd_float_parameter("sampling",2.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("minimum",0.500000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("maximum",2.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("period",15.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("rise time ",20.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("fall time ",10.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("pulse width ",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("init delay","integer",0,0,1);
   AVSadd_parameter("data","choice","float","float,complex",",");
   AVSadd_parameter("direction","choice","across bands","down vectors,across bands",",");

   AVSset_compute_proc(dgpwl_compute);
   return(1);
}

int dgrleigh_desc ()
{
   int in_port, out_port, param;
   extern int dgrleigh_compute();

   AVSset_module_name("dgrleigh",MODULE_FILTER);

   AVScreate_output_port("Output File  ","field 2D");
   AVSadd_parameter("vectors","integer",1,1,25);
   AVSadd_parameter("points","integer",128,1,256);
   AVSadd_float_parameter("variance",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("data","choice","float","float,complex",",");
   AVSadd_parameter("direction","choice","across bands","down vectors,across bands",",");

   AVSset_compute_proc(dgrleigh_compute);
   return(1);
}

int dgsin_desc ()
{
   int in_port, out_port, param;
   extern int dgsin_compute();

   AVSset_module_name("dgsin",MODULE_FILTER);
   AVScreate_output_port("Output Image ","field 2D");
   AVSadd_parameter("vectors","integer",1,1,25);
   AVSadd_parameter("points","integer",50,1,256);
   AVSadd_float_parameter("sampling freq",2.0,1.0,256.0);
   AVSadd_float_parameter("amplitude",1.0,1.0,256.0);
   AVSadd_float_parameter("frequency",1.0,1.0,256.0);
   AVSadd_float_parameter("phase ",0.0,1.0,256.0);
   AVSadd_parameter("init delay","integer",0,1,256);
   AVSadd_parameter("data","choice","float","float,complex",",");
   AVSadd_parameter("units","choice","hertz","radians/pixel,hertz",",");
   AVSadd_parameter("direction","choice","across bands","down vectors,across bands",",");


   AVSset_compute_proc(dgsin_compute);
   return(1);
}

int dgsinc_desc ()
{
   int in_port, out_port, param;
   extern int dgsinc_compute();

   AVSset_module_name("dgsinc",MODULE_FILTER);

   AVScreate_output_port("Output Image ","field 2D");
   AVSadd_parameter("vectors","integer",1,1,25);
   AVSadd_parameter("points","integer",50,1,256);
   AVSadd_float_parameter("sampling freq",2.0,1.0,256.0);
   AVSadd_float_parameter("amplitude",1.0,1.0,256.0);
   AVSadd_float_parameter("frequency",1.0,1.0,256.0);
   AVSadd_parameter("init delay","integer",0,0,256);
   AVSadd_parameter("orientation","choice","not-centered","centered,not-centered,straight,gay,bisexual",",");
   AVSadd_parameter("data","choice","float","float,complex",",");
   AVSadd_parameter("direction","choice","across bands","down vectors,across bands",",");

   AVSset_compute_proc(dgsinc_compute);
   return(1);
}

int dgunif_desc ()
{
   int in_port, out_port, param;
   extern int dgunif_compute();

   AVSset_module_name("dgunif",MODULE_FILTER);

   AVScreate_output_port("Output File  ","field 2D");
   AVSadd_parameter("vectors","integer",1,1,25);
   AVSadd_parameter("points","integer",125,1,256);
   AVSadd_float_parameter("minimum",1.0,1.0,256.0);
   AVSadd_float_parameter("maximum",256.0,1.0,256.0);
   AVSadd_parameter("data","choice","float","float,complex",",");
   AVSadd_parameter("direction","choice","across bands","down vectors,across bands",",");

   AVSset_compute_proc(dgunif_compute);
   return(1);
}

int dgwindow_desc ()
{
   int in_port, out_port, param;
   extern int dgwindow_compute();

   AVSset_module_name("dgwindow",MODULE_FILTER);

   AVScreate_output_port("Output file ","field 2D");
   AVSadd_parameter("data","choice","float","float,complex",",");
   AVSadd_parameter("window","choice","Hamming","Rectangular,Bartlett,Hamming,Hanning,Parzen,Kaiser,Exponential,Blackman,BlackmanHarris,Rt-Triangular,Left-Triangular,Rt-Exponential,Lft-Exponential,User Defined",",");
   AVSadd_parameter("signals","integer",1,1,256);
   AVSadd_parameter("elements","integer",128,1,256);
   AVSadd_float_parameter("theta",1.0,1.0,256.0);
   AVSadd_float_parameter("damping",1.0,1.0,256.0);
   AVSadd_parameter("width","integer",1,1,256);
   AVSadd_parameter("direction","choice","across bands","down vectors,across bands",",");

   AVSset_compute_proc(dgwindow_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int dgexpon_compute ( 	AVSfield **o1,
			int numvec,
			int numpts,
			float *variance,
			char *typeS,
			char *procdirS)
{
   int value, type, procdir;
   struct xvimage *ko1 = (struct xvimage *) NULL;
 
   if (strcmp(procdirS, "Vectors") == 0)
	procdir = 0; else
   if (strcmp(procdirS, "Bands") == 0)
	procdir = 1; else
	{
   	fprintf(stderr, "Processing %s is invalid!\n", procdirS);
	return 0;
	}	
 
   if (strcmp(typeS, "float") == 0)
	type = VFF_TYP_FLOAT; else
   if (strcmp(typeS, "complex") == 0)
	type = VFF_TYP_COMPLEX; else
	{
   	fprintf(stderr, "data %s is invalid!\n", typeS);
	return 0;
	}	

   value=(int)	ldgexpon(	&ko1,
				numvec,
				numpts,
				(double ) *variance,
				type,
				procdir);

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 

int dggauss_compute (	AVSfield **o1,
			int vectors,
			int points,
			float *mean,
			float *variance,
			char *typeS,	
			char *procdirS)
{
   int value, procdir,type;
   struct xvimage *ko1 = (struct xvimage *) NULL;
 
   if (strcmp(procdirS, "down vectors") == 0)
	procdir = 0; else
   if (strcmp(procdirS, "across bands") == 0)
	procdir = 1; else
	{
   	fprintf(stderr, "Processing %s is invalid!\n", procdirS);
	return 0;
	}	
 
   if (strcmp(typeS, "float") == 0)
	type = VFF_TYP_FLOAT; else
   if (strcmp(typeS, "complex") == 0)
	type = VFF_TYP_COMPLEX; else
	{
   	fprintf(stderr, "data %s is invalid!\n", typeS);
	return 0;
	}	


   value=(int)ldggauss(&ko1,vectors,points,(double)*mean,(double)*variance,type,procdir);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dgpoiss_compute (	AVSfield **o1,
			int numvec,
			int numpts,
			float *variance,
			float *timex,
			char *typeS,
			char *procdirS)
{
   int value, type, procdir;
   struct xvimage *ko1 = (struct xvimage *) NULL;
 
   if (strcmp(procdirS, "down vectors") == 0)
	procdir = 0; else
   if (strcmp(procdirS, "across bands") == 0)
	procdir = 1; else
	{
   	fprintf(stderr, "Processing %s is invalid!\n", procdirS);
	return 0;
	}	
 
   if (strcmp(typeS, "float") == 0)
	type = VFF_TYP_FLOAT; else
   if (strcmp(typeS, "complex") == 0)
	type = VFF_TYP_COMPLEX; else
	{
   	fprintf(stderr, "data %s is invalid!\n", typeS);
	return 0;
	}	

   value=(int)ldgpoiss(&ko1,numvec,numpts,(double)*variance,(double)*timex,type,procdir);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dgpwl_compute ( 	AVSfield **o1,
			int numvec,
			int numpts,
			float *fs,
			float *minimum,
			float *maximum,
			float *period,
			float *rise,
			float *fall,
			float *width,
			int delay,
			char *typeS,
			char *procdirS)
{
   int value, type, procdir;
   struct xvimage *ko1 = (struct xvimage *) NULL;
 
   if (strcmp(procdirS, "down vectors") == 0)
	procdir = 0; else
   if (strcmp(procdirS, "across bands") == 0)
	procdir = 1; else
	{
   	fprintf(stderr, "Processing %s is invalid!\n", procdirS);
	return 0;
	}	
 
   if (strcmp(typeS, "float") == 0)
	type = VFF_TYP_FLOAT; else
   if (strcmp(typeS, "complex"))
	type = VFF_TYP_COMPLEX; else
	{
   	fprintf(stderr, "data %s is invalid!\n", typeS);
	return 0;
	}	


   value=(int) ldgpwl(	&ko1,
			numvec,
			numpts,
			(double)*fs,
			(double)*minimum,
			(double)*maximum,
			(double)*period,
			(double)*rise,
			(double)*fall,
			(double)*width,
			delay,
			type,
			procdir
			);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 

int dgrleigh_compute (	AVSfield **o1,
			int numvec,
			int numpts,
			float *variance,
			char *typeS,
			char *procdirS)
{
   int value, type, procdir;
   struct xvimage *ko1 = (struct xvimage *) NULL;
 
   if (strcmp(procdirS, "down vectors") == 0)
	procdir = 0; else
   if (strcmp(procdirS, "across bands") == 0)
	procdir = 1; else
	{
   	fprintf(stderr, "Processing %s is invalid!\n", procdirS);
	return 0;
	}	
 
   if (strcmp(typeS, "float") == 0)
	type = VFF_TYP_FLOAT; else
   if (strcmp(typeS, "complex") == 0)
	type = VFF_TYP_COMPLEX; else
	{
   	fprintf(stderr, "data %s is invalid!\n", typeS);
	return 0;
	}	

   value=(int)ldgrleigh(	&ko1,
				numvec,
				numpts,
				(double) *variance,
				type,
				procdir);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dgsin_compute ( 	AVSfield **o1,
			int numvec,
			int numpts,
			float *fs,
			float *amp,
			float *freq,
			float *phase,
			int delay,
			char *typeS,
			char *samplingS,
			char *procdirS)
{
   int value, type, sampling, procdir;
   struct xvimage *ko1 = (struct xvimage *) NULL;
 
   if (strcmp(procdirS, "down vectors") == 0)
	procdir = 0; else
   if (strcmp(procdirS, "across bands") == 0)
	procdir = 1; else
	{
   	fprintf(stderr, "Processing %s is invalid!\n", procdirS);
	return 0;
	}	
 
   if (strcmp(samplingS, "radians/pixel") == 0)
	sampling = 0; else
   if (strcmp(samplingS, "hertz") == 0)
	sampling = 1; else
	{
   	fprintf(stderr, "Processing %s is invalid!\n", samplingS);
	return 0;
	}	
 
   if (strcmp(typeS, "float") == 0)
	type = VFF_TYP_FLOAT; else
   if (strcmp(typeS, "complex") == 0)
	type = VFF_TYP_COMPLEX; else
	{
   	fprintf(stderr, "data %s is invalid!\n", typeS);
	return 0;
	}	


   value=(int)ldgsin(	&ko1,
			numvec,
			numpts,
			(double)*fs,
			(double)*amp,
			(double)*freq,
			(double)*phase,
			delay,
			type,
			sampling,
			procdir);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dgsinc_compute (	AVSfield **o1,
			int numvec,
			int numpts,
			float *fs,
			float *amp,
			float *freq,
			int delay,
			char *centerS,
			char *typeS,
			char *procdirS )
{
   int value, type, procdir, center;
   struct xvimage *ko1 = (struct xvimage *) NULL;
 
   if (strcmp(procdirS, "down vectors") == 0)
	procdir = 0; else
   if (strcmp(procdirS, "across bands") == 0)
	procdir = 1; else
	{
   	fprintf(stderr, "Processing %s is invalid!\n", procdirS);
	return 0;
	}	
 
   if (strcmp(centerS, "centered") == 0)
	center = 0; else
   if (strcmp(centerS, "not-centered") == 0)
	center = 1; else
	{
   	fprintf(stderr, "Processing %s is invalid!\n", centerS);
	return 0;
	}	
 
   if (strcmp(typeS, "float") == 0)
	type = VFF_TYP_FLOAT; else
   if (strcmp(typeS, "complex") == 0)
	type = VFF_TYP_COMPLEX; else
	{
   	fprintf(stderr, "data %s is invalid!\n", typeS);
	return 0;
	}	


   value=(int)ldgsinc(	&ko1,numvec,numpts,(double)*fs,(double)*amp,(double)*freq,delay,
			center,type,procdir);

 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}

 
int dgunif_compute (	AVSfield **o1,
			int numvec,
			int numpts,
			float *minimum,
			float *maximum,
			char *typeS,
			char *procdirS )
{
   int value, type, procdir;
   struct xvimage *ko1 = (struct xvimage *) NULL;
 
   if (strcmp(procdirS, "down vectors") == 0)
	procdir = 0; else
   if (strcmp(procdirS, "across bands") == 0)
	procdir = 1; else
	{
   	fprintf(stderr, "Processing %s is invalid!\n", procdirS);
	return 0;
	}	
 
   if (strcmp(typeS, "float") == 0)
	type = VFF_TYP_FLOAT; else
   if (strcmp(typeS, "complex") == 0)
	type = VFF_TYP_COMPLEX; else
	{
   	fprintf(stderr, "data %s is invalid!\n", typeS);
	return 0;
	}	

   value=(int)ldgunif( &ko1,numvec,numpts,(double)*minimum,(double)*maximum,type,procdir);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dgwindow_compute (	AVSfield **o1,
			char *typeS,
			char *window_optionS,
			int nsig,	
			int nelem,
			float *theta,
			float *damp,	
			int width,
			char *procdirS )
{
   int value, type, procdir, window_option;
   struct xvimage *ko1 = (struct xvimage *) NULL;

	/* SRT Terry - I'm not sure if the window_option argument
		is calculated correctly here! - Steve */
   if (strcmp(window_optionS, "Rectangular") == 0)
	window_option = 0; else
   if (strcmp(window_optionS, "Bartlett") == 0)
	window_option = 1; else
   if (strcmp(window_optionS, "Hamming") == 0)
	window_option = 2; else
   if (strcmp(window_optionS, "Hanning") == 0)
	window_option = 3; else
   if (strcmp(window_optionS, "Parzen") == 0)
	window_option = 4; else
   if (strcmp(window_optionS, "Kaiser") == 0)
	window_option = 6; else
   if (strcmp(window_optionS, "Exponential") == 0)
	window_option = 6; else
   if (strcmp(window_optionS, "Blackman") == 0)
	window_option = 7; else
   if (strcmp(window_optionS, "Blackman-Harris") == 0)
	window_option = 8; else
   if (strcmp(window_optionS, "Right-Triangular") == 0)
	window_option = 9; else
   if (strcmp(window_optionS, "Left-Triangular") == 0)
	window_option = 10; else
   if (strcmp(window_optionS, "Right-Exponential") == 0)
	window_option = 11; else
   if (strcmp(window_optionS, "Left-Exponential") == 0)
	window_option = 12; else
   if (strcmp(window_optionS, "User Defined") == 0)
	window_option = 13; else
	{
   	fprintf(stderr, "Processing %s is invalid!\n", window_optionS);
	return 0;
	}	
 
   if (strcmp(procdirS, "down vectors") == 0)
	procdir = 0; else
   if (strcmp(procdirS, "across bands") == 0)
	procdir = 1; else
	{
   	fprintf(stderr, "Processing %s is invalid!\n", procdirS);
	return 0;
	}	
 
   if (strcmp(typeS, "float") == 0)
	type = VFF_TYP_FLOAT; else
   if (strcmp(typeS, "complex") == 0)
	type = VFF_TYP_COMPLEX; else
	{
   	fprintf(stderr, "data %s is invalid!\n", typeS);
	return 0;
	}	

 
   value=(int)ldgwindow(&ko1,type,window_option,nsig,nelem,
			(double)*theta,(double)*damp,width,procdir);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 

int image2signal_compute(AVSfield *, AVSfield **, int );

int image2signal_desc ()
{
   int in_port, out_port, param;
   int image2signal_compute();

   AVSset_module_name("image to signal",MODULE_FILTER);

   AVScreate_input_port("image","field 2D",REQUIRED);
   AVScreate_output_port("signal","field 1D uniform");
   AVSadd_parameter("scan line","integer",1,1,512);

   AVSset_compute_proc(image2signal_compute);
   return(1);
}


int image2signal_compute( input, output,line)
	AVSfield *input;
	AVSfield **output;
	int line;
{
   char template_string[30];
   int dims[1],i,n;
   AVSfield template;

   if (*output) free(*output);

   memset((char *)&template,0,sizeof(AVSfield));
   template.ndim=1;
   template.nspace=1;
   dims[0]=MAXX(input);
   template.veclen=((input)->veclen);
   template.type = ((input)->type);
   template.size = ((input)->size);
   template.uniform = UNIFORM;

   if ((*output = (AVSfield *)AVSfield_alloc(&template,dims)) == NULL )
   {
      AVSwarning ("Can't malloc enough memory for output field.");
      return(0);
   }

   switch (input->type)
   {
      case AVS_TYPE_BYTE:
         for (i=0;i<dims[0];i++)
            for (n=0;n<input->veclen;n++)
{
fprintf(stderr,"%d \n",i);
               NEW_I1DV(((*output)->field_union).field_data_char,*output,i)[n]
	           =
	       NEW_I2DV((input->field_union).field_data_char,input,i,line-1)[n];
}
      break;
      case AVS_TYPE_SHORT:
         for (i=0;i<dims[0];i++)
            for (n=0;n<input->veclen;n++)
               NEW_I1DV(((*output)->field_union).field_data_short_u,*output,i) [n]
                   =
               NEW_I2DV((input->field_union).field_data_short_u,input,i,line-1)[n];
      break;
      case AVS_TYPE_INTEGER:
         for (i=0;i<dims[0];i++)
            for (n=0;n<input->veclen;n++)
               NEW_I1DV(((*output)->field_union).field_data_int_u,*output,i) [n]
                   =
               NEW_I2DV((input->field_union).field_data_int_u,input,i,line-1)[n];
      break;
      case AVS_TYPE_REAL:
         for (i=0;i<dims[0];i++)
            for (n=0;n<input->veclen;n++)
               NEW_I1DV(((*output)->field_union).field_data_float_u,*output,i) [n]
                   =
               NEW_I2DV((input->field_union).field_data_float_u,input,i,line-1)[n];
      break;
      case AVS_TYPE_DOUBLE:
         for (i=0;i<dims[0];i++)
            for (n=0;n<input->veclen;n++)
               NEW_I1DV(((*output)->field_union).field_data_double_u,*output,i) [n]
                   =
               NEW_I2DV((input->field_union).field_data_double_u,input,i,line-1)[n];
      break;
   }


   return(1);
}

/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   dgexpon_desc,
   dggauss_desc,
   dgpoiss_desc,
   dgpwl_desc,
   dgrleigh_desc,
   dgsin_desc,
   dgsinc_desc,
   dgunif_desc,
   dgwindow_desc,
   image2signal_desc
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

