 /*
  * Khoros: $Id: ldgwindow.c,v 1.3 1992/03/20 23:27:19 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: ldgwindow.c,v 1.3 1992/03/20 23:27:19 dkhoros Exp $";
#endif

 /*
  * $Log: ldgwindow.c,v $
 * Revision 1.3  1992/03/20  23:27:19  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: ldgwindow.c
 >>>>
 >>>>      Program Name: dgwindow
 >>>>
 >>>> Date Last Updated: Thu Mar  5 12:02:16 1992 
 >>>>
 >>>>          Routines: ldgwindow - the library call for dgwindow
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: ldgwindow - library call for dgwindow
*
* Purpose:
*    
*    1D Window Creation.
*    
*    

* Input:
*    
*    image          pointer to VIFF structure containing image data to
*                   be processed.
*    
*    type           output images data storage type.
*    
*    window_option  window function to be used.
*    
*    nsig           number of signals in ensemble.
*    
*    nelem          number of data elements in a signal.
*    
*    theta          theta parameter for kaiser function.
*    
*    damp           damping factor for exponential functions.
*    
*    width          desired window width for user defined window.
*    
*    procdir        process direction:  0  indicated  vector  oriented
*                   processing, 1 indicates band oriented processing.
*    
*    

* Output:
*    
*    image          pointer to VIFF structure  containing  image  data
*                   after processing.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Jeremy Worley
*    
*    Jeremy Worley 05 Mar 1992 12:00 MST
*              Made implicit declarations of functions in  ldgwindow()
*              explicit.
*    
*    

****************************************************************/


/* -library_def */
int
ldgwindow (image,type,window_option,nsig,nelem,theta,damp,width,procdir)

int    window_option, width, nsig, nelem, procdir,type;
double  theta, damp;
struct xvimage **image;
/* -library_def_end */

/* -library_code */
{
  int rows,cols,bands;
  float real = 1.0, imag = 0.0;
  int lvgconst(), ldwindow();

/*
** setup dimensions based on direction of processing
*/

  cols = 1;
  if(procdir==DSP_VECTOR){
     rows = nsig;
     bands = nelem;
  }else{
     rows = nelem;
     bands = nsig;
  }

/*
** generate constant image with lvgconst
*/

  if(!lvgconst(image,rows,cols,type, real,imag,bands)){
     fprintf(stderr,"ldgwindow:  Generation of constant data failed\n");
     return(0);
  }

/*
** apply window function to image
*/

  if(!ldwindow(*image,window_option,theta,damp,width,procdir)){
     fprintf(stderr,"ldgwindow:  Application of ldwindow failed\n");
     return(0);
  }

/*
** normal return
*/

  return(1);
}
/* -library_code_end */
