#include <stdio.h>


#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int vcustom_desc ()
{
   int in_port, out_port, param;
   extern int vcustom_compute();

   AVSset_module_name("vcustom",MODULE_FILTER);

   /*AVScreate_output_port("Output Image","field 2D");*/
   AVScreate_output_port("image", "field 2D");

   AVSadd_parameter("rows","integer",3,1,256);
   AVSadd_parameter("columns","integer",3,1,256);
   AVSadd_parameter("data","choice","float","byte,short,integer,float",",");

   AVSset_compute_proc(vcustom_compute);
   return(1);
}

int vgauss_desc ()
{
   int in_port, out_port, param;
   extern int vgauss_compute();

   AVSset_module_name("vgauss",MODULE_FILTER);

   /*AVScreate_input_port("Parameters Input Image","field 2D",REQUIRED);*/
   AVScreate_output_port("image", "field 2D");
   AVSadd_parameter("rows","integer",512,3,512);
   AVSadd_parameter("columns","integer",512,3,512);
   AVSadd_float_parameter("X peak",256.0,1.0,512.0);
   AVSadd_float_parameter("Y peak",256.0,1.0,512.0);
   AVSadd_float_parameter("X var",30.0,1.0,60.0);
   AVSadd_float_parameter("Y var",30.0,1.0,60.0);
   AVSadd_float_parameter("Rotation",0.0,-90.0,90.0);
   AVSadd_float_parameter("Peak",1.0,0.0,1.0);
   AVSadd_parameter("Normalize ","boolean",0,0,1);

   AVSset_compute_proc(vgauss_compute);
   return(1);
}

int vgbox_desc ()
{
   int in_port, out_port, param;
   extern int vgbox_compute();

   AVSset_module_name("vgbox",MODULE_FILTER);

   AVScreate_output_port("image", "field 2D");
   AVSadd_parameter("Row","integer",512,1,512);
   AVSadd_parameter("Col","integer",512,1,512);
   AVSadd_float_parameter("Pixel Width",1.0,0.0,1.0);
   AVSadd_float_parameter("Pixel Height",1.0,0.0,1.0);
   AVSadd_float_parameter("Offset left",0.0,0.0,1.0);
   AVSadd_float_parameter("Offset top",0.0,0.0,1.0);
   AVSadd_parameter("Grey outside","integer",100,1,256);
   AVSadd_parameter("Grey inside","integer",100,1,256);
   AVSadd_float_parameter("Box Width",20.6,0.0,256.0);
   AVSadd_float_parameter("Box Height",40.3,0.0,256.0);
   AVSadd_float_parameter("Box rt offset",0.0,0.0,256.0);
   AVSadd_float_parameter("Box dwn offset",0.0,0.0,256.0);
   AVSadd_float_parameter("Box rotation",0.0,0.0,360.0);
   AVSadd_float_parameter("Corner angle",0.0,0.0,360.0);

   AVSset_compute_proc(vgbox_compute);
   return(1);
}

int vgcirc_desc ()
{
   int in_port, out_port, param;
   extern int vgcirc_compute();

   AVSset_module_name("vgcirc",MODULE_FILTER);

   AVScreate_output_port("Output image","field 2D");
   AVSadd_parameter("rows","integer",2,1,512);
   AVSadd_parameter("columns","integer",2,1,512);
   AVSadd_parameter("data","choice","byte","byte,float",",");
   AVSadd_float_parameter("Background",0.0,0.0,255.0);
   AVSadd_float_parameter("Foreground",255.0,0.0,255.0);
   AVSadd_float_parameter("X center",0.0,0.0,256.0);
   AVSadd_float_parameter("Y center",0.0,0.0,256.0);
   AVSadd_float_parameter("Diameter",25.0,0.0,256.0);

   AVSset_compute_proc(vgcirc_compute);
   return(1);
}

int vgconst_desc ()
{
   int in_port, out_port, param;
   extern int vgconst_compute();

   AVSset_module_name("vgconst",MODULE_FILTER);

   AVScreate_output_port("image", "field 2D");
   AVSadd_parameter("columns","integer",2,100,512);
   AVSadd_parameter("rows","integer",2,100,512);
   AVSadd_parameter("data","choice","byte","byte,short,integer,float,double,complex,dcomplex",",");
   AVSadd_float_parameter("real constant",100.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("imag constant",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("data bands","integer",2,4,512);

   AVSset_compute_proc(vgconst_compute);
   return(1);
}

int vgfractal_desc ()
{
   int in_port, out_port, param;
   extern int vgfractal_compute();

   AVSset_module_name("vgfractal",MODULE_FILTER);

   AVScreate_output_port("image", "field 2D");
   AVSadd_parameter("No recursions","integer",2,6,10);
   AVSadd_float_parameter("Hurst",0.500000,0.000000,1.000000);
   AVSadd_float_parameter("Std dev",0.5,0.0,10.0);
   AVSadd_parameter("Seed","integer",1,INT_UNBOUND,INT_UNBOUND);
   AVSadd_parameter("Coastline","boolean",0,0,1);
   AVSadd_parameter("Random Add ","boolean",0,0,1);

   AVSset_compute_proc(vgfractal_compute);
   return(1);
}
int vggauss_desc ()
{
   int in_port, out_port, param;
   extern int vggauss_compute();

   AVSset_module_name("vggauss",MODULE_FILTER);

   AVScreate_output_port("image", "field 2D");
   AVSadd_parameter("columns","integer",50,2,512);
   AVSadd_parameter("rows","integer",50,2,512);
   AVSadd_parameter("bands","integer",4,1,512);
   AVSadd_float_parameter("noise mean",0.0,0.0,1.0);
   AVSadd_float_parameter("noise var",0.5,0.0,1.0);
   AVSadd_parameter("data","choice","float","float,complex",",");

   AVSset_compute_proc(vggauss_compute);
   return(1);
}

int vgpwl_desc ()
{
   int in_port, out_port, param;
   extern int vgpwl_compute();

   AVSset_module_name("vgpwl",MODULE_FILTER);

   AVScreate_output_port("image", "field 2D");
   AVSadd_parameter("columns","integer",100,2,512);
   AVSadd_parameter("rows","integer",100,2,512);
   AVSadd_parameter("bands","integer",4,2,512);
   AVSadd_float_parameter("sampling",10.0,1.0,512.0);
   AVSadd_float_parameter("minimum",0.0,0.0,512.0);
   AVSadd_float_parameter("maximum",512.0,0.0,512.0);
   AVSadd_float_parameter("X period",5.0,1.0,100.0);
   AVSadd_float_parameter("Y period",7.0,1.0,100.0);
   AVSadd_float_parameter("X rise",0.0,1.0,100.0);
   AVSadd_float_parameter("Y rise",0.0,1.0,100.0);
   AVSadd_float_parameter("X fall",0.0,1.0,100.0);
   AVSadd_float_parameter("Y fall",0.0,1.0,100.0);
   AVSadd_float_parameter("X width",0.0,1.0,100.0);
   AVSadd_float_parameter("Y width",0.0,1.0,100.0);
   AVSadd_parameter("data","choice","float","float,complex",",");

   AVSset_compute_proc(vgpwl_compute);
   return(1);
}

int vgshot_desc ()
{
   int in_port, out_port, param;
   extern int vgshot_compute();

   AVSset_module_name("vgshot",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("image", "field 2D");
   AVSadd_float_parameter("spikes percent",50.0,0.0,100.0);

   AVSset_compute_proc(vgshot_compute);
   return(1);
}

int vgsin_desc ()
{
   int in_port, out_port, param;
   extern int vgsin_compute();

   AVSset_module_name("vgsin",MODULE_FILTER);

   AVScreate_output_port("image", "field 2D");
   AVSadd_parameter("columns","integer",150,2,512);
   AVSadd_parameter("rows","integer",150,2,512);
   AVSadd_parameter("bands","integer",4,1,512);
   AVSadd_float_parameter("amplitude",35.0,1.0,100.0);
   AVSadd_float_parameter("Sampling Frequency",35.0,1.0,100.0);
   AVSadd_float_parameter("X Frequency",8.0,1.0,100.0);
   AVSadd_float_parameter("Y Frequency",8.0,1.0,100.0);
   AVSadd_float_parameter("X Phase",1.0,1.0,100.0);
   AVSadd_float_parameter("Y Phase",1.0,1.0,100.0);

   AVSset_compute_proc(vgsin_compute);
   return(1);
}

int vimpulse_desc ()
{
   int in_port, out_port, param;
   extern int vimpulse_compute();

   AVSset_module_name("vimpulse",MODULE_FILTER);

   AVScreate_output_port("image", "field 2D");
   AVSadd_parameter("Y spacing","integer",30,1,512);
   AVSadd_parameter("X spacing","integer",30,1,512);
   AVSadd_parameter("Y impulses","integer",400,1,512);
   AVSadd_parameter("X impulses","integer",400,1,512);
   AVSadd_parameter("Y offset","integer",1,1,512);
   AVSadd_parameter("X offset","integer",1,1,512);
   AVSadd_parameter("cols","integer",512,1,512);
   AVSadd_parameter("rows","integer",512,1,512);

   AVSset_compute_proc(vimpulse_compute);
   return(1);
}

int vmarr_desc ()
{
   int in_port, out_port, param;
   extern int vmarr_compute();

   AVSset_module_name("vmarr",MODULE_FILTER);

   AVScreate_output_port("image", "field 2D");
   AVSadd_parameter("cols","integer",250,2,512);
   AVSadd_parameter("rows","integer",250,2,512);
   AVSadd_float_parameter("variance",100.0,1.0,500.0);

   AVSset_compute_proc(vmarr_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/
/* SRT int vcustom_compute (AVSfield *i1,AVSfield **o1,int param1,int param2) */
int vcustom_compute (AVSfield **o1,int param1,int param2, char *param3)/* SRT */ 
{
   int value;
   struct xvimage *ko1;
   struct xvimage *ki1;
   int type; /* SRT */

printf("Enter vcustom_compute\n");
   if (strcmp(param3, "byte") == 0) /*SRT*/
	type = VFF_TYP_1_BYTE; else /*SRT*/
   if (strcmp(param3, "short") == 0) /*SRT*/
	type = VFF_TYP_2_BYTE; else /*SRT*/
   if (strcmp(param3, "integer") == 0) /*SRT*/
	type = VFF_TYP_4_BYTE; else /*SRT*/
   if (strcmp(param3, "float") == 0) /*SRT*/
	type = VFF_TYP_FLOAT; else /*SRT*/
	{ /*SRT*/
	fprintf(stderr, "Invalid data choice '%s'!\n", /*SRT*/
			param3); /*SRT*/
	return 0; /*SRT*/
	} /*SRT*/
 

 /*SRT*/ value=(int)lvcustom(&ko1,param1,param2,type);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
printf("Exit vcustom_compute\n");
 
   return (value);
}
 

int vgauss_compute (/*AVSfield *i1,*/ AVSfield **o1,int param1,int param2,float *param3,float *param4,float *param5,float *param6,float *param7,float *param8,int param9)
{
   int value;
   struct xvimage *ko1;
   struct xvimage *ki1 = NULL;
   struct xvimage *ki2;
 
printf("Enter vgauss_compute\n");
   /*if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);*/
   /* if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0); SRT */

/*SRT*/printf("calling lvgauss with &ko1, %d, %d, %f, %f, %f, %f, %f, %f\n",
			param1, param2, *param3, *param4, *param5, *param6, *param7, *param8);
   value=(int)lvgauss(&ko1,param1,param2,(double)*param3,(double)*param4,
	(double)*param5,(double)*param6,(double)*param7,(double)*param8,
	param9, ki1);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
printf("Exit vgauss_compute\n");
   return (value);
}
 


int vgbox_compute (	AVSfield  **o1,  
			int param1,   	
			int param2,     
			float *param3,  
			float *param4,   
			float *param5,   
			float *param6,  
			int param7,    
			int param8,   
			float *param9,   
			float *param10, 
			float *param11,
			float *param12,   
			float *param13,  
			float *param14)
{
   int value;
   struct xvimage *ko1;
   struct xvimage *ki1;
   char *dummy = '\0';

printf("param1, param2 == %d %d\n", param1, param2);
   printf("Calling createimage(%d %d %d %d %d %s %d %d %d %d %d)\n",
			param2,
                        param1,
                        VFF_TYP_1_BYTE,
                        1,
                        1,
                        dummy,
                        0,
                        0,
                        VFF_MS_NONE,
                        VFF_MAPTYP_NONE,
                        VFF_LOC_IMPLICIT);
   ko1 = createimage(   param2,
                        param1,
                        (unsigned long)/*VFF_TYP_FLOAT*/ VFF_TYP_1_BYTE ,
                        1,
                        1,
                        "created by vbox",
                        0,
                        0,
                        VFF_MS_NONE,
                        VFF_MAPTYP_NONE,
                        VFF_LOC_IMPLICIT,
			(unsigned long)0); /* location dim added SRT */
   if (ko1 == NULL)
    {
       (void) fprintf(stderr,"vgbox: Unable to allocate memory!\\n");
       exit(1);
    }

   value=(int)lvgbox(	(unsigned char *) ko1->imagedata,
			(unsigned short) param1,
			(unsigned short) param2,
			(double) *param3,
			(double) *param4,
			(double) *param5,
			(double) *param6,
			(unsigned char) param7,
			(unsigned char) param8,
			(double) *param9,
			(double) *param10,
			(double) *param11,
			(double) *param12,
			(double) *param13 * XV_PI/180,
			(double) *param14 * XV_PI/180);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return 1 /* (value) SRT */;
}
 
int vgcirc_compute (	AVSfield **o1,
			int r,
			int c,
			char *typeS,
			float *bgnd,
			float *fgnd,
			float *y,
			float *x,
			float *d)
{
   int value;
   struct xvimage *ko1;
   struct xvimage *ki1;
   int type;
 
   if (strcmp(typeS, "byte") == 0) /*SRT*/
	type = VFF_TYP_1_BYTE; else /*SRT*/
   if (strcmp(typeS, "float") == 0) /*SRT*/
	type = VFF_TYP_FLOAT; else /*SRT*/
	{ /*SRT*/
	fprintf(stderr, "Invalid data choice '%s'!\n", /*SRT*/
			typeS); /*SRT*/
	return 0; /*SRT*/
	} /*SRT*/
 
   value=(int)lvgcirc(	&ko1,
			r,
			c,
			type,
			(double) *bgnd,
			(double) *fgnd,
			(double) *x,
			(double) *y,
			(double) *d);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vgconst_compute (	AVSfield **o1,
			int r,
			int c,
			char *typeS,
			float *realc,
			float *imagec,
			int bands)
{
   int value;
   int type;
   struct xvimage *ko1;
   struct xvimage *ki1;
 
   if (strcmp (typeS, "byte") == 0)
	type = VFF_TYP_1_BYTE; else
   if (strcmp (typeS, "short") == 0)
	type = VFF_TYP_2_BYTE; else
   if (strcmp (typeS, "integer") == 0)
	type = VFF_TYP_4_BYTE; else
   if (strcmp (typeS, "float") == 0)
	type = VFF_TYP_FLOAT; else
   if (strcmp (typeS, "double") == 0)
	type = VFF_TYP_COMPLEX; else
   if (strcmp (typeS, "complex") == 0)
	type = VFF_TYP_DOUBLE; else
   if (strcmp (typeS, "dcomplex") == 0)
	type = VFF_TYP_DCOMPLEX; else
	{
	fprintf(stderr, "'%s' is an invalid data choice!\n", typeS);
	return 0;
	}

   value=(int)lvgconst(&ko1,r,c,type,(double) *realc,(double) *imagec,bands);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vgfractal_compute (	AVSfield **o1,
			int maxlevel,
			float *hurst,
			float *sigma,
			int seed,
			int coast,
			int add_flag )
{
   int value;
   struct xvimage *ko1;
   struct xvimage *ki1;
 

   value=(int)lvgfractal(&ko1,
			 maxlevel,
			 (double) *hurst,
			 (double) *sigma,
			 seed,
			 coast,
			 add_flag);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 

int vggauss_compute (	AVSfield **o1,
			int r,
			int c,
			int bands,
			float *mean,
			float *var,
			char *typeS)
{
   int value;
   struct xvimage *ko1;
   int type;

   if (strcmp (typeS, "float") == 0)
	type = VFF_TYP_FLOAT; else
   if (strcmp (typeS, "complex") == 0)
	type = VFF_TYP_COMPLEX; else
	{
	fprintf(stderr, "'%s' is an invalid data choice!\n", typeS);
	return 0;
	}
   value=(int)lvggauss(	&ko1, r, c, bands, (double) *mean, (double) *var, type, 0);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vgpwl_compute (	AVSfield **o1,	
			int rows,
                	int cols,
                	int bands,
                	float *fs,
                	float *minimum,
                	float *maximum,
                	float *xperiod,
                	float *yperiod,
                	float *xrise,
                	float *yrise,
                	float *xfall,
                	float *yfall,
			float *xwidth,
			float *ywidth,
			char *typeS)

{
   int value, type;
   struct xvimage *ko1;
   struct xvimage *ki1;
 
   if (strcmp (typeS, "float") == 0)
	type = VFF_TYP_FLOAT; else
   if (strcmp (typeS, "complex") == 0)
	type = VFF_TYP_COMPLEX; else
	{
	fprintf(stderr, "'%s' is an invalid data choice!\n", typeS);
	return 0;
	}

   value=(int)lvgpwl(	&ko1,rows,cols,bands,
			(double) *fs,
			(double) *minimum,
			(double) *maximum,
			(double) *xperiod,
			(double) *yperiod,
			(double) *xrise,
			(double) *yrise,
			(double) *xfall,
			(double) *yfall,
			(double) *xwidth,
			(double) *ywidth,type);	

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vgshot_compute (AVSfield *i1,AVSfield **o1,float *percent)
{
   int value;
   struct xvimage *ki1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvgshot(ki1,(double)*percent);
 
   if (((*o1)=(AVSfield *)viff_to_field(ki1))==NULL) return (0);
 
   return (value);
}
 
int vgsin_compute (	AVSfield **o1,
			int rows,
			int columns,
			int bands,
			float *amp,
			float *fs,
			float *fx,
			float *fy,
			float *px,
			float *py)
{
   int value;
   struct xvimage *ko1;
   struct xvimage *ki1;
 
   value=(int)lvgsin( 	&ko1,
			rows,
                        columns,
                        bands,
                        (double) *amp,
                        (double) *fs,
                        (double) *fx,
                        (double) *fy,
                        (double) *px,
                        (double) *py,
			VFF_TYP_FLOAT );
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vimpulse_compute (	AVSfield **o1,
                	int deltax,
                	int deltay,
                	int nx,
                	int ny,
                	int xoff,
                	int yoff,
                	int rows,
                	int cols)
{
   int value;
   struct xvimage *ko1;
   struct xvimage *ki1;
 

   value=(int)lvimpulse( &ko1, deltax, deltay, nx, ny, 
				xoff, yoff, rows, cols);

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vmarr_compute (	AVSfield **o1,
			int rows,
			int cols,
			float *variance)
{
   int value;
   struct xvimage *ko1;
 

   value=(int)lvmarr(	&ko1,rows,cols,(double)*variance);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   vcustom_desc,
   vgauss_desc,
   vgbox_desc,
   vgcirc_desc,
   vgconst_desc,
   vgfractal_desc,
   vggauss_desc,
   vgpwl_desc,
   vgshot_desc,
   vgsin_desc,
   vimpulse_desc,
   vmarr_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}


#ifdef SQUAT
/* added to forget about these %$#@$#%^% linking problems for a bit SRT */
double floor (double x)
{
int xi = x;

if (x - xi < 0.5) return (double) xi; 
return xi +1;
}

/* added to forget about these %$#@$#%^% linking problems for a bit SRT */
double ceil (double x)
{
int xi = x + 0.5;

return ((double) xi); 
}
#endif
