 /*
  * Khoros: $Id: lvgconst.c,v 1.2 1991/12/18 09:23:53 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvgconst.c,v 1.2 1991/12/18 09:23:53 dkhoros Exp $";
#endif

 /*
  * $Log: lvgconst.c,v $
 * Revision 1.2  1991/12/18  09:23:53  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvgconst.c
 >>>>
 >>>>      Program Name: vgconst
 >>>>
 >>>> Date Last Updated: Mon Dec  9 23:23:02 1991 
 >>>>
 >>>>          Routines: lvgconst - the library call for vgconst
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvgconst - library call for vgconst
*
* Purpose:
*    
*    Creates an image with constant pixel values.
*    
*    

* Input:
*    
*    Input to lvgconst :
*    
*    image          pointer to VIFF structure containing image data to
*                   be processed.
*    
*    rows           number of rows in output image.
*    
*    cols           number of columns in output image.
*    
*    type      Uses the data storage type convension from the  defines
*              in   the   viff   header.    VFF_TYP_1_BYTE   =   char,
*              VFF_TYP_2_BYTE   =   short,   VFF_TYP_4_BYTE   =   int,
*              VFF_TYP_FLOAT   =  float,  VFF_TYP_COMPLEX  =  complex,
*              VFF_TYP_DOUBLE = double, and VFF_TYP_DCOMPLEX  =  dcom-
*              plex.
*    
*    real      specifices the constant value (level) for the real part
*    
*    imag      specifices the constant value for the imaginary part.
*    
*    bands     defines the number of  data  bands  for  the  resulting
*              image.
*    
*    

* Output:
*    
*    Output from lvgconst :
*    
*    image          pointer to VIFF structure  containing  image  data
*                   after processing.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Marcelo Teran, Ramiro Jordan, Tom Sauer
*    
*    Modifications to lvgconst :
*    
*    7-Feb-91 Scott Wilson - Added DOUBLE and DCOMPLEX data types.
*    
*    

****************************************************************/


/* -library_def */
int
lvgconst (image, rows, cols, type, real, imag, bands)
struct xvimage **image;
int rows, cols, type, bands;
double real, imag;
/* -library_def_end */

/* -library_code */
{
    int i, bsize;
    struct xvimage *kern, *createimage();

    int      *iptr;
    short    *sptr;
    float    *fptr;
    double   *dptr;
    unsigned char *cptr, bit;

    kern = createimage((unsigned long) rows,    /* number of rows */
                        (unsigned long) cols,   /* number of columns */
                        (unsigned long) type,   /* data storage type */
                        (unsigned long) 1,      /* num_of_images */ 
                        (unsigned long) bands,  /* num_data_bands */ 
                        "created by vgctt",     /* comment */
                        (unsigned long) 0,      /* map_row_size */
                        (unsigned long) 0,      /* map_col_size */
                        (unsigned long)
                        VFF_MS_NONE,             /* map_scheme */
                        (unsigned long)
                        VFF_MAPTYP_NONE,        /* map_storage_type */
                        (unsigned long)
                        VFF_LOC_IMPLICIT,       /* location_type */
                        (unsigned long) 0);     /* location_dim */

    if (kern == NULL)
    {
       (void)fprintf(stderr,"lvgconst: Unable to allocate new image!\n");
       *image = NULL;
       return(0);
     }

    if ( kern->data_storage_type == VFF_TYP_1_BYTE )
    {
       if ( real > 255 || real < 0 ) 
       {
          (void) fprintf(stderr,"lvgconst: byte type image 0 < real < 255 !\n");
          return(0);
       }
    }

    switch (kern->data_storage_type)
    {
      case VFF_TYP_BIT:
           if (real != 0.0) bit = 0xff;
           else bit = 0;

           cptr = (unsigned char *) kern->imagedata;
           bsize = ((cols+7)/8)*rows*bands;
           for (i = 0; i < bsize; i++) *cptr++ = bit;
           break;
      case VFF_TYP_1_BYTE:
           cptr = (unsigned char *) kern->imagedata;
           for (i = 0; i < rows*cols*bands; i++) *cptr++ = (unsigned char) real;
           break;
      case VFF_TYP_2_BYTE:
           sptr = (short *) kern->imagedata;
           for (i = 0; i < rows*cols*bands; i++) *sptr++ = (short) real;
           break;
      case VFF_TYP_4_BYTE:
           iptr = (int *) kern->imagedata;
           for (i = 0; i < rows*cols*bands; i++) *iptr++ = (int) real;
           break;
      case VFF_TYP_FLOAT:
           fptr = (float *) kern->imagedata;
           for (i = 0; i < rows*cols*bands; i++) *fptr++ = real;
           break;
      case VFF_TYP_DOUBLE:
           dptr = (double *) kern->imagedata;
           for (i = 0; i < rows*cols*bands; i++) *dptr++ = real;
           break;
      case VFF_TYP_COMPLEX:
           fptr = (float *) kern->imagedata;
           for (i = 0; i < rows*cols*bands; i++) {
               *fptr++ = real;
               *fptr++ = imag;
           }
           break;
      case VFF_TYP_DCOMPLEX:
           dptr = (double *) kern->imagedata;
           for (i = 0; i < rows*cols*bands; i++) {
               *dptr++ = real;
               *dptr++ = imag;
           }
           break;
      default:
           (void) fprintf(stderr,"lvgconst: Unsupported data storage type %d\n",
                       kern->data_storage_type);
        return(0);
    }

    *image = kern;
    return(1);
}

/* -library_code_end */
