 /*
  * Khoros: $Id: lvcast.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvcast.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvcast.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvcast.c
 >>>>
 >>>>      Program Name: vcast
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:23:18 1991 
 >>>>
 >>>>          Routines: lvcast - the library call for vcast
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvcast - library call for vcast
*
* Purpose:
*    
*    Upconvert all images to the highest input image data type.
*    
*    
* Input:
*    
*    images         array of pointers to xvimage structures
*    
*    image_num      integer indicating the number of input images
*    
*    up_type        optional target data type. Pass in "-1" to  select
*                   auto upconvert.
*    
*    
* Output:
*    
*    images         array of pointers to resulting xvimage structures.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    
*
* Written By: Charlie Gage
****************************************************************/


/* -library_def */
int
lvcast(images, image_num, up_type)
struct xvimage **images;
int  image_num, up_type;
/* -library_def_end */

/* -library_code */
{
 int chg_flag,
     prev_type,
     max_type,
     type,
     i;

 chg_flag = 0;
 max_type = 0;
 prev_type = (int) images[0]->data_storage_type;

   /*-------------------------------------------------------
    * Determine highest data type of input images 
    *------------------------------------------------------*/
 for (i=0; i < image_num; i++)
 {
   type = (int) images[i]->data_storage_type;
   if (type > max_type)
   {
     max_type = type;
   }
          /* Set flag if any data type differs from any other */
   if (prev_type != type)
   {
     chg_flag = 1;
   }
   prev_type = type;
 }

   /*------------------------------------------------------
    * Determine if requested data type is equal to
    *     or greater highest data type of input images.
    *-----------------------------------------------------*/
 if (up_type != -1)
 {
   if (up_type >= max_type)
   {
     max_type = up_type;
     chg_flag = 1;
   }
   else
   {
     (void)fprintf(stderr, "lvcast: You have requested a data type that\n");
     (void)fprintf(stderr, "is lower than the highest data type of the\n");
     (void)fprintf(stderr, "input images.  Unable to down cast data.\n");
     return(0);
   }
 }
   
   /*------------------------------------------------------
    * If images are of different data types, 
    *  then upconvert/cast them.
    *-----------------------------------------------------*/
 if (chg_flag == 1)
 {
   for (i=0; i < image_num; i++)
   {
                   /* Upconvert only those images that are not of max_type */
     if ((int) images[i]->data_storage_type != max_type)
     {
                       /* Call lvconvert to upconvert to max data type */
       if (lvconvert(images[i], max_type, 0, 1, 0.0, 1.0) == 0)
       {
         (void)fprintf(stderr,"lvcast: ERROR, lvconvert failed\n");
         return(0);
       }
     }
   }
 }
 else           /*** Do nothing if all images are of the same data type ***/
   return(1);

 return(1);
}  /*** End of lvcast ***/
/* -library_code_end */
