#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int mcovar_desc ()
{
   int in_port, out_port, param;
   extern int mcovar_compute();

   AVSset_module_name("mcovar",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");

   AVSset_compute_proc(mcovar_compute);
   return(1);
}

int meigen_desc ()
{
   int in_port, out_port, param;
   extern int meigen_compute();

   AVSset_module_name("meigen",MODULE_FILTER);

   AVScreate_input_port("Input File","field 2D",REQUIRED);
   AVScreate_output_port("Eigenvector Output File ","field 2D");
   AVScreate_output_port("Eigenvalue Output File  ","field 2D");
   AVSadd_parameter("Math Type","choice","Scalar","Scalar,Vector",",");

   AVSset_compute_proc(meigen_compute);
   return(1);
}

int minfo_desc ()
{
   int in_port, out_port, param;
   extern int minfo_compute();

   AVSset_module_name("minfo",MODULE_FILTER);

   AVScreate_input_port("Input Matrix Image","field 2D",REQUIRED);
   ADD_FILE;

   AVSset_compute_proc(minfo_compute);
   return(1);
}

int minvert_desc ()
{
   int in_port, out_port, param;
   extern int minvert_compute();

   AVSset_module_name("minvert",MODULE_FILTER);

   AVScreate_input_port("Input Image   ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");

   AVSset_compute_proc(minvert_compute);
   return(1);
}

int mlde_desc ()
{
   int in_port, out_port, param;
   extern int mlde_compute();

   AVSset_module_name("mlde",MODULE_FILTER);

   AVScreate_input_port("Coefficient Matrix A        ","field 2D",REQUIRED);
   AVScreate_input_port("Constant Driving Term Vector","field 2D",REQUIRED);
   AVScreate_input_port("Initial Value Vector        ","field 2D",REQUIRED);
   AVScreate_output_port("Solution Data File  ","field 2D");
   AVSadd_float_parameter("initial time",0.000000,0.000000,10000000.0);
   AVSadd_float_parameter("final time",1.000000,0.000000,10000000.0);
   AVSadd_float_parameter("time step",0.100000,0.000000,100000.0);

   AVSset_compute_proc(mlde_compute);
   return(1);
}

int mlse_desc ()
{
   int in_port, out_port, param;
   extern int mlse_compute();

   AVSset_module_name("mlse",MODULE_FILTER);

   AVScreate_input_port("Coefficient Matrix A","field 2D",REQUIRED);
   AVScreate_input_port("Vector B            ","field 2D",REQUIRED);
   AVScreate_output_port("Solution Vector     ","field 2D");

   AVSset_compute_proc(mlse_compute);
   return(1);
}

int mlud_desc ()
{
   int in_port, out_port, param;
   extern int mlud_compute();

   AVSset_module_name("mlud",MODULE_FILTER);

   AVScreate_input_port("Input Matrix","field 2D",REQUIRED);
   AVScreate_output_port("Lower Diagonal Output Matrix ","field 2D");
   AVScreate_output_port("Upper Diagonal Output Matrix ","field 2D");

   AVSset_compute_proc(mlud_compute);
   return(1);
}

int mmult_desc ()
{
   int in_port, out_port, param;
   extern int mmult_compute();

   AVSset_module_name("mmult",MODULE_FILTER);

   AVScreate_input_port("Input Matrix #1","field 2D",REQUIRED);
   AVScreate_input_port("Input Matrix #2","field 2D",REQUIRED);
   AVScreate_output_port("Output Matrix  ","field 2D");

   AVSset_compute_proc(mmult_compute);
   return(1);
}

int msvd_desc ()
{
   int in_port, out_port, param;
   extern int msvd_compute();

   AVSset_module_name("msvd",MODULE_FILTER);

   AVScreate_input_port("Input Image","field 2D",REQUIRED);
   AVScreate_output_port("Unitary Output Image U ","field 2D");
   AVScreate_output_port("Singular Output Image S","field 2D");
   AVScreate_output_port("Unitary Output Image V ","field 2D");

   AVSset_compute_proc(msvd_compute);
   return(1);
}

int mtrans_desc ()
{
   int in_port, out_port, param;
   extern int mtrans_compute();

   AVSset_module_name("mtrans",MODULE_FILTER);

   AVScreate_input_port("Input Matrix   ","field 2D",REQUIRED);
   AVScreate_output_port("Output Matrix  ","field 2D");
   AVSadd_parameter("conjugate","choice","conjugate","no conjugate|conjugate","|");

   AVSset_compute_proc(mtrans_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int mcovar_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lmcovar(ki1,&ko1);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int meigen_compute (AVSfield *i1,AVSfield **o1,AVSfield **o2,int param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ko2;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lmeigen(ki1,ko2,3,AVSchoice_number("Math Type"));
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
 
   return (value);
}
 
int minfo_compute (AVSfield *i1,char *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;

   FILE *fp;
 
   FILE_OPEN(fp,param1);

   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lminfo(ki1,fp);
 
   FILE_CLOSE(fp,param1);

   return (value);
}
 
int minvert_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lminvert(ki1);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int mlde_compute (AVSfield *i1,AVSfield *i2,AVSfield *i3,AVSfield **o1,float *param1,float *param2,float *param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ki3;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i3)
      if ((ki3=(struct xvimage *)field_to_viff(i3))==NULL) return(0);

   value=(int)lmlde(ki1,ki2,ki3,*param1,*param2,*param3);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int mlse_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lmlse(ki1,ki2);
  
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int mlud_compute (AVSfield *i1,AVSfield **o1,AVSfield **o2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ko2;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lmlud(ki1,ko2);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
 
   return (value);
}
 
int mmult_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lmmult(ki1,ki2);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int msvd_compute (AVSfield *i1,AVSfield **o1,AVSfield **o2,AVSfield **o3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ko2;
   struct xvimage *ko3;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lmsvd(ki1,ko2,ko3);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
   if (((*o3)=(AVSfield *)viff_to_field(ko3))==NULL) return (0);
 
   return (value);
}
 
int mtrans_compute (AVSfield *i1,AVSfield **o1,int param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lmtrans(ki1,AVSchoice_number("conjugate"));

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   mcovar_desc,
   meigen_desc,
   minfo_desc,
   minvert_desc,
   mlde_desc,
   mlse_desc,
   mlud_desc,
   mmult_desc,
   msvd_desc,
   mtrans_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

