#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int dcpad_desc ()
{
   int in_port, out_port, param;
   extern int dcpad_compute();

   AVSset_module_name("dcpad",MODULE_FILTER);

   AVScreate_input_port("Input file ","field 2D",REQUIRED);
   AVScreate_output_port("Output file","field 2D");
   AVSadd_parameter("length","integer",2,2,256);
   AVSadd_parameter("offset","integer",1,0,256);
   AVSadd_float_parameter("real pad",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("imag pad",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dcpad_compute);
   return(1);
}

int dextract_desc ()
{
   int in_port, out_port, param;
   extern int dextract_compute();

   AVSset_module_name("dextract",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("start","integer",1,1,4);
   AVSadd_parameter("finish","choice","to end","to end,length",",");
   AVSadd_parameter("length","integer",1,1,4);
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dextract_compute);
   return(1);
}

int dinsert_desc ()
{
   int in_port, out_port, param;
   extern int dinsert_compute();

   AVSset_module_name("dinsert",MODULE_FILTER);

   AVScreate_input_port("Input File (1)    ","field 2D",REQUIRED);
   AVScreate_input_port("File to Insert (2)","field 2D",REQUIRED);
   AVScreate_input_port("Insert File","field 2D",OPTIONAL);
   AVScreate_output_port("Output File       ","field 2D");
   AVSadd_parameter("position","choice","append","append,specify",",");
   AVSadd_parameter("specify","integer",1,1,256);
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dinsert_compute);
   return(1);
}

int dmirror_desc ()
{
   int in_port, out_port, param;
   extern int dmirror_compute();

   AVSset_module_name("dmirror",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("type","choice","exact","exact,conjugate,complex mirro",",");
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dmirror_compute);
   return(1);
}

int dnormal_desc ()
{
   int in_port, out_port, param;
   extern int dnormal_compute();

   AVSset_module_name("dnormal",MODULE_FILTER);

   AVScreate_input_port("Input file  ","field 2D",REQUIRED);
   AVScreate_output_port("Output file ","field 2D");
   AVSadd_parameter("normal","choice","normal","normal,scale&shift",",");
   AVSadd_float_parameter("minimum",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("maximum",1.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dnormal_compute);
   return(1);
}

int dscale_desc ()
{
   int in_port, out_port, param;
   extern int dscale_compute();

   AVSset_module_name("dscale",MODULE_FILTER);

   AVScreate_input_port("Input file  ","field 2D",REQUIRED);
   AVScreate_output_port("Output file ","field 2D");
   AVSadd_float_parameter("scale",1.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dscale_compute);
   return(1);
}

int dshift_desc ()
{
   int in_port, out_port, param;
   extern int dshift_compute();

   AVSset_module_name("dshift",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_input_port("Value(s) File ","field 2D",OPTIONAL);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("which","choice","shift","shift,rotate",",");
   AVSadd_float_parameter("Real Pad",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("Imag Pad",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("Constant","integer",1,INT_UNBOUND,INT_UNBOUND);
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dshift_compute);
   return(1);
}

int dsubsamp_desc ()
{
   int in_port, out_port, param;
   extern int dsubsamp_compute();

   AVSset_module_name("dsubsamp",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("skip value","integer",0,INT_UNBOUND,INT_UNBOUND);
   AVSadd_parameter("first point","integer",0,INT_UNBOUND,INT_UNBOUND);
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dsubsamp_compute);
   return(1);
}

int dwindow_desc ()
{
   int in_port, out_port, param;
   extern int dwindow_compute();

   AVSset_module_name("dwindow",MODULE_FILTER);

   AVScreate_input_port("Input file  ","field 2D",REQUIRED);
   AVScreate_output_port("Output file ","field 2D");
   AVSadd_parameter("window","choice","Rectangular","Rectangular,Bartlett,Hamming,Hanning,Parzen,Kaiser,Exponential,Blackman,Blackman,Right-Triangular,Left-Triangular,Right-Exponential,Left-Exponential,User Defined",",");
   AVSadd_float_parameter("theta",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("damping",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");
   AVSadd_parameter("width","integer",0,0,256);

   AVSset_compute_proc(dwindow_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int dcpad_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,float *param3,float *param4,char *param5)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldcpad(ki1,param1,param2,*param3,*param4,AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dextract_compute (AVSfield *i1,AVSfield **o1,int param1,char *param2,int param3,char *param4)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldextract(ki1,param1,AVSchoice_number("finish"),param3,AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dinsert_compute (AVSfield *i1,AVSfield *i2,AVSfield *i3,AVSfield **o1,char *param1,int param2,char *param3)
{
   int value;
   int end_flg;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
   struct xvimage *ki3;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i3)
      if ((ki3=(struct xvimage *)field_to_viff(i3))==NULL) return(0);
   
   end_flg = 1; /*for lack of any better way to determine if end of file*/

   value=(int)ldinsert(ki1,ki2,ki3,AVSchoice_number("position"),param2,end_flg,AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dmirror_compute (AVSfield *i1,AVSfield **o1,char *param1,char *param2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldmirror(ki1,AVSchoice_number("type"),AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dnormal_compute (AVSfield *i1,AVSfield **o1,char *param1,float *param2,float *param3,char *param4)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldnormal(ki1,*param2,*param3,AVSchoice_number("normal"),AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dscale_compute (AVSfield *i1,AVSfield **o1,float *param1,char *param2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldscale(ki1,*param1,AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dshift_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,char *param1,float *param2,float *param3,int param4,char *param5)
{
   int value;
   int i2_flg;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ki2;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i2) i2_flg=TRUE;
   else i2_flg=FALSE;         

  value=(int)ldshift(ki1,ki2,i2_flg,param4,AVSchoice_number("which"),*param2,*param3,AVSchoice_number("direction"));
   ko1=ki1;

 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dsubsamp_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,char *param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldsubsamp(ki1,param1,param2,AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dwindow_compute (AVSfield *i1,AVSfield **o1,char *param1,float *param2,float *param3,char *param4,int param5)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldwindow(ki1,AVSchoice_number("window"),*param2,*param3,param5,AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   dcpad_desc,
   dextract_desc,
   dinsert_desc,
   dmirror_desc,
   dnormal_desc,
   dscale_desc,
   dshift_desc,
   dsubsamp_desc,
   dwindow_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

