#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"

#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int v1bgamut_desc ()
{
   int in_port, out_port, param;
   extern int v1bgamut_compute();

   AVSset_module_name("v1bgamut",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("Compression","integer",128,1,256);
   AVSadd_float_parameter("2-norm fract",0.5,0.0,1.0);

   AVSset_compute_proc(v1bgamut_compute);
   return(1);
}

int vclose_desc ()
{
   int in_port, out_port, param;
   extern int vclose_compute();

   AVSset_module_name("vclose",MODULE_FILTER);

   AVScreate_input_port("Input Boundary Image","field 2D",REQUIRED);
   AVScreate_input_port("Input Gradient Image","field 2D",REQUIRED);
   AVScreate_output_port("Output Image or File","field 2D");
   AVSadd_parameter("Threshold","integer",1,1,512);
   AVSadd_parameter("Min Gap","integer",1,1,512);

   AVSset_compute_proc(vclose_compute);
   return(1);
}

int vdistance_desc ()
{
   int in_port, out_port, param;
   extern int vdistance_compute();

   AVSset_module_name("vdistance",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");

   AVSset_compute_proc(vdistance_compute);
   return(1);
}

int vdyth_desc ()
{
   int in_port, out_port, param;
   extern int vdyth_compute();

   AVSset_module_name("vdyth",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("width","integer",3,1,100);
   AVSadd_parameter("height","integer",3,1,100);
   AVSadd_parameter("non zero","integer",255,0,255);
   AVSadd_parameter("threshold","choice","median","median,mean",",");

   AVSset_compute_proc(vdyth_compute);
   return(1);
}

int vgamth_desc ()
{
   int in_port, out_port, param;
   extern int vgamth_compute();

   AVSset_module_name("vgamth",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("high red","integer",0,0,0);
   AVSadd_parameter("low red","integer",0,0,0);
   AVSadd_parameter("high green","integer",0,0,0);
   AVSadd_parameter("low green","integer",0,0,0);
   AVSadd_parameter("high blue","integer",0,0,0);
   AVSadd_parameter("low blue","integer",0,0,0);
   AVSadd_parameter("non-zero","integer",128,0,255);

   AVSset_compute_proc(vgamth_compute);
   return(1);
}

int vgrow_desc ()
{
   int in_port, out_port, param;
   extern int vgrow_compute();

   AVSset_module_name("vgrow",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");

   AVSset_compute_proc(vgrow_compute);
   return(1);
}

int vmediaxis_desc ()
{
   int in_port, out_port, param;
   extern int vmediaxis_compute();

   AVSset_module_name("vmediaxis",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("Border Distance","choice","white","white,distance",",");

   AVSset_compute_proc(vmediaxis_compute);
   return(1);
}

int vthresh_desc ()
{
   int in_port, out_port, param;
   extern int vthresh_compute();

   AVSset_module_name("vthresh",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_float_parameter("low threshold",0,0,255);
   AVSadd_float_parameter("hi threshold",255,0,255);
   AVSadd_float_parameter("non-zero",0,0,255);

   AVSset_compute_proc(vthresh_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int v1bgamut_compute (AVSfield *i1,AVSfield **o1,int param1,float *param2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lv1bgamut(ki1,param1,*param2);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vclose_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,int param1,int param2)
{
   int value;
   int cols,rows; /* size of both images (+ or same?) */
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
   unsigned char  *c1;
   unsigned char  *c2;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

/* this assumes nc and nr in l*.c wants them to be same size, not sum of 2*/
   cols = ki1->col_size;
   rows = ki1->row_size;

   c1 = (unsigned char *) malloc(cols*rows*sizeof(unsigned char));
   c2 = (unsigned char *) malloc(cols*rows*sizeof(unsigned char));

   c1 = (unsigned char *)ki1->imagedata;
   c2 = (unsigned char *)ki2->imagedata;

   value=(int)lvclose(c1,c2,cols,rows,param1,param2);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vdistance_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvdistance(ki1);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vdyth_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,int param3,char *param4)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvdyth(ki1,param1,param2,param3,AVSchoice_number("threshold"));
   ko1=ki1; 

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vgamth_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,int param3,int param4,int param5,int param6,int param7)
{
   int value;
   int param1flag,param2flag,param3flag,param4flag,param5flag,param6flag,param7flag;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

/* there shoud be some checking here to mack sure values of param# are within
pixel bounds */
   if (param1) param1flag=1;
   else param1flag=0;
   if (param2) param2flag=1;
   else param2flag=0;
   if (param3) param3flag=1;
   else param3flag=0;
   if (param4) param4flag=1;
   else param4flag=0;
   if (param5) param5flag=1;
   else param5flag=0;
   if (param6) param6flag=1;
   else param6flag=0;
   if (param7) param7flag=1;
   else param7flag=0;

   value=(int)lvgamth(ki1,param1,param2,param3,param4,param5,param6,param1flag,param2flag,param3flag,param4flag,param5flag,param6flag,param7flag,param7);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vgrow_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvgrow(ki1);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vmediaxis_compute (AVSfield *i1,AVSfield **o1,int param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvmediaxis(ki1,param1);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vthresh_compute (AVSfield *i1,AVSfield **o1,float *param1,float *param2,float *param3)
{
   int value;
   int lflag,uflag;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   lflag = 1;
   uflag = 1;

   value=(int)lvthresh(ki1,lflag,*param1,uflag,*param2,*param3);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   v1bgamut_desc,
   vclose_desc,
   vdistance_desc,
   vdyth_desc,
   vgamth_desc,
   vgrow_desc,
   vmediaxis_desc,
   vthresh_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

