#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"

#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int vfft_desc ()
{
   int in_port, out_port, param;
   extern int vfft_compute();

   AVSset_module_name("vfft",MODULE_FILTER);

   AVScreate_input_port("Complex or real image","field 2D float",REQUIRED);
   AVScreate_input_port("Imaginary image   ","field 2D float",OPTIONAL);
   AVScreate_output_port("Complex image  ","field 2D");
   AVScreate_output_port("Real image     ","field 2D");
   AVScreate_output_port("Imaginary image","field 2D");
   AVSadd_parameter("direction","choice","Forward","Forward,Inverse",",");

   AVSset_compute_proc(vfft_compute);
   return(1);
}

int vfht_desc ()
{
   int in_port, out_port, param;
   extern int vfht_compute();

   AVSset_module_name("vfht",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("inverse","boolean",0,0,1);

   AVSset_compute_proc(vfht_compute);
   return(1);
}

int vmpp_desc ()
{
   int in_port, out_port, param;
   extern int vmpp_compute();

   AVSset_module_name("vmpp",MODULE_FILTER);

   AVScreate_input_port("Input Image   ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");
   AVSadd_parameter("info","choice","magnitude","magnitude,log (mag+1),power,low (pow+1),phase",",");

   AVSset_compute_proc(vmpp_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int vfft_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,AVSfield **o2,AVSfield **o3,char *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
   struct xvimage *ko2;
   struct xvimage *ko3;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvfft(ki1,ki2,1,&ko1,1,&ko2,1,&ko3,AVSchoice_number("direction"));
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
   if (((*o3)=(AVSfield *)viff_to_field(ko3))==NULL) return (0);
 
   return (value);
}
 
int vfht_compute (AVSfield *i1,AVSfield **o1,int param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvfht(ki1,param1);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vmpp_compute (AVSfield *i1,AVSfield **o1,char *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvmpp(ki1,AVSchoice_number("info"));

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   vfft_desc,
   vfht_desc,
   vmpp_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

