/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* This is a modification of the field to contour
module by Wes Bethel. 

    Enhancements include:
      1. Generating contours as polylines and not disjoint lines
         for faster rendering;
      2. Generating whole range of contours by a single module;
      3. Generating surfaces (these produced by field_to_mesh
         do not fit into dimensions, sometime);
      4. Optional plane and/or 3D maps;
      5. Second field and colormap input to color surfaces. 
*/


#include <stdio.h>
#include <avs/avs.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
#include <avs/colormap.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/udata.h>

#define sqrtf sqrt /* IAC Code Addition */

AVSinit_modules()
{
        int             contour();
        AVSmodule_from_desc(contour);
}

int
contour()
{
        int             p, contour_p(), contour_init();

        AVSset_module_name("3D contour map", MODULE_MAPPER);

        AVSset_module_flags(COOPERATIVE | REENTRANT);

        AVScreate_input_port("InputField", "field 2D scalar float", REQUIRED);
        AVScreate_input_port("InputCmap", "colormap", REQUIRED);
        AVScreate_input_port("InputField2", "field 2D scalar float", OPTIONAL);
        AVScreate_input_port("InputCmap2", "colormap", OPTIONAL);
        AVScreate_output_port("OutputGeom", "geom");
        AVScreate_output_port("val 0", "real");
        AVScreate_output_port("delta", "real");

        p = AVSadd_parameter("Levels computed", "boolean", 1, 0, 1);
        AVSconnect_widget(p, "toggle");

        p = AVSadd_parameter("Nice levels", "boolean", 1, 0, 1);
        AVSconnect_widget(p, "toggle");

        p = AVSadd_parameter("Levels", "integer",10, 1, 100);
        AVSconnect_widget(p, "islider");

        p = AVSadd_float_parameter("Level 0", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
        AVSconnect_widget(p, "typein_real");

        p = AVSadd_float_parameter("Delta", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
        AVSconnect_widget(p, "typein_real");

        p = AVSadd_parameter("Boundary On/Off", "boolean", 1, 0, 1);

        p = AVSadd_parameter("zchoice", "choice", "z normalized", "z=field data!z normalized", "!");
        AVSconnect_widget(p, "radio buttons");

        p = AVSadd_float_parameter("Z scale", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
        AVSconnect_widget(p, "dial");

        p = AVSadd_float_parameter("Z offset", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
        AVSconnect_widget(p, "dial");

        p = AVSadd_float_parameter("Contour offset", 0.01, -.1, .1);
        AVSconnect_widget(p, "slider");

        p = AVSadd_parameter("Output surface", "tristate", 0, 0, 1);

        p = AVSadd_parameter("Color contours", "boolean", 1, 0, 1);

        p = AVSadd_parameter("Plane map", "boolean", 0, 0, 1);

        p = AVSadd_parameter("Color plane contours", "boolean", 1, 0, 1);

        p = AVSadd_parameter("Color plane", "boolean", 1, 0, 1);


        p = AVSadd_float_parameter("Label height", 0.01, 0., 0.5);
        AVSconnect_widget(p, "slider");

        p = AVSadd_parameter("Labelled levels", "integer",0, 0, 100);
        AVSconnect_widget(p, "islider");

        AVSset_init_proc(contour_init);
        AVSset_compute_proc(contour_p);
}

int
contour_init()
{
}

#define MAXLEN 2000
#define LEN 1000
/* maximum lengths of contour segments*/
#define LOWER 0
#define UPPER 1

/* pointers to the x,y,z coordinates in the input field */
static float   *xp, *yp, *zp, *field_coords, *d;

/* field dimensions - again to avoid pointers */
static int      dim0, dim1, npoly;

/* to be passed for proper 3D axis description */
static float    minval, maxval, val0, deltav;

/* map of already processed triangles - to be allocated */
static unsigned char *proc;

/* tables for storing the polylines built  */
static float    polyline[MAXLEN][3],tmp_poly[LEN][3];
static float    normals[MAXLEN][3],tmp_norm[LEN][3];
static float    colors[MAXLEN][3];
static float	lab_height;
static int      lab_dens,do_label;
int
contour_p(inf, cmap, inf2, cmap2,
        og, val_0, delta_val,
        lev_comp, nice_lev, levels, level0, delta,
        boundary_onoff, 
        zchoice, zscale, zoffset,
        coffset, 
        surface, col, 
	plane, col_pl_cont, col_plane,
	label_ht,label_lev)

/*      inf is the field to be contoured,
optional inf2 will be used for surface coloring */
        AVSfield_float *inf, *inf2;

/*
optional cmap2 for surface coloring */
        AVScolormap    *cmap, *cmap2;

        GEOMedit_list  *og;

/*      val 0 is mapped to z=0,
        delta_val is mapped to z interval of length 1 -
        both for use for axis description */
        float          **val_0, **delta_val;

/*      switches - if levels have to span entire val range
        and be rounded*/
        int             lev_comp, nice_lev;

/*      number of threshold levels (can be altered if nice_lev!=0 */
        int             levels;

/*      initial level and level spacing */
        float          *level0, *delta;

/*      boundary and flat map control switches */
        int             boundary_onoff;

/*      if inf is 2-space, how to interpret field values */
        char           *zchoice;

/*      length of interval to which values will be mapped */
        float          *zscale;

/*      position of the plane map */
        float          *zoffset;

/*      offset of curface with respect to contours */
        float          *coffset;

/*      switches to control contour coloring,
                 surface output and coloring,
                          plane map coloring */
        int             col, surface, plane, col_pl_cont, col_plane;
        float          *label_ht;
        int             label_lev;
{
        GEOMobj        *contour_obj;
        GEOMobj        *contour_0_obj;
        GEOMobj        *surface_obj;
        GEOMobj        *plane_obj;
        GEOMobj        *label_obj;
        float          *extent = NULL, level;
        float           contour_shade[3];
        int             index, status, i, j, lev, valid;
        char            *minfld, *maxfld;
        char            *comment="contouring";
        static void     hsv_to_rgb();
        int             zinterpret = AVSchoice_number("zchoice", zchoice);
        int             surf;
        int             col_surf;
        int             label_flg;
        float           maxlev;


        *val_0=&val0; *delta_val=&deltav;
	lab_height=*label_ht;
        surf=    (surface>0 ? 1 : 0);
        col_surf=(surface>1 ? 1 : 0);
        d = inf->data;
        dim1 = inf->dimensions[1];
        dim0 = inf->dimensions[0];
        if (inf2 != NULL)
            {
            if ((dim1 != inf2->dimensions[1])||
                (dim0 != inf->dimensions[0]))
               {AVSerror("Both inputs must have the same dimensions");
                return 0;}
            }

        AVSfield_reset_minmax(inf);
        minfld = (char *) &minval;
        maxfld = (char *) &maxval;
        status = AVSfield_get_minmax(inf, minfld, maxfld);
        if ((zinterpret==2) && (*zscale!=0.))
            {
                **val_0 = minval;
                **delta_val = (maxval-minval)/(*zscale);
            }
            else
            {
                **val_0 = **delta_val = 0.;
                AVSmark_output_unchanged("val 0");
                AVSmark_output_unchanged("delta");
            }
        if ((inf->nspace ==3) &&  (inf->uniform == IRREGULAR)) {
                AVSparameter_visible("zchoice", 0);
                AVSparameter_visible("Z scale", 0);
                AVSparameter_visible("Z offset", 0);
                AVSparameter_visible("Plane map", 0);
                AVSparameter_visible("Color plane", 0);
                *zscale=*zoffset=0.;
                plane=0;
                }
        else {
                AVSparameter_visible("zchoice", 1);
                AVSparameter_visible("Z scale", 1);
                AVSparameter_visible("Plane map", 1);
                AVSparameter_visible("Output surface", 1);
                if (plane!=0)
		      {
                      AVSparameter_visible("Z offset", 1);
                      AVSparameter_visible("Color plane", 1);
		      }
                else
		      {
                      AVSparameter_visible("Color plane", 0);
                      AVSparameter_visible("Z offset", 0);
		      }
                if (surf!=0)
                      AVSparameter_visible("Contour offset", 1);
                else
                      AVSparameter_visible("Contour offset", 0);
                }
        if (surf!=0)
                AVSparameter_visible("Contour offset", 1);
        else
                AVSparameter_visible("Contour offset", 0);
 

        if (lev_comp == 1) {
                maxlev=maxval;
                *level0 = minval;
                *delta = (maxval - minval) / (float) (1+levels);
                }
        else
                maxlev=*level0+levels*(*delta);
        if (nice_lev==1) {
                nice_interval(*level0,maxlev,&levels,level0,delta);
                AVSmodify_parameter("Levels",AVS_VALUE,levels,0,0);
                AVSmodify_float_parameter("Level 0",AVS_VALUE,*level0,0.,0.);
                AVSmodify_float_parameter("Delta",AVS_VALUE,*delta,0.,0.);
                }
	lab_dens=levels/(1+label_lev)+1;
        build_field_coords(inf, zinterpret, minval, maxval, *zscale);

        /* initialize edit list.... */
        npoly = 0;
                        for (i = 0; i < MAXLEN; i++)
                                for (j = 0; j < 3; j++)
                                        colors[i][j] = 1.;
        *og = GEOMinit_edit_list(*og);
        contour_obj = GEOMcreate_obj(GEOM_POLYTRI, extent);
        contour_0_obj = GEOMcreate_obj(GEOM_POLYTRI, extent);
    	label_flg   = GEOMcreate_label_flags(1,0,0,0,GEOM_LABEL_CENTER,0);
    	label_obj   = GEOMcreate_label(GEOM_NULL,label_flg);
        for (level = (*level0)+(*delta),lev=1;lev<=levels;lev++, level += (*delta))
        {
                index = AVScmap_index(cmap, level);
                hsv_to_rgb(contour_shade, contour_shade + 1, contour_shade + 2,
                                   cmap->hue[index], cmap->saturation[index], cmap->value[index]);

                for (i = 0; i < MAXLEN; i++)
                        for (j = 0; j < 3; j++)
                                colors[i][j] = (*(contour_shade + j));
		do_label=(((lev%lab_dens)==0)&&(label_lev!=0)?1:0);
                build_contour_list
                        (contour_obj,contour_0_obj,label_obj, inf, level, col, plane, col_pl_cont, *zoffset);
                AVSmodule_status(comment,(100*lev)/levels);

        }

        if (boundary_onoff == 1)
                boundary(contour_obj,contour_0_obj, inf, col, plane, *zoffset);
        GEOMset_extent(contour_obj);
        GEOMset_extent(contour_0_obj);
        GEOMedit_geometry(*og, "contour", contour_obj);
        GEOMedit_geometry(*og, "contour 0", contour_0_obj);
        GEOMedit_geometry(*og, "contour labels", label_obj);
        GEOMdestroy_obj(contour_obj);
        GEOMdestroy_obj(label_obj);
        GEOMdestroy_obj(contour_0_obj);

        surface_obj = GEOMcreate_obj(GEOM_POLYTRI, extent);
        plane_obj = GEOMcreate_obj(GEOM_POLYTRI, extent);
        if (surf+plane >= 1)
            {if (inf2 == NULL)
                build_surface(surface_obj, plane_obj, inf, inf, cmap, surf, col_surf, plane, col_plane, *coffset,*zoffset);
             else
                {
                if (cmap2 == NULL)
                     build_surface(surface_obj, plane_obj, inf, inf2, cmap, surf, col_surf, plane, col_plane, *coffset, *zoffset);
                else
                     build_surface(surface_obj, plane_obj, inf, inf2, cmap2, surf, col_surf, plane, col_plane, *coffset, *zoffset);
                }
            }

        GEOMset_extent(surface_obj);
        GEOMedit_geometry(*og, "surface", surface_obj);
        GEOMdestroy_obj(surface_obj);
        GEOMset_extent(plane_obj);
        GEOMedit_geometry(*og, "plane", plane_obj);
        GEOMdestroy_obj(plane_obj);
	GEOMedit_parent(*og, "contour 0", "plane");
	GEOMedit_parent(*og, "surface", "contour");
	GEOMedit_parent(*og, "contour labels", "contour");
        GEOMedit_transform_mode(*og, "contour 0", "parent", BUTTON_MOVING + BUTTON_UP);
        GEOMedit_transform_mode(*og, "surface", "parent", BUTTON_MOVING + BUTTON_UP);
        GEOMedit_transform_mode(*og, "contour labels", "parent", BUTTON_MOVING + BUTTON_UP);
        GEOMedit_transform_mode(*og, "contour", "parent", BUTTON_MOVING + BUTTON_UP);
        if ((inf->nspace == 2) || (inf->uniform != IRREGULAR))

/* IAC CODE CHANGE :                 free((char *) field_coords); */
                 free( field_coords);

/* IAC CODE CHANGE :         free((char *) proc); */
         free( proc);
        return (1);
}

build_field_coords(inf, zinterpret, minval, maxval, zscale)
        AVSfield_float *inf;
        int             zinterpret;
        float           minval, maxval, zscale;
{
        int             i, j, offset0, offset1;
        /*
         * for uniform and rectilinear fields, build arrays which "look like"
         * the coordinates in irregular fields.
         */
        if ((inf->nspace == 2) || (inf->uniform == UNIFORM) || (inf->uniform == RECTILINEAR)) {
                field_coords = (float *) malloc(sizeof(float) * 3 * dim0 * dim1);
                if (field_coords == NULL)
                        AVSerror("Malloc failure in contour_p for coordinates.");

                if (inf->uniform == UNIFORM)
                        build_uniform_coords(field_coords, inf, zinterpret, minval, maxval, zscale);
                else {
                        if (inf->uniform == RECTILINEAR)
                                build_rectilinear_coords(field_coords, inf, zinterpret, minval, maxval, zscale);
                        else
                                build_irregular_coords(field_coords, inf, zinterpret, minval, maxval, zscale);
                }
        } else
                field_coords = inf->points;
        xp = field_coords;
        yp = field_coords + (dim0 * dim1);      /* 2D field ! */
        zp = field_coords + 2 * (dim0 * dim1);
        proc = (char *) malloc((dim0 * dim1));
        if (proc == NULL)
                AVSerror("Malloc failure in contour_p for aux_table.");

}

#define ADDRESS(i,j) (j)*dim0+(i)

static void
mark(i, j, position)
        int             i, j, position;
{
/* register int  addr=ADDRESS(i, j);
        proc[addr/4] = proc[addr/4] | (position ? 2 : 1) << 2*(addr%4);*/
        proc[ADDRESS(i, j)] = proc[ADDRESS(i, j)] | (position ? 2 : 1);
}

static
done(i, j, position)
        int             i, j, position;
{
/*register int  addr=ADDRESS(i, j);
        return (int) proc[addr/4] & (position ? 2 : 1) << 2*(addr%4);*/
        return (int) proc[ADDRESS(i, j)] & (position ? 2 : 1) ;
}

build_contour_list(obj,obj0,objl, inf, lev, col, flat, col_flat, offset)
        GEOMobj        *obj,*obj0,*objl;
        AVSfield_float *inf;
        float           lev, offset;
        int             col, flat, col_flat;
{
        int             i, j;
        char 		txt[10];
	float		ref_pt[3];

        for (j = 0; j < dim0 * dim1; proc[j++] = (unsigned char) 0);



        for (i = 0; i < dim0 - 1; i++)
                for (j = 0; j < dim1 - 1; j++) {
                        if (!(proc[ADDRESS(i, j)] & 2))
                                start_triangle(i, j, UPPER, inf, lev, col, obj,obj0,objl, flat, col_flat, offset);
                        if (!(proc[ADDRESS(i, j)] & 1))
                                start_triangle(i, j, LOWER, inf, lev, col, obj,obj0,objl, flat, col_flat, offset);
                }
}



start_triangle(i, j, position, inf, lev, col, obj, obj0, objl, flat, col_flat, offset)
        int             i, j, position;
        AVSfield_float *inf;
        float           lev,offset;
        int             col, flat, col_flat;
        GEOMobj        *obj,*obj0,*objl;
{

        int             p0, p1, p2, opcode, length;
        double          u, v;
    	float 		lab_offset[3];
        char 		txt[10];
	float		ref_pt[3];
        static int      THRESHCROSS();

        mark(i, j, position, inf);
        p0 = ADDRESS(i, j);
        p1 = ADDRESS(i + 1, j + 1);
        p2 = (position ? ADDRESS(i + 1, j) : ADDRESS(i, j + 1));
        opcode = 0;
        if (THRESHCROSS(d + p0, d + p1, lev))
                opcode |= 1;
        if (THRESHCROSS(d + p1, d + p2, lev))
                opcode |= 2;
        if (THRESHCROSS(d + p2, d + p0, lev))
                opcode |= 4;
        length = 0;
        if (opcode > 0)
                switch (opcode) {
                case 0:
                        break;  /* no threshold crossings here */
                case 1:
                case 2:
                case 4:
                case 7:
                        fprintf(stderr, "impossible situation\n");
                        break;  /* no odd # of crossings */
                case 3:
                        do_corner(&length, p0, p1, p2, inf, lev);
                        if (position) {
                                continue_poly(&length, i + 1, j, LOWER, 1, inf, lev);
                                if (length >= MAXLEN-1) break;
                                reverse_poly(length);
                                continue_poly(&length, i, j, LOWER, 2, inf, lev);
                                if (length >= MAXLEN-1) break;
                        } else {
                                continue_poly(&length, i, j + 1, UPPER, 1, inf, lev);
                                if (length >= MAXLEN-1) break;
                                reverse_poly(length);
                                continue_poly(&length, i, j, UPPER, 2, inf, lev);
                                if (length >= MAXLEN-1) break;
                        }

                        break;
                case 5:
                        do_corner(&length, p2, p0, p1, inf, lev);
                        if (position) {
                                continue_poly(&length, i, j, LOWER, 2, inf, lev);
                                if (length >= MAXLEN-1) break;
                                reverse_poly(length);
                                continue_poly(&length, i, j - 1, LOWER, 0, inf, lev);
                                if (length >= MAXLEN-1) break;
                        } else {
                                length = continue_poly(&length, i, j, UPPER, 2, inf, lev);
                                if (length >= MAXLEN-1) break;
                                reverse_poly(length);
                                length = continue_poly(&length, i - 1, j, UPPER, 0, inf, lev);
                                if (length >= MAXLEN-1) break;
                        }
                        break;
                case 6:
                        do_corner(&length, p1, p2, p0, inf, lev);
                        if (position) {
                                continue_poly(&length, i, j - 1, LOWER, 0, inf, lev);
                                if (length >= MAXLEN-1) break;
                                reverse_poly(length);
                                continue_poly(&length, i + 1, j, LOWER, 1, inf, lev);
                                if (length >= MAXLEN-1) break;
                        } else {
                                continue_poly(&length, i - 1, j, UPPER, 0, inf, lev);
                                if (length >= MAXLEN-1) break;
                                reverse_poly(length);
                                continue_poly(&length, i, j + 1, UPPER, 1, inf, lev);
                                if (length >= MAXLEN-1) break;
                        }
                        break;
                default:
                        break;
                }
        if (length > 1) {
                if (col!=0)
                        GEOMadd_polyline(obj, polyline, colors, length, GEOM_COPY_DATA);
                else
                        GEOMadd_polyline(obj, polyline, GEOM_NULL, length, GEOM_COPY_DATA);
		if (do_label!=0)
		{
        	for (i=0;i<3;i++)
			{
		    	ref_pt[i]=polyline[0][i];
			lab_offset[i]=0.;
			}
			sprintf(txt,"%.1f",lev);
	    		GEOMadd_label(objl,txt,ref_pt,lab_offset,lab_height,GEOM_NULL,-1);
		}
                if (flat!=0) {
                        for (i=0;i<length;i++)
                                polyline[i][2]=offset;
                        if (col_flat!=0)
                                GEOMadd_polyline(obj0, polyline, colors, length, GEOM_COPY_DATA);
                        else
                                GEOMadd_polyline(obj0, polyline, GEOM_NULL, length, GEOM_COPY_DATA);
                }

        }
}

continue_poly(length, i, j, position, enter_side, inf, lev)
        int            *length, i, j, position, enter_side;
        AVSfield_float *inf;
        float           lev;
{
        int             p0, p1, p2, opcode;
        double          u, v;
        static int      THRESHCROSS();
        for (; *length<MAXLEN-1 ;) {
                if (i < 0 || i >= (dim0 - 1) ||
                    j < 0 || j >= (dim1 - 1) ||
                    done(i, j, position, inf))
                        break;
                mark(i, j, position, inf);



                p0 = ADDRESS(i, j);
                p1 = ADDRESS(i + 1, j + 1);
                p2 = (position ? ADDRESS(i + 1, j) : ADDRESS(i, j + 1));
                /* p2=(position?ADDRESS(i+1,j):ADDRESS(i,j+1)); */

                opcode = 0;
                switch (enter_side) {
                case 0:
                        if (THRESHCROSS(d + p0, d + p1, lev))
                                opcode |= 1;
                        if (THRESHCROSS(d + p2, d + p0, lev))
                                opcode |= 4;
                        break;
                case 1:
                        if (THRESHCROSS(d + p0, d + p1, lev))
                                opcode |= 1;
                        if (THRESHCROSS(d + p1, d + p2, lev))
                                opcode |= 2;
                        break;
                case 2:
                        if (THRESHCROSS(d + p1, d + p2, lev))
                                opcode |= 2;
                        if (THRESHCROSS(d + p2, d + p0, lev))
                                opcode |= 4;
                        break;
                default:
                        break;
                }
                switch (opcode) {
                case 1:
                        new_vertex(length, p0, p1, inf, lev);
                        if (position) {
                                position = LOWER;
                                enter_side = 2;
                        } else {
                                position = UPPER;
                                enter_side = 2;
                        }
                        break;
                case 2:
                        new_vertex(length, p1, p2, inf, lev);
                        if (position) {
                                position = LOWER;
                                enter_side = 1;
                                i += 1;
                        } else {
                                position = UPPER;
                                enter_side = 1;
                                j += 1;
                        }
                        break;
                case 4:
                        new_vertex(length, p0, p2, inf, lev);
                        if (position) {
                                position = LOWER;
                                enter_side = 0;
                                j -= 1;
                        } else {
                                position = UPPER;
                                enter_side = 0;
                                i -= 1;
                        }
                        break;
                default:
                        fprintf(stderr, "impossible situation\n");
                        break;  /* no odd # of crossings */
                }
        }
}

reverse_poly(length)
        int             length;
{
        int             i, j;
        float           t;
        for (i = 0; i < length / 2; i++) {
                for (j = 0; j < 3; j++) {
                        t = polyline[i][j];
                        polyline[i][j] = polyline[length - i - 1][j];
                        polyline[length - i - 1][j] = t;
                }
        }
}


do_corner(length, p0, p1, p2, inf, thresh)
        int            *length;
        int             p0, p1, p2;
        AVSfield_float *inf;
        float           thresh;
{
        new_vertex(length, p0, p1, inf, thresh);
        new_vertex(length, p1, p2, inf, thresh);
}

new_vertex(length, p0, p1, inf, thresh)
        int            *length;
        int             p0, p1;
        AVSfield_float *inf;
        float           thresh;
{
        float           u;
        u = (thresh - *(inf->data + p0)) / (*(inf->data + p1) - *(inf->data + p0));
        polyline[*length][0] = *(xp + p0) + u * (*(xp + p1) - *(xp + p0));
        polyline[*length][1] = *(yp + p0) + u * (*(yp + p1) - *(yp + p0));
        polyline[*length][2] = *(zp + p0) + u * (*(zp + p1) - *(zp + p0));
        (*length) += 1;
}


static int
THRESHCROSS(v1, v2, t)
        float          *v1, *v2, t;
{
        float           d1, d2, r1, r2;

        d1 = *v1;
        d2 = *v2;

        r1 = d1 - t;
        r2 = d2 - t;

        if ((r1 > 0.) && (r2 <= 0.))
                return (1);
        if ((r1 <= 0.) && (r2 > 0.))
                return (1);

        return (0);
}

static void
hsv_to_rgb(R, G, B, h, s, v)
        float          *R, *G, *B;
        float           h, s, v;
{
        float           f, p, q, t;
        float           r, g, b;
        float           ht;
        int             i;

        /* Make sure not to trash the input colormap */
        ht = h;

        if (v == 0.) {
                r = 0.;
                g = 0.;
                b = 0.;
        } else {
                if (s == 0.) {
                        r = v;
                        g = v;
                        b = v;
                } else {
                        ht = ht * 6.0;
                        if (ht >= 6.0)
                                ht = 0.0;

                        i = ht;
                        f = ht - i;
                        p = v * (1.0 - s);
                        q = v * (1.0 - s * f);
                        t = v * (1.0 - s * (1.0 - f));
                        switch (i) {
                        case 0:
                                r = v;
                                g = t;
                                b = p;
                                break;
                        case 1:
                                r = q;
                                g = v;
                                b = p;
                                break;
                        case 2:
                                r = p;
                                g = v;
                                b = t;
                                break;
                        case 3:
                                r = p;
                                g = q;
                                b = v;
                                break;
                        case 4:
                                r = t;
                                g = p;
                                b = v;
                                break;
                        case 5:
                                r = v;
                                g = p;
                                b = q;
                                break;
                        default:
                                break;
                        }
                }
        }
        *R = r;
        *G = g;
        *B = b;

}

build_uniform_coords(field_coords, inf, zinterpret, minval, maxval, zscale)
        float          *field_coords;
        AVSfield_float *inf;
        int             zinterpret;
        float           minval, maxval, zscale;
{
        float           xmin, ymin, dx, dy, tempx;
        int             i, j;
        register float *x, *y, *z;
        float          *fd;

        x = field_coords;
        y = x + dim0 * dim1;
        z = y + dim0 * dim1;

        xmin = inf->points[0];
        ymin = inf->points[2];
        dx = (inf->points[1] - xmin) / (dim0 - 1);
        dy = (inf->points[3] - ymin) / (dim1 - 1);

        tempx = xmin;

        fd = inf->data;

        for (j = 0; j < dim1; j++, ymin += dy) {
                xmin = tempx;
                for (i = 0; i < dim0; i++, xmin += dx) {
                        *x++ = xmin;
                        *y++ = ymin;
                        *z++ = ((zinterpret == 0) ? (0.) :
                                ((zinterpret == 1) ? (*fd++) :
                                  zscale * ((*fd++) - minval) / (maxval - minval)));
                }
        }
}

build_rectilinear_coords(field_coords, inf, zinterpret, minval, maxval, zscale)
        float          *field_coords;
        AVSfield_float *inf;
        int             zinterpret;
        float           minval, maxval, zscale;
{
        float          *x, *y, *z;
        float          *xsrc, *ysrc;
        int             i, j;

        /* additions to support 2d height fields */
        float          *fd = NULL;



        x = field_coords;
        y = x + dim0 * dim1;
        z = y + dim0 * dim1;
        fd = inf->data;

        ysrc = inf->points + dim0;
        for (j = 0; j < dim1; j++, ysrc++) {
                xsrc = inf->points;
                for (i = 0; i < dim0; i++) {
                        *x++ = *xsrc++;
                        *y++ = *ysrc;
                        *z++ = ((zinterpret == 0) ? (0.) :
                                ((zinterpret == 1) ? (*fd++) :
                                  zscale * ((*fd++) - minval) / (maxval - minval)));
                }
        }
}

build_irregular_coords(field_coords, inf, zinterpret, minval, maxval, zscale)
        float          *field_coords;
        AVSfield_float *inf;
        int             zinterpret;
        float           minval, maxval, zscale;
{
        float          *x, *y, *z;
        float          *xsrc, *ysrc, *zsrc;
        int             i, j;
        float          *fd = NULL;


        fd = inf->data;
        x = field_coords;
        y = x + dim0 * dim1;
        z = y + dim0 * dim1;


        xsrc = inf->points;
        ysrc = inf->points + dim0 * dim1;
        if ((inf->nspace)==2){
                for (j = 0; j < dim1; j++) {
                        for (i = 0; i < dim0; i++) {
                                *x++ = *xsrc++;
                                *y++ = *ysrc++;
                                *z++ = ((zinterpret == 0) ? (0.) :
                                        ((zinterpret == 1) ? (*fd++) :
                                          zscale * ((*fd++) - minval) / (maxval - minval)));
                        }
                }
        }
        else
        {
                zsrc = inf->points + 2 * dim0 * dim1;
                for (j = 0; j < dim1; j++) {
                        for (i = 0; i < dim0; i++) {
                                *x++ = *xsrc++;
                                *y++ = *ysrc++;
                                *z++ = *zsrc++;
                        }
                }
        }
}

boundary(obj,obj0, inf, col, flat, zoffset)
        AVSfield_float *inf;
        GEOMobj        *obj,*obj0;
        int col, flat;
        float zoffset;
{
        int             i, j, verts;
        int             offset, delta;

        /* do boundary of v=0 */
        polyline[0][0] = *(xp);
        polyline[0][1] = *(yp);
        polyline[0][2] = *(zp);
        j = 0;
        offset = 0;

        for (i = 0; i < dim0 - 1; i++, ++j, ++offset) {
                polyline[j][0] = *(xp + offset);
                polyline[j][1] = *(yp + offset);
                polyline[j][2] = *(zp + offset);
        }

        delta = dim0;

        for (i = 0; i < dim1 - 1; i++, offset += delta, ++j) {
                polyline[j][0] = *(xp + offset);
                polyline[j][1] = *(yp + offset);
                polyline[j][2] = *(zp + offset);
        }
        /* do boundary of u=1 */
        for (i = 0; i < dim0 - 1; i++, offset--, ++j) {
                polyline[j][0] = *(xp + offset);
                polyline[j][1] = *(yp + offset);
                polyline[j][2] = *(zp + offset);
        }

        /* do boundary of v=1 */

        for (i = 0; i < dim1; i++, offset -= delta, ++j) {
                polyline[j][0] = *(xp + offset);
                polyline[j][1] = *(yp + offset);
                polyline[j][2] = *(zp + offset);
        }
        polyline[j][0] = *(xp);
        polyline[j][1] = *(yp);
        polyline[j][2] = *(zp);
        verts = j;
        for (; j >= 0; j--)
                for (i = 0; i < 3; i++)
                        colors[j][i] = 1.0;

                if (col!=0)
                        GEOMadd_polyline(obj, polyline, colors, verts, GEOM_COPY_DATA);
                else
                        GEOMadd_polyline(obj0, polyline, GEOM_NULL, verts, GEOM_COPY_DATA);
                if (flat!=0) {
                        for (j=0;j<verts;j++)
                                polyline[j][2] = zoffset;

                if (col!=0 || flat!=2)
                        GEOMadd_polyline(obj, polyline, colors, verts, GEOM_COPY_DATA);
                else
                        GEOMadd_polyline(obj0, polyline, GEOM_NULL, verts, GEOM_COPY_DATA);
                }
}

build_surface(obj, p_obj, inf, inf2, cmap, surf, color, plane, color_plane, offset, zoffset)
        GEOMobj        *obj, *p_obj;
        AVSfield_float *inf,*inf2;
        AVScolormap    *cmap;
        float           offset, zoffset;
        int             surf, color, plane, color_plane;
{
        int             jj, i, j, l, k, index, cindex, addr, dim20, addr2;
        float           val;
        float           surface_shade[3], u[3], v[3], w[3];

        dim20 = inf2->dimensions[0];
        k = 0;
        for (jj = dim1-2; jj >=0; jj--) {
                index = 0;
                for (i = 0; i < dim0; i++) {
                        for (j = jj+1; j >= jj; j--, index++) {
                            if ((j == jj+1) && (jj < dim1-2)) {

                                for (l = 0; l < 3; l++)
                                {
                                        colors[index][l]  = colors[index+1][l];
                                        normals[index][l] = tmp_norm[index/2][l];
                                        polyline[index][l] = tmp_poly[index/2][l];
                                }
                            } else {
                                addr = ADDRESS(i, j);
                                addr2 = j*dim20+i;

                                polyline[index][0] = *(xp + addr);
                                polyline[index][1] = *(yp + addr);
                                polyline[index][2] = *(zp + addr);

                                val = (*(inf2->data + addr2));
                                cindex = AVScmap_index(cmap, val);
                                if (cindex<0) cindex=0;
                                hsv_to_rgb(surface_shade, surface_shade + 1, surface_shade + 2,
                                           cmap->hue[cindex], cmap->saturation[cindex], cmap->value[cindex]);

                                if (i > 0 && i < dim0 - 1) {
                                        u[0] = *(xp + addr + 1) - *(xp + addr - 1);
                                        u[1] = *(yp + addr + 1) - *(yp + addr - 1);
                                        u[2] = *(zp + addr + 1) - *(zp + addr - 1);
                                } else {
                                        if (i == 0) {
                                                u[0] = *(xp + addr + 1) - *(xp + addr);
                                                u[1] = *(yp + addr + 1) - *(yp + addr);
                                                u[2] = *(zp + addr + 1) - *(zp + addr);
                                        } else {
                                                u[0] = -*(xp + addr - 1) + *(xp + addr);
                                                u[1] = -*(yp + addr - 1) + *(yp + addr);
                                                u[2] = -*(zp + addr - 1) + *(zp + addr);
                                        }
                                }

                                if (j > 0 && j < dim1 - 1) {
                                        v[0] = *(xp + addr + dim0) - *(xp + addr - dim0);
                                        v[1] = *(yp + addr + dim0) - *(yp + addr - dim0);
                                        v[2] = *(zp + addr + dim0) - *(zp + addr - dim0);
                                } else {
                                        if (j == 0) {
                                                v[0] = *(xp + addr + dim0) - *(xp + addr);
                                                v[1] = *(yp + addr + dim0) - *(yp + addr);
                                                v[2] = *(zp + addr + dim0) - *(zp + addr);
                                        } else {
                                                v[0] = -*(xp + addr - dim0) + *(xp + addr);
                                                v[1] = -*(yp + addr - dim0) + *(yp + addr);
                                                v[2] = -*(zp + addr - dim0) + *(zp + addr);
                                        }
                                }

                                w[0] = u[1] * v[2] - u[2] * v[1];
                                w[1] = u[2] * v[0] - u[0] * v[2];
                                w[2] = u[0] * v[1] - u[1] * v[0];
                                val = sqrtf(w[0] * w[0] + w[1] * w[1] + w[2] * w[2]);
                                for (l = 0; l < 3; l++)
                                {
                                        colors[index][l] = surface_shade[l];
                                        tmp_norm[index/2][l] = normals[index][l] = w[l] / val;
                                        tmp_poly[index/2][l] = polyline[index][l] =
                                                polyline[index][l] - offset * normals[index][l];
                                }
                            }
                        }
                }
		if (surf)
			{
                	if (color!=0)
                	        GEOMadd_polytriangle(obj, polyline, normals, colors, 2 * dim0, GEOM_COPY_DATA);
                	else
                	        GEOMadd_polytriangle(obj, polyline, normals, GEOM_NULL , 2 * dim0, GEOM_COPY_DATA);
			}

                if (plane) {
                        for (i=0;i<2 * dim0;i++){
                                polyline[i][2]=zoffset - offset;
                                normals[i][0]=0.;
                                normals[i][1]=0.;
                                normals[i][2]=1.;
                                }
                if (color_plane!=0)
                        GEOMadd_polytriangle(p_obj, polyline, normals, colors, 2 * dim0, GEOM_COPY_DATA);
                else
                        GEOMadd_polytriangle(p_obj, polyline, normals, GEOM_NULL , 2 * dim0, GEOM_COPY_DATA);
                        }

	}
	for (j = 0; j < dim1; j++)
		{
                for (i = 0,index = 0; i < dim0; i++, index++) {
                	addr = ADDRESS(i, j);
                	addr2 = j*dim20+i;
                        polyline[index][0] = *(xp + addr);
                        polyline[index][1] = *(yp + addr);
                        polyline[index][2] = *(zp + addr);

                        val = (*(inf2->data + addr2));
                        cindex = AVScmap_index(cmap, val);
                        if (cindex<0) cindex=0;
                        hsv_to_rgb(surface_shade, surface_shade + 1, surface_shade + 2,
                               cmap->hue[cindex], cmap->saturation[cindex], cmap->value[cindex]);

                        for (l = 0; l < 3; l++)
                               colors[index][l] = surface_shade[l];
			}
		if (surf)
			{
                	if (color!=0)
                	        GEOMadd_polyline(obj, polyline, colors, dim0, GEOM_COPY_DATA);
               		 else
                       		GEOMadd_polyline(obj, polyline, GEOM_NULL, dim0, GEOM_COPY_DATA);
			}
		}
        for (i = 0; i < dim0; i++) 
		{
                for (j = 0,index = 0; j < dim0; j++, index++) {
                	addr = ADDRESS(i, j);
                	addr2 = j*dim20+i;
                        polyline[index][0] = *(xp + addr);
                        polyline[index][1] = *(yp + addr);
                        polyline[index][2] = *(zp + addr);

                        val = (*(inf2->data + addr2));
                        cindex = AVScmap_index(cmap, val);
                        if (cindex<0) cindex=0;
                        hsv_to_rgb(surface_shade, surface_shade + 1, surface_shade + 2,
                               cmap->hue[cindex], cmap->saturation[cindex], cmap->value[cindex]);

                        for (l = 0; l < 3; l++)
                               colors[index][l] = surface_shade[l];
			}
		if (surf)
			{
                	if (color!=0)
                	        GEOMadd_polyline(obj, polyline, colors, dim1, GEOM_COPY_DATA);
                	else
               		         GEOMadd_polyline(obj, polyline, GEOM_NULL, dim1, GEOM_COPY_DATA);
   		        }


        }


}

nice_interval(low,up,n,x0,dx)
float low,up,*x0,*dx;
int *n;
{
    int tint, exp;
    float interval, f, y;
    float mypow();
    interval=(double)(up-low)/(*n);
    if (interval<=0.)
        {
        *x0=0.;
        *dx=1.;
        return;
        }
    f=interval;exp=0;
    if (interval>10.)
       for (;f>10.;exp++,f/=10.);
    if (interval<1.)
       for (;f<1.;exp--,f*=10.);

        if (f<1.5) tint = 1;
        else if (f<3.) tint = 2;
        else if (f<7.) tint = 5;
        else tint = 10;
    *dx=tint*mypow(10., exp);
    *x0=*dx * (ceil((double)low/(*dx)));
    *n=((up-(*x0))/(*dx));
}

float mypow(a, n)
float a;
int n;

{
    float x;

    x = 1.;
    if (n>0)
        for (; n>0; n--)
            x *= a;
    else
        for (; n<0; n++)
            x /= a;
    return x;
}
