C                  INTERNATIONAL AVS CENTER
C        (This disclaimer must remain at the top of all files)
C
C WARRANTY DISCLAIMER
C
C This module and the files associated with it are distributed free of charge.
C It is placed in the public domain and permission is granted for anyone to use,
C duplicate, modify, and redistribute it unless otherwise noted.  Some modules
C may be copyrighted.  You agree to abide by the conditions also included in
C the AVS Licensing Agreement, version 1.0, located in the main module
C directory located at the International AVS Center ftp site and to include
C the AVS Licensing Agreement when you distribute any files downloaded from
C that site.
C
C The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module provide absolutely
C NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
C the quality and performance of this software is with the user.  IN NO EVENT
C WILL The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module BE LIABLE TO
C ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
C WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
C SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.
C
C This AVS module and associated files are public domain software unless
C otherwise noted.  Permission is hereby granted to do whatever you like with
C it, subject to the conditions that may exist in copyrighted materials. Should
C you wish to make a contribution toward the improvement, modification, or
C general performance of this module, please send us your comments:  why you
C liked or disliked it, how you use it, and most important, how it helps your
C work. We will receive your comments at avs@ncsc.org.
C
C Please send AVS module bug reports to avs@ncsc.org.
C
C
C			Copyright (c) 1995 by
C			Kubota Graphics Technology Inc.
C			All Rights Reserved
C	
C	This software comprises unpublished confidential information of
C	Kubota Graphics Technology Inc. and may not be used, copied or
C	made available to anyone, except in accordance with the license
C	under which it is furnished.
C	
C
C       module name   :  CFD objectline
C       file name     :  objectline.f
C       exe           :  objectline
C
C       This module create the line object from CFD obstacle.
C
C       input scalar value
C          1 = fluid node      (live)
C          0 = non-fluid node  (obstacle)
C
C        1---1---1             
C        |   |   |            
C        1---0---0  ----->       +---+
C        |   |   |               |   |  
C        1---0---0               +   +
C        |   |   |               |   |  : create outline
C        1---0---0               +---+
C
C	
C **********************************************************************
C  Module Description
C **********************************************************************
      integer function Create_GEOM_desc()
C   IAC CODE CHANGE :       include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
C   IAC CODE CHANGE :       include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'
      integer in_port,out_port,param
      external Create_GEOM_compute
      integer Create_GEOM_compute

C Set the module name and type
      call AVSset_module_name('CFD objectline', 'mapper')
      call AVSset_module_flags(single_arg_data)

C Create an input port (name,type)
      in_port = AVScreate_input_port('mask3d-in',
     &        'field 3D 3-space scalar real irregular',REQUIRED)

C Create an output port (name,type)
      out_port = AVScreate_output_port('output1', 'geom')

C Add parameter
      iparm = AVSadd_parameter('On/Off','boolean',1,0,1)
 
      call AVSautofree_output(op1)
      call AVSset_compute_proc(Create_GEOM_compute)
      Create_GEOM_desc = 1
      return
      end

C **********************************************************************
C  Module Compute Routine
C **********************************************************************
      integer function Create_GEOM_compute(input1, output1, ionoff)
C   IAC CODE CHANGE :       include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
C   IAC CODE CHANGE :       include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'
#ifdef OSF1
      integer*8 input1
      integer*8 output1,obj0
      integer*8 pfield,pcoords
#else
      integer input1
      integer output1,obj0
      integer pfield,pcoords
#endif
      integer idim,dims(3),ni,nj,nk
      integer ionoff

C swith on/off
      if( ionoff .eq. 0) then
          obj0 = geom_create_obj(GEOM_POLYTRI,GEOM_NULL)
          output1 = geom_init_edit_list(output1)
          call geom_edit_geometry(output1,'output1',obj0)
          call geom_destroy_obj(obj0)
          Create_GEOM_compute = 1
          return
      endif
 
C Make mask
      obj0 = geom_create_obj(GEOM_POLYTRI,GEOM_NULL)

C Get Input data
      idim = AVSfield_get_dimensions(input1,dims)
      ni = dims(1)
      nj = dims(2)
      nk = dims(3)
      pfield = AVSfield_data_ptr(input1)
      pcoords = AVSfield_points_ptr(input1)

C Create obstacle
      call mask_create(%val(pfield),%val(pcoords),ni,nj,nk,obj0)

      call geom_gen_normals(obj0,0)
      output1 = geom_init_edit_list(output1)
      call geom_edit_geometry(output1,'output1',obj0)
      call geom_destroy_obj(obj0)
      Create_GEOM_compute = 1
      return
      end

C **********************************************************************
C  Initialization for modules contained in this file.
C **********************************************************************
      subroutine AVSinit_modules
C   IAC CODE CHANGE :       include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
C   IAC CODE CHANGE :       include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'
      external Create_GEOM_desc
      integer Create_GEOM_desc
      call AVSmodule_from_desc(Create_GEOM_desc)
      end

C **********************************************************************
C  User routine 
C **********************************************************************
      subroutine mask_create(data,xyz,nx,ny,nz,obj0)
      real data(nx,ny,nz),xyz(nx,ny,nz,3)
      integer nx,ny,nz
#ifdef OSF1
      integer*8 obj0
#else
      integer obj0
#endif
C
C data(ni,nj,nk)  : the flag data of node
C
       do k = 1,nz-1
        do j = 1,ny-1
         do i = 1,nx-1
           if((data(i  ,j  ,k  ).eq.0.) .and.
     &        (data(i+1,j  ,k  ).eq.0.) .and.
     &        (data(i  ,j+1,k  ).eq.0.) .and.
     &        (data(i  ,j  ,k+1).eq.0.) .and.
     &        (data(i+1,j+1,k  ).eq.0.) .and.
     &        (data(i  ,j+1,k+1).eq.0.) .and.
     &        (data(i+1,j  ,k+1).eq.0.) .and.
     &        (data(i+1,j+1,k+1).eq.0.)) then
             call make_box(xyz,i,j,k,nx,ny,nz,obj0,data)
           endif
         enddo
        enddo
       enddo

      ierr = 0
      return
      end
 
C **********************************************************************
C  create box
C **********************************************************************
      subroutine make_box(xyz,i,j,k,nx,ny,nz,obj,data)
C   IAC CODE CHANGE :       include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'
      real verts(3,2),xyz(nx,ny,nz,3),data(nx,ny,nz)
#ifdef OSF1
      integer*8 obj
#else
      integer obj
#endif
 
      f1 = 0.
      f2 = 0.
      f3 = 0.
      f4 = 0.
      f5 = 0.
      f6 = 0.
      f7 = 0.
      f8 = 0.
      f9 = 0.
      f10 = 0.
      f11 = 0.
      f12 = 0.
      f13 = 0.
      f14 = 0.
      f15 = 0.
      f16 = 0.
      f17 = 0.
      f18 = 0.
      if(k.gt.1) then
        f1 = 1.
        if((data(i  ,j  ,k-1).eq.0.) .and.
     &     (data(i+1,j  ,k-1).eq.0.) .and.
     &     (data(i  ,j+1,k-1).eq.0.) .and.
     &     (data(i+1,j+1,k-1).eq.0.)) then
                 f1 = 0.
        endif
      endif
      if(k.lt.nz-1) then
        f2 = 1.
        if((data(i  ,j  ,k+2).eq.0.) .and.
     &     (data(i+1,j  ,k+2).eq.0.) .and.
     &     (data(i  ,j+1,k+2).eq.0.) .and.
     &     (data(i+1,j+1,k+2).eq.0.)) then
                 f2 = 0.
        endif
      endif
      if(j.gt.1) then
        f3 = 1.
        if((data(i  ,j-1,k  ).eq.0.) .and.
     &     (data(i+1,j-1,k  ).eq.0.) .and.
     &     (data(i  ,j-1,k+1).eq.0.) .and.
     &     (data(i+1,j-1,k+1).eq.0.)) then
                 f3 = 0.
        endif
      endif
      if(j.lt.ny-1) then
        f4 = 1.
        if((data(i  ,j+2,k  ).eq.0.) .and.
     &     (data(i+1,j+2,k  ).eq.0.) .and.
     &     (data(i  ,j+2,k+1).eq.0.) .and.
     &     (data(i+1,j+2,k+1).eq.0.)) then
                 f4 = 0.
        endif
      endif
      if(i.gt.1) then
        f5 = 1.
        if((data(i-1,j  ,k  ).eq.0.) .and.
     &     (data(i-1,j+1,k  ).eq.0.) .and.
     &     (data(i-1,j  ,k+1).eq.0.) .and.
     &     (data(i-1,j+1,k+1).eq.0.)) then
                 f5 = 0.
        endif
      endif
      if(i.lt.nx-1) then
        f6 = 1.
        if((data(i+2,j  ,k  ).eq.0.) .and.
     &     (data(i+2,j+1,k  ).eq.0.) .and.
     &     (data(i+2,j  ,k+1).eq.0.) .and.
     &     (data(i+2,j+1,k+1).eq.0.)) then
                 f6 = 0.
        endif
      endif
      if(k.gt.1.and.j.gt.1) then
        f7 = 1.
        if((data(i  ,j-1,k-1).eq.0.) .and.
     &     (data(i+1,j-1,k-1).eq.0.) .and.
     &     (data(i+1,j  ,k-1).eq.0.) .and.
     &     (data(i  ,j  ,k-1).eq.0.) .and.
     &     (data(i  ,j-1,k  ).eq.0.) .and.
     &     (data(i+1,j-1,k  ).eq.0.)) then
                 f7 = 0.
        endif
      endif
      if(k.lt.nz-1.and.j.gt.1) then
        f8 = 1.
        if((data(i  ,j-1,k+1).eq.0.) .and.
     &     (data(i+1,j-1,k+1).eq.0.) .and.
     &     (data(i  ,j-1,k+2).eq.0.) .and.
     &     (data(i+1,j-1,k+2).eq.0.) .and.
     &     (data(i+1,j  ,k+2).eq.0.) .and.
     &     (data(i  ,j  ,k+2).eq.0.)) then
                 f8 = 0.
        endif
      endif
      if(k.gt.1.and.j.lt.ny-1) then
        f9 = 1.
        if((data(i  ,j+1,k-1).eq.0.) .and.
     &     (data(i+1,j+1,k-1).eq.0.) .and.
     &     (data(i  ,j+2,k-1).eq.0.) .and.
     &     (data(i+1,j+2,k-1).eq.0.) .and.
     &     (data(i  ,j+2,k  ).eq.0.) .and.
     &     (data(i+1,j+2,k  ).eq.0.)) then
                 f9 = 0.
        endif
      endif
      if(k.lt.nz-1.and.j.lt.ny-1) then
        f10 = 1.
        if((data(i  ,j+2,k+1).eq.0.) .and.
     &     (data(i+1,j+2,k+1).eq.0.) .and.
     &     (data(i  ,j+1,k+2).eq.0.) .and.
     &     (data(i+1,j+1,k+2).eq.0.) .and.
     &     (data(i  ,j+2,k+2).eq.0.) .and.
     &     (data(i+1,j+2,k+2).eq.0.)) then
                 f10 = 0.
        endif
      endif
      if(i.gt.1.and.k.gt.1) then
        f11 = 1.
        if((data(i-1,j  ,k-1).eq.0.) .and.
     &     (data(i  ,j  ,k-1).eq.0.) .and.
     &     (data(i  ,j+1,k-1).eq.0.) .and.
     &     (data(i-1,j+1,k-1).eq.0.) .and.
     &     (data(i-1,j  ,k  ).eq.0.) .and.
     &     (data(i-1,j+1,k  ).eq.0.)) then
                 f11 = 0.
        endif
      endif
      if(i.lt.nx-1.and.k.gt.1) then
        f12 = 1.
        if((data(i+1,j  ,k-1).eq.0.) .and.
     &     (data(i+2,j  ,k-1).eq.0.) .and.
     &     (data(i+2,j+1,k-1).eq.0.) .and.
     &     (data(i+1,j+1,k-1).eq.0.) .and.
     &     (data(i+2,j  ,k  ).eq.0.) .and.
     &     (data(i+2,j+1,k  ).eq.0.)) then
                 f12 = 0.
        endif
      endif
      if(i.gt.1.and.k.lt.nz-1) then
        f13 = 1.
        if((data(i-1,j  ,k+1).eq.0.) .and.
     &     (data(i-1,j+1,k+1).eq.0.) .and.
     &     (data(i-1,j  ,k+2).eq.0.) .and.
     &     (data(i  ,j  ,k+2).eq.0.) .and.
     &     (data(i  ,j+1,k+2).eq.0.) .and.
     &     (data(i-1,j+1,k+2).eq.0.)) then
                 f13 = 0.
        endif
      endif
      if(i.lt.nx-1.and.k.lt.nz-1) then
        f14 = 1.
        if((data(i+2,j  ,k+1).eq.0.) .and.
     &     (data(i+2,j+1,k+1).eq.0.) .and.
     &     (data(i+1,j  ,k+2).eq.0.) .and.
     &     (data(i+2,j  ,k+2).eq.0.) .and.
     &     (data(i+2,j+1,k+2).eq.0.) .and.
     &     (data(i+1,j+1,k+2).eq.0.)) then
                 f14 = 0.
        endif
      endif
      if(i.gt.1.and.j.gt.1) then
        f15 = 1.
        if((data(i-1,j-1,k  ).eq.0.) .and.
     &     (data(i  ,j-1,k  ).eq.0.) .and.
     &     (data(i-1,j  ,k  ).eq.0.) .and.
     &     (data(i-1,j-1,k+1).eq.0.) .and.
     &     (data(i  ,j-1,k+1).eq.0.) .and.
     &     (data(i-1,j  ,k+1).eq.0.)) then
                 f15 = 0.
        endif
      endif
      if(i.lt.nx-1.and.j.gt.1) then
        f16 = 1.
        if((data(i+1,j-1,k  ).eq.0.) .and.
     &     (data(i+2,j-1,k  ).eq.0.) .and.
     &     (data(i+2,j  ,k  ).eq.0.) .and.
     &     (data(i+1,j-1,k+1).eq.0.) .and.
     &     (data(i+2,j-1,k+1).eq.0.) .and.
     &     (data(i+2,j  ,k+1).eq.0.)) then
                 f16 = 0.
        endif
      endif
      if(i.gt.1.and.j.lt.ny-1) then
        f17 = 1.
        if((data(i-1,j+1,k  ).eq.0.) .and.
     &     (data(i  ,j+2,k  ).eq.0.) .and.
     &     (data(i-1,j+2,k  ).eq.0.) .and.
     &     (data(i-1,j+1,k+1).eq.0.) .and.
     &     (data(i  ,j+2,k+1).eq.0.) .and.
     &     (data(i-1,j+2,k+1).eq.0.)) then
                 f17 = 0.
        endif
      endif
      if(i.lt.nx-1.and.j.lt.ny-1) then
        f18 = 1.
        if((data(i+2,j+1,k  ).eq.0.) .and.
     &     (data(i+2,j+2,k  ).eq.0.) .and.
     &     (data(i+1,j+2,k  ).eq.0.) .and.
     &     (data(i+2,j+1,k+1).eq.0.) .and.
     &     (data(i+2,j+2,k+1).eq.0.) .and.
     &     (data(i+1,j+2,k+1).eq.0.)) then
                 f18 = 0.
        endif
      endif

C Line (i~i+1,j,k)
        if((f1.eq.0.).and.(f3.eq.0.).and.(f7.eq.0.)) goto 111
          if((f1.eq.0.).and.(f3.eq.0.).and.(f7.eq.1.)) then
            do L=1,3
               verts(L,1) = xyz(i  ,j  ,k  ,L)
               verts(L,2) = xyz(i+1,j  ,k  ,L)
            enddo
            call GEOM_add_disjoint_line
     &           (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
          elseif((f1.eq.0.).and.(f3.eq.1.).and.(f7.eq.0.)) then
            do L=1,3
               verts(L,1) = xyz(i  ,j  ,k  ,L)
               verts(L,2) = xyz(i+1,j  ,k  ,L)
            enddo
            call GEOM_add_disjoint_line
     &           (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
          elseif((f1.eq.1.).and.(f3.eq.0.).and.(f7.eq.0.)) then
            do L=1,3
               verts(L,1) = xyz(i  ,j  ,k  ,L)
               verts(L,2) = xyz(i+1,j  ,k  ,L)
            enddo
            call GEOM_add_disjoint_line
     &           (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
          elseif((f1.eq.1.).and.(f3.eq.1.).and.(f7.eq.0.)) then
            do L=1,3
               verts(L,1) = xyz(i  ,j  ,k  ,L)
               verts(L,2) = xyz(i+1,j  ,k  ,L)
            enddo
            call GEOM_add_disjoint_line
     &           (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
          elseif((f1.eq.1.).and.(f3.eq.1.).and.(f7.eq.1.)) then
            do L=1,3
               verts(L,1) = xyz(i  ,j  ,k  ,L)
               verts(L,2) = xyz(i+1,j  ,k  ,L)
            enddo
            call GEOM_add_disjoint_line
     &           (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
           endif
 
 111    continue
 
C Line (i~i+1,j,k+1)
       if((f2.eq.0.).and.(f3.eq.0.).and.(f8.eq.0.)) goto 222
         if((f2.eq.0.).and.(f3.eq.0.).and.(f8.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k+1,L)
              verts(L,2) = xyz(i+1,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.0.).and.(f3.lt.1.).and.(f8.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k+1,L)
              verts(L,2) = xyz(i+1,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.1.).and.(f3.eq.0.).and.(f8.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k+1,L)
              verts(L,2) = xyz(i+1,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.1.).and.(f3.eq.1.).and.(f8.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k+1,L)
              verts(L,2) = xyz(i+1,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.1.).and.(f3.eq.1.).and.(f8.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k+1,L)
              verts(L,2) = xyz(i+1,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         endif
 
 222    continue
 
C Line (i~i+1,j+1,k)
        if((f1.eq.0.).and.(f4.eq.0.).and.(f9.eq.0.)) goto 333
         if((f1.eq.0.).and.(f4.eq.0.).and.(f9.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f1.eq.0.).and.(f4.eq.1.).and.(f9.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f1.eq.1.).and.(f4.eq.0.).and.(f9.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f1.eq.1.).and.(f4.eq.1.).and.(f9.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f1.eq.1.).and.(f4.eq.1.).and.(f9.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         endif
 
 333    continue
 
C Line (i~i+1,j+1,k+1)
        if((f2.eq.0.).and.(f4.eq.0.).and.(f10.eq.0.)) goto 444
         if((f2.eq.0.).and.(f4.eq.0.).and.(f10.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k+1,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.0.).and.(f4.eq.1.).and.(f10.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k+1,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.1.).and.(f4.eq.0.).and.(f10.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k+1,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.1.).and.(f4.eq.1.).and.(f10.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k+1,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.1.).and.(f4.eq.1.).and.(f10.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k+1,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         endif
 
 444    continue
 
C Line (i,j~j+1,k)
        if((f1.eq.0.).and.(f5.eq.0.).and.(f11.eq.0.)) goto 555
         if((f1.eq.0.).and.(f5.eq.0.).and.(f11.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k  ,L)
              verts(L,2) = xyz(i  ,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f1.eq.0.).and.(f5.eq.1.).and.(f11.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k  ,L)
              verts(L,2) = xyz(i  ,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f1.eq.1.).and.(f5.eq.0.).and.(f11.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k  ,L)
              verts(L,2) = xyz(i  ,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f1.eq.1.).and.(f5.eq.1.).and.(f11.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k  ,L)
              verts(L,2) = xyz(i  ,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f1.eq.1.).and.(f5.eq.1.).and.(f11.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k  ,L)
              verts(L,2) = xyz(i  ,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         endif
 
 555    continue
 
C Line (i+1,j~j+1,k)
        if((f1.eq.0.).and.(f6.eq.0.).and.(f12.eq.0.)) goto 666
         if((f1.eq.0.).and.(f6.eq.0.).and.(f12.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f1.eq.0.).and.(f6.eq.1.).and.(f12.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f1.eq.1.).and.(f6.eq.0.).and.(f12.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f1.eq.1.).and.(f6.eq.1.).and.(f12.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f1.eq.1.).and.(f6.eq.1.).and.(f12.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k  ,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         endif
 
 666    continue
 
C Line (i,j~j+1,k+1)
       if((f2.eq.0.).and.(f5.ge.0.).and.(f13.ge.0.)) goto 777
         if((f2.eq.0.).and.(f5.eq.0.).and.(f13.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k+1,L)
              verts(L,2) = xyz(i  ,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.0.).and.(f5.lt.1.).and.(f13.ge.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k+1,L)
              verts(L,2) = xyz(i  ,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.1.).and.(f5.eq.0.).and.(f13.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k+1,L)
              verts(L,2) = xyz(i  ,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.1.).and.(f5.eq.1.).and.(f13.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k+1,L)
              verts(L,2) = xyz(i  ,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.1.).and.(f5.eq.1.).and.(f13.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k+1,L)
              verts(L,2) = xyz(i  ,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         endif
 
 777    continue
 
C Line (i+1,j~j+1,k+1)
        if((f2.eq.0.).and.(f6.eq.0.).and.(f14.eq.0.)) goto 888
         if((f2.eq.0.).and.(f6.eq.0.).and.(f14.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k+1,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.0.).and.(f6.eq.1.).and.(f14.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k+1,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.1.).and.(f6.eq.0.).and.(f14.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k+1,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.1.).and.(f6.eq.1.).and.(f14.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k+1,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f2.eq.1.).and.(f6.eq.1.).and.(f14.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k+1,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         endif
 
 888    continue
 
C Line (i,j,k~k+1)
        if((f3.eq.1.).and.(f5.eq.1.).and.(f15.eq.1.)) goto 999
         if((f3.eq.0.).and.(f5.eq.0.).and.(f15.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k  ,L)
              verts(L,2) = xyz(i  ,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f3.eq.0.).and.(f5.eq.1.).and.(f15.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k  ,L)
              verts(L,2) = xyz(i  ,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f3.eq.1.).and.(f5.eq.0.).and.(f15.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k  ,L)
              verts(L,2) = xyz(i  ,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f3.eq.1.).and.(f5.eq.1.).and.(f15.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k  ,L)
              verts(L,2) = xyz(i  ,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f3.eq.1.).and.(f5.eq.1.).and.(f15.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j  ,k  ,L)
              verts(L,2) = xyz(i  ,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         endif
 
 999    continue
 
C Line (i+1,j,k~k+1)
        if((f3.eq.1.).and.(f6.eq.1.).and.(f16.eq.1.)) goto 1000
         if((f3.eq.0.).and.(f6.eq.0.).and.(f16.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k  ,L)
              verts(L,2) = xyz(i+1,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f3.eq.0.).and.(f6.eq.1.).and.(f16.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k  ,L)
              verts(L,2) = xyz(i+1,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f3.eq.1.).and.(f6.eq.0.).and.(f16.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k  ,L)
              verts(L,2) = xyz(i+1,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f3.eq.1.).and.(f6.eq.1.).and.(f16.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k  ,L)
              verts(L,2) = xyz(i+1,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f3.eq.1.).and.(f6.eq.1.).and.(f16.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j  ,k  ,L)
              verts(L,2) = xyz(i+1,j  ,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         endif
 
 1000   continue
 
C Line (i,j+1,k~k+1)
        if((f4.eq.0.).and.(f5.eq.0.).and.(f17.eq.0.)) goto 1010
         if((f4.eq.0.).and.(f5.eq.0.).and.(f17.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k  ,L)
              verts(L,2) = xyz(i  ,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f4.eq.0.).and.(f5.eq.1.).and.(f17.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k  ,L)
              verts(L,2) = xyz(i  ,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f4.eq.1.).and.(f5.eq.0.).and.(f17.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k  ,L)
              verts(L,2) = xyz(i  ,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f4.eq.1.).and.(f5.eq.1.).and.(f17.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k  ,L)
              verts(L,2) = xyz(i  ,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f4.eq.1.).and.(f5.eq.1.).and.(f17.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i  ,j+1,k  ,L)
              verts(L,2) = xyz(i  ,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         endif
 
 1010   continue
 
C Line (i+1,j+1,k~k+1)
        if((f4.eq.0.).and.(f6.eq.0.).and.(f18.eq.0.)) goto 1020
         if((f4.eq.0.).and.(f6.eq.0.).and.(f18.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j+1,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f4.eq.0.).and.(f6.eq.1.).and.(f18.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j+1,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f4.eq.1.).and.(f6.eq.0.).and.(f18.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j+1,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f4.eq.1.).and.(f6.eq.1.).and.(f18.eq.0.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j+1,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         elseif((f4.eq.1.).and.(f6.eq.1.).and.(f18.eq.1.)) then
           do L=1,3
              verts(L,1) = xyz(i+1,j+1,k  ,L)
              verts(L,2) = xyz(i+1,j+1,k+1,L)
           enddo
           call GEOM_add_disjoint_line
     &          (obj,verts,GEOM_NULL,2,GEOM_COPY_DATA)
         endif
 
 1020   continue

      return
      end
