/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
#ifdef SCCS
static char sccsid[]="@(#)exc_brick.c	8.2 Stardent 92/09/03";
#endif
/*
			Copyright (c) 1991 by
			Stardent Computer Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Stardent Computer Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under sccs control at Stardent in:
	@europa/sccs1.p/avs/modules/mappers/s.exc_brick.c
*/
/*
Original: field to mesh, AVS Inc.
Modified: added textures, Scott Goodyear, AVS Inc
          various improvements From: avs.AVS.COM!esuk!mike (Mike French) E&S
          statics removed Ian Curington, AVS Inc.
 */

#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>
#include <avs/colormap.h>
#include <avs/geom.h>

/*****************************************/
/* Module Specification                  */
/*****************************************/

MODexcavate_brick() {

        int excavate_brick_compute();

	int in_port, out_port, param;

	AVSset_module_name("ChairPlot 2D Txt",  MODULE_MAPPER);

	/* Input Port Specifications */
	in_port = AVScreate_input_port("input", "field 3D uniform byte", REQUIRED);
	AVScreate_input_port("Colormap Input", "colormap", REQUIRED);

	/* Output Port Specifications */
	out_port = AVScreate_output_port("output", "geom", REQUIRED);

	/* Parameter Specifications */
	param = AVSadd_parameter("X", "integer", 0, 0, 1);
	AVSconnect_widget(param, "idial");
	AVSadd_parameter_prop(param, "immediate", "boolean", 1);

	param = AVSadd_parameter("Y", "integer", 0, 0, 1);
	AVSconnect_widget(param, "idial");
	AVSadd_parameter_prop(param, "immediate", "boolean", 1);

	param = AVSadd_parameter("Z", "integer", 0, 0, 1);
	AVSconnect_widget(param, "idial");
	AVSadd_parameter_prop(param, "immediate", "boolean", 1);

/*
	param = AVSadd_parameter("Flip_X", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Flip_Y", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Flip_Z", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
*/
	param = AVSadd_parameter("Draw_Sides", "boolean", 1, 0, 1);
	AVSconnect_widget(param, "toggle");

	AVSset_compute_proc(excavate_brick_compute);
}

/*****************************************/
/* Module Compute Routine                */
/*****************************************/

static float uvws[256][3];
static float uvs[256][2];
static int uvw_count = 0;
static int uv_count = 0;
static int obj_count = 0;
static int slices_initialized = 0;

#define FX 1
#define FY 2
#define FZ 4

excavate_brick_compute ( input, colormap, output, X, Y, Z,  Draw_Sides )

    AVSfield_char *input;
    AVScolormap *colormap;
    GEOMedit_list *output;
    int X, Y, Z, Draw_Sides;
{

    GEOMobj *obj;
    GEOMobj *obj1;
    GEOMobj *obj2;
    GEOMobj *obj3;
    GEOMobj *obj4;
    GEOMobj *obj5;
    GEOMobj *obj6;
    GEOMobj *obj7;
    GEOMobj *obj8;
    GEOMobj *obj9;

    int Flip_X = 0;
    int Flip_Y = 0;
    int Flip_Z = 0;

    float ext[6];
    float x, y, z, N;
    float perx, pery, perz;
    float tx, ty, tz, ux, uy, uz, xx, yy, zz;
    float x1, y1, z1;
    float x2, y2, z2;
    int mode;
/*-- MikeF - pseudo-zero values for uvw --*/
#ifdef MikeF
    float dx, dy, dz;
#endif
/*----------------------------------------*/

    /* The slice plane fields */
    static AVSfield *slice_plane1;
    static AVSfield *slice_plane2;
    static AVSfield *slice_plane3;
    static AVSfield *slice_plane4;
    static AVSfield *slice_plane5;
    static AVSfield *slice_plane6;
    static AVSfield *slice_plane7;
    static AVSfield *slice_plane8;
    static AVSfield *slice_plane9;

    /* The texture map fields */
    static AVSfield *texture1;
    static AVSfield *texture2;
    static AVSfield *texture3;
    static AVSfield *texture4;
    static AVSfield *texture5;
    static AVSfield *texture6;
    static AVSfield *texture7;
    static AVSfield *texture8;
    static AVSfield *texture9;

    int max_x, max_y, max_z;

/*
    if (colormap == NULL) 
       AVSwarning(" No colormap supplied ");
*/

    if (AVSinput_changed("input", 0)) {
	AVSmodify_parameter("X", AVS_VALUE | AVS_MAXVAL, MAXX(input)/2, 0, MAXX(input)-1);
	AVSmodify_parameter("Y", AVS_VALUE | AVS_MAXVAL, MAXY(input)/2, 0, MAXY(input)-1);
	AVSmodify_parameter("Z", AVS_VALUE | AVS_MAXVAL, MAXZ(input)/2, 0, MAXZ(input)-1);
	X = MAXX(input)/2;
	Y = MAXY(input)/2;
	Z = MAXZ(input)/2;
/*
        max_x =  MAXX(input);
        max_y =  MAXY(input);
        max_z =  MAXZ(input);
*/
        slices_initialized = 0;
    }

    if (AVSinput_changed("Colormap Input", 0)) {
        slices_initialized = 0;
    }

    ext[0] = ext[2] = ext[4] = 0.0;
    ext[1] = MAXX(input)-1;
    ext[3] = MAXY(input)-1;
    ext[5] = MAXZ(input)-1;

    max_x =  MAXX(input);
    max_y =  MAXY(input);
    max_z =  MAXZ(input);

/*-- MikeF - create pseudo-zero values --*/
#ifdef MikeF
    dx = 1.0 / (float)max_x;
    dy = 1.0 / (float)max_y;
    dz = 1.0 / (float)max_z;
#endif
/*---------------------------------------*/
    /* fprintf(stderr,"MaxY = %d\n",max_y); */

    /* Create the objects */
    obj1 = GEOMcreate_obj(GEOM_POLYHEDRON, ext);
    obj2 = GEOMcreate_obj(GEOM_POLYHEDRON, ext);
    obj3 = GEOMcreate_obj(GEOM_POLYHEDRON, ext);
    obj4 = GEOMcreate_obj(GEOM_POLYHEDRON, ext);
    obj5 = GEOMcreate_obj(GEOM_POLYHEDRON, ext);
    obj6 = GEOMcreate_obj(GEOM_POLYHEDRON, ext);
    obj7 = GEOMcreate_obj(GEOM_POLYHEDRON, ext);
    obj8 = GEOMcreate_obj(GEOM_POLYHEDRON, ext);
    obj9 = GEOMcreate_obj(GEOM_POLYHEDRON, ext);

    uvw_count = 0;
    uv_count = 0;

    UTILget_world_coords (&ux, &uy, &uz, MAXX(input)-1, 
			  MAXY(input)-1, MAXZ(input)-1, input);
    UTILget_world_coords (&tx, &ty, &tz, 0, 0, 0, input);
    UTILget_world_coords (&xx, &yy, &zz, X, Y, Z, input);

    N = 1.0;
    x1 = tx;
    x2 = ux;
    x = xx+tx;

    y1 = ty;
    y2 = uy;
    y = yy+ty;
    
    z1 = tz;
    z2 = uz;
    z = zz+tz;

    perx = (x2 == 0.0) ? 1.0 : (x / x2);
    pery = (y2 == 0.0) ? 1.0 : (y / y2);
    perz = (z2 == 0.0) ? 1.0 : (z / z2);

/*-- MikeF - round up for zero values --*/
#ifdef MikeF
    perx = dx + perx * (1.0-dx);
    pery = dy + pery * (1.0-dy);
    perz = dz + perz * (1.0-dz);
#endif
/*----------------------------------*/

    obj_count = 1;
    /*X*/ 
    add_square(obj1, x, x, y, y2, z, z2,  perx, perx, pery, 1.0, perz, 1.0, N);
    obj_count = 2;
    /*Y*/ 
    add_square(obj2, x, x2, y, y, z, z2,  perx, 1.0, pery, pery, perz, 1.0, N);
    obj_count = 3;
    /*Z*/ 
    add_square(obj3, x, x2, y, y2, z, z,  perx, 1.0, pery, 1.0, perz, perz, N);

    if (Draw_Sides) {
       /* Add Left Side Square */
       obj_count = 4;
/*-- MikeF - use pseudo-zero values --*/
#ifdef MikeF
     add_square(obj4, x1, x1, y1, y2, z1, z2, dx, dx, dy, 1.0, dz, 1.0, -N);
#else
     add_square(obj4, x1, x1, y1, y2, z1, z2, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, -N);
#endif
/*------------------------------------*/

       /* Add Bottom Square */
       obj_count = 5;
/*-- MikeF - use pseudo-zero values --*/
#ifdef MikeF
     add_square(obj5, x1, x2, y1, y1, z1, z2, dx, 1.0, dy, dy, dz, 1.0, -N);
#else
     add_square(obj5, x1, x2, y1, y1, z1, z2, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, -N);
#endif
/*------------------------------------*/

       /* Add Back Side Square */
     obj_count = 6;
/*-- MikeF - use pseudo-zero values --*/
#ifdef MikeF
     add_square(obj6, x1, x2, y1, y2, z1, z1, dx, 1.0, dy, 1.0, dz, dz, -N);
#else
     add_square(obj6, x1, x2, y1, y2, z1, z1, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, -N);
#endif
/*------------------------------------*/

     /* Add L Shaped Sides */
obj_count = 7;
/*-- MikeF - use pseudo-zero values --*/
#ifdef MikeF
if ( !(y==y1 && z==z1) )
add_x_L(obj7, x2, y1, y, y2, z1, z, z2, 1.0, dy, pery, 1.0, dz, perz, 1.0, N);
#else
add_x_L(obj7, x2, y1, y, y2, z1, z, z2, 1.0, 0.0, pery, 1.0, 0.0, perz, 1.0, N);
#endif
/*------------------------------------*/

obj_count = 8;
/*-- MikeF - use pseudo-zero values --*/
#ifdef MikeF
if ( !(x==x1 && z==z1) )
add_y_L(obj8, x1, x, x2, y2, z1, z, z2, dx, perx, 1.0, 1.0, dz, perz, 1.0, N);
#else
add_y_L(obj8, x1, x, x2, y2, z1, z, z2, 0.0, perx, 1.0, 1.0, 0.0, perz, 1.0, N);
#endif
/*------------------------------------*/

obj_count = 9;
/*-- MikeF - use pseudo-zero values --*/
#ifdef MikeF
if ( !(x==x1 && y==y1) )
add_z_L(obj9, x1, x, x2, y1, y, y2, z2, dx, perx, 1.0, dy, pery, 1.0, 1.0, N);
#else
add_z_L(obj9, x1, x, x2, y1, y, y2, z2, 0.0, perx, 1.0, 0.0, pery, 1.0, 1.0, N);
#endif
/*------------------------------------*/
   }

    /* Create the GEOM Edit List */
    *output = GEOMinit_edit_list(*output);

    /* Obj 1 - Excavate portion X */
    GEOMedit_geometry(*output, "ExcavateX", obj1);
    /* Create texture map for Obj1 */
    if (AVSparameter_changed("X") || (slices_initialized == 0)) {
       /* fprintf(stderr,"Computing new X slice ...\n"); */

       ortho_slice_compute(input,&slice_plane1,X,"I");
       colorizer_compute(slice_plane1,colormap,&texture1);

       if (texture1) {
          GEOMedit_field_texture(*output, "ExcavateX", texture1);
       } else {
         fprintf(stderr,"Warning: Problem creating texture \n");
         AVSwarning("Problem creating texture");
       }
    }
    GEOMedit_parent(*output, "ExcavateX", "ChairPlot");
/*-- MikeF - lock planes to parent --*/
#ifdef MikeF
    GEOMedit_transform_mode( *output, "ExcavateX", "parent", 0 );
#endif
/*-----------------------------------*/
    /* GEOMedit_window(*output, "ExcavateX", ext); */
    GEOMdestroy_obj(obj1);
    
    /* Obj 2 - Excavate portion Y */
    GEOMedit_geometry(*output, "ExcavateY", obj2);
    /* Create texture map for Obj2 */
    if (AVSparameter_changed("Y") || (slices_initialized == 0)) {
       /* fprintf(stderr,"Computing new Y slice ...\n"); */
       /* ortho_slice_compute(input,&texture2,Y,"J");  */
       /* ortho_slice_compute(input,&slice_plane2,max_y-Y-1,"J"); */
       ortho_slice_compute(input,&slice_plane2,Y,"J"); 
       colorizer_compute(slice_plane2,colormap,&texture2);
       if (texture2) {
          GEOMedit_field_texture(*output, "ExcavateY", texture2);
       } else {
         fprintf(stderr,"Warning: Problem creating texture for ExcavateY\n");
         AVSwarning("Problem creating texture for ExcavateY");
       }
    }
    GEOMedit_parent(*output, "ExcavateY", "ChairPlot");
/*-- MikeF - lock planes to parent --*/
#ifdef MikeF
    GEOMedit_transform_mode( *output, "ExcavateY", "parent", 0 );
#endif
/*-----------------------------------*/
    /* GEOMedit_window(*output, "ExcavateY", ext); */
    GEOMdestroy_obj(obj2);

    /* Obj 3 - Excavate portion Z */
    GEOMedit_geometry(*output, "ExcavateZ", obj3);
    /* Create texture map for Obj3 */
    if (AVSparameter_changed("Z") || (slices_initialized == 0)) {
       /* fprintf(stderr,"Computing new Z slice ...\n"); */
       ortho_slice_compute(input,&slice_plane3,Z,"K");
       colorizer_compute(slice_plane3,colormap,&texture3);
       if (texture3) {
          GEOMedit_field_texture(*output, "ExcavateZ", texture3);
       } else {
         fprintf(stderr,"Warning: Problem creating texture for ExcavateZ\n");
         AVSwarning("Problem creating texture for ExcavateZ");
       }
    }
    GEOMedit_parent(*output, "ExcavateZ", "ChairPlot");
/*-- MikeF - lock planes to parent --*/
#ifdef MikeF
    GEOMedit_transform_mode( *output, "ExcavateZ", "parent", 0 );
#endif
/*-----------------------------------*/
    /* GEOMedit_window(*output, "ExcavateZ", ext); */
    GEOMdestroy_obj(obj3);

    /* Obj 4 - Left Side Full portion */
       GEOMedit_geometry(*output, "LeftSide", obj4);
    if (slices_initialized == 0) {
    /* Create texture map for Obj4 */
       ortho_slice_compute(input,&slice_plane4,0,"I");
       colorizer_compute(slice_plane4,colormap,&texture4);
       if (texture4) {
          GEOMedit_field_texture(*output, "LeftSide", texture4);
       } else {
          fprintf(stderr,"Warning: Problem creating texture for LeftSide\n");
          AVSwarning("Problem creating texture for LeftSide");
        }
       GEOMedit_parent(*output, "LeftSide", "ChairPlot");
/*-- MikeF - lock planes to parent --*/
#ifdef MikeF
       GEOMedit_transform_mode( *output, "LeftSide", "parent", 0 );
#endif
/*-----------------------------------*/
       /* GEOMedit_window(*output, "LeftSide", ext); */
       GEOMdestroy_obj(obj4);
    }

    /* Obj 5 - Bottom Side Full portion */
       GEOMedit_geometry(*output, "BottomSide", obj5);
    if (slices_initialized == 0) {
       /* Create texture map for Obj5 */
       ortho_slice_compute(input,&slice_plane5,0,"J");
       colorizer_compute(slice_plane5,colormap,&texture5);
       if (texture5) {
          GEOMedit_field_texture(*output, "BottomSide", texture5);
       } else {
         fprintf(stderr,"Warning: Problem creating texture for BottomSide\n");
         AVSwarning("Problem creating texture for BottomSide");
       }
       GEOMedit_parent(*output, "BottomSide", "ChairPlot");
/*-- MikeF - lock planes to parent --*/
#ifdef MikeF
       GEOMedit_transform_mode( *output, "BottomSide", "parent", 0 );
#endif
/*-----------------------------------*/
       /* GEOMedit_window(*output, "BottomSide", ext); */
       GEOMdestroy_obj(obj5);
    }

    /* Obj 6 - Back Side Full portion */
       GEOMedit_geometry(*output, "BackSide", obj6);
    if (slices_initialized == 0) {
       /* Create texture map for Obj6 */
       ortho_slice_compute(input,&slice_plane6,0,"K");
       colorizer_compute(slice_plane6,colormap,&texture6);
       if (texture6) {
          GEOMedit_field_texture(*output, "BackSide", texture6);
       } else {
         fprintf(stderr,"Warning: Problem creating texture for BackSide\n");
         AVSwarning("Problem creating texture for BackSide");
       }
       GEOMedit_parent(*output, "BackSide", "ChairPlot");
/*-- MikeF - lock planes to parent --*/
#ifdef MikeF
       GEOMedit_transform_mode( *output, "BackSide", "parent", 0 );
#endif
/*-----------------------------------*/
       /* GEOMedit_window(*output, "BackSide", ext); */
       GEOMdestroy_obj(obj6);
    }

    /* Obj 7 - L-shape X */
    GEOMedit_geometry(*output, "LShapeX", obj7);
    /* Create texture map for Obj7 */
    if (slices_initialized == 0) {
       ortho_slice_compute(input,&slice_plane7,max_x,"I");
       colorizer_compute(slice_plane7,colormap,&texture7);
       if (texture7) {
          GEOMedit_field_texture(*output, "LShapeX", texture7);
       } else {
         fprintf(stderr,"Warning: Problem creating texture for LShapeX\n");
         AVSwarning("Problem creating texture for LShapeX");
       }
    }
    GEOMedit_parent(*output, "LShapeX", "ChairPlot");
/*-- MikeF - lock planes to parent --*/
#ifdef MikeF
    GEOMedit_transform_mode( *output, "LShapeX", "parent", 0 );
#endif
/*-----------------------------------*/
    /* GEOMedit_window(*output, "LShapeX", ext); */
    GEOMdestroy_obj(obj7);
   
    /* Obj 8 - L-shape Y */
    GEOMedit_geometry(*output, "LShapeY", obj8);
    /* Create texture map for Obj8 */
    if (slices_initialized == 0) {
       ortho_slice_compute(input,&slice_plane8,max_y,"J");
       colorizer_compute(slice_plane8,colormap,&texture8);
       if (texture8) {
          GEOMedit_field_texture(*output, "LShapeY", texture8);
       } else {
         fprintf(stderr,"Warning: Problem creating texture for LShapeY\n");
         AVSwarning("Problem creating texture for LShapeY");
       }
    }
    GEOMedit_parent(*output, "LShapeY", "ChairPlot");
/*-- MikeF - lock planes to parent --*/
#ifdef MikeF
    GEOMedit_transform_mode( *output, "LShapeY", "parent", 0 );
#endif
/*-----------------------------------*/
    /* GEOMedit_window(*output, "LShapeY", ext); */
    GEOMdestroy_obj(obj8);

    /* Obj 9 - L-shape Z */
    GEOMedit_geometry(*output, "LShapeZ", obj9);
    /* Create texture map for Obj9 */
    if (slices_initialized == 0) {
       ortho_slice_compute(input,&slice_plane9,max_z,"K");
       colorizer_compute(slice_plane9,colormap,&texture9);
       if (texture9) {
          GEOMedit_field_texture(*output, "LShapeZ", texture9);
       } else {
         fprintf(stderr,"Warning: Problem creating texture for LShapeZ\n");
         AVSwarning("Problem creating texture for LShapeZ");
       }
    }
    GEOMedit_parent(*output, "LShapeZ", "ChairPlot");
/*-- MikeF - lock planes to parent --*/
#ifdef MikeF
    GEOMedit_transform_mode( *output, "LShapeZ", "parent", 0 );
#endif
/*-----------------------------------*/
    /* GEOMedit_window(*output, "LShapeZ", ext); */
    GEOMdestroy_obj(obj9);

    slices_initialized = 1;

    GEOMedit_window(*output, "ChairPlot", ext);
    /* free any locally allocated data */
    return(1);
}

add_square(obj, x1, x2, y1, y2, z1, z2, u1, u2, v1, v2, w1, w2, N)
GEOMobj *obj;
float x1, x2, y1, y2, z1, z2, u1, u2, v1, v2, w1, w2, N;
{
    float v[4][3], uv[4][2], norm[4][3];
    int i, j;

/*
    fprintf(stderr,"\nObject Number: %d N = %f\n",obj_count,N);
    fprintf(stderr,"P1 = %f, %f, %f P2 = %f, %f, %f \n",x1,y1,z1,x2,y2,z2);
    fprintf(stderr,"uv1= %f, %f, %f uv2= %f, %f, %f \n",u1,v1,w1,u2,v2,w2);
*/

    /* initialize normals */
    for(i=0; i<4; i++)
      norm[i][0] = norm[i][1] = norm[i][2] = 0.0;

    /* assign x coordinates */
    if ( y1 == y2 ) {
	v[0][0] = v[3][0] = x1;
	v[1][0] = v[2][0] = x2;
	uv[0][0] = u1;
	uv[1][0] = u2;
        uv[2][0] = u2; 
        uv[3][0] = u1;
	for (i=0; i<4; i++)
	  norm[i][1] = N;
    } else {
	if (x1 == x2) { /* Side lives in X-plane */
	  for (i=0; i<4; i++)
	    norm[i][0] = N;
	  uv[0][0] = v1;
          uv[1][0] = 1.0;
	  uv[2][0] = 1.0; 
          uv[3][0] = v1; /* Not u2 - wrong plane */
        }
	if (z1 == z2) {
	  for (i=0; i<4; i++)
	    norm[i][2] = N;
	  uv[0][0] = u1;
          uv[1][0] = u1;
	  uv[2][0] = u2;
          uv[3][0] = u2;
        }
	v[0][0] = x1;
        v[1][0] = x1;
	v[2][0] = x2;
        v[3][0] = x2;
    }


    /* assign Y coordinates */
    v[0][1] = y1;
    v[1][1] = y2;
    v[2][1] = y2;
    v[3][1] = y1;

    if ( y1 == y2 ) {
       uv[0][1] = w1; 
       uv[1][1] = w1;
       uv[2][1] = w2;
       uv[3][1] = w2;
    }
    else if ( x1 == x2 ) {
       uv[0][1] = w1;
       uv[1][1] = w1;
       uv[2][1] = 1.0;
       uv[3][1] = 1.0;
    }
    else {
       uv[0][1] = v1;
       uv[1][1] = 1.0;
       uv[2][1] = 1.0;
       uv[3][1] = v1;
    }

    /* assign z coordinates */
    v[0][2] = v[1][2] = z1;
    v[2][2] = v[3][2] = z2;
/*
    uv[0][2] = uv[1][2] = w1;
    uv[2][2] = uv[3][2] = w2;
*/


    /* assign geometries */
    GEOMadd_disjoint_polygon(obj, v, norm, GEOM_NULL, 4, GEOM_NOT_SHARED|GEOM_CONVEX,
			     GEOM_COPY_DATA);

    for (i=0; i<4; i++) {
      for (j=0; j<2; j++) {
         uvs[i][j] = uv[i][j];
      }
/*
      fprintf(stderr," P%d X = %f Y = %f Z = %f",i,v[i][0],v[i][1], v[i][2]);
      fprintf(stderr," UV%d u = %f v = %f\n",i,uv[i][0],uv[i][1]);
*/
    }

    /* uvw_count += 4; For 3-D texture mapping */

    uv_count = 4;

    /* fprintf(stderr,"UVW count = %d\n",uv_count); */
    GEOMadd_uvs(obj, uvs, uv_count, GEOM_COPY_DATA);
}

add_x_L(obj, x, y1, y, y2, z1, z, z2, u, v1, v, v2, w1, w, w2, N)
GEOMobj *obj;
float x, y1, y, y2, z1, z, z2, u, v, w, v1, v2, w1, w2, N;
{
    float verts[6][3], uv[6][2], norm[6][3];
    int i, j;

/*
    fprintf(stderr,"Add_X_L: u = %f v  = %f w  = %f\n",u,v,w);
    fprintf(stderr,"\nObject Number: %d N = %f\n",obj_count,N);
    fprintf(stderr,"x = %f y1 = %f z1 = %f \n",x,y1,z1);
    fprintf(stderr,"x = %f y  = %f z  = %f \n",x,y,z);
    fprintf(stderr,"x = %f y2 = %f z2 = %f \n",x,y2,z2);

    fprintf(stderr,"u = %f v1 = %f w1 = %f\n",u,v1,w1);
    fprintf(stderr,"u = %f v  = %f w  = %f\n",u,v,w);
    fprintf(stderr,"u = %f v2 = %f w2 = %f\n",u,v2,w2);
*/

    /* initialize normals */
    for(i=0; i<6; i++) {
	norm[i][0] = N;
	norm[i][1] = norm[i][2] = 0.0;
	/* verts[i][0] = x; */
/*	uv[i][0] = u; */
    }

    /* Assign values */
    verts[0][0] = x; verts[0][1]= y1; verts[0][2]= z2;
    verts[1][0] = x; verts[1][1]= y1; verts[1][2]= z1;
    verts[2][0] = x; verts[2][1]= y2; verts[2][2]= z1;
    verts[3][0] = x; verts[3][1]= y2; verts[3][2]= z;
    verts[4][0] = x; verts[4][1]= y; verts[4][2]= z;
    verts[5][0] = x; verts[5][1]= y; verts[5][2]= z2;

    /* assign uv values */
    uv[0][0] = v1;    uv[0][1]= w2; 
    uv[1][0] = v1;    uv[1][1]= w1; 
    uv[2][0] = v2;    uv[2][1]= w1;
    uv[3][0] = v2;    uv[3][1]= w;
    uv[4][0] = v;     uv[4][1]= w; 
    uv[5][0] = v;    uv[5][1]= w2; 

/*
    uv[0][0] = u;
    uv[1][0] = w;
    uv[2][0] = w1;
    uv[3][0] = w1;
*/

    /* assign y coordinates */
    /* verts[0][1] = verts[3][1] = y1; */
    /* verts[1][1] = verts[2][1] = y; */
/*
    uv[0][1] = uv[3][1] = v1;
    uv[1][1] = uv[2][1] = v;
*/

    /* assign z coordinates */
    /* verts[0][2] = z1; */
    /* verts[1][2] = z; */
    /* verts[2][2] = verts[3][2] = z2; */

/* Don't do for 2-D texture mapping 
    uvw[0][2] = w1;
    uvw[1][2] = w;
    uvw[2][2] = uvw[3][2] = w2;
*/

    for (i=0; i<6; i++) {
      for (j=0; j<2; j++) {
         uvs[i][j] = uv[i][j];
      }
/*
      fprintf(stderr," P%d X = %f Y = %f Z = %f",i,
                       verts[i][0],verts[i][1], verts[i][2]);
      fprintf(stderr," UV%d u = %f v = %f\n",i,uv[i][0],uv[i][1]);
*/
    }

    /* assign geometries for bottom of L */
    GEOMadd_disjoint_polygon(obj, verts, norm, GEOM_NULL, 6, 
                             GEOM_NOT_SHARED|GEOM_CONCAVE, GEOM_COPY_DATA);

    uv_count = 6;
    GEOMadd_uvs(obj, uvs, uv_count, GEOM_COPY_DATA); 
}

add_y_L(obj, x1, x, x2, y, z1, z, z2, u1, u, u2, v, w1, w, w2, N)
GEOMobj *obj;
float x1, x, x2, y, z1, z, z2, u1, u, u2, v, w, w1, w2, N;
{
    float verts[6][3], uv[6][2], norm[6][3];
    int i, j;

/*
    fprintf(stderr,"Add_Y_L: u  = %f v  = %f w  = %f\n",u,v,w);
    fprintf(stderr,"\nObject Number: %d N = %f\n",obj_count,N);
    fprintf(stderr,"x1 = %f y = %f z1 = %f \n",x1,y,z1);
    fprintf(stderr,"x = %f  y  = %f z  = %f \n",x,y,z);
    fprintf(stderr,"x2= %f  y = %f z2 = %f \n",x2,y,z2);

    fprintf(stderr,"u1 = %f v  = %f w1 = %f\n",u1,v,w1);
    fprintf(stderr,"u  = %f v  = %f w  = %f\n",u,v,w);
    fprintf(stderr,"u2 = %f v  = %f w2 = %f\n",u2,v,w2);
*/

    /* initialize normals */
    for(i=0; i<6; i++) {
	norm[i][1] = N;
	norm[i][0] = norm[i][2] = 0.0;
    }

    /* Assign values */
    verts[0][0] = x1; verts[0][1]= y; verts[0][2]= z2;
    verts[1][0] = x;  verts[1][1]= y; verts[1][2]= z2;
    verts[2][0] = x;  verts[2][1]= y; verts[2][2]= z;
    verts[3][0] = x2; verts[3][1]= y; verts[3][2]= z;
    verts[4][0] = x2; verts[4][1]= y; verts[4][2]= z1;
    verts[5][0] = x1; verts[5][1]= y; verts[5][2]= z1;

    /* assign uv values */
    uv[0][0] = u1; uv[0][1]= w2; 
    uv[1][0] = u;  uv[1][1]= w2; 
    uv[2][0] = u;  uv[2][1]= w;
    uv[3][0] = u2; uv[3][1]= w;
    uv[4][0] = u2; uv[4][1]= w1; 
    uv[5][0] = u1; uv[5][1]= w1; 

    for (i=0; i<6; i++) {
      for (j=0; j<2; j++) {
         uvs[i][j] = uv[i][j];
      }
/*
      fprintf(stderr," P%d X = %f Y = %f Z = %f",i,
                       verts[i][0],verts[i][1], verts[i][2]);
      fprintf(stderr," UV%d u = %f v = %f\n",i,uv[i][0],uv[i][1]);
*/
     }

    /* assign geometries */
    GEOMadd_disjoint_polygon(obj, verts, norm, GEOM_NULL, 6, 
                             GEOM_NOT_SHARED|GEOM_CONCAVE, GEOM_COPY_DATA);

    uv_count = 6;
    GEOMadd_uvs(obj, uvs, uv_count, GEOM_COPY_DATA); 

}

add_z_L(obj, x1, x, x2, y1, y, y2, z, u1, u, u2, v1, v, v2, w, N)
GEOMobj *obj;
float x1, x, x2, y1, y, y2, z, u, u1, u2, v, w, v1, v2, N;
{
    float verts[6][3], uv[6][2], norm[6][3];
    int i, j;

/*
    fprintf(stderr,"Add_Z_L: u  = %f v  = %f w  = %f\n\n\n",u,v,w);
    fprintf(stderr,"\nObject Number: %d N = %f\n",obj_count,N);
    fprintf(stderr,"x1 = %f y1 = %f z = %f \n",x1,y1,z);
    fprintf(stderr,"x = %f  y  = %f z  = %f \n",x,y,z);
    fprintf(stderr,"x2= %f  y2 = %f z = %f \n",x2,y2,z);

    fprintf(stderr,"u1 = %f v1  = %f w = %f\n",u1,v1,w);
    fprintf(stderr,"u  = %f v  = %f w  = %f\n",u,v,w);
    fprintf(stderr,"u2 = %f v2  = %f w = %f\n",u2,v2,w);
*/

    /* initialize normals */
    for(i=0; i<6; i++) {
	norm[i][2] = N;
	norm[i][0] = norm[i][1] = 0.0;
    }

    /* Assign values */
    verts[0][0] = x1; verts[0][1]= y1; verts[0][2]= z;
    verts[1][0] = x2; verts[1][1]= y1; verts[1][2]= z;
    verts[2][0] = x2; verts[2][1]= y;  verts[2][2]= z;
    verts[3][0] = x;  verts[3][1]= y;  verts[3][2]= z;
    verts[4][0] = x;  verts[4][1]= y2; verts[4][2]= z;
    verts[5][0] = x1; verts[5][1]= y2; verts[5][2]= z;

    /* assign uv values */
    uv[0][0] = u1; uv[0][1]= v1; 
    uv[1][0] = u2; uv[1][1]= v1; 
    uv[2][0] = u2; uv[2][1]= v;
    uv[3][0] = u;  uv[3][1]= v;
    uv[4][0] = u;  uv[4][1]= v2; 
    uv[5][0] = u1; uv[5][1]= v2; 

    for (i=0; i<6; i++) {
      for (j=0; j<2; j++) {
         uvs[i][j] = uv[i][j];
      }
/*
      fprintf(stderr," P%d X = %f Y = %f Z = %f",i,
                       verts[i][0],verts[i][1], verts[i][2]);
      fprintf(stderr," UV%d u = %f v = %f\n",i,uv[i][0],uv[i][1]);
*/
     }

    /* assign geometries */
    GEOMadd_disjoint_polygon(obj, verts, norm, GEOM_NULL, 6, 
                             GEOM_NOT_SHARED|GEOM_CONCAVE, GEOM_COPY_DATA);

    uv_count = 6;
    GEOMadd_uvs(obj, uvs, uv_count, GEOM_COPY_DATA); 
}





/******************************************************/
/* initialization for modules contained in this file. */
/******************************************************/
#ifdef SEPARATE_MODULES
int ((*filter_mod_list[])()) = {
	MODexcavate_brick,
};
#define NMODS (sizeof(filter_mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(filter_mod_list, NMODS);
}
#endif



/* tag */


extern char *AVSstatic;

#define ORTHO_INPUT "ortho_slice input"
#define ORTHO_SLICE "slice plane"

/* static   */
ortho_slice_compute(input, outputp, plane, choice)
    AVSfield *input;
    AVSfield **outputp;
    int plane;
    char *choice;
{
    static AVSfield *output = 0;
    AVSfield template;
    int dims[2];
    int i, j, k, l, z, size, location;
    int	start, size2d, size3d;
    int	slicex, slicey, axis;
    float  min_extent[3], max_extent[3];
    
    /* Free old output data */	
    if (*outputp != NULL) 
	AVSfield_free(*outputp);

/*
    fprintf(stderr,"Calling ortho_slice_compute:\n");
    fprintf(stderr,"Slicing: %s in plane = %d\n",choice,plane);
*/

    switch(input->ndim) {
      case 3:
	/* AVSmodify_parameter("axis", AVS_MINVAL, NULL, "I J K", " "); */
	if (!strcmp(choice, "I")) {
	    axis = 0;
	    slicex = MAXY(input);
	    slicey = MAXZ(input);
	    z = MAXX(input) - 1;
	} else if (!strcmp(choice, "J")) {
	    axis = 1;
	    slicex = MAXX(input);
	    slicey = MAXZ(input);
	    z = MAXY(input) - 1;
	} else {
	    axis = 2;
	    slicex = MAXX(input);
	    slicey = MAXY(input);
	    z = MAXZ(input) - 1;
	}

	/*AVSmodify_parameter(ORTHO_SLICE, AVS_MINVAL | AVS_MAXVAL, z, 0, z);*/
	if (plane > z)
	    plane = z;

	/* Modify the slice plane widter to match the new incoming data */
	if (!AVSstatic || ((char *)z != AVSstatic)) {
	    AVSstatic = (char *)z;
	    if (plane > z) {
       /*AVSmodify_parameter(ORTHO_SLICE, AVS_MAXVAL | AVS_VALUE, z/2, 0, z);*/
		plane = z = z/2;
	    } 
	}
	
	dims[0] = slicex;
	dims[1] = slicey;
	
	AVSfield_get_extent (input, min_extent, max_extent);
	
	AVSfield_make_template(input, &template);
	template.ndim = 2;
	template.dimensions[0] = slicex;
	template.dimensions[1] = slicey;
	template.dimensions[2] = 1;
        
        if ( (output = (AVSfield *) AVSfield_alloc ( &template, dims)) == NULL)
           AVSmessage("Problem with AVSfield_alloc in ortho_slice_compute");
	
	size = input->veclen * input->size;
	size2d = slicex * slicey;
	size3d = MAXX(input) * MAXY(input) * MAXZ(input);
	
	start = plane*MAXX(input)*MAXY(input);
	location = start*size;
	
	/* copy data */
	switch ( axis ) {
	  case 0:
	    i = plane;
	    switch ( input->type ) {
	      case  AVS_TYPE_BYTE:
      /*   fprintf(stderr,"Using a BYTE field of lng = %d\n",input->veclen); */
		if (input->veclen == 1) {
		    for (j=0; j<slicey; j++) 
		      for(k=0; k<slicex; k++)
			output->field_data[j*slicex+k] = 
			  input->field_data[(MAXX(input)*((j*MAXY(input))+k))+i];
		} else {
		    for (j=0; j<slicey; j++) 
		      for(k=0; k<slicex; k++)
			for(l=0; l<input->veclen; l++)
			  output->field_data[input->veclen*(j*slicex+k)+l] = 
			    input->field_data[input->veclen*((MAXX(input)*
							      ((j*MAXY(input))+k))+i)+l];
		}
		break;
	      case  AVS_TYPE_REAL:
		if (input->veclen == 1) {
		    for (j=0; j<slicey; j++) 
		      for(k=0; k<slicex; k++)
			output->field_data_float[j*slicex+k] = 
			  input->field_data_float[(MAXX(input)*((j*MAXY(input))+k))+i];
		} else {
		    for (j=0; j<slicey; j++) 
		      for(k=0; k<slicex; k++)
			for(l=0; l<input->veclen; l++)
			  output->field_data_float[input->veclen*(j*slicex+k)+l] = 
			    input->field_data_float[input->veclen*((MAXX(input)*
								    ((j*MAXY(input))+k))+i)+l];
		}

		break;
 	      case  AVS_TYPE_DOUBLE:
 		if (input->veclen == 1) {
 		    for (j=0; j<slicey; j++)
  		      for(k=0; k<slicex; k++)
 			output->field_data_double[j*slicex+k] =  			    
			  input->field_data_double[(MAXX(input)*((j*MAXY(input))+k))+i];
 		} else {
 		    for (j=0; j<slicey; j++)
  		      for(k=0; k<slicex; k++)
 			for(l=0; l<input->veclen; l++)
 			  output->field_data_double[input->veclen*(j*slicex+k)+l] =
			    input->field_data_double[input->veclen*((MAXX(input)*
								     ((j*MAXY(input))+k))+i)+l];
 		}
  		break; 
	      case  AVS_TYPE_INTEGER:
 		if (input->veclen == 1) {
 		    for (j=0; j<slicey; j++)
  		      for(k=0; k<slicex; k++)
			output->field_data_int[j*slicex+k] =
			    input->field_data_int[(MAXX(input)*((j*MAXY(input))+k))+i];
 		} else {
 		    for (j=0; j<slicey; j++)
  		      for(k=0; k<slicex; k++)
 			for(l=0; l<input->veclen; l++)
 			  output->field_data_int[input->veclen*(j*slicex+k)+l] =
			    input->field_data_int[input->veclen*((MAXX(input)*
								  ((j*MAXY(input))+k))+i)+l];
 		}
  		break;
	      case  AVS_TYPE_SHORT:
 		if (input->veclen == 1) {
 		    for (j=0; j<slicey; j++)
  		      for(k=0; k<slicex; k++)
			output->field_data_short[j*slicex+k] =
			    input->field_data_short[(MAXX(input)*((j*MAXY(input))+k))+i];
 		} else {
 		    for (j=0; j<slicey; j++)
  		      for(k=0; k<slicex; k++)
 			for(l=0; l<input->veclen; l++)
 			  output->field_data_short[input->veclen*(j*slicex+k)+l] =
			    input->field_data_short[input->veclen*((MAXX(input)*
								  ((j*MAXY(input))+k))+i)+l];
 		}
  		break;
 	    }
 	    break;
 	  case 1:
 	    j = plane;
 	    switch ( input->type ) {
 	      case  AVS_TYPE_BYTE: 
		for (k=0; k<slicey; k++) 
 		  memcpy(&(output->field_data[input->veclen*k*slicex]),
			 &(input->field_data[input->veclen*((MAXX(input)*((k*MAXY(input))+j)))]),  
			 size*slicex);
 		break; 
	      case  AVS_TYPE_REAL: 
		for (k=0; k<slicey; k++)
  		  memcpy(&(output->field_data_float[input->veclen*k*slicex]),
			 &(input->field_data_float[input->veclen*((MAXX(input)*((k*MAXY(input))+j)))]),
 			 size*slicex); 
		break;
 	      case  AVS_TYPE_DOUBLE:
 		for (k=0; k<slicey; k++)
  		  memcpy(&(output->field_data_double[input->veclen*k*slicex]),
			 &(input->field_data_double[input->veclen*((MAXX(input)*((k*MAXY(input))+j)))]),
			 size*slicex);
		break;
	      case  AVS_TYPE_INTEGER:
		for (k=0; k<slicey; k++) 
		  memcpy(&(output->field_data_int[input->veclen*k*slicex]), 
			 &(input->field_data_int[input->veclen*((MAXX(input)*((k*MAXY(input))+j)))]),
			 size*slicex);
		break;
	      case  AVS_TYPE_SHORT:
		for (k=0; k<slicey; k++) 
		  memcpy(&(output->field_data_short[input->veclen*k*slicex]), 
			 &(input->field_data_short[input->veclen*((MAXX(input)*((k*MAXY(input))+j)))]),
			 size*slicex);
		break;
	    }
	    break;
	  case 2:
	    memcpy(output->field_data, &(input->field_data[location]), size*size2d);
	    break;
	}
	
	/* copy points */
	switch(input->uniform) {
	  case IRREGULAR:
	    switch (axis) {
	      case 0:
		i = plane;
		for (j=0; j<slicey; j++) {
		    for(k=0; k<slicex; k++) {
			l = (MAXX(input)*((MAXY(input)*j)+k))+i;
			output->points[j*slicex+k] = input->points[l];
			output->points[j*slicex+k+size2d] = input->points[l+size3d];
			output->points[j*slicex+k+(2*size2d)] = input->points[l+size3d*2];
		    }
		}
		break;
	      case 1:
		j = plane;
		for (k=0; k<slicey; k++) {
		    for(i=0; i<slicex; i++) {
			output->points[k*slicex+i]  =  COORD_X_3D(input, i, j, k);
			output->points[k*slicex+i+size2d]  =  COORD_Y_3D(input, i, j, k);
			output->points[k*slicex+i+(2*size2d)]  =  COORD_Z_3D(input, i, j, k);
		    }
		}
		break;
	      case 2:
		for(i=0; i<size2d; i++) {
		    output->points[i] = input->points[start+i];
		    output->points[i+size2d] = input->points[start+i+size3d];
		    output->points[i+2*size2d] = input->points[start+i+2*size3d];
		}
		break;
	    }
	    break;
	  case RECTILINEAR:
	    switch (axis) {
	      case 0:
		i = plane;
		output->min_extent[axis] = output->max_extent[axis] = 
		  input->points[i];
		for(j=0; j<slicex; j++) 
		    output->points[j] = input->points[MAXX(input)+j];
		for (k=0; k<slicey; k++) 
		    output->points[slicex+k] = input->points[MAXX(input)+MAXY(input)+k];
		break;
	      case 1:
		j = plane;
		output->min_extent[axis] = output->max_extent[axis] = 
		  input->points[MAXX(input)+j];
		for(i=0; i<slicex; i++) 
		  output->points[i] = input->points[i];
		for (k=0; k<slicey; k++) 
		  output->points[slicex+k] = input->points[MAXX(input)+MAXY(input)+k];
		break;
	      case 2:
		k = plane;
		output->min_extent[axis] = output->max_extent[axis] = 
		  input->points[MAXX(input)+MAXY(input)+k];
		for(i=0; i<slicex; i++) 
		  output->points[i] = input->points[i];
		for (j=0; j<slicey; j++) 
		  output->points[slicex+j] = input->points[MAXX(input)+j];
		break;
	    }
	    break;
	  default:
	  case UNIFORM:
	     for (i=0; i<2*input->nspace; i++) 
		 output->points[i] = input->points[i];

	     if (axis == 0) {
		 if (MAXX(input) != 1) {
		     output->points[0] =  ((float)plane/(input->dimensions[0]-1))*
		       (input->points[1]-input->points[0]) + input->points[0];
		     output->points[1] =  ((float)plane/(input->dimensions[0]-1))*
		       (input->points[1]-input->points[0]) + input->points[0];
		 } else {
		   output->points[0] = output->points[1] = input->points[0];
		 }
	     }
	     if (axis == 1) {
		 if (MAXY(input) != 1) {
		     output->points[2] =  ((float)plane/(input->dimensions[1]-1))*
		       (input->points[3]-input->points[2]) + input->points[2];
		     output->points[3] =  ((float)plane/(input->dimensions[1]-1))*
		       (input->points[3]-input->points[2]) + input->points[2];
		 } else {
		   output->points[2] = output->points[3] = input->points[2];
		 }
	     }
	     if (axis == 2) {
		 if (MAXZ(input) != 1) {
		     output->points[4] =  ((float)plane/(input->dimensions[2]-1))*
		       (input->points[5]-input->points[4]) + input->points[4];
		     output->points[5] =  ((float)plane/(input->dimensions[2]-1))*
		       (input->points[5]-input->points[4]) + input->points[4];
		 } else {
		   output->points[4] = output->points[5] = input->points[4];
		 }
	     }

	    break;
	}
	break;	/* end of 3D data */

      case 2:		/* start of 2D data  */
	  if (!strcmp(choice, "I")) {
	      axis = 0;
	      slicex = MAXY(input);
	      z = MAXX(input) - 1;
	  } else {
	      axis = 1;
	      slicex = MAXX(input);
	      z = MAXY(input) - 1;
	  }

	  /* AVSmodify_parameter("axis", AVS_MINVAL, NULL, "I J", " "); */
	  /* AVSmodify_parameter(ORTHO_SLICE, AVS_MAXVAL, z, 0, z); */
  	  if (plane > z) {
	    plane = z;
	  } else if ( plane < 0) {
	    plane = 0;
	  }
	  
	  /* Modify the slice plane widter to match the new incoming data */
	  if (!AVSstatic || ((char *)z != AVSstatic)) {
	      AVSstatic = (char *)z;
	      if (plane > z) {
/* AVSmodify_parameter(ORTHO_SLICE, AVS_MAXVAL | AVS_VALUE, z/2, 0, z); */
		  z = z/2;
	      }

	  }
	  
	  dims[0] = slicex;
	  
	  AVSfield_make_template(input, &template);
	  template.ndim = 1;
	  if (input->uniform == UNIFORM)
	    template.nspace = 1;
	  template.dimensions[0] = slicex;
	  if ((output = (AVSfield *) AVSfield_alloc ( &template, dims))== NULL)
           AVSmessage("Problem with AVSfield_alloc in ortho_slice_compute");
	  output->min_extent[0] = input->min_extent[axis];
	  output->max_extent[0] = input->max_extent[axis];
	  
	  size = input->veclen * input->size;
	  size2d = MAXX(input)*MAXY(input);
	  
	  /* copy data */
	  switch ( axis ) {
	    case 0:
	      i = plane;
	      switch ( input->type ) {
		case  AVS_TYPE_BYTE:
		  for(k=0; k<slicex; k++)
		    for(l=0; l<input->veclen; l++)
		      output->field_data[input->veclen*k+l] = 
			input->field_data[input->veclen*(k*MAXX(input)+i)+l];
		  break;
		case  AVS_TYPE_REAL:
		  for(k=0; k<slicex; k++)
		    for(l=0; l<input->veclen; l++)
		      output->field_data_float[input->veclen*k+l] = 
			input->field_data_float[input->veclen*(k*MAXX(input)+i)+l];
		  break;
		case  AVS_TYPE_DOUBLE:
		  for(k=0; k<slicex; k++)
		    for(l=0; l<input->veclen; l++)
		      output->field_data_double[input->veclen*k+l] = 
			input->field_data_double[input->veclen*(k*MAXX(input)+i)+l];
		  break;
		case  AVS_TYPE_INTEGER:
		  for(k=0; k<slicex; k++)
		    for(l=0; l<input->veclen; l++)
		      output->field_data_int[input->veclen*k+l] = 
			input->field_data_int[input->veclen*(k*MAXX(input)+i)+l];
		  break;
		case  AVS_TYPE_SHORT:
		  for(k=0; k<slicex; k++)
		    for(l=0; l<input->veclen; l++)
		      output->field_data_short[input->veclen*k+l] = 
			input->field_data_short[input->veclen*(k*MAXX(input)+i)+l];
		  break;
	      }
	      break;
	    case 1:
	      j = plane;
	      switch ( input->type ) {
		case  AVS_TYPE_BYTE:
		  memcpy(output->field_data, 
			 &(input->field_data[input->veclen*(j*MAXX(input))]),
			 size*slicex);
		  break;
		case  AVS_TYPE_REAL:
		  memcpy(output->field_data_float, 
			 &(input->field_data_float[input->veclen*(j*MAXX(input))]),
			 size*slicex);
		  break;
		case  AVS_TYPE_DOUBLE:
		  memcpy(output->field_data_double, 
			 &(input->field_data_double[input->veclen*(j*MAXX(input))]),
			 size*slicex);
		  break;
		case  AVS_TYPE_INTEGER:
		  memcpy(output->field_data_int, 
			 &(input->field_data_int[input->veclen*(j*MAXX(input))]),
			 size*slicex);
		  break;
		case  AVS_TYPE_SHORT:
		  memcpy(output->field_data_short, 
			 &(input->field_data_short[input->veclen*(j*MAXX(input))]),
			 size*slicex);
		  break;
	      }
	      break;
	  }
	  
	  /* copy points */
	  switch(input->uniform) {
	    case IRREGULAR:
	      switch (axis) {
		case 0:
		  i = plane;
		  for(k=0; k<slicex; k++) {
		      l = (MAXX(input)*k)+i;
		      output->points[k] = input->points[l];
		      output->points[k+slicex] = input->points[size2d+l];
		      if (input->nspace == 3)
			output->points[k+(2*slicex)] = input->points[(size2d*2)+l];
		  }
		  break;
		case 1:
		  j = plane;
		  for (k=0; k<slicex; k++) {
		      output->points[k] = input->points[dims[0]*j+k];
		      output->points[k+slicex] = input->points[size2d+dims[0]*j+k];
		      if (input->nspace == 3)
			output->points[k+(2*slicex)] = input->points[(size2d*2)+(dims[0]*j)+k];
		  }
		  break;
	      }
	      break;
	    case RECTILINEAR:
	      j = axis * input->dimensions[axis];
	      for (i=0; i<slicex; i++) 
		output->points[i] = input->points[j+i];
	      break;
	    case UNIFORM:
	      output->points[0] = input->points[axis*2];
	      output->points[1] = input->points[axis*2+1];
	      break;
	  }
	  break;
      }
					   
    /* *outputp = output;  */
    *outputp = output; 

    /* Free the output */
    /* AVSfield_free(output); */

    return(1);
}


#define NULL 0


/* Colorizer */

static float cmap_data[4*BYTE_TABLE];
static AVScolormap default_color_map;

static colorizer_init()
{
	register int i;

	default_color_map.size = BYTE_TABLE;
	default_color_map.lower = 0.0;
	default_color_map.upper = 255.0;
	default_color_map.hue = &cmap_data[0];
	default_color_map.saturation = &cmap_data[BYTE_TABLE];
	default_color_map.value = &cmap_data[2*BYTE_TABLE];
	default_color_map.alpha = &cmap_data[3*BYTE_TABLE];
	for (i=0; i<BYTE_TABLE; i++) {
		cmap_data[i] = 0.0;
		cmap_data[BYTE_TABLE+i] = 0.0;
		cmap_data[(2*BYTE_TABLE) + i] = (float)i/(float)(BYTE_TABLE-1);
		cmap_data[(3*BYTE_TABLE) + i] = (float)i/(float)(BYTE_TABLE-1);
	}
}	

/*********************************************************/
/* static */
colorizer_compute(in_field, in_colormap, outputp)
AVSfield *in_field;
AVScolormap *in_colormap;
AVSfield_char **outputp;
{
	AVSfield_char *output = *outputp, template;
	unsigned int   lut[BYTE_TABLE];
	register int   i, size;
	int 	       *dims, *intbuf, index;
	AVScolormap   *CM;
#if _CRAY
	unsigned char *cbuf;
#endif


        /* Initialize the default colormap */
        colorizer_init();

	CM = (in_colormap) ? in_colormap : &(default_color_map);
	size = AVSfield_prod(in_field->ndim, in_field->dimensions);

	/* if (AVSinput_changed("Input Field", 0) || !output) { */
	if (in_field || !output) {
	    dims = (int *) ALLOC_LOCAL (sizeof(int) * in_field->ndim);
	    for(i=0; i<in_field->ndim; i++) 
	      dims[i] = in_field->dimensions[i];

	    if (output) 
	      AVSdata_free ( "field", output );

	    AVSfield_make_template(in_field, &template);
	    template.veclen = 4;
	    template.type = AVS_TYPE_BYTE;
	    output = (AVSfield_char *) AVSfield_alloc ( &template, dims);
	    AVSfield_copy_points(in_field, output);
	    FREE_LOCAL(dims);
        }
	
	for(i=0;i<BYTE_TABLE;i++)
	  PIXELhsva_to_pixel(&lut[i],
			     CM->hue[i],
			     CM->saturation[i],
			     CM->value[i],
			     CM->alpha[i]);

	intbuf = (int *)output->data;
#if _CRAY
	cbuf = output->data;
#endif

	switch(in_field->type) {
	  case AVS_TYPE_BYTE:
	    for(i=0; i<size; i++) {
#if _CRAY
	      /* Portable version that will work on all machines. */
	      index = PIXELget_index(CM, (float)(in_field->field_data[i]));
	      cbuf[i*4+AVS_ALPHA_BYTE] = 
			(lut[index] & AVS_ALPHA_MASK) >> AVS_ALPHA_SHIFT;
	      cbuf[i*4+AVS_RED_BYTE] = 
			(lut[index] & AVS_RED_MASK) >> AVS_RED_SHIFT;
	      cbuf[i*4+AVS_GREEN_BYTE] = 
			(lut[index] & AVS_GREEN_MASK) >> AVS_GREEN_SHIFT;
	      cbuf[i*4+AVS_BLUE_BYTE] = 
			(lut[index] & AVS_BLUE_MASK) >> AVS_BLUE_SHIFT;
#else
	      /* Faster version which works only for 32 bit integers. */
	      intbuf[i] = lut[in_field->field_data[i]];

#endif
	    }
	    break;
	  case AVS_TYPE_REAL:
	    for(i=0; i<size; i++) {
	      index = PIXELget_index(CM,
(float)(in_field->field_data_float[i]));
#if _CRAY
	      /* Portable version that will work on all machines. */

	      cbuf[i*4+AVS_ALPHA_BYTE] = 
			(lut[index] & AVS_ALPHA_MASK) >> AVS_ALPHA_SHIFT;
	      cbuf[i*4+AVS_RED_BYTE] = 
			(lut[index] & AVS_RED_MASK) >> AVS_RED_SHIFT;
	      cbuf[i*4+AVS_GREEN_BYTE] = 
			(lut[index] & AVS_GREEN_MASK) >> AVS_GREEN_SHIFT;
	      cbuf[i*4+AVS_BLUE_BYTE] = 
			(lut[index] & AVS_BLUE_MASK) >> AVS_BLUE_SHIFT;
#else
	      /* Faster version which works only for 32 bit integers. */

	      intbuf[i] = lut[index];
#endif
	    }
	    break;
	  case AVS_TYPE_DOUBLE:
	    for(i=0; i<size; i++) {
	      index = PIXELget_index(CM,
(float)(in_field->field_data_double[i]));
#if _CRAY
	      /* Portable version that will work on all machines. */

	      cbuf[i*4+AVS_ALPHA_BYTE] = 
			(lut[index] & AVS_ALPHA_MASK) >> AVS_ALPHA_SHIFT;
	      cbuf[i*4+AVS_RED_BYTE] = 
			(lut[index] & AVS_RED_MASK) >> AVS_RED_SHIFT;
	      cbuf[i*4+AVS_GREEN_BYTE] = 
			(lut[index] & AVS_GREEN_MASK) >> AVS_GREEN_SHIFT;
	      cbuf[i*4+AVS_BLUE_BYTE] = 
			(lut[index] & AVS_BLUE_MASK) >> AVS_BLUE_SHIFT;
#else
	      /* Faster version which works only for 32 bit integers. */

	      intbuf[i] = lut[index];
#endif
	    }
	    break;
	  case AVS_TYPE_INTEGER:
	    for(i=0; i<size; i++) {
	      index = PIXELget_index(CM, (float)(in_field->field_data_int[i]));
#if _CRAY
	      /* Portable version that will work on all machines. */

	      cbuf[i*4+AVS_ALPHA_BYTE] = 
			(lut[index] & AVS_ALPHA_MASK) >> AVS_ALPHA_SHIFT;
	      cbuf[i*4+AVS_RED_BYTE] = 
			(lut[index] & AVS_RED_MASK) >> AVS_RED_SHIFT;
	      cbuf[i*4+AVS_GREEN_BYTE] = 
			(lut[index] & AVS_GREEN_MASK) >> AVS_GREEN_SHIFT;
	      cbuf[i*4+AVS_BLUE_BYTE] = 
			(lut[index] & AVS_BLUE_MASK) >> AVS_BLUE_SHIFT;
#else
	      /* Faster version which works only for 32 bit integers. */

	      intbuf[i] = lut[index];
#endif
	    }
	    break;
	}
	
	/* AVSfield_set_labels (output, "alpha;red;green;blue", ";"); */
	AVSfield_invalid_minmax (output);
	*outputp = output;
	return(1);
}

