/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

*****************************************************************************/
/* Module Name: "Draw Text" (Mapper) (Subroutine)                       */
/* Author: Ron Stogner, CSC                                             */
/* Date Created: Tue May  5 10:56:15 1992                               */
/*      Modified: by Kathy Pearson to optionally append an input hour   */
/*                to the label so that animated frames can be           */
/*                appropriately labelled                                */
  
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>
 
/* *****************************************/
/*  Module Specification                   */
/* *****************************************/

int Draw_Text_spec()
{

  int in_port, out_port, param ;
  extern int Draw_Text_compute() ;

  AVSset_module_name("Draw Text", MODULE_MAPPER);

  /* Input Port Specification */

  in_port = AVScreate_input_port( "Label String", "string", REQUIRED ) ;

  in_port = AVScreate_input_port( "Hour", "integer", OPTIONAL);

  /* Output Port Specifications */

  out_port = AVScreate_output_port("Text Geometry", "geom");

  /* Parameters */

  param = AVSadd_parameter( "Append Hour", "boolean", 0, 0, 0);
  AVSconnect_widget( param, "toggle");

  param = AVSadd_parameter( "Font", "choice", "Courier",
                            "Courier:Helvetica:Times:Roman:Script", ":" ) ;
  AVSconnect_widget( param, "radio_buttons" ) ;

  param = AVSadd_parameter( "Bold", "boolean", 0, 0, 0 ) ;
  AVSconnect_widget( param, "toggle" ) ;

  param = AVSadd_parameter( "Italic", "boolean", 0, 0, 0 ) ;
  AVSconnect_widget( param, "toggle" ) ;

  param = AVSadd_float_parameter( "x location", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND ) ;
  AVSconnect_widget( param, "typein_real" ) ;

  param = AVSadd_float_parameter( "y location", 0.75, FLOAT_UNBOUND, FLOAT_UNBOUND ) ;
  AVSconnect_widget( param, "typein_real" ) ;

  param = AVSadd_float_parameter( "z location", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND ) ;
  AVSconnect_widget( param, "typein_real" ) ;

  param = AVSadd_float_parameter( "x offset", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND ) ;
  AVSconnect_widget( param, "typein_real" ) ;

  param = AVSadd_float_parameter( "y offset", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND ) ;
  AVSconnect_widget( param, "typein_real" ) ;

  param = AVSadd_float_parameter( "z offset", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND ) ;
  AVSconnect_widget( param, "typein_real" ) ;

  param = AVSadd_float_parameter( "label height", 0.07, FLOAT_UNBOUND, FLOAT_UNBOUND ) ;
  AVSconnect_widget( param, "typein_real" ) ;

/* added by jfwang */
  param = AVSadd_parameter("content", "string", " ", " ", ":");
  AVSconnect_widget(param, "typein");
  AVSadd_parameter_prop(param,"width","integer",4);

  AVSset_compute_proc(Draw_Text_compute);

  return( 1 );

}
 

/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/

/* IAC CODE CHANGE - remove ANSI style argument list */
int Draw_Text_compute(  Label_String, 
			Hour,
			Text_Geometry,
		        Append_Hour,
                        Font, 
			Bold, 
			Italic, 
                        x_location, 
			y_location, 
			z_location,
                        x_offset, 
			y_offset, 
			z_offset,
                        label_height,
                        content
                      )
char 		*Label_String; 
int 		Hour;
GEOMedit_list 	*Text_Geometry;
int 		Append_Hour;
char 		*Font; 
int 		Bold; 
int 		Italic; 
float 		*x_location; 
float 		*y_location; 
float 		*z_location;
float 		*x_offset; 
float 		*y_offset; 
float 		*z_offset;
float 		*label_height;
char 		*content;
{

  int     label_flags, pass ;
  static float   ref_point[3] ;
  static float   offset[3] ;
  float   height ;
  GEOMobj *obj ;
  char *temp_str;
  register n;

  if (pass == 0)
  {
     AVSmodify_parameter("content", AVS_VALUE, Label_String,
                         content, ":");
     pass++;
  }
  n = strlen(Label_String);

  if ((temp_str = ((char *) malloc(sizeof(char) * n + 8))) == NULL)
	{
	AVSerror("Cannot alloccate memory for local string in DrawText.");
	return(0);
	}

  if (Append_Hour)
  	sprintf(temp_str, "%s %d  ", Label_String, Hour);
  else
	sprintf(temp_str, "%s", Label_String);

  /* by jfwang */
  if (AVSparameter_changed("content"))
  {
     if (Append_Hour)
     	sprintf(temp_str, "%s %d  ", content, Hour);
     else
   	sprintf(temp_str, "%s", content);
  }

  /* Create the Text_Geometry object */

  label_flags = GEOMcreate_label_flags( GEOMget_font_number( Font, Bold, Italic)
                                  , 1, 0, 1, GEOM_LABEL_CENTER, 0 ) ;

  obj = GEOMcreate_obj( GEOM_LABEL, GEOM_NULL ) ;

  /* Add label */

  ref_point[0] = *x_location ;
  ref_point[1] = *y_location ;
  ref_point[2] = *z_location ;

  offset[0] = *x_offset ;
  offset[1] = *y_offset ;
  offset[2] = *z_offset ;

  height = *label_height ;

  GEOMadd_label( obj, temp_str, ref_point, offset, height, GEOM_NULL, label_flags ) ;

  /* Create the GEOM Edit List for Text_Geometry */

  *Text_Geometry = GEOMinit_edit_list( *Text_Geometry ) ;
  GEOMedit_geometry( *Text_Geometry, "Text_Geometry", obj ) ;
  GEOMdestroy_obj( obj ) ;

  free((char *) temp_str);
  return( 1 ) ;

}
 

AVSinit_modules()
{

  AVSmodule_from_desc( Draw_Text_spec ) ;

}
