/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*------------------------------------------------------------------
   The algorithm to create isosurface from 3D uniform data volume
   is a marching cubes method from Lorensen et al
   The main routine to generate isosurface is "create_isosurf".
   Input : 3D field scalar byte uniform
   Output: Geom object for rendering routine
--------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
#include <stdio.h>
/* IAC CODE CHANGE : #include <math.h> */
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include <avs/avs.h>
#include <avs/colormap.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <sys/times.h>
#include "pattern.h"
/*------------------------------------------------------------------*/

#define PATNO 256
#define BOUND(x,t) (x>=t ? 1 : 0)
#define EXTRACT(x,n) (x>>(n*3))&07
#define EXTRACT1(x,n) (x>>n)&01
/*-------------------------------ba9 876 543 210 */
#define XTRACED 01122         /* 001 001 010 010 */
#define YTRACED 00461         /* 000 100 110 001 */
#define ZTRACED 00017         /* 000 000 001 111 */
#define PlyNo1 1
#define PlyNo2 2
#define PlyNo3 2
#define PlyNo4 2
#define PlyNo5 3
#define PlyNo6 2
#define PlyNo7 3
#define PlyNo8 2
#define PlyNo9 4
#define PlyNo10 4
#define PlyNo11 4
#define PlyNo12 4
#define PlyNo13 4
#define PlyNo14 4

/*------------------------------------------------------------------*/
/* one pattern table with 128 entries is defined */
/* IAC code change - static */ unsigned int pattab[PATNO];

/* pre-computed dim0,dim1,dim2,dim01,dim012 */
/* IAC code change - static */ int dim0, dim1, dim2, dim01, dim012, dim_01;

/*------------------------------------------------------------------*/
struct INTERINFO {
   float pos[3];
   float norm[3];
};

/*------------------------------------------------------------------*/
/* initialize isosurf module */
AVSinit_modules()
{
   int isosurf();
   AVSmodule_from_desc(isosurf);
}

/* define the isosurf module */
int isosurf()
{
   int isosurf_p();
   int parm;

   /* declare module by name */
   AVSset_module_name("Field to Isosurface",MODULE_MAPPER);

   /* create 2 input port */
   AVScreate_input_port("InputField","field 3D scalar byte uniform",REQUIRED);
   AVScreate_input_port("InputCmap","colormap",REQUIRED);

   /* create 1 output port */
   AVScreate_output_port("OutputGeom","geom");

   /* define parameter for threshold level input */
   parm=AVSadd_float_parameter("Level",180.,0.,255.);
   AVSconnect_widget(parm,"dial");

   /* set computing procedure */
   AVSset_compute_proc(isosurf_p);
}

/* computing procedure body */
int isosurf_p(inf,cmap,og,level)
AVSfield_char *inf;
AVScolormap *cmap;
GEOMedit_list *og;
float *level;
{
/*-----------------------Local variables-----------------------------*/
   GEOMobj *isosurf_obj;
   float *extent=NULL;
   float isosurf_shade[3];
   int index;
   /* IAC code change - static void hsv_to_rgb(); */

/*------------------------------------------------------------------*/
   /* initialize pattern table as well-defined pattern */
   init_pattab();

   /* initialize edit list */
   *og=GEOMinit_edit_list(*og);

   /* create the empty polytri object */
   isosurf_obj=GEOMcreate_obj(GEOM_POLYTRI,extent);

   /* determine the color associated with this level value */
   index=AVScmap_index(cmap,*level);
   hsv_to_rgb(isosurf_shade,isosurf_shade+1,isosurf_shade+2,
              cmap->hue[index],cmap->saturation[index],cmap->value[index]);

   /* process the input and create the isosurface geom */
   create_isosurf(isosurf_obj,inf,level,isosurf_shade);
/*------------------------------------------------------------------*/

   GEOMedit_geometry(*og,"isosurface",isosurf_obj);
   GEOMdestroy_obj(isosurf_obj);

   return(1);
}

/* Main routine to generate isosurface geometric object by Marching method
   Note: the input field is a uniform one
*/

/* STATIC GLOBAL VARIABLES */
/* IAC code change - static */ float *xp,*yp,*zp,*coord,*color;
/* IAC code change - static */ int count=0;
/* IAC code change - static */ struct INTERINFO *px[2],*py[2],*pz;
/* IAC code change - static */ struct INTERINFO *b0,*f0,*m0,*b,*f,*m,*tbf;
/* IAC code change - static */ float verts[3][3],normals[3][3],colors[3][3];
/* IAC code change - static */ int pno[15];
/* IAC code change - static */ int xtraced,ytraced,ztraced,traced;

/*------------------------------------------------------------------*/
create_isosurf(obj,inf,lev,shade)
GEOMobj *obj;
AVSfield_char *inf;
float *lev;
float *shade;
{

/*------------------------------------------------------------------*/
  /* look up pattern code prototype */
  unsigned int getpcode();
  int typeno[15];
  unsigned int pcode,ptype;
  /* pointer to input data */
  unsigned char *data=inf->data;
  int size;
  /* miscellaneous local variable declarations */
  int zoffset0,zoffset1;
  int yoffset0,yoffset1;
  int i,j,k;
/*------------------------------------------------------------------*/


  /* get dimension for x, y and z and pre-compute multiply */
  dim0=inf->dimensions[0];
  dim1=inf->dimensions[1];
  dim2=inf->dimensions[2];
  dim01=dim0*dim1;
  dim012=dim01*dim2;

  /* assign shade to color for rendering use */
  color=shade;
  colors[0][0]=colors[1][0]=colors[2][0]= *color;
  colors[0][1]=colors[1][1]=colors[2][1]= *(color+1);
  colors[0][2]=colors[1][2]=colors[2][2]= *(color+2);

  /* generate uniform coordinate list */
  coord=(float *)malloc(sizeof(float)*3*dim012);
  if (coord==NULL)
     AVSerror("Malloc failure in isosurf_p for coordinates.");
  generate_coords(coord);

  b0=(struct INTERINFO *)malloc(sizeof(struct INTERINFO)*(2*dim01-dim0-dim1));
  if (b0==NULL)
     AVSerror("Malloc failure in isosurf_p for back plane coordinates.");

  f0=(struct INTERINFO *)malloc(sizeof(struct INTERINFO)*(2*dim01-dim0-dim1));
  if (f0==NULL)
     AVSerror("Malloc failure in isosurf_p for front plane coordinates.");

  m0=(struct INTERINFO *)malloc(sizeof(struct INTERINFO)*dim01);
  if (m0==NULL)
     AVSerror("Malloc failure in isosurf_p for middle plane coordinates.");

  /* xp -->start of all x coord under dimension */
  xp=coord;
  /* yp -->start of all y coord under dimension */
  yp=xp+dim012;
  /* zp -->start of all z coord under dimension */
  zp=yp+dim012;

  for (i=0;i<15;i++)
      pno[i]=0;

  /* for all cubes match pattern code table to generate triangles */
  zoffset1=0;
  b=b0;
  m=m0;
  f=f0;
  for (k=0,ztraced=0;k<dim2-1;k++,ztraced=ZTRACED) {
      zoffset0=zoffset1;
      zoffset1=zoffset0+dim01;
      /* deal with only one z plane cubes */
      read1plane(obj,data,*lev,zoffset0,k,&size);
      /* redirect front pointer to back pointer */
      tbf=f;
      f=b;
      b=tbf;

  }

  for (i=0;i<15;i++) printf("Type %d = %d\n",i,pno[i]);
  /* free all tempory memory */


/* IAC CODE CHANGE :   free(b0); */

/* IAC CODE CHANGE :    free(b0); */

/* IAC CODE CHANGE :     free(b0); */
     free(b0);

/* IAC CODE CHANGE :   free(f0); */

/* IAC CODE CHANGE :    free(f0); */

/* IAC CODE CHANGE :     free(f0); */
     free(f0);

/* IAC CODE CHANGE :   free(m0); */

/* IAC CODE CHANGE :    free(m0); */

/* IAC CODE CHANGE :     free(m0); */
     free(m0);

/* IAC CODE CHANGE :   free(coord); */

/* IAC CODE CHANGE :    free(coord); */

/* IAC CODE CHANGE :     free(coord); */
     free(coord);

  return(1);
}

/* read 1st cubic plane with positions and normals */
read1plane(obj,d,lev,zoff,z,size)
GEOMobj *obj;
unsigned char *d;
float lev;
int zoff;
int z;
int *size;
{
/* ------------------------------------local variables define--------------------- */
   int i,j,k;
   unsigned char vdata1,vdata2;
   unsigned int pcode;
   unsigned int ptype;
   unsigned int cedge;
   unsigned int uedge;
   unsigned int c1,c2;
   struct INTERINFO *px0;
   struct INTERINFO *px1;
   struct INTERINFO *py0;
   struct INTERINFO *py1;
   float *addressv,*addressn;
   struct INTERINFO edge_array[12];
   struct INTERINFO *edgea;
   char *plyedges;
   char PlyNo;
   char edge_cnvt[12];
   char e1,e2,e3;
   float *post,*norm;
   float v0[3],v1[3];
   float n0[3],n1[3];
   float n[3],v[3];
   int yoffset1,yoffset0,zoffset1,zoffset0;

/* ------------------------------------z & y offset initialization-----------------*/
   zoffset0=zoff;
   zoffset1=zoffset0+dim01;
   yoffset1=0;
   *size=0;

/*-----------------------------------begin to find isosurface----------------------*/
   /* loop for y direction with yExt=dim1-1 */
   for (i=0,ytraced=ztraced;i<dim1-1;i++,ytraced=ztraced,ytraced|=YTRACED) {
       yoffset0=yoffset1;
       yoffset1=yoffset0+dim0;
       /* ----------------------loop for x direction with xExt=dim0-1------------- */
       for (j=0,xtraced=ytraced;j<dim0-1;j++,xtraced=ytraced,xtraced|=XTRACED) {
           /* get pattern code from the current cubic */
           pcode=getpcode(d,zoffset0,yoffset0,j,lev);
           ptype=pcode;
           ptype=(ptype>>24)&077;
           pno[ptype]++;
           /* this case will not happen */
           if (ptype>14)
              AVSerror("Error pattern type !!");

           /* get cross edge code for ptype */
           cedge=CROSSEDGE[ptype];

           /* -------------------calculate interseted position --------------------*/
           for (k=0;k<12;cedge>>=1,k++) {
               /* only consider the edges that are intersected by isosurface */
               if (cedge&1) {

                  /* convert real corner index for these two end points */
                  c1=EXTRACT(pcode,UEDGETABLE[k][0]);
                  c2=EXTRACT(pcode,UEDGETABLE[k][1]);

                  /* decide real edge that is intersected */
                  uedge=EDGETABLE[c1][c2];

                  /* ready for retrieval later */
                  edge_cnvt[k]=uedge;

                  /* redirect edge_array */
                  addressv=edge_array[uedge].pos;
                  addressn=edge_array[uedge].norm;

                  if (EXTRACT1(xtraced,uedge)) {
                     /* this is a shared edge and only get data from cache */
                     switch (uedge) {
                        case  0: copy_nv(f+yoffset0+yoffset0-i+j,addressv,addressn);
                                 break;
                        case  1: copy_nv(f+dim0-1+yoffset0+yoffset0-i+j,addressv,addressn);
                                 break;
                        case  2: copy_nv(f+dim0-1+yoffset0+yoffset0-i+j+1,addressv,addressn);
                                 break;
                        case  3: copy_nv(f+yoffset0+dim0+yoffset0+dim0-i-1+j,addressv,addressn);
                                 break;
                        case  4: copy_nv(m+yoffset0+j,addressv,addressn);
                                 break;
                        case  5: copy_nv(m+yoffset0+j+1,addressv,addressn);
                                 break;
                        case  6: copy_nv(m+yoffset1+j,addressv,addressn);
                                 break;
                        case  8: copy_nv(b+yoffset0+yoffset0-i+j,addressv,addressn);
                                 break;
                        case  9: copy_nv(b+dim0-1+yoffset0+yoffset0-i+j,addressv,addressn);
                                 break;
                        case  7:
                        case 10:
                        case 11:
                        default: break;
                     }
                  }
                  /* v,n must be generated and copy them onto bmf */
                  else {
                     find_offset(d,c1,zoffset0,yoffset0,j,i,z,v0,n0,&vdata1);
                     find_offset(d,c2,zoffset0,yoffset0,j,i,z,v1,n1,&vdata2);

                     /* here v0,n0,vdata1 & v1,n1,vdata2 are available */
                     /* interpolate these two end points into the edge */
                     interpolate(v0,v1,vdata1,vdata2,lev,addressv);
                     interpolate(n0,n1,vdata1,vdata2,lev,addressn);

                     /* record it into cache */
                     switch (uedge) {
                        case  0: copy_bmf(f+yoffset0+yoffset0-i+j,addressv,addressn);
                                 break;
                        case  1: copy_bmf(f+dim0-1+yoffset0+yoffset0-i+j,addressv,addressn);
                                 break;
                        case  2: copy_bmf(f+dim0-1+yoffset0+yoffset0-i+j+1,addressv,addressn);
                                 break;
                        case  3: copy_bmf(f+yoffset0+dim0+yoffset0+dim0-i-1+j,addressv,addressn);
                                 break;
                        case  4: copy_bmf(m+yoffset0+j,addressv,addressn);
                                 break;
                        case  5: copy_bmf(m+yoffset0+j+1,addressv,addressn);
                                 break;
                        case  6: copy_bmf(m+yoffset1+j,addressv,addressn);
                                 break;
                        case  8: copy_bmf(b+yoffset0+yoffset0-i+j,addressv,addressn);
                                 break;
                        case  9: copy_bmf(b+dim0-1+yoffset0+yoffset0-i+j,addressv,addressn);
                                 break;
                        case  7: copy_bmf(m+yoffset1+j+1,addressv,addressn);
                                 break;
                        case 10: copy_bmf(b+dim0-1+yoffset0+yoffset0-i+j+1,addressv,addressn);
                                 break;
                        case 11: copy_bmf(b+yoffset0+dim0+yoffset0+dim0-i-1+j,addressv,addressn);
                                 break;
                        default: break;
                     }
                  
                  /* assign address pointer to be ready for fill coords and norms
                                   (8)
                              4------------5
                        (4)  /|       (5) /|
                             0------------1|
                             ||    (0)    ||        edge index assignment (0..11)
                             ||(9)        ||(10)
                        (1)  ||       (2) ||        corner index assignment (0..7)
                             |6___(11)____|7
                             2/(6)_ ______3/(7)
                                   (3)
                  */
                  }

               }
               /* unsetting edge doesn't care !! */
           }
           /* complete all these 12 edge checkings */
           /* PlyNo     : decides how many triangles to generate
              plyedges  : defines all triangle edge index
              both variables must be pointered to appropriate data structure for different type
           */
/*-----------------------------------------------------------*/
           switch (ptype) {
              case 1:
                     PlyNo=PlyNo1;                     
                     plyedges= &PLYEDGES1[0][0];
                     break;
              case 2:
                     PlyNo=PlyNo2;
                     plyedges= &PLYEDGES2[0][0];
                     break;
              case 3:
                     PlyNo=PlyNo3;
                     plyedges= &PLYEDGES3[0][0];
                     break;
              case 4:
                     PlyNo=PlyNo4;
                     plyedges= &PLYEDGES4[0][0];
                     break;
              case 5:
                     PlyNo=PlyNo5;
                     plyedges= &PLYEDGES5[0][0];
                     break;
              case 6:
                     PlyNo=PlyNo6;
                     plyedges= &PLYEDGES6[0][0];
                     break;
              case 7:
                     PlyNo=PlyNo7;
                     plyedges= &PLYEDGES7[0][0];
                     break;
              case 8:
                     PlyNo=PlyNo8;
                     plyedges= &PLYEDGES8[0][0];
                     break;
              case 9:
                     PlyNo=PlyNo9;
                     plyedges= &PLYEDGES9[0][0];
                     break;
              case 10:
                     PlyNo=PlyNo10;
                     plyedges= &PLYEDGES10[0][0];
                     break;
              case 11:
                     PlyNo=PlyNo11;
                     plyedges= &PLYEDGES11[0][0];
                     break;
              case 12:
                     PlyNo=PlyNo12;
                     plyedges= &PLYEDGES12[0][0];
                     break;
              case 13:
                     PlyNo=PlyNo13;
                     plyedges= &PLYEDGES13[0][0];
                     break;
              case 14:
                     PlyNo=PlyNo14;
                     plyedges= &PLYEDGES14[0][0];
                     break;
              default:
                     PlyNo=0;
                     break;
            }
/*------------------------------------------------------------*/
            /* ---------------here actually generate geometry object for triangles --------------*/


                     for (k=0;k<PlyNo;k++) {
                         /* convert to correct edge lists */
                         e1=edge_cnvt[*(plyedges+k*3)];
                         e2=edge_cnvt[*(plyedges+k*3+1)];
                         e3=edge_cnvt[*(plyedges+k*3+2)];

                         /* by the edge lists produce vertices, normals */
                         
                         verts[0][0]=edge_array[e1].pos[0];
                         verts[0][1]=edge_array[e1].pos[1];
                         verts[0][2]=edge_array[e1].pos[2];
                         normals[0][0]=edge_array[e1].norm[0];
                         normals[0][1]=edge_array[e1].norm[1];
                         normals[0][2]=edge_array[e1].norm[2];

                         verts[1][0]=edge_array[e2].pos[0];
                         verts[1][1]=edge_array[e2].pos[1];
                         verts[1][2]=edge_array[e2].pos[2];
                         normals[1][0]=edge_array[e2].norm[0];
                         normals[1][1]=edge_array[e2].norm[1];
                         normals[1][2]=edge_array[e2].norm[2];

                         verts[2][0]=edge_array[e3].pos[0];
                         verts[2][1]=edge_array[e3].pos[1];
                         verts[2][2]=edge_array[e3].pos[2];
                         normals[2][0]=edge_array[e3].norm[0];
                         normals[2][1]=edge_array[e3].norm[1];
                         normals[2][2]=edge_array[e3].norm[2];
                         
                         GEOMadd_polytriangle(obj,verts,normals,colors,3,GEOM_COPY_DATA);
                         
                      }
                      *size= *size + PlyNo;
        }
        /* end of j */
     }
     /* end of i */
}

/* copy from bmf to n,v */
copy_nv(bmf,v,n)
struct INTERINFO *bmf;
float *v;
float *n;
{
   *v=bmf->pos[0];  *(v+1)=bmf->pos[1];  *(v+2)=bmf->pos[2];
   *n=bmf->norm[0]; *(n+1)=bmf->norm[1]; *(n+2)=bmf->norm[2];
   return(1);
}

/* copy from n,v to bmf */
copy_bmf(bmf,v,n)
struct INTERINFO *bmf;
float *v;
float *n;
{
   bmf->pos[0]= *v;  bmf->pos[1]= *(v+1);  bmf->pos[2]= *(v+2);
   bmf->norm[0]= *n; bmf->norm[1]= *(n+1); bmf->norm[2]= *(n+2);
   return(1);
}

/* get vert,norm and data for interesting cubic index */
find_offset(d,c,z0,y0,x,y,z,v,n,vd)
unsigned char *d;
unsigned char c;
int z0,y0,x,y,z;
float *v,*n;
unsigned char *vd;
{
/*------------------------------------------------------------*/
  int offset;
  int z1=z0+dim01;
  int y1=y0+dim0;
  float Gx,Gy,Gz,Nx,Ny,Nz,G,H;
  int X=x;
  int Y=y;
  int Z=z;
/*------------------------------------------------------------*/

/* adjust X,Y and Z and the offset to get data from */
  switch (c) {
     case 0: offset=z0+y0+x;
             break;
     case 1: offset=z0+y0+x+1;
             X++;
             break;
     case 2: offset=z0+y1+x;
             Y++;
             break;
     case 3: offset=z0+y1+x+1;
             X++; Y++;
             break;
     case 4: offset=z1+y0+x;
             Z++;
             break;
     case 5: offset=z1+y0+x+1;
             Z++; X++;
             break;
     case 6: offset=z1+y1+x;
             Z++; Y++;
             break;
     case 7: offset=z1+y1+x+1;
             Z++; Y++; X++;
             break;
     default: break;
  }

  /* get real coordinates for vertex v */
  *v= *(xp+offset);
  *(v+1)= *(yp+offset);
  *(v+2)= *(zp+offset);

  /* get real normals for normal n */
  if (X==0 || X==(dim0-1)) *n=0.0;
  else *n=(float)*(d+offset+1)-(float)*(d+offset-1);
  if (Y==0 || Y==(dim1-1)) *(n+1)=0.0;
  else *(n+1)=(float)*(d+offset+dim0)-(float)*(d+offset-dim0);
  if (Z==0 || Z==(dim2-1)) *(n+2)=0.0;
  else *(n+2)=(float)*(d+offset-dim01)-(float)*(d+offset+dim01);
  Gx= *n; Gy= *(n+1); Gz= *(n+2);
  /*
  if ((Gx= *n)<0.0) Gx=0.0-Gx;
  if ((Gy= *(n+1))<0.0) Gy=0.0-Gy;
  if ((Gz= *(n+2))<0.0) Gz=0.0-Gz;
  */
  G=Gx*Gx+Gy*Gy+Gz*Gz;
  if (G>0.0) {
     H=sqrt(G);
     *n=Gx/H;
     *(n+1)=Gy/H;
     *(n+2)=Gz/H;
  }

  /* get vertice data */
  *vd= *(d+offset);

  return(1);
}

/* interpolate data for coord */
interpolate(v1,v2,d1,d2,lev,vert)
float *v1,*v2;
unsigned char d1,d2;
float lev;
float *vert;
{
   float u;
   u=(lev-(float)d1)/((float)d2-(float)d1);
   *vert= *v1+u*(*v2-*v1);
   *(vert+1)= *(v1+1)+u*(*(v2+1)-*(v1+1));
   *(vert+2)= *(v1+2)+u*(*(v2+2)-*(v1+2));
   return(1);
}
/* get pattern code for some cube
   the eight pos for this cube is arranged as the following :


       z1+y0+x      z1+y0+x+1
       (4)X=============X(5)
         /|            /|
     (0)X=============X(1)
     z0+y0+x       z0+y0+x+1     ======>  bit 7 6 5 4 3 2 1 0
        | |           | |                 -------------------
        | |(6)        | |(7)                  0 0 1 1 0 1 0 0
        |/z1+y1+x=====|/z1+y1+x+1             LOOK UP PATTAB
     (2)X=============X(3)                          ||
     z0+y1+x       z0+y1+x+1             (int)(6 bits)(8X3 bits)
                                                 |        |
                                           pattern type   |
                                             result after rotations

*/
unsigned int getpcode(d,z0,y0,x,lev)
unsigned char *d;
int z0,y0,x;
float lev;
{
   unsigned char code=0,tcode,sum1=0;
   int z1=z0+dim01;
   int y1=y0+dim0;
   /* 7 */
   tcode=BOUND((float)(*(d+z1+y1+x+1)),lev);
   code|=tcode; code<<=1; sum1+=tcode;
   /* 6 */
   tcode=BOUND((float)(*(d+z1+y1+x)),lev);
   code|=tcode; code<<=1; sum1+=tcode;
   /* 5 */
   tcode=BOUND((float)(*(d+z1+y0+x+1)),lev);
   code|=tcode; code<<=1; sum1+=tcode;
   /* 4 */
   tcode=BOUND((float)(*(d+z1+y0+x)),lev);
   code|=tcode; code<<=1; sum1+=tcode;
   /* 3 */
   tcode=BOUND((float)(*(d+z0+y1+x+1)),lev);
   code|=tcode; code<<=1; sum1+=tcode;
   /* 2 */
   tcode=BOUND((float)(*(d+z0+y1+x)),lev);
   code|=tcode; code<<=1; sum1+=tcode;
   /* 1 */
   tcode=BOUND((float)(*(d+z0+y0+x+1)),lev);
   code|=tcode; code<<=1; sum1+=tcode;
   /* 0 */
   tcode=BOUND((float)(*(d+z0+y0+x)),lev);
   code|=tcode; sum1+=tcode;
   /* here sum1 accumulates # of 1 in code */

   /* if # of 1 greater than four then inverse it */
   if (sum1>4)
      code=~code;

   /* return code in the pattern table */
   return(pattab[code]);

}

generate_coords(coord)
float *coord;
{
  float xmin,xmax,ymin,ymax,zmin,zmax,dx,dy,dz,tempx,tempy,tempz;
  int max_dim,max_no;
  int i,j,k;
  register float *x,*y,*z;

  /* pointer to coord structure for x,y and z */
  x=coord;
  y=x+dim012;
  z=y+dim012;

  /* find the max among inf->dimensions */
  /* decide max resolution dimension for dividing part */
  max_dim=dim0;
  max_no=0;
  if (dim1>max_dim){
     max_dim=dim1;
     max_no=1;
  }
  if (dim2>max_dim){
     max_dim=dim2;
     max_no=2;
  }
  /* decide xmin,ymin,zmin,dx,dy,dz and max dimension */
  switch (max_no) {
     case 0 : xmin= -4.;
              xmax=4.;
              dx=8./(float)(max_dim);
              dy=dx;
              dz=dy;
              ymin= -0.5*dx*dim1;
              zmin= -0.5*dx*dim2;
              break;
     case 1 : ymin= -4.;
              ymax=4.;
              dx=8./(float)(max_dim);
              dy=dx;
              dz=dy;
              xmin= -0.5*dy*dim0;
              zmin= -0.5*dy*dim2;
              break;
     default: zmin= -4.;
              zmax=4.;
              dx=8./(float)(max_dim);
              dy=dx;
              dz=dy;
              xmin= -0.5*dz*dim0;
              ymin= -0.5*dz*dim1;
              break;
  }

  /* accumulate coordinate values for x, y and z */
  tempy=ymin;
  tempx=xmin;
  for (k=0;k<dim2;k++,zmin+=dz){
      ymin=tempy;
      for (j=0;j<dim1;j++,ymin+=dy){
          xmin=tempx;
          for (i=0;i<dim0;i++,xmin+=dx){
              *x++=xmin;
              *y++=ymin;
              *z++=zmin;

          }

      }
  }
  return(1);
}

/* transform h,s and v into the associated R,G,B */
/* IAC code change - static void */ hsv_to_rgb(R,G,B,h,s,v)
float *R,*G,*B;
float h,s,v;
{
   float f,p,q,t;
   float r,g,b;
   float ht;
   int i;

   /* make sure not to trash the input colormap */
   ht=h;

   if (v==0.) {
      r=0.;
      g=0.;
      b=0.;
   }
   else {
      if (s==0.)
         r=g=b=v;
      else {
         ht=ht*6.0;
         if (ht>=6.0)
            ht=0.0;
         i=ht;
         f=ht-i;
         p=v*(1.0-s);
         q=v*(1.0-s*f);
         t=v*(1.0-s*(1.0-f));
         if (i==0) {
            r=v;
            g=t;
            b=p;
         }
         else if (i==1) {
            r=q;
            g=v;
            b=p;
         }
         else if (i==2) {
            r=p;
            g=v;
            b=t;
         }
         else if (i==3) {
            r=p;
            g=q;
            b=v;
         }
         else if (i==4) {
            r=t;
            g=p;
            b=v;
         }
         else if (i==5) {
            r=v;
            g=p;
            b=q;
         }
      }
   }
   *R=r;
   *G=g;
   *B=b;
}

int init_pattab()
{
   int i;

   /* set initial pattern value */
   for (i=0;i<=PATNO-1;i++) {
       pattab[i]=01700000000;  /* only for checking empty pattern use */
   }
   /* fill special pattern values from predefined ones */
   for (i=0;i<Pattern0No;i++)
       pattab[PAT0[i].cubeindex]=PAT0[i].patcode;

   for (i=0;i<Pattern1No;i++)
       pattab[PAT1[i].cubeindex]=PAT1[i].patcode;

   for (i=0;i<Pattern2No;i++)
       pattab[PAT2[i].cubeindex]=PAT2[i].patcode;

   for (i=0;i<Pattern3No;i++)
       pattab[PAT3[i].cubeindex]=PAT3[i].patcode;

   for (i=0;i<Pattern4No;i++)
       pattab[PAT4[i].cubeindex]=PAT4[i].patcode;

   for (i=0;i<Pattern5No;i++)
       pattab[PAT5[i].cubeindex]=PAT5[i].patcode;

   for (i=0;i<Pattern6No;i++)
       pattab[PAT6[i].cubeindex]=PAT6[i].patcode;

   for (i=0;i<Pattern7No;i++)
       pattab[PAT7[i].cubeindex]=PAT7[i].patcode;

   for (i=0;i<Pattern8No;i++)
       pattab[PAT8[i].cubeindex]=PAT8[i].patcode;

   for (i=0;i<Pattern9No;i++)
       pattab[PAT9[i].cubeindex]=PAT9[i].patcode;

   for (i=0;i<Pattern10No;i++)
       pattab[PAT10[i].cubeindex]=PAT10[i].patcode;

   for (i=0;i<Pattern11No;i++)
       pattab[PAT11[i].cubeindex]=PAT11[i].patcode;

   for (i=0;i<Pattern12No;i++)
       pattab[PAT12[i].cubeindex]=PAT12[i].patcode;

   for (i=0;i<Pattern13No;i++)
       pattab[PAT13[i].cubeindex]=PAT13[i].patcode;

   for (i=0;i<Pattern14No;i++)
       pattab[PAT14[i].cubeindex]=PAT14[i].patcode;

   return(1);
}

