/* define case # of pattern from Marching Cube method
   the file must be included in a main AVS routine for fast
   cube intersections retrieval by looking up into the
   well-defined pattern table

   Date: 12/10/92

*/

/* POLYGON NUMBER */
#define PATNO 256
#define PlyNo1 1
#define PlyNo2 2
#define PlyNo3 2
#define PlyNo4 2
#define PlyNo5 3
#define PlyNo6 2
#define PlyNo7 3
#define PlyNo8 2
#define PlyNo9 4
#define PlyNo10 4
#define PlyNo11 4
#define PlyNo12 4
#define PlyNo13 4
#define PlyNo14 4

/* PATTERN TYPE NO */
#define PatternNo 15

/* PATTERN 0 -- 0's 1 */
#define Pattern0No 1                  /*         1          */

/* PATTREN 1 -- 1's 1 */
#define Pattern1No 8                  /*         8          */

/* PATTERN 2 -- 2's 1 */
#define Pattern2No 12                 /*        12          */

/* PATTERN 3 -- 2's 1 */
#define Pattern3No 12                 /*        12          */

/* PATTERN 4 -- 2's 1 */
#define Pattern4No 4                  /*         4          */

/* PATTERN 5 -- 3's 1 */
#define Pattern5No 24                 /*        24          */

/* PATTERN 6 -- 3's 1 */
#define Pattern6No 24                 /*        24          */

/* PATTERN 7 -- 3's 1 */
#define Pattern7No 8                  /*         8          */

/*--------------------------------------------93X2=186----------------------*/

/* PATTERN 8 -- 4's 1 */
#define Pattern8No 6                  /*         6          */

/* PATTERN 9 -- 4's 1 */
#define Pattern9No 8                  /*         8          */

/* PATTERN 10 -- 4's 1 */
#define Pattern10No 6                 /*         6          */

/* PATTERN 11 -- 4's 1 */
#define Pattern11No 12                /*        12          */

/* PATTERN 12 -- 4's 1 */
#define Pattern12No 24                /*        24          */

/* PATTERN 13 -- 4's 1 */
#define Pattern13No 2                 /*         2          */

/* PATTERN 14 -- 4's 1 */
#define Pattern14No 12                /*        12          */

/*-----------------------70 
/* define initial case table for Rotation operation

   entry format per word [pattern no][8 corner node indices]
                             6 bits         8x3=24 bits
   a initial pattern table with size equal to 128 must be initialized
   with initial values from the following reference pattern structures
*/
char PLYEDGES1[1][3]={
     {1,3,6}
};
char PLYEDGES2[2][3]={
     {1,2,6},
     {2,6,7}
};
char PLYEDGES3[2][3]={
     {1,3,6},
     {0,2,5}
};
char PLYEDGES4[2][3]={
     {1,3,6},
     {5,8,10}
};
char PLYEDGES5[3][3]={
     {2,6,9},
     {2,3,6},
     {2,9,10}
};
char PLYEDGES6[3][3]={
     {5,8,10},
     {1,2,6},
     {2,6,7}
};
char PLYEDGES7[3][3]={
     {0,1,4},
     {5,8,10},
     {2,3,7}
};
char PLYEDGES8[2][3]={
     {1,9,10},
     {1,2,10}
};
char PLYEDGES9[4][3]={
     {1,4,8},
     {1,3,8},
     {3,8,10},
     {3,7,10}
};
char PLYEDGES10[4][3]={
     {0,4,6},
     {0,3,6},
     {5,8,11},
     {5,7,11}
};
char PLYEDGES11[4][3]={
     {1,3,9},
     {5,8,9},
     {3,5,9},
     {3,5,7}
};
char PLYEDGES12[4][3]={
     {0,1,4},
     {2,6,9},
     {2,9,10},
     {2,3,6}
};
char PLYEDGES13[4][3]={
     {4,8,9},
     {1,3,6},
     {0,2,5},
     {7,10,11}
};
char PLYEDGES14[4][3]={
     {3,4,6},
     {3,4,10},
     {4,8,10},
     {2,3,10}
}; 
/* CROSSEDGE table defines the bit pattern which shows edge crossing */
unsigned int CROSSEDGE[PatternNo]={
         00000,
         00112,
         00306,
         00157,
         02552,
         03114,
         02746,
         02677,
         03006,
         02632,
         04771,
         01652,
         03137,
         07777,
         02534
};
char EDGETABLE[8][8]={
     -1, 0, 1,-1, 4,-1,-1,-1,
      0,-1,-1, 2,-1, 5,-1,-1,
      1,-1,-1, 3,-1,-1, 6,-1,
     -1, 2, 3,-1,-1,-1,-1, 7,
      4,-1,-1,-1,-1, 8, 9,-1,
     -1, 5,-1,-1, 8,-1,-1,10,
     -1,-1, 6,-1, 9,-1,-1,11,
     -1,-1,-1, 7,-1,10,11,-1
};
char UEDGETABLE[12][2]={
     0,1,
     0,2,
     1,3,
     2,3,
     0,4,
     1,5,
     2,6,
     3,7,
     4,5,
     4,6,
     5,7,
     6,7
};
     
         
struct PATSTRUC {
    unsigned char cubeindex;
    unsigned int patcode;
};

/* PATTERN 0 */
struct PATSTRUC PAT0[Pattern0No]={{0x0,00076543210}};

/* PATTERN 1 */
struct PATSTRUC PAT1[Pattern1No]={{0x04,00176543210},
                                  {0x01,00164752031},
                                  {0x02,00173625140},
                                  {0x08,00157461302},
                                  {0x10,00126370415},
                                  {0x20,00131207564},
                                  {0x80,00123016745},
                                  {0x40,00137152604}};

/* PATTERN 2 */
struct PATSTRUC PAT2[Pattern2No]={{0x0c,00276543210},
                                  {0x44,00237152604},
                                  {0xc0,00223016745},
                                  {0x88,00262407351},
                                  {0x05,00264752031},
                                  {0x0a,00257461302},
                                  {0xa0,00246025713},
                                  {0x50,00275316420},
                                  {0x03,00232761054},
                                  {0x22,00273625140},
                                  {0x30,00210325476},
                                  {0x11,00226370415}};

/* PATTERN 3 */
struct PATSTRUC PAT3[Pattern3No]={{0x06,00376543210},
                                  {0x09,00364752031},
                                  {0x28,00362407351},
                                  {0x82,00320643175},
                                  {0x41,00337152604},
                                  {0x14,00313570246},
                                  {0x60,00331207564},
                                  {0x90,00323016745},
                                  {0x12,00326370415},
                                  {0x21,00332761054},
                                  {0x84,00340516273},
                                  {0x48,00354107632}};

/* PATTERN 4 */
struct PATSTRUC PAT4[Pattern4No]={{0x24,00476543210},
                                  {0x18,00462407351},
                                  {0x81,00423016745},
                                  {0x42,00437152604}};

/* PATTERN 5 */
struct PATSTRUC PAT5[Pattern5No]={{0xc8,00576543210},
                                  {0x8c,00537152604},
                                  {0x4c,00523016745},
                                  {0xc4,00562407351},
                                  {0x0b,00513570246},
                                  {0x0e,00532761054},
                                  {0x0d,00520643175},
                                  {0x07,00501452367},
                                  {0x8a,00531207564},
                                  {0x2a,00515043726},
                                  {0xa2,00557461302},
                                  {0xa8,00573625140},
                                  {0x15,00502134657},
                                  {0x51,00540516273},
                                  {0x54,00564752031},
                                  {0x45,00526370415},
                                  {0x13,00504261537},
                                  {0x31,00545670123},
                                  {0x32,00551734062},
                                  {0x23,00510325476},
                                  {0xd0,00567234501},
                                  {0x70,00546025713},
                                  {0xb0,00554107632},
                                  {0xe0,00575316420}};

/* PATTERN 6 */
struct PATSTRUC PAT6[Pattern6No]={{0x2c,00676543210},
                                  {0x46,00637152604},
                                  {0xc1,00623016745},
                                  {0x98,00662407351},
                                  {0xa1,00646025713},
                                  {0x26,00604261537},
                                  {0x4a,00620643175},
                                  {0x85,00664752031},
                                  {0x43,00645670123},
                                  {0x58,00675316420},
                                  {0x38,00610325476},
                                  {0x91,00651734062},
                                  {0x1c,00601452367},
                                  {0x64,00640516273},
                                  {0xc2,00654107632},
                                  {0x89,00615043726},
                                  {0xa4,00631207564},
                                  {0x25,00613570246},
                                  {0x83,00632761054},
                                  {0x52,00602134657},
                                  {0x34,00667234501},
                                  {0x19,00626370415},
                                  {0x62,00673625140},
                                  {0x1a,00657461302}};

/* PATTERN 7 */
struct PATSTRUC PAT7[Pattern7No]={{0x29,00776543210},
                                  {0x92,00762407351},
                                  {0x86,00754107632},
                                  {0x68,00740516273},
                                  {0x94,00701452367},
                                  {0x49,00715043726},
                                  {0x61,00773625140},
                                  {0x16,00737152604}};

/* PATTERN 8 */
struct PATSTRUC PAT8[Pattern8No]={{0xcc,01076543210},
                                  {0x0f,01032761054},
                                  {0x33,01010325476},
                                  {0xf0,01054107632},
                                  {0xaa,01031207564},
                                  {0x55,01026370415}};

/* PATTERN 9 */
struct PATSTRUC PAT9[Pattern9No]={{0xd4,01176543210},
                                  {0xe8,01137152604},
                                  {0x8e,01123016745},
                                  {0x4d,01162407351},
                                  {0x71,01154107632},
                                  {0xb2,01115043726},
                                  {0x2b,01101452367},
                                  {0x17,01140516273}};

/* PATTERN 10 */
struct PATSTRUC PAT10[Pattern10No]={{0xa5,01276543210},
                                   {0x5a,01237152604},
                                   {0x66,01254107632},
                                   {0xc3,01215043726},
                                   {0x99,01201452367},
                                   {0x3c,01240516273}};

/* PATTERN 11 */
struct PATSTRUC PAT11[Pattern11No]={{0xe4,01376543210},
                                   {0xca,01337152604},
                                   {0x8d,01323016745},
                                   {0x5c,01362407351},
                                   {0x72,01354107632},
                                   {0xa3,01315043726},
                                   {0x1b,01301452367},
                                   {0x35,01340516273},
                                   {0x2e,01331207564},
                                   {0x47,01302134657},
                                   {0xd1,01346025713},
                                   {0xb8,01357461302}};

/* PATTERN 12 */
struct PATSTRUC PAT12[Pattern12No]={{0xc9,01476543210},
                                   {0x9c,01437152604},
                                   {0x6c,01423016745},
                                   {0xc6,01462407351},
                                   {0x56,01464752031},
                                   {0x65,01426370415},
                                   {0x95,01402134657},
                                   {0x59,01440516273},
                                   {0x1e,01432761054},
                                   {0x2d,01420643175},
                                   {0x87,01401452367},
                                   {0x4b,01413570246},
                                   {0xa9,01473625140},
                                   {0x9a,01431207564},
                                   {0x6a,01415043726},
                                   {0xa6,01457461302},
                                   {0xd2,01467234501},
                                   {0x78,01446025713},
                                   {0xb4,01454107632},
                                   {0xe1,01475316420},
                                   {0x39,01445670123},
                                   {0x36,01451734062},
                                   {0x63,01410325476},
                                   {0x93,01404261537}};

/* PATTERN 13 */
struct PATSTRUC PAT13[Pattern13No]={{0x96,01576543210},
                                   {0x69,01537152604}};

/* PATTERN 14 */
struct PATSTRUC PAT14[Pattern14No]={{0xd8,01676543210},
                                   {0xac,01637152604},
                                   {0x4e,01623016745},
                                   {0xc5,01662407351},
                                   {0x3a,01615043726},
                                   {0x27,01601452367},
                                   {0x53,01640516273},
                                   {0xb1,01654107632},
                                   {0x8b,01613570246},
                                   {0xe2,01675316420},
                                   {0x1d,01602134657},
                                   {0x74,01646025713}};

