/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <strings.h>
#include <avs/flow.h>
#include <avs/avs_data.h>
#include <avs/field.h>
#include <avs/avs.h>
#include <avs/geom.h>
#include <avs/udata.h>


AVSinit_modules()
{
        int graphit();
  
        AVSmodule_from_desc(graphit);
}

/*  
 * The routine "combine" is the description routine.  It provides
 * AVS some necessary information such as: name, input and output ports, 
 * parameters etc. 
 */
graphit()
{
	int graph_init();
	int graph_compute();
	int graph_destroy();
	int p;

	/* Set the module name and type */
	AVSset_module_name("GraphSound", MODULE_MAPPER);

	/* required input port */
	AVScreate_input_port("field","field uniform float", REQUIRED);

	/* optional input ports */
	AVScreate_input_port("Frame","integer", OPTIONAL|INVISIBLE);
	p = AVScreate_input_port("Pick Info","struct upstream_geom",
			     OPTIONAL|INVISIBLE);
	AVSset_input_class(p,"upstream_geom");

	/* Create output ports for the results */
	p = AVScreate_output_port("Geometry", "geom");
	AVScreate_output_port("Frame Picked","integer",INVISIBLE);

	/* parameters */
	p = AVSadd_parameter("normalize graph","boolean",0,NULL,NULL);
	AVSadd_parameter_prop(p,"width","integer",4); 
	AVSconnect_widget(p,"toggle");

	p = AVSadd_float_parameter("horiz position","real",0.0,
				FLOAT_UNBOUND,FLOAT_UNBOUND);
	AVSconnect_widget(p,"dial");
	p = AVSadd_float_parameter("vert position","real",0.0,
				FLOAT_UNBOUND,FLOAT_UNBOUND);
	AVSconnect_widget(p,"dial");

	p = AVSadd_float_parameter("horiz mag","real",1.0,
				FLOAT_UNBOUND,FLOAT_UNBOUND);
	AVSconnect_widget(p,"dial");
	p = AVSadd_float_parameter("vertical mag","real",1.0,
				FLOAT_UNBOUND,FLOAT_UNBOUND);
	AVSconnect_widget(p,"dial");
	p = AVSadd_float_parameter("size","real",1.0,
				FLOAT_UNBOUND,FLOAT_UNBOUND);
	AVSconnect_widget(p,"dial");

	p = AVSadd_parameter("picking enabled","boolean",0,NULL,NULL);
	AVSadd_parameter_prop(p,"width","integer",4);

	AVSset_init_proc(graph_init);
	AVSset_compute_proc(graph_compute);
	AVSset_destroy_proc(graph_destroy);
}

/*
 * combine_compute is the compute routine.  It is called whenever AVS 
 * is given a new filename for us to compute.  The arguments are: the 
 * output geometry (passed by reference), and the filename parameter.  
 * Note that the order is always inputs, outputs, parameters.
 */

#define I1D(field, i) (((field)->data)[i])

#define XSIZE 10.0  /* horizontal size of the graph */
#define YSIZE 0.5   /* a half of the vertical size of the graph */

/* declare globals */
float *Vertices = NULL;
float *Xaxis = NULL;
int *Vertdata = NULL;

graph_compute(field, frame, pickinfo, output, outframe,
	      norm, xmove, ymove, xmagnif, ymagnif, size, pickon)
AVSfield_float *field;
int frame;
upstream_geom *pickinfo;
GEOMedit_list *output;
int *outframe;
int norm,pickon;
float *size,*xmagnif,*ymagnif,*xmove,*ymove;
{
   GEOMobj *obj;

   int i,j, k;
   float xpos;
   float Maxz;
   float Minz;
   float tempval;

   float Framemark[6];

   char graphname[32];

   int dim[1];
   float color[3];
   static int vchanged = 1;
   static int numframes = 2;

   static int channels = 1;
   static int channelswas = 0;

   static float mini;
   static float maxi;

   /* see if we have picked a frame number from the graph */
   if (AVSinput_changed("Pick Info",0)) {
     if (pickinfo) {
       if (pickinfo->vdata > 0) {
	 *outframe = pickinfo->vdata;
	 return(1);
       }
     }
   }

   /* unless we picked something, we need no output from that port */
   AVSmark_output_unchanged("Frame Picked");

   /* there will be a change of geometry output, so initialize it */
   *output = GEOMinit_edit_list(*output);

   /* turn picking on and off */
   if (AVSparameter_changed("picking enabled")) {
     if (pickon) {
       GEOMedit_selection_mode(*output,"X-axis","notify",
			       BUTTON_DOWN|BUTTON_MOVING);
       GEOMedit_selection_mode(*output,"Graph","notify",
			       BUTTON_DOWN|BUTTON_MOVING);
       GEOMedit_selection_mode(*output,"%top","ignore");
       GEOMedit_selection_mode(*output,"FrameMark","ignore");
     }
     else {
       GEOMedit_selection_mode(*output,"%top","normal",
			       BUTTON_DOWN|BUTTON_MOVING);
       GEOMedit_selection_mode(*output,"Graph","normal",
			       BUTTON_DOWN|BUTTON_MOVING);
       GEOMedit_selection_mode(*output,"FrameMark","normal",
			       BUTTON_DOWN|BUTTON_MOVING);
       GEOMedit_selection_mode(*output,"X-axis","normal",
			       BUTTON_DOWN|BUTTON_MOVING);
     }
     return(1);
   }

   /* see if animation window has changed */
   else if (AVSinput_changed("field",0)) {
     channels = AVSfield_get_int(field, AVS_FIELD_NDIM);

     if (channels == 1) {
	numframes = MAXX(field);
	if (channelswas == 2) GEOMedit_visibility(*output, "Graph1", -1);
	channelswas = 1;
     }
     else if (channels == 2) {
	numframes = MAXY(field);
	channelswas = 2;
     }

     /* calculate mini and maxi */
     maxi = -1000000.0;   /* real small number */
     mini = 1000000.0;    /* real big number */
     if (channels > 1) {
       for (j=0; j<numframes; j++) {
         for (i=0; i<channels; i++) {
           tempval = I2D(field,i,j);
           if (maxi < tempval) maxi = tempval;
           if (mini > tempval) mini = tempval;
         }       
       }
     }
     else {
       for (j=0; j<numframes; j++) {
           tempval = I1D(field,j);
           if (maxi < tempval) maxi = tempval;
           if (mini > tempval) mini = tempval;
       }	 
     }

     vchanged = 1;
   }

   /* update the frame marker if necessary */
   else if (AVSinput_changed("Frame",0)) {
     xpos = -(XSIZE/2.0) + ((frame-1) * (XSIZE / (numframes-1)));
     xpos = *xmove + ( *xmagnif * *size * xpos );
     Framemark[0] = xpos;
     Framemark[1] = *ymove + ( *ymagnif * *size * YSIZE);
     Framemark[2] = 0.0;
     Framemark[3] = xpos;
     Framemark[4] = *ymove + ( *ymagnif * *size * -YSIZE);
     Framemark[5] = 0.0;
     color[0] = 1.0;
     color[1] = 0.0;
     color[2] = 0.0;

     /* output the frame marker */
     obj = GEOMcreate_obj(GEOM_POLYTRI,NULL);
     GEOMadd_disjoint_line(obj,Framemark,NULL,2,GEOM_COPY_DATA);
     GEOMedit_geometry(*output,"FrameMark",obj);
     GEOMdestroy_obj(obj); 
     GEOMedit_color(*output, "FrameMark", color);

     /* if the vertex movement info hasn't changed, don't redraw the graph */
     if (!vchanged) return(1);
     vchanged = 0;
   }
   
   /* if we got this far, we should produce a new graph */
   
   /* calculate the minimums and maximums for the fields */

   if (norm) {
       Minz = mini;
       Maxz = maxi;
       if (Maxz < -Minz) Maxz = -Minz;
   }

    /* reallocate memory for arrays */
    Vertices = (float *) realloc (Vertices,numframes*3*sizeof(float));
    if (pickon) {
	Xaxis = (float *) realloc (Xaxis,numframes*3*sizeof(float));
	Vertdata = (int *) realloc (Vertdata,numframes*sizeof(float));
    }
    else {
	Xaxis = (float *) realloc (Xaxis,6*sizeof(float));
    }

    for (k=0; k<channels; k++) {
	if (!norm) {
	    /* calculate Minz and Maxz based on the current channel */

	    if (channels > 2) {
		Maxz = -1000000.0;   /* real small number */
		Minz = 1000000.0;    /* real big number */
		for (j=0; j<numframes; j++) {
		    tempval = I2D(field, k, j);
		    if (Maxz < tempval) Maxz = tempval;
		    if (Minz > tempval) Minz = tempval;
		}
	    }
	    else {
		Minz = mini;
		Maxz = maxi;
	    }	 
	    if (Maxz < -Minz) Maxz = -Minz;
	}

	if (Maxz == 0.0) return(0);
	
	/* fill Vertices and Colors lists from field information */
	if (channels > 1) {
	    for (j=0, i=0, xpos = -(XSIZE/2.0); j<numframes; j++, i+=3, xpos+=(XSIZE/numframes)) {
		Vertices[i] = *xmove + ( *xmagnif * *size * xpos );
     		Vertices[i+1] = *ymove + ( *ymagnif * *size * YSIZE * (I2D(field,k,j)/Maxz) );
		Vertices[i+2] = 0.0;
	    }
	}
	else {
	    for (j=0, i=0, xpos = -(XSIZE/2.0); j<numframes; j++, i+=3, xpos+=(XSIZE/numframes)) {
		Vertices[i] = *xmove + ( *xmagnif * *size * xpos );
     		Vertices[i+1] = *ymove + ( *ymagnif * *size * YSIZE * (I1D(field,j)/Maxz) );
		Vertices[i+2] = 0.0;
	    }
	}
	    	    
	if (k == 0) {
	    color[0] = 0.0;
	    color[1] = 0.0;
     	    color[2] = 1.0;
	}
	else {
	    color[0] = 1.0;
	    color[1] = 0.0;
     	    color[2] = 1.0;	    
	}

	/* output the graph */
	obj = GEOMcreate_obj(GEOM_POLYTRI,NULL);
	GEOMadd_polyline(obj,Vertices,NULL, /*Colors,*/ numframes,GEOM_COPY_DATA);
	if (pickon)
	    GEOMadd_polyline_vertex_data(obj,Vertdata,0,numframes,GEOM_COPY_DATA);
	sprintf(graphname, "Graph%d\0", k);
	GEOMedit_geometry(*output,graphname,obj);
	GEOMdestroy_obj(obj); 
	GEOMedit_color(*output, graphname, color);
    }

    /* fill Xaxis, Xasixcol, and Vertdata arrays */
    if (pickon) {
	for (j=0, i=0, xpos = -(XSIZE/2.0); j<numframes; j++, i+=3, xpos+=(XSIZE/numframes)) {
	    Vertdata[j] = j+1;

	    Xaxis[i] = *xmove + ( *xmagnif * *size * xpos );
	    Xaxis[i+1] = 0.0;
	    Xaxis[i+2] = 0.0;
	}
    }
    else {
	Xaxis[0] = -(XSIZE/2.0);
	Xaxis[1] = 0;
	Xaxis[2] = 0;
	Xaxis[3] = XSIZE/2.0;
	Xaxis[4] = 0;
	Xaxis[5] = 0;
    }

    color[0] = 1.0;
    color[1] = 0.0;
    color[2] = 0.0;

    /* output the X axis */
    obj = GEOMcreate_obj(GEOM_POLYTRI,NULL);
    if (pickon) {
        GEOMadd_polyline(obj,Xaxis,NULL,numframes,GEOM_COPY_DATA);
	GEOMadd_polyline_vertex_data(obj,Vertdata,0,numframes,GEOM_COPY_DATA);
    }
    else
        GEOMadd_polyline(obj,Xaxis,NULL,2,GEOM_COPY_DATA);
    GEOMedit_geometry(*output,"X-axis",obj);
    GEOMdestroy_obj(obj); 
    GEOMedit_color(*output, "X-axis", color);

    return(1);
}


graph_init()
{
  Vertices = (float *) malloc(sizeof(float));
  Xaxis = (float *) malloc(sizeof(float));
  Vertdata = (int *) malloc(sizeof(float));
}

graph_destroy()
{

/* IAC CODE CHANGE :   free(Vertices); */
   free(Vertices);

/* IAC CODE CHANGE :   free(Xaxis); */
   free(Xaxis);

/* IAC CODE CHANGE :   free(Vertdata); */
   free(Vertdata);
}
