/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#ifdef SCCS
static char sccsid[]="@(#)field2mesh.c	7.1 Stardent 91/09/10";
#endif
/*
			Copyright (c) 1989 by
			Stardent Computer Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Stardent Computer Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under sccs control at Stardent in:
	@europa/sccs1.p/avs/modules/mappers/s.field2mesh.c
	
*/

/* 
 * AVS primitive mapper module wrappers.
 */


#include <stdio.h>

#include <avs/port.h>
#include <avs/flow.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/geomdata.h>
#include <avs/colormap.h>


/**********************************************************************/

MODgrid_to_mesh()
{
    int grid_to_mesh_compute();
    int param;
    
    AVSset_module_name("Grid 2 TxtMesh", MODULE_MAPPER);
    AVSset_module_flags( COOPERATIVE | REENTRANT );
    AVScreate_input_port("Field Input","field 2D scalar float", 
			 REQUIRED | MODIFY_IN);
    AVScreate_input_port("image","field 2D 4-vector byte", 
			 OPTIONAL );
    AVScreate_input_port("Input Colormap", "colormap", OPTIONAL);
    
    AVScreate_output_port("geometry", "geom");
    AVSadd_float_parameter("Z scale", 1.0, 0.0, 100.0);
#ifdef NORMALIZE
    AVSadd_parameter("Normalize", "boolean", 0, 0, 1);
#endif
    param = AVSadd_parameter("GenNormals", "boolean", 0, 0, 1);
    AVSconnect_widget(param, "toggle");
    param = AVSadd_parameter("GenWireframe", "boolean", 0, 0, 1);
    AVSconnect_widget(param, "toggle");

    /* UV choices */
    param = AVSadd_parameter("UV", "choice", "0011", 
                              "0011:1100:0101:1010:0110:1001", ":");
    AVSconnect_widget(param, "radio_buttons");

    /* Starting Point in X */
    param = AVSadd_float_parameter("StartX", 0.00000, 0.00000, 2000000.);
    AVSconnect_widget(param, "typein_real");
    /* Starting Point in Y */
    param = AVSadd_float_parameter("StartY", 0.00000, 0.00000, 2000000.);
    AVSconnect_widget(param, "typein_real");
    /* Grid Step Size */
    param = AVSadd_parameter("GridStepSize", "integer", 1, 0, 100);
    AVSconnect_widget(param, "typein_integer");
    /* Downsize Value */
    param = AVSadd_parameter("Downsize", "integer", 1, 1, 16);
    AVSconnect_widget(param, "typein_integer");

    AVSset_compute_proc(grid_to_mesh_compute);
}

int
  grid_to_mesh_compute(input,image, colormap, output, zscale,GenNormals,
                        GenWireframe,UVstr, StartX, StartY, 
                        GridStepSize,Downsize)
   AVSfield *input;
   AVSfield *image;
   AVScolormap *colormap;
   GEOMedit_list *output;
   float *zscale;
   int GenNormals;
   int GenWireframe;
   char *UVstr;
   float *StartX;
   float *StartY;
   int GridStepSize;
   int Downsize;
{
    GEOMobj *obj;
    float   *fmesh, min, max;
    unsigned int color_lut[BYTE_TABLE], *colors;
    int size, i, j, index;
    int  axis;
    float   extent[6], min_extent[3], max_extent[3];
    float	tx, ty, tz;
    int points_ndim = input->ndim;
    int MinX, MaxX, MinY, MaxY;
    float X,Y, DeltaX, DeltaY;
    
#ifdef NORMALIZE
    /* normalize the data if necessary */
    if (normalize) 
      AVSfield_normalize(input);
#endif
    
    if (!AVSfield_get_extent (input, min_extent, max_extent)) {
	for (i = 0; i < 3; i++) {
	    min_extent[i] = 0.0;
	    max_extent[i] = 1.0;
	}  /* end for */
    }  /* end if */
    else {
	min_extent[2] = 0.0;
	if (input->points != NULL)
	  max_extent[2] = input->points[2];
	else
	  max_extent[2] = 1.0;
    }  /* end else */
    
    /* find the extent of the bounding hull */
    for (i = 0; i < 3; i++) {
	extent[i*2]   = min_extent[i];
	extent[i*2+1] = max_extent[i];
    }  /* end for */
    
   fprintf(stderr,"Field2TxtMesh: Extents: \n");
   fprintf(stderr,"               %f %f \n",extent[0],extent[1]);
   fprintf(stderr,"               %f %f \n",extent[2],extent[3]);
   fprintf(stderr,"               %f %f \n",extent[4],extent[5]);
    
   /* Works only for 2-D fields */
   MinX = input->points[0];
   MaxX = input->points[1];
   MinY = input->points[2];
   MaxY = input->points[3];
   fprintf(stderr,"Field2TxtMesh: MinX = %d MaxX = %d\n",MinX,MaxX);
   fprintf(stderr,"Field2TxtMesh: MinY = %d MaxY = %d\n",MinY,MaxY);

   /* Compute DeltaX */
   /* DeltaX = (float)(MaxX - MinX)/MAXX(input); */
   /* DeltaY = (float)(MaxY - MinY)/MAXY(input); */
   DeltaX = DeltaY = GridStepSize*Downsize;
   fprintf(stderr,"Field2TxtMesh: DeltaX = %f \n",DeltaX);
   fprintf(stderr,"Field2TxtMesh: DeltaY = %f \n",DeltaY);


    /* size = MAXX(input) * MAXY(input); */
    size = (MAXX(input)+1) * (MAXY(input)+1);
    
    if (colormap) {
	colors = (unsigned int *) ALLOC_LOCAL (size * sizeof(unsigned int));
	for (i=0; i<colormap->size; i++) 
	  PIXELhsva_to_pixel (&color_lut[i], colormap->hue[i], 
			      colormap->saturation[i],
			      colormap->value[i], colormap->alpha[i]);
    }  /* end if */
    
    if (input->uniform == UNIFORM) {
	fmesh = (float *) ALLOC_LOCAL (3 * size * sizeof(float));
	if (input->points[0] == input->points[1])
	  axis = 0;
	else if (input->points[2] == input->points[3])
	  axis = 1;
	else if (input->points[4] == input->points[5])
	  axis = 2;
        fprintf(stderr,"Field2TxtMesh: Using Axis: %d ...\n",axis);
        fprintf(stderr,"Field2TxtMesh: Max X: %d ...\n",MAXX(input));
        fprintf(stderr,"Field2TxtMesh: Max Y: %d ...\n",MAXY(input));

        Y = *StartY;
	for (i=0; i<MAXY(input)+1; i++) {
           X = *StartX;
	   for (j=0; j<MAXX(input)+1; j++) {
              fmesh[(i*MAXX(input)+j)*3+0] = X;
              fmesh[(i*MAXX(input)+j)*3+1] = Y;
	      fmesh[(i*MAXX(input)+j)*3+2] = *zscale *
                    ((float)(input->field_data_float[i*MAXX(input)+j]));
	      axis = 2;
              X = X + DeltaX;   
	   }  /* end for j */

            fprintf(stderr,"Field2TxtMesh: i = %d x = %f y = %f z = %f\n",
               i, fmesh[(i*MAXX(input)+0)*3+0], 
               fmesh[(i*MAXX(input)+0)*3+1],fmesh[(i*MAXX(input)+0)*3+2]);
              Y = Y + DeltaY;   

	}  /* end for i */
    }  else {
       AVSwarning("Field2TxtMesh: Warning: Field not Uniform\n");   
       fprintf(stderr,"Field2TxtMesh: Warning: Field not Uniform\n");   
    } /* end if */
    
      min = max = input->field_data_float[0];
      for (i=0; i<size; i++) {
         min = (input->field_data_float[i] < min ) ? input->field_data_float[i] : min;
         max = (input->field_data_float[i] > max ) ? input->field_data_float[i] : max;
      }

#ifdef Scott
      if (input->uniform != IRREGULAR && input->uniform != RECTILINEAR) {
         if (max == min) {
            fprintf(stderr,"Setting in #1 \n");
	    for (i=0; i<MAXY(input); i++) 
               for (j=0; j<MAXX(input); j++) 
		  fmesh[(i*MAXX(input)+j)*3+axis] += *zscale;
	  } else {
             fprintf(stderr,"Setting in #2 \n");
             for (i=0; i<MAXY(input); i++) 
		  for (j=0; j<MAXX(input); j++) 
		    fmesh[(i*MAXX(input)+j)*3+axis] += *zscale *
		      ((float)(input->field_data_float[i*MAXX(input)+j]));
/*
		    fmesh[(i*MAXX(input)+j)*3+axis] += *zscale *
		      ((float)(input->field_data_float[i*MAXX(input)+j]) - min) / (max-min);
*/
	    }
	} 
#endif

	if (colormap)  {
	    if (max == min) {
		for (i=0; i<MAXY(input); i++) 
		  for (j=0; j<MAXX(input); j++) 
		    colors[i*MAXX(input)+j] = color_lut[0];
	    } else {
		for (i=0; i<MAXY(input); i++) {
		    for (j=0; j<MAXX(input); j++) {
			index = PIXELget_index(colormap, 
			        input->field_data_float[i*MAXX(input)+j]);
			colors[i*MAXX(input)+j] = color_lut[index];
		    }
		}
	    }
	}
	
    
/*
    obj = GEOMcreate_mesh_with_data(extent, fmesh, NULL, NULL, MAXX(input),
	 			    MAXY(input), GEOM_COPY_DATA); 
*/

    obj = GEOMcreate_mesh_with_data(NULL, fmesh, NULL, NULL, MAXX(input),
	 			    MAXY(input), GEOM_COPY_DATA); 

    /* SET the UV's */
    if (!strcmp(UVstr,"0011")) {
       fprintf(stderr,"Field2TxtMesh: Setting UV's: 0,0 1,1 ...\n");
       GEOMcreate_mesh_uvs(obj,0.0,0.0,1.0,1.0);
    }
    else if (!strcmp(UVstr,"1100")) {
       fprintf(stderr,"Field2TxtMesh: Setting UV's: 1,1 0,0 ...\n");
       GEOMcreate_mesh_uvs(obj,1.0,1.0,0.0,0.0);
    }
    else if (!strcmp(UVstr,"0101")) {
       fprintf(stderr,"Field2TxtMesh: Setting UV's: 0,1 0,1 ...\n");
       GEOMcreate_mesh_uvs(obj,0.0,1.0,0.0,1.0);
    }
    else if (!strcmp(UVstr,"1010")) {
       fprintf(stderr,"Field2TxtMesh: Setting UV's: 1,0 1,0 ...\n");
       GEOMcreate_mesh_uvs(obj,1.0,0.0,1.0,0.0);
    }
    else if (!strcmp(UVstr,"0110")) {
       fprintf(stderr,"Field2TxtMesh: Setting UV's: 0,1 1,0 ...\n");
       GEOMcreate_mesh_uvs(obj,0.0,1.0,1.0,0.0);
    }
    else if (!strcmp(UVstr,"1001")) {
       fprintf(stderr,"Field2TxtMesh: Setting UV's: 1,0 0,1 ...\n");
       GEOMcreate_mesh_uvs(obj,1.0,0.0,0.0,1.0);
    }
    else {
       fprintf(stderr,"Field2TxtMesh: Error in selecting UV string ...\n");
    }

    if (colormap) 
      GEOMadd_int_colors(obj, colors, size, GEOM_COPY_DATA);
     
    if (GenNormals) {
       fprintf(stderr,"Field2TxtMesh: Generating Normals ...\n");
       GEOMgen_normals(obj, 0); 
    }

    if (GenWireframe) {
       fprintf(stderr,"Field2TxtMesh: Generating Wireframe ...\n");
       GEOMcvt_mesh_to_polytri(obj, GEOM_SURFACE | GEOM_WIREFRAME); 
    } else {
       fprintf(stderr,"Field2TxtMesh: NOT Generating Wireframe ...\n");
       GEOMcvt_mesh_to_polytri(obj, GEOM_SURFACE); 
    }
    
   /* GEOMset_computed_extent (obj, extent); */

    if (input->uniform == UNIFORM) {
	if ( input->nspace == 3 ) 
	  ;
#ifdef AUTO_TRANSFORM
	GEOMset_computed_extent (obj, extent);
#endif
	else if (GenNormals) {
           fprintf(stderr,"Field2TxtMesh: Fliping Normals ...\n");
/*            GEOMflip_normals(obj);  */
        }
  
#ifdef AUTO_TRANSFORM
	GEOMauto_transform (obj);
#endif
    }  /* end if */
    
    *output = GEOMinit_edit_list(*output);
    GEOMedit_geometry(*output,"field mesh",obj);
    /* GEOMedit_transform_mode(*output, "field mesh", "parent",0); */
    if (image) {
       fprintf(stderr,"Field2TxtMesh: Adding image texture\n\n\n");
       GEOMedit_field_texture(*output,"field mesh",image);
    }
    GEOMdestroy_obj(obj);
    
    FREE_LOCAL(fmesh);
    if (colormap) 
      FREE_LOCAL(colors);
    
    return(1);
}

/*
 * initialization for modules contained in this file.
 */

int ((*mapper_mod_list[])()) = {
    MODgrid_to_mesh,
};

#define NMODS sizeof(mapper_mod_list) / sizeof(char *) 

AVSinit_modules ()
{
    AVSinit_from_module_list(mapper_mod_list, NMODS);
}
