/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <math.h>
#include <stdio.h>
#include "vector.h"

#define XY 0
#define XZ 1
#define YZ 2
#define SMALL_NUMBER	1.e-8

mat_decode(mat, trans, scale, qrot)
    float mat[4][4];
    double trans[3];
    double scale[3];
    double qrot[4];
{
  register int i,j;
  Matrix4 locmat;
  Matrix4 pmat,invpmat;
  Vector4 prhs,psol;
  Point3 row[3];

  double persp[4];
  double shear[3];
  double rot[3];
  double rotmat[3][3];
  
  /*
   * This code is modified from Graphics Gems code
   */

  for (i=0; i<4; i++)
    for (j=0; j<4; j++) locmat.element[i][j] = mat[i][j];  

  /* Normalize the matrix */
  if (fabs(locmat.element[3][3]) > SMALL_NUMBER)
    for (i=0; i<4; i++)
      for (j=0; j<4; j++)
	locmat.element[i][j] /= locmat.element[3][3];
  

    for (i=0; i<4; i++)
      for (j=0; j<4; j++)
      {
	pmat.element[i][j] = locmat.element[i][j];  
      }

  for (i=0; i<3; i++) 
    pmat.element[i][3] = 0.0;
  
  pmat.element[3][3] = 1.0;
 

  /* check for singularity in the upper 3x3 component */
  if (fabs(det4x4(&pmat)) < SMALL_NUMBER) {
    fprintf(stderr,"unmatrix:  Matrix is singular!\n");
    return(-1);
  }

  /* isolate perspective */
  if (fabs(locmat.element[0][3]) > SMALL_NUMBER || 
      fabs(locmat.element[1][3]) > SMALL_NUMBER ||
      fabs(locmat.element[2][3]) > SMALL_NUMBER) {
    /* prhs is the righthand side of the equation */
    prhs.x = locmat.element[0][3];
    prhs.y = locmat.element[1][3];
    prhs.z = locmat.element[2][3];
    prhs.w = locmat.element[3][3];
    /* solve the equation by inverting pmat and multiplying prhs by the inverse 
     * this is the crapiest way not necessarily the cleanest 
     */
    if (inverse(&pmat,&invpmat) < 0) {
      fprintf(stderr,"unmatrix:  Matrix is singular!\n");
      return(-1);
    }
    psol = *V4MulPointByMatrix(&prhs,&invpmat);

    persp[0] = psol.x;
    persp[1] = psol.y;
    persp[2] = psol.z;
    persp[3] = psol.w;
    /* clear the perspective partition */
    locmat.element[0][3] = locmat.element[1][3] = locmat.element[2][3] = 0.0;
    locmat.element[3][3] = 1.0;
  }
  else {
    /* there is no perspective */
    persp[0] = persp[1] = persp[2] = persp[3] = 0.0;
  }

  /* translation */
  for (i=0; i<3; i++) {
    trans[i] = locmat.element[3][i];
    locmat.element[3][i] = 0.0;
  }

  /* Scale and shear */
  for (i=0; i<3; i++) {
    row[i].x = locmat.element[i][0];
    row[i].y = locmat.element[i][1];
    row[i].z = locmat.element[i][2];
  }

  scale[0] = V3Length(&row[0]);
  (void) V3Normalize(&row[0]);

  shear[XY] = V3Dot(&row[0],&row[1]);
  (void) V3Combine(&row[1],&row[0],&row[1],1.0,-shear[XY]);

  scale[1] = V3Length(&row[1]);
  (void) V3Normalize(&row[1]);
  shear[XY] /= scale[1];

  shear[XZ] = V3Dot(&row[0],&row[2]);
  (void) V3Combine(&row[2],&row[0],&row[2],1.0,-shear[XZ]);
  shear[YZ] = V3Dot(&row[1],&row[2]);
  (void) V3Combine(&row[2],&row[1],&row[2],1.0,-shear[YZ]);
  
  scale[2] = V3Length(&row[2]);
  (void) V3Normalize(&row[2]);
  shear[XZ] /= scale[2];
  shear[YZ] /= scale[2];

  if (V3Dot(&row[0],V3Cross(&row[1],&row[2])) < -SMALL_NUMBER) {
    for (i=0;i<3;i++) {
      scale[i] *= -1.0;
      row[i].x *= -1.0;
      row[i].y *= -1.0;
      row[i].z *= -1.0;
    }
  }

  for (i=0;i<3;i++) {
     rotmat[0][i] = row[i].x;
     rotmat[1][i] = row[i].y;
     rotmat[2][i] = row[i].z;
  }

  mattoquat(qrot, rotmat);
  
  /* Rotations */
/*
  rot[1] = (float) asin(-row[0].z);
  if (fabs(cos(rot[1])) > SMALL_NUMBER) {
    rot[0] = atan2(row[1].z, row[2].z);
    rot[2] = atan2(row[0].y, row[0].x);
  }
  else {
    rot[0] = atan2(row[1].x, row[1].y);
    rot[2] = 0.0;
  }

  quat_rotate(qrot, rot);
*/
  
  return(0);
}

HSVtoRGB(H,S,V,R,G,B)
/**************************************************************/
/* Convert Hue-Saturation-Value to Red-Green-Blue             */
/* All values range from 0 to 1                               */
/**************************************************************/
     float H,S,V;
     float *R, *G, *B;
{
  float p1, p2, p3;
  int i;
  float f;

  H = H * 360;
  if (H == 360) H = 0;
  H = H / 60;
  i = H;
  f = H - i;
  p1 = V * (1 - S);
  p2 = V * (1 - (S * f));
  p3 = V * (1 - (S * (1 - f)));
  if (i == 0) { *R = V; *G = p3; *B = p1; }
  else if (i == 1) { *R = p2; *G = V; *B = p1; }
  else if (i == 2) { *R = p1; *G = V; *B = p3; }
  else if (i == 3) { *R = p1; *G = p2; *B = V; }
  else if (i == 4) { *R = p3; *G = p1; *B = V; }
  else { *R = V; *G = p1; *B = p2; }
}    
