/* 
 * KEYFRAME ANIMATOR:
 * perform keyframe animation and interpolation of objects in a network.
 * rotation and interpolation of rotation can be either standard X-Y-Z matrix
 * rotation, or quaternion rotation.
 *
 * created by Brian Kaplan
 *      kaplan@cica.indiana.edu
 *      Center for Innovative Computer Applications (CICA)
 *      Indiana University
 *
 * thanks to the following for their help:
 *      Gregory Travis, Eric Ost -- general C help.
 *      Andrew Hanson -- help with interpolation code.
 *
 * Copyright (c) 1991 Brian Kaplan, CICA, Indiana University
 * All rights reserved.
 *
 * This material was developed at the Center for Innovative Computer
 * Applications (CICA), Indiana University.  Permission to copy this
 * software or any portion of it, to redistribute it, and to use it for
 * any purpose and without fee is granted, subject to the following
 * restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright notice
 * in full.  Any materials containing this software or any part of this
 * software must include this copyright notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the Center for Innovative Computer Applications any improvements
 * or extensions that they make, so that these may be included in future
 * releases; and (b) to inform Indiana University of noteworthy uses of this
 * software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the usual
 * standards of acknowledging credit in academic research.
 *
 * 4. Indiana University has made no warrantee or representation that the
 * operation of this software will be error-free, and Indiana University
 * is under no obligation to provide any services, by way of maintenance,
 * update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this material,
 * there shall be no use of the name of Indiana University or the Center
 * for Innovative Computer Applications nor of any adaptation thereof in
 * any advertising, promotional, or sales literature without prior written
 * consent from Indiana University in each case.
 *
 */

/***********
 * DEFINES *
 ***********/

#define VERSION "V2.40"                                /* the version number */
#define rad(x) ((x)*M_PI/180.0)                /* convert degrees to radians */
#define MAXNAMELENGTH 24         /* maximum number of characters in a string */

/* define the names of the transformation channels */
#define XROT 0                                          /* normal X rotation */
#define YROT 1                                          /* normal Y rotation */
#define ZROT 2                                          /* normal Z rotation */
#define XTRN 3                                              /* X translation */
#define YTRN 4                                              /* Y translation */
#define ZTRN 5                                              /* Z translation */
#define SIZE 6                                        /* size, (X,Y,Z scale) */
#define QTRC 7                                    /* the quaternion channels */
#define QTRX 8
#define QTRY 9
#define QTRZ 10

/* special channels (NOT IMPLIMENTED) */
#define MODE 11                                  /* the object's render mode */
#define COL1 12                                                    /* R or H */
#define COL2 13                                                    /* G or S */
#define COL3 14                                                    /* B or V */
#define TRANSP 15                                   /* object's transparency */

#define NUMCHANNELS 11                  /* the number of above channels used */
#define NUMFRAMES 150              /* default number of frames for animation */
#define NUMOBJS 1                 /* default number of objects for animation */

/**************************
 * STRUCTURES AND GLOBALS *
 **************************/

/* global structures to hold the animation information */
struct Objinfo {      /* object info that remains constant for the animation */
  char name[MAXNAMELENGTH];                             /* the object's name */
  char parent[MAXNAMELENGTH];                  /* the object's parent object */
  char rotation[MAXNAMELENGTH];      /* type of rotation: quaternion, matrix */
  /* colortype is NOT USED currently */
  char colortype[MAXNAMELENGTH];                  /* color system:  RGB, HSV */
};
struct Frameinfo {                   /* information which is frame-dependant */
  int keyframe;                                  /* is this frame a keyframe */
  /* background color NOT IMPLIMENTED
  float background[3];
  */
};

extern struct Objinfo *Objlist;
extern struct Frameinfo *Framelist;
extern float ***Anim;
extern int Totobjs;
extern int Totframes;
extern int Totchannels;

