/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 * Make ROI from point list, fill the enclosing area
 *
 * taken from sketch roi, adapted for marker shapes,
 * and edge mode.
 *
 * Adapted by: Ian Curington
 * Revision:
 *    8 Feb 94
 *   27 May 94
 */

/*
                  Copyright (c) 1992, 1993, 1994 by
                  Advanced Visual Systems Inc.
                  All Rights Reserved

      This software comprises unpublished confidential information of
      Advanced Visual Systems Inc. and may not be used, copied or made
      available to anyone, except in accordance with the license
      under which it is furnished.

*/

#include <stdio.h>

#define PBX(i) ((pb[(i)]) * size + x)
#define PBY(i) ((pb[(i)]) * size + y)

/****
#define DEBUG_ROI 1
 ****/

/*
 * supports both single byte or ARGB image fills
 *   #define ARGB_MODE 1
 */


/*************************************
 *  make roi from points 
 *************************************/

int make_roi_from_points(pb,          /* shape verts list, n x 2 */
			 roi_data,    /* output char 2d buffer */
			 dims,        /* size of output array  */
			 fill_value,  /* value to fill with    */
			 pverts,      /* number of verts in shape */
			 edge_mode,   /* fill or edge only mode */
                         x,           /* offset position */
                         y,           /* offset position */
                         size )       /* marker scale size */



        int         *pb;
        char        *roi_data;
        int         *dims;
#ifdef ARGB_MODE
        int         fill_value;
#else
        char        fill_value;
#endif
	int         pverts;
        int         x;
        int         y;
        int         size;
{
  int   i, j, k, scan, ymin, ymax, nxings;
  int   *xb, xbsize, *pbp;
  float dx, dy, ey;
  char  *rdp;
  int   ii;
  int   nverts;

  nverts = pverts * 2;

#ifdef DEBUG_ROI
  pbp = pb;
  printf("nverts %d\n", nverts);
  for (ii=0; ii < nverts; ii++ )
    printf("%d %d\n", *pbp++, *pbp++);
#endif




  /* only if 3 or more points... */
  if (nverts > 4)
  {
    /* init crossings buffer */
    xbsize = 256;
    if ((xb = (int *) malloc(xbsize * sizeof(int))) == NULL)
      return(0);

    /* find the y range */
    ymin = 65536;
    ymax = 0;
    for (i = 1; i < nverts; i += 2)
    {
      if (PBY(i) < ymin)
	ymin = PBY(i);
      if (PBY(i) > ymax)
	ymax = PBY(i);
    }
    if (ymin < 0)
      ymin = 0;
    if (ymax > dims[1])
      ymax = dims[1];

    /* start filling from here */
#ifdef ARGB_MODE
    rdp = roi_data + (ymin * dims[0]) * sizeof(int);
#else
    rdp = roi_data + (ymin * dims[0]);
#endif

    /* n-1 lines for n points */
    nverts--;
    nverts--;

    /* for each scanline... */
    for (scan = ymin; scan < ymax; scan++)
    {
      /* look for lines crossing this scanline */
      nxings = 0;
      for (i = 1; i < nverts; i += 2)
      {
	/* NOTE! this test should eliminate horizontals */
	if ((PBY(i) >  scan && PBY(i+2) <= scan) ||
	    (PBY(i) <= scan && PBY(i+2) >  scan))
	{
	  /* crosses, calculate the x crossing point */
	  if (nxings >= xbsize)
	  {
	    xbsize *= 2;
	    if ((xb = (int *) realloc(xb, xbsize * sizeof(int))) == NULL)
	      return(0);
	  }

	  /* pretty inefficient to calculate this for every scanline...
	   * should really have an active edge list, compute this once
	   * and do increments off the total delta...
	   */
	  dx = PBX(i-1) - PBX(i+1);
	  dy = PBY(i+2) - PBY(i);
	  ey = PBY(i) - scan;
	  xb[nxings] = PBX(i-1) + (int) ((dx * ey) / dy);
	  nxings++;
	}
      }

/**
#ifdef DEBUG_ROI
      printf("scan %d nxings %d", scan, nxings);
      for (ii = 0; ii < nxings; i++)
        printf(" %d", xb[ii]);
      printf("\n");
#endif
**/

      /* sort the crossings, left to right - simple swap sort */
      for (i = 0; i < nxings; i++)
      {
	k = i;
	for (j = i+1; j < nxings; j++)
	  if (xb[j] < xb[k])
	    k = j;

	if (k != i)
	{
	  j = xb[k];
	  xb[k] = xb[i];
	  xb[i] = j;
	}
      }

#ifdef DEBUG_ROI
      printf("sorted xings");
      for (ii = 0; ii < nxings; ii++)
        printf(" %d", xb[ii]);
      printf("\n");
#endif

      /* should always be an even number of crossing points */
      if (nxings % 2)
	printf("odd %d number of spans!!\n", nxings-1);
      else
      {
	/* do the fill - spans are "off", "on", "off", etc */
	for (i = 0, j = 0; i <= nxings; i++)
	{
	  /* k is the delta between this crossing and the previous;
	   * j is the previous crossing
	   */
	  if (i == nxings)
	    k = dims[0] - j;
	  else
	    k = xb[i] - j;

	  if (k > 0)
	  {
	    /* span inside left edge: clip against right edge */
	    if ((j + k) > dims[0])
	      k = dims[0] - j;

#ifdef ARGB_MODE
	    if (i % 2)
	    {
	      if ( edge_mode == 2 )
	      {
		  *rdp = *(rdp+(k-1)*sizeof(int)) = fill_value;
	      }
	      else
	          memset(rdp, fill_value, k * sizeof(int));
	    }
	    rdp += k * sizeof(int);
	  }
#else
	    if (i % 2)
	    {
	      if ( edge_mode == 2 )
	      {
		  *rdp = *(rdp+k-1) = fill_value;
	      }
	      else
	          memset(rdp, fill_value, k);
	    }
	    rdp += k;
	  }
#endif


	  /* set previous crossing for next span */
	  if (xb[i] < 0)
	    j = 0;
	  else if (xb[i] > dims[0])
	    j = dims[0];
	  else
	    j = xb[i];
	}
      }
    }


/* IAC CODE CHANGE :     free(xb); */

/* IAC CODE CHANGE :      free(xb); */
      free(xb);
  }

  return(1);
}

