/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/

/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 * Name: marker_gen - generate marker bitmaps from marker input list
 *
 * Type: mapper
 *
 * Author: Ian Curington, AVS/UNIRAS Ltd.
 *
 * Description:
 *   This module converts vector edge defined marker shapes
 *   into ROI bit masks coverage for AVS images.
 *   The input is compatable with any AVS image, and
 *   any fully specified marker list 1D integer field.
 *   The marker list can be specified from a stored field,
 *   or more often, marker_select, or marker_pick modules.
 *
 *   This module scan converts the marker edge list into
 *   a binary bit pattern, where the bit pattern at each
 *   pixel is either zero for no marker present, or the
 *   marker shape index.
 *
 *   The output is a full size scalar byte field, the same
 *   size as the input image.
 *
 *
 * ------------------------------
 * Revision:
 *  7 Feb 94 ianc: Orig
 *
 */
/* mod_gen Version 1                                                     */
/* Module Name: "marker_gen" (Mapper) (Subroutine)                       */
/* Author: Ian_Curington                                                 */
/* Date Created: Tue Jun 22 00:01:03 1993                                */
/*                                                                       */
/* input 0 "ref_image" field 2D byte REQUIRED                            */
/* input 1 "marker_input" field 1D 4-vector uniform integer REQUIRED     */
/* output 0 "roi_out" field 2D 1-vector uniform byte                     */
/* End of Module Description Comments                                    */

/*
                  Copyright (c) 1992, 1993, 1994 by
                  Advanced Visual Systems Inc.
                  All Rights Reserved

      This software comprises unpublished confidential information of
      Advanced Visual Systems Inc. and may not be used, copied or made
      available to anyone, except in accordance with the license
      under which it is furnished.

*/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 

#include "marker.h"
 

/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int marker_gen_desc()
{

	int in_port, out_port, param, iresult;
	extern int marker_gen_compute();

	AVSset_module_name("Marker Gen", MODULE_MAPPER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("ref_image", "field 2D byte", REQUIRED);
	in_port = AVScreate_input_port("marker_input", 
		MARKER_FIELD_SPEC, REQUIRED);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("roi_out", 
		MARKER_ROI_SPEC );

	AVSset_compute_proc(marker_gen_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int marker_gen_compute( ref_image, marker_input, roi_out)
	AVSfield_char *ref_image;
	AVSfield_int *marker_input;
	AVSfield_char **roi_out;
{

   int dims[4];
   int size;
   int i;
   int veclen;
   int x,y,type,sz,fill,endx,endy;
   char fill_value;
   int nverts;
   int *shape_ptr;

   dims[0] = MAXX(ref_image);  /* set the array dimensions */
   dims[1] = MAXY(ref_image);
   size = dims[0] * dims[1];
   veclen = marker_input->veclen;

   /* Default Full On ROI */
   fill_value = 0xff;

   if ( size <= 20 )
   {
       printf("marker_gen: reference image is too small\n");
       return(0);
   }

   /* alloc speedup */
   if ( AVSinput_changed("ref_image",0) ||
	*roi_out == NULL )
   {
       if ( *roi_out ) AVSfield_free ( *roi_out );
       *roi_out = (AVSfield_char *)
           AVSdata_alloc( MARKER_ROI_SPEC ,dims);
   }

   /* clear it out */
   bzero( (*roi_out)->data, size);

   /* If no markers, send through blank roi */
   if ( MAXX(marker_input) <= 0 ) return(1);


   /*
    * Process Markers
    */
   for ( i=0; i < MAXX(marker_input); i++ )
   {
       /*
	* get marker place, size and type
	*/
       x    = marker_input->data[ i * veclen + 0 ];
       y    = marker_input->data[ i * veclen + 1 ];
       type = marker_input->data[ i * veclen + 2 ];
       sz   = marker_input->data[ i * veclen + 3 ];
       fill = marker_input->data[ i * veclen + 4 ];
       endx = marker_input->data[ i * veclen + 5 ];
       endy = marker_input->data[ i * veclen + 6 ];

       /* find center of marker in ref image */
       nverts = mlist_size[type];
       if ( sz <= MIN_MARKER_SIZE ) sz = MIN_MARKER_SIZE;

       /*
        * Try passing type as colour key
        */
       fill_value = type;

       switch (type)
       {
           case MARKER_SQUARE:
	       shape_ptr = (int *)shape_square;
               break;
           case MARKER_DIAMOND:
	       shape_ptr = (int *)shape_diamond;
               break;
           case MARKER_CIRCLE:
	       shape_ptr = (int *)shape_circle;
               break;
           case MARKER_X:
	       shape_ptr = (int *)shape_x;
               break;
           case MARKER_FLEUR:
	       shape_ptr = (int *)shape_fleur;
               break;
           case MARKER_POLY:
	       shape_ptr = (int *)shape_poly;
               break;
           default:
	       shape_ptr = (int *)shape_square;
	       nverts = mlist_size[MARKER_SQUARE];
               break;
       }


       /* drop pixels into the ROI to makeup the marker */

       make_roi_from_points(shape_ptr,      /* shape verts list, n x 2 */
                         (*roi_out)->data,  /* output char 2d buffer */
                         dims,              /* size of output array  */
                         fill_value,        /* value to fill with    */
                         nverts,            /* number of verts in shape */
                         fill,              /* fill or edge only mode */
			 x,                 /* offset position */
			 y,                 /* offset position */
			 sz );              /* marker scale size */


   }

   return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
#ifdef sep_exe
int ((*mod_list[])()) = {
	marker_gen_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
#endif

