/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 * Name:
 * marker_merge - merge roi marker pattern with full colour image
 *
 * Type: Mapper
 *
 * Author: Ian Curington, AVS/UNIRAS Ltd.
 *
 * Description:
 *   This module modifies a full color input image by
 *   masking it with an ROI byte field. The marker
 *   type code in the ROI is used to control what
 *   color is replaced inside each marker area,
 *   and optionally a secondary texture image can
 *   be used as the fill color inside of the marker areas.
 *   The ROI field is compatable with other ROI
 *   field modules (IP Lib).
 *
 *   This module is designed to work with other marker modules,
 *   marker_gen, marker_select, marker_draw, marker_pick, etc.
 *
 * (to go with marker_pick and marker_gen modules)
 *
 * -----------------------------------------------
 *
 * Revision:
 *  8 Feb 94 ianc: Original
 *  9 Feb 94 ianc:  debugging
 */
/* mod_gen Version 1                                                     */
/* Module Name: "marker_merge" (Mapper) (Subroutine)                     */
/* Author: Ian_Curington                                                 */
/* Date Created: Tue Jun 22 22:37:41 1993                                */
/*                                                                       */

/*
                  Copyright (c) 1992, 1993, 1994 by
                  Advanced Visual Systems Inc.
                  All Rights Reserved

      This software comprises unpublished confidential information of
      Advanced Visual Systems Inc. and may not be used, copied or made
      available to anyone, except in accordance with the license
      under which it is furnished.

*/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
#include "marker.h"
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int marker_merge_desc()
{

	int in_port, out_port, param, iresult;
	extern int marker_merge_compute();

	AVSset_module_name("Marker Merge", MODULE_MAPPER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("ref_image", 
		MARKER_IMAGE_SPEC, REQUIRED);
	in_port = AVScreate_input_port("roi_in", 
		MARKER_ROI_SPEC, OPTIONAL);
	in_port = AVScreate_input_port("stipple_in", 
		MARKER_IMAGE_SPEC, OPTIONAL);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("output", 
		MARKER_IMAGE_SPEC);

	/* Parameter Specifications                */
	param = AVSadd_float_parameter("Square_Hue", 0.100000, 0.00000, 
		1.00000);
	AVSconnect_widget(param, "slider");
	param = AVSadd_float_parameter("Diamond_Hue", 0.200000, 0.00000, 
		1.00000);
	AVSconnect_widget(param, "slider");
	param = AVSadd_float_parameter("Circle_Hue", 0.300000, 0.00000, 
		1.00000);
	AVSconnect_widget(param, "slider");
	param = AVSadd_float_parameter("X_Hue", 0.400000, 0.00000, 1.00000);
	AVSconnect_widget(param, "slider");
	param = AVSadd_float_parameter("Fleur_Hue", 0.500000, 0.00000, 
		1.00000);
	AVSconnect_widget(param, "slider");
	param = AVSadd_float_parameter("Poly_Hue", 0.600000, 0.00000, 1.00000);
	AVSconnect_widget(param, "slider");

	param = AVSadd_parameter("Stipple", "boolean", 0, 0, 1 );

	AVSset_compute_proc(marker_merge_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int marker_merge_compute( ref_image,
                          roi_in,
                          stipple_in,
                          output,
                          square_hue, 
                          diamond_hue,
                          circle_hue,
                          x_hue,
                          fleur_hue,
                          poly_hue,
			  stipple_mode)

	AVSfield_char *ref_image;
	AVSfield_char *roi_in;
	AVSfield_char *stipple_in;
	AVSfield_char **output;
	float *square_hue;
	float *diamond_hue;
	float *circle_hue;
	float *x_hue;
	float *fleur_hue;
	float *poly_hue;
	int   stipple_mode;
{
        int i, j, k;
        float        roi_col[256][3];
        int         roi_icol[256][3];
        int dims[2];
        int size;
        register unsigned char *p, *q, *w, *s;

        for (i=0; i < 256; i++ )
	{
            roi_col[i][0] =
	    roi_col[i][1] =
	    roi_col[i][2] = 0.0;
	}

        FILTERhsv_to_rgb (&(roi_col[1][0]),
                          &(roi_col[1][1]),
                          &(roi_col[1][2]),
                          *square_hue, 1.0, 1.0 );
        FILTERhsv_to_rgb (&(roi_col[2][0]),
                          &(roi_col[2][1]),
                          &(roi_col[2][2]),
                          *diamond_hue, 1.0, 1.0 );
        FILTERhsv_to_rgb (&(roi_col[3][0]),
                          &(roi_col[3][1]),
                          &(roi_col[3][2]),
                          *circle_hue, 1.0, 1.0 );
        FILTERhsv_to_rgb (&(roi_col[4][0]),
                          &(roi_col[4][1]),
                          &(roi_col[4][2]),
                          *x_hue, 1.0, 1.0 );
        FILTERhsv_to_rgb (&(roi_col[5][0]),
                          &(roi_col[5][1]),
                          &(roi_col[5][2]),
                          *fleur_hue, 1.0, 1.0 );
        FILTERhsv_to_rgb (&(roi_col[6][0]),
                          &(roi_col[6][1]),
                          &(roi_col[6][2]),
                          *poly_hue, 1.0, 1.0 );

        for (i=0; i < 256; i++ )
        for (j=0; j < 3; j++ )
	{
            roi_icol[i][j]= (int)(roi_col[i][j]*255.0);
	}

        dims[0] = MAXX(ref_image);
        dims[1] = MAXY(ref_image);
        size    = dims[0] * dims[1];

        /* alloc speedup */
        if ( AVSinput_changed("ref_image",0) ||
             *output == NULL )
        {
            if ( *output ) AVSfield_free ( *output );
            *output = (AVSfield_char *)
                AVSdata_alloc( MARKER_IMAGE_SPEC ,dims);
        }

        /*
         * merge both input ports, looking up color of roi
         */
        q = (unsigned char *) ref_image->data;
        w = (unsigned char *) (*output)->data;

        if ( !stipple_in ) stipple_mode=0;

        if ( roi_in && !stipple_mode )
	{
            p = (unsigned char *) roi_in->data;
            for (i=0; i < size; i++ )
            {
                if ( *p )  /* roi=0 is background */
                {
		    w++;                     /* alpha */
                    *w++ = roi_icol[*p][0];  /* red */
                    *w++ = roi_icol[*p][1];  /* green */
                    *w++ = roi_icol[*p][2];  /* blue */
                    p++;
                    q += 4;
                }
                else
                {
		    w++; q++;
		    *w++ = *q++;
		    *w++ = *q++;
		    *w++ = *q++;
                    p++;
                }
            }
        }
	else if ( roi_in && stipple_mode )
	{
            p = (unsigned char *) roi_in->data;
            s = (unsigned char *) stipple_in->data;
            for (i=0; i < size; i++ )
            {
                if ( *p )  /* roi=0 is background */
                {
		    w++;    s++;              /* alpha */
                    *w++ = *s++ ;  /* red */
                    *w++ = *s++ ;  /* green */
                    *w++ = *s++ ;  /* blue */
                    p++;
                    q += 4;
                }
                else
                {
		    w++;    q++;
		    *w++ = *q++;
		    *w++ = *q++;
		    *w++ = *q++;
                    p++;
                    s += 4;
                }
            }

	}
	else
	/* no roi, just copy ref */
	{
            for (i=0; i < size*4; i++ )
            {
		    *w++ = *q++;
            }
        }


        return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
#ifdef sep_exe
int ((*mod_list[])()) = {
	marker_merge_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
#endif

