
/*
 * marker.h - marker data struct definitions
 *            shared between marker modules
 *            This file is used by both the
 *            selection, editing, drawing, and generator
 *            modules in the marker suite.
 *            It allows modules to share assumptions
 *            over the AVS fields passed between them
 *            pertaining to the marker list structure.
 *            By keeping these definitions in one place,
 *            the module code can be kept in sync.
 *
 * Revision:
 *   8 Feb 94, ianc
 *  10 June 94 ianc - updated for Oracle Demo project
 */

/*
                  Copyright (c) 1992, 1993, 1994 by
                  Advanced Visual Systems Inc.
                  All Rights Reserved

      This software comprises unpublished confidential information of
      Advanced Visual Systems Inc. and may not be used, copied or made
      available to anyone, except in accordance with the license
      under which it is furnished.

*/

/* Marker symbolic name definitions */

#define NUM_MARKERS    7

#define MARKER_NULL    0
#define MARKER_SQUARE  1
#define MARKER_DIAMOND 2
#define MARKER_CIRCLE  3
#define MARKER_X       4
#define MARKER_FLEUR   5
#define MARKER_POLY    6

#define MIN_MARKER_SIZE 2

/* Full Marker port field vector length */
#define MARKER_VECLEN               7

/* Input marker port spec, allow multiple vector lengths */
#define MARKER_FIELD_I_SPEC "field 1D uniform integer"

/* Output port spec, completely specified, for mem allocation */
#define MARKER_FIELD_SPEC "field 1D 7-vector uniform integer"

#define MARKER_ROI_SPEC   "field 2D 1-vector uniform byte"
#define MARKER_IMAGE_SPEC "field 2D 4-vector uniform byte"

/* marker field vector definitions:
 * v=0   x
 * v=1   y
 * v=2   type (from above list)
 * v=3   size
 * v=4   fill
 * v=5   end X (from rubber band)
 * v=6   end Y
 *
 * fill=1    filled
 * fill=2    outline
 */

/* number of verts in each shape */
static int mlist_size[8] = { 0, 5, 5, 9, 13, 9, 5 };

/* marker shapes, [verts][xy] */
/* x-y coordinate pairs, first and last must be the same */
/* to close the shape for the fill algorithm */

static int shape_square[5][2] = 
     {  /* square */
       {  1,  1},
       {  1, -1},
       { -1, -1},
       { -1,  1},
       {  1,  1},
     };

static int shape_diamond[5][2] = 
     {  /* diamond */
       {  1,  0},
       {  0,  1},
       { -1,  0},
       {  0, -1},
       {  1,  0},
     };

static int shape_circle[9][2] = 
     {  /* circle (octogon) */
       {  3,  1},
       {  1,  3},
       { -1,  3},
       { -3,  1},
       { -3, -1},
       { -1, -3},
       {  1, -3},
       {  3, -1},
       {  3,  1},
     };

static int shape_x[13][2] = 
     {  /* X */
       {  1,  0},
       {  3,  2},
       {  2,  3},
       {  0,  1},
       { -2,  3},
       { -3,  2},
       { -1,  0},
       { -3, -2},
       { -2, -3},
       {  0, -1},
       {  2, -3},
       {  3, -2},
       {  1,  0},
     };

static int shape_fleur[9][2] = 
     {  /* fleur de lis ?? */
       {  3,  1},
       {  1,  0},
       { -1,  3},
       { -3,  1},
       { -3, -1},
       { -1,  0},
       {  1, -3},
       {  3, -1},
       {  3,  1},
     };

static int shape_poly[5][2] = 
     {  /* poly */
       {  1,  3},
       {  1, -3},
       { -1, -3},
       { -1,  3},
       {  1,  3},
     };

/* add your own here... */

