/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include "separate.h"

/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int NEW_PRINTFIELD_desc()
{

	int in_port, in_2port, out_port, param;
	extern int NEW_PRINTFIELD_compute();

	AVSset_module_name("NEW PRINTFIELD", MODULE_MAPPER);
	AVSset_module_flags(COOPERATIVE);

	/* Input Port Specifications               */

	in_port = AVScreate_input_port("input field", 
		"field uniform 1-vector float", REQUIRED);

	in_port = AVScreate_input_port("slice axis", "string", REQUIRED);

	/* Parameter Specifications                */

	param = AVSadd_parameter("output matrix", "string",
		 " ", NULL, NULL);
	AVSconnect_widget(param, "text_browser");
	AVSadd_parameter_prop(param, "width", "integer", 8);
	AVSadd_parameter_prop(param, "height", "integer", 4);

	param = AVSadd_parameter("format", "string", "%7.2f", NULL, NULL);
	AVSconnect_widget(param, "typein");
	AVSadd_parameter_prop(param, "width", "integer", 4);

	param = AVSadd_parameter("file name", "string", NULL, NULL, NULL);
	AVSconnect_widget(param, "typein");
	AVSadd_parameter_prop(param, "width", "integer", 4);

	param = AVSadd_parameter("invert dim2", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	param = AVSadd_parameter("labels", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	param = AVSadd_parameter("label width", "integer", 7, 7, 30);
	AVSconnect_widget(param, "islider");
	AVSadd_parameter_prop(param, "width", "integer", 4);

	param = AVSadd_parameter("display now", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	AVSset_compute_proc(NEW_PRINTFIELD_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int NEW_PRINTFIELD_compute(input_field, input_slice_axis,
output_matrix, format, file_name,
invert_dim2, labels, label_width, display_now)
AVSfield_float *input_field;
char *input_slice_axis;
char *output_matrix;
char *format;
char *file_name;
int invert_dim2;
int labels;
int label_width;
int display_now;
{
FILE *f;
register int i, j, k, dim1, dim2, ni, nj;
register int lowdim1, highdim1, lowdim2, highdim2;
static char local_filename[132];
static char label1_format[64];
static char label2_format[64];
static char label_slice_format[64];
static char spaces[32];

#define XCOORD_MIN ((int) (input_field->points[0]))
#define XCOORD_MAX ((int) (input_field->points[1]))
#define YCOORD_MIN ((int) (input_field->points[2]))
#define YCOORD_MAX ((int) (input_field->points[3]))
#define ZCOORD_MIN ((int) (input_field->points[4]))
#define ZCOORD_MAX ((int) (input_field->points[5]))
 
#define NX ((int) ((XCOORD_MAX - XCOORD_MIN) + 1) )
#define NY ((int) ((YCOORD_MAX - YCOORD_MIN) + 1) )
#define NZ ((int) ((ZCOORD_MAX - ZCOORD_MIN) + 1) )

if (!display_now)
	{
	AVSparameter_visible("output matrix", 0);
	return(0);
	}
AVSparameter_visible("output matrix", 1);

if (file_name == NULL)
	sprintf(local_filename, "/tmp/matrix.%d", getpid());
else
	sprintf(local_filename, "%s", file_name);
	
if ((f = fopen(local_filename, "w")) == NULL)
	{
	AVSerror("File %s cannot be created.\n", local_filename);
	return(0);
	}

if (!strcmp(input_slice_axis, "X"))
	{
	sprintf(label_slice_format, "COL  %d", XCOORD_MIN + 1);
	lowdim1 = YCOORD_MIN;
	highdim1 = YCOORD_MAX;
	dim1 = NY;
	sprintf(label1_format, " ROW%%3d");
	lowdim2 = ZCOORD_MIN;
	highdim2 = ZCOORD_MAX;
	dim2 = NZ;
	sprintf(label2_format, " LEV%%3d");
	}
else if (!strcmp(input_slice_axis, "Y"))
	{
	sprintf(label_slice_format, "ROW  %d", YCOORD_MIN + 1);
	lowdim1 = XCOORD_MIN;
	highdim1 = XCOORD_MAX;
	dim1 = NX;
	sprintf(label1_format, " COL%%3d");
	lowdim2 = ZCOORD_MIN;
	highdim2 = ZCOORD_MAX;
	dim2 = NZ;
	sprintf(label2_format, " LEV%%3d");
	}
else if (!strcmp(input_slice_axis, "Z"))
	{
	sprintf(label_slice_format, "LEVEL %d", ZCOORD_MIN + 1);
	lowdim1 = XCOORD_MIN;
	highdim1 = XCOORD_MAX;
	dim1 = NX;
	sprintf(label1_format, " COL%%3d");
	lowdim2 = YCOORD_MIN;
	highdim2 = YCOORD_MAX;
	dim2 = NY;
	sprintf(label2_format, " ROW%%3d");
	}

if (labels)
	{
	fprintf(f, "%s\n", label_slice_format);
	for (i = 0; i < label_width; ++i)
		spaces[i] = ' ';
	spaces[i] = '\0';
	fprintf(f,  "%s", spaces);		/* for the corner */

	for (i = 0; i < label_width - 7; ++i)	/* for each dim1-dim2 label */
		spaces[i] = ' ';
	spaces[i] = '\0';

	for (i = lowdim1; i <= highdim1; ++i)
		{
		fprintf(f, "%s", spaces);
		fprintf(f, label1_format, i + 1);
		}
	fprintf(f, "\n"); 
	}

if (invert_dim2)
	{
	nj = 0;
	for (j = lowdim2; j <= highdim2; ++j)
		{
		if (labels)
			{
			fprintf(f, "%s", spaces);
			fprintf(f, label2_format, j+1);
			}
		ni = 0;
		for (i = lowdim1; i <= highdim1; ++i)
			{
			k = ni + nj * dim1;
			fprintf(f, format, input_field->data[k]); 
			++ni;
			}
		fprintf(f, "\n");
		++nj;
		}
	}
else
	{
	nj = 0;
	for (j = highdim2; j >= lowdim2; --j)
		{
		if (labels)
			{
			fprintf(f, "%s", spaces);
			fprintf(f, label2_format, j + 1);
			}
		ni = 0;
		for (i = lowdim1; i <= highdim1; ++i)
			{
			k = ni + nj * dim1;
			fprintf(f, format, input_field->data[k]); 
			++ni;
			}
		fprintf(f, "\n");
		++nj;
		}
	}

fclose(f);

AVSmodify_parameter("output matrix", AVS_VALUE, local_filename, NULL, NULL);
AVSmodify_parameter("file name", AVS_VALUE, local_filename, NULL, NULL);

return(1);
}
 
#ifdef SEPARATE_MODULES

/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	NEW_PRINTFIELD_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}

#endif

