/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include "separate.h"

static char def_dim[8] = {'Z', '\0', '\0', '\0', '\0', };
static char list_dim[16] = {
	 'X', ':', 'Y', ':', 'Z', ':', 'T', 'i', 'm', 'e', ':', '\0', };

 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int NEW_SLICE_desc()
{

	int in_port, in_2port, out_port, param;
	extern int NEW_SLICE_compute();

	AVSset_module_name("NEW SLICE", MODULE_MAPPER);
	AVSset_module_flags(COOPERATIVE);

	/* Input Port Specifications               */

	in_port = AVScreate_input_port("input field", 
		"field uniform float", REQUIRED);

	/* Output Port Specifications              */

	out_port = AVScreate_output_port("output field", 
		"field uniform float");

	out_port = AVScreate_output_port("output string", "string");

	out_port = AVScreate_output_port("output slice axis", "string");

	/* Parameter Specifications                */

	param = AVSadd_parameter("slice plane", "integer", 0, -5000, 5000);
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("slice axis", "choice", 
		def_dim, list_dim, ":");
	AVSconnect_widget(param, "radio_buttons");

        param = AVSadd_parameter("reset field minmax", "boolean", 0, 0, 1);
        AVSconnect_widget(param, "toggle");

	AVSset_compute_proc(NEW_SLICE_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int NEW_SLICE_compute(input_field, 
output_field, output_string, output_slice_axis, slice_plane,
slice_axis, reset_field_minmax)
	AVSfield_float *input_field;
	AVSfield_float **output_field;
	char **output_string;
	char **output_slice_axis;
	int slice_plane;
	char *slice_axis;
	int reset_field_minmax;
{
static int dim[4];
static float minext[3];
static float maxext[3];
static char field_str[132];

int slice;
int xmin, xmax;
int ymin, ymax;
int zmin, zmax;
int tmin, tmax;
static char delimiter[2];
static char output_axis[32];

char *str = NULL;
register int i, j, k, l, n, iv;
register int in, out;

#define INPUT_POINT input_field->data[in]
#define OUTPUT_POINT (*output_field)->data[out]
#define NDIM input_field->ndim
#define NSPACE input_field->nspace
#define NVEC input_field->veclen

#define INPUT_MIN_XCOORD input_field->points[0]
#define INPUT_MAX_XCOORD input_field->points[1]
#define INPUT_MIN_YCOORD input_field->points[2]
#define INPUT_MAX_YCOORD input_field->points[3]
#define INPUT_MIN_ZCOORD input_field->points[4]
#define INPUT_MAX_ZCOORD input_field->points[5]
#define INPUT_MIN_TCOORD input_field->points[6]
#define INPUT_MAX_TCOORD input_field->points[7]

#define NX ((int) (INPUT_MAX_XCOORD - INPUT_MIN_XCOORD + 1.0))
#define NY ((int) (INPUT_MAX_YCOORD - INPUT_MIN_YCOORD + 1.0))
#define NZ ((int) (INPUT_MAX_ZCOORD - INPUT_MIN_ZCOORD + 1.0))
#define NT ((int) (INPUT_MAX_TCOORD - INPUT_MIN_TCOORD + 1.0))

#define OUTPUT_MIN_XCOORD (*output_field)->points[0]
#define OUTPUT_MAX_XCOORD (*output_field)->points[1]
#define OUTPUT_MIN_YCOORD (*output_field)->points[2]
#define OUTPUT_MAX_YCOORD (*output_field)->points[3]
#define OUTPUT_MIN_ZCOORD (*output_field)->points[4]
#define OUTPUT_MAX_ZCOORD (*output_field)->points[5]
#define OUTPUT_MIN_TCOORD (*output_field)->points[6]
#define OUTPUT_MAX_TCOORD (*output_field)->points[7]


if ((NDIM > 4) || (NSPACE > 3))
	{
	AVSerror("# dimensions must be <= 4 and # coordinates must be <= 3!");
	return(0);
	}

if (AVSinput_changed("input field", 0))
	{
	switch(NDIM)
		{
		case 1: 
			{
			sprintf(def_dim, "X");
			sprintf(list_dim, "X:");
			if (strtest(list_dim, slice_axis, ':'))
				sprintf(def_dim, "%s", slice_axis);
			AVSmodify_parameter("slice axis",
				AVS_VALUE | AVS_MINVAL | AVS_MAXVAL,
				def_dim, list_dim, ":");
			break;
			}
		case 2: 
			{
			sprintf(def_dim, "Y");
			sprintf(list_dim, "X:Y");
			if (strtest(list_dim, slice_axis, ':'))
				sprintf(def_dim, "%s", slice_axis);
			AVSmodify_parameter("slice axis",
				AVS_VALUE | AVS_MINVAL | AVS_MAXVAL,
				def_dim, list_dim, ":");
			break;
			}
		case 3: 
			{
			sprintf(def_dim, "Z");
			sprintf(list_dim, "X:Y:Z");
			if (strtest(list_dim, slice_axis, ':'))
				sprintf(def_dim, "%s", slice_axis);
			AVSmodify_parameter("slice axis",
				AVS_VALUE | AVS_MINVAL | AVS_MAXVAL,
				def_dim, list_dim, ":");
			break;
			}
		case 4: 
			{
			sprintf(def_dim, "Z");
			sprintf(list_dim, "X:Y:Z:Time");
			if (strtest(list_dim, slice_axis, ':'))
				sprintf(def_dim, "%s", slice_axis);
			AVSmodify_parameter("slice axis",
				AVS_VALUE | AVS_MINVAL | AVS_MAXVAL,
				def_dim, list_dim, ":");
			break;
			}
		}
	}
xmin = xmax = ymin = ymax = zmin = zmax = tmin = tmax = 0;

if (NDIM >= 1)
	{
	xmin = i = (int) INPUT_MIN_XCOORD;
	xmax = j = (int) INPUT_MAX_XCOORD;
	if (!strcmp(slice_axis, "X"))
		{
		k = slice_plane;
		if ((k < i) || (k > j))
			k = i;
		if (NX > 1)
			{
			AVSparameter_visible("slice plane", 1);
			AVSmodify_parameter("slice plane",
				AVS_VALUE | AVS_MINVAL | AVS_MAXVAL, k, i, j);
			}
		else
			AVSparameter_visible("slice plane", 0);
		xmin = xmax = k;
		}
	}
if (NDIM >= 2)
	{
	ymin = i = (int) INPUT_MIN_YCOORD;
	ymax = j = (int) INPUT_MAX_YCOORD;
	if (!strcmp(slice_axis, "Y"))
		{
		k = slice_plane;
		if ((k < i) || (k > j))
			k = i;
		if (NY > 1)
			{
			AVSparameter_visible("slice plane", 1);
			AVSmodify_parameter("slice plane",
				AVS_VALUE | AVS_MINVAL | AVS_MAXVAL, k, i, j);
			}
		else
			AVSparameter_visible("slice plane", 0);
		ymin = ymax = k;
		}
	}
if (NDIM >= 3)
	{
	zmin = i = (int) INPUT_MIN_ZCOORD;
	zmax = j = (int) INPUT_MAX_ZCOORD;
	if (!strcmp(slice_axis, "Z"))
		{
		k = slice_plane;
		if ((k < i) || (k > j))
			k = i;
		if (NZ > 1)
			{
			AVSparameter_visible("slice plane", 1);
			AVSmodify_parameter("slice plane",
				AVS_VALUE | AVS_MINVAL | AVS_MAXVAL, k, i, j);
			}
		else
			AVSparameter_visible("slice plane", 0);
		zmin = zmax = k;
		}
	}
if (NDIM >= 4)
	{
	tmin = i = (int) INPUT_MIN_TCOORD;
	tmax = j = (int) INPUT_MAX_TCOORD;
	if (!strcmp(slice_axis, "Time"))
		{
		k = slice_plane;
		if ((k < i) || (k > j))
			k = i;
		if (NT > 1)
			{
			AVSparameter_visible("slice plane", 1);
			AVSmodify_parameter("slice plane",
				AVS_VALUE | AVS_MINVAL | AVS_MAXVAL, k, i, j);
			}
		else
			AVSparameter_visible("slice plane", 0);
		tmin = tmax = k;
		}
	}
sprintf(output_axis, "%s", slice_axis);
*output_slice_axis = output_axis;

i = 0;
if (strcmp(slice_axis, "X"))
	dim[i++] = xmax - xmin + 1;
if (strcmp(slice_axis, "Y"))
	dim[i++] = ymax - ymin + 1;
if (strcmp(slice_axis, "Z"))
	dim[i++] = zmax - zmin + 1;
if (strcmp(slice_axis, "Time"))
	dim[i++] = tmax - tmin + 1;

sprintf(field_str, "field %dD %d-space uniform %d-vector float",
	 NDIM - 1, NSPACE, NVEC);

if (*output_field)
	AVSfield_free((AVSfield *) *output_field);
if ((*output_field = (AVSfield_float *) 
	AVSdata_alloc(field_str, dim)) == NULL)
	{
	AVSerror("Cannot allocate memory for output field!");
	return(0);
	}	

in = out = 0;
switch(NDIM)
	{
	case 4:
		{
		for (l = INPUT_MIN_TCOORD; l <= INPUT_MAX_TCOORD ; ++l)
			{
			for (k = INPUT_MIN_ZCOORD; k <= INPUT_MAX_ZCOORD; ++k)
				{
				for (j = INPUT_MIN_YCOORD; j <= INPUT_MAX_YCOORD; ++j)
					{
					for (i = INPUT_MIN_XCOORD; i <= INPUT_MAX_XCOORD; ++i)
						{
						for (iv = 0; iv < NVEC; ++iv)
							{
							if (
							(l >= tmin) &&
							(l <= tmax) &&	
							(k >= zmin) &&
							(k <= zmax) &&
							(j >= ymin) &&
							(j <= ymax) &&
							(i >= xmin) &&
							(i <= xmax))
								{
						OUTPUT_POINT = INPUT_POINT;
								++out;
								}
							++in;
							}
						}
					}
				}
			}
		break;
		}
	case 3:
		{
		for (k = INPUT_MIN_ZCOORD; k <= INPUT_MAX_ZCOORD; ++k)
			{
			for (j = INPUT_MIN_YCOORD; j <= INPUT_MAX_YCOORD; ++j)
				{
				for (i = INPUT_MIN_XCOORD; i <= INPUT_MAX_XCOORD; ++i)
					{
					for (iv = 0; iv < NVEC; ++iv)
						{
						if (
						(k >= zmin) &&
						(k <= zmax) &&
						(j >= ymin) &&
						(j <= ymax) &&
						(i >= xmin) &&
						(i <= xmax))
							{
						OUTPUT_POINT = INPUT_POINT;
							++out;
							}
						++in;
						}
					}
				}
			}
		break;
		}
	case 2:
		{
		for (j = INPUT_MIN_YCOORD; j <= INPUT_MAX_YCOORD; ++j)
			{
			for (i = INPUT_MIN_XCOORD; i <= INPUT_MAX_XCOORD; ++i)
				{
				for (iv = 0; iv < NVEC; ++iv)
					{
					if (
					(j >= ymin) &&
					(j <= ymax) &&
					(i >= xmin) &&
					(i <= xmax))
						{
						OUTPUT_POINT = INPUT_POINT;
						++out;
						}
					++in;
					}
				}
			}
		break;
		}
	case 1:
		{
		for (i = INPUT_MIN_XCOORD; i <= INPUT_MAX_XCOORD; ++i)
			{
			for (iv = 0; iv < NVEC; ++iv)
				{
				if (
				(i >= xmin) &&
				(i <= xmax))
					{
					OUTPUT_POINT = INPUT_POINT;
					++out;
					}
				++in;
				}
			}
		break;
		}
	}

if (NDIM >= 1)
	{
	minext[0] = input_field->min_extent[0];
	maxext[0] = input_field->max_extent[0];
	OUTPUT_MIN_XCOORD = xmin;
	OUTPUT_MAX_XCOORD = xmax;
	}
if (NDIM >= 2)
	{
	minext[1] = input_field->min_extent[1];
	maxext[1] = input_field->max_extent[1];
	OUTPUT_MIN_YCOORD = ymin;
	OUTPUT_MAX_YCOORD = ymax;
	}
if (NDIM >= 3)
	{
	minext[2] = input_field->min_extent[2];
	maxext[2] = input_field->max_extent[2];
	OUTPUT_MIN_ZCOORD = zmin;
	OUTPUT_MAX_ZCOORD = zmax;
	}
/*
if (NDIM >= 4)
	{
	OUTPUT_MIN_TCOORD = tmin;
	OUTPUT_MAX_TCOORD = tmax;
	}
*/


AVSfield_set_extent((AVSfield *) (*output_field), minext, maxext);

if (reset_field_minmax)
	AVSfield_reset_minmax((AVSfield *) *output_field);

sscanf(input_field->labels, "%c", delimiter);
delimiter[1] = '\0';
AVSfield_set_labels((AVSfield *) (*output_field), input_field->labels+1,
	delimiter);

sscanf(input_field->units, "%c", delimiter);
delimiter[1] = '\0';
AVSfield_set_units((AVSfield *) (*output_field), input_field->units+1,
	delimiter);

if (str != NULL)

/* IAC CODE CHANGE :         free((char *) str); */
         free( str);
 
if ((str = ((char *) malloc(sizeof(char) * 1024))) == NULL)
        {
        AVSerror("Cannot allocate string for output!"); 
        return(0);
        }
sprintf(str, "%d %d %d %d %d %d %d %d",
	xmin, xmax, ymin, ymax,
	zmin, zmax, tmin, tmax);

*output_string = str;
 
return(1);
}
 
#ifdef SEPARATE_MODULES

/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	NEW_SLICE_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}

#endif

