/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/*
 * Polyline
 *
 * A Test Bed for polyline picking applications
 * with the AVS5 Image Viewer
 *
 * Adapted from ip_read_line,
 * by Ian Curington
 *
 * Revision: 
 * 18 March 93 ianc - Original (Ensign Demo)
 * 22 March 93 ianc - inverted output port Y
 *                  - fixed buffer update bug
 */

/*
                  Copyright (c) 1992 by
                  Advanced Visual Systems Inc.
                  All Rights Reserved
      
      This software comprises unpublished confidential information of
      Advanced Visual Systems Inc. and may not be used, copied or made
      available to anyone, except in accordance with the license
      under which it is furnished.
      
*/

/**********************************************************/
#include <stdio.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>

#include <avs/avs.h>
#include <avs/field.h>
#include <avs/udata.h>
#include <avs/image_draw.h>
#include <avs/image_upstrm.h>

#define BUFSIZE 1024
#define CLI_BUFFER_SIZE BUFSIZE*32
#define MAX_POLYLINE 500
#define CMD_STR \
 "%s -scene_id %d -image_name \"%s\" -module $Module %f %f %f %f"

/**********************************************************/

typedef struct
{
  char buffer[CLI_BUFFER_SIZE], *bptr;
} CLIbuffer;

/**********************************************************/
/* Module Description Section */
/**********************************************************/
polyline_desc()
{
  int port, param;
  char spath[128];
  extern char *AVSpath;
  int polyline_compute();
    
  AVSset_module_name("Polyline", MODULE_MAPPER);

  /* can't be REENTRANT? (compute function has statics) */
  AVSset_module_flags(COOPERATIVE);

  AVScreate_input_port("input", "field 2D", REQUIRED);

  port = AVScreate_input_port("Image Viewer Id", "struct image_viewer_id",
                        INVISIBLE | OPTIONAL);
  AVSset_input_class(port, "Image Draw:image_viewer_id");

  port = AVScreate_input_port("Mouse Info","struct mouse_info",
                        INVISIBLE | OPTIONAL);
  AVSset_input_class(port, "Image Draw:mouse_info");

  AVScreate_output_port("Polyline Output",
     "field 1D 3-space irregular scalar float");

  AVScreate_output_port("Image Draw", "struct image_draw");

  param = AVSadd_parameter("set pick mode", "oneshot", 0, 0, 1);
  AVSconnect_widget(param, "oneshot");

  param = AVSadd_parameter("clear polyline", "oneshot", 0, 0, 1);
  AVSconnect_widget(param, "oneshot");

  param = AVSadd_parameter("undo last pick", "oneshot", 0, 0, 1);
  AVSconnect_widget(param, "oneshot");

  AVSset_compute_proc(polyline_compute);

  /* collect runtime configurable data type */
  if (AVSpath != NULL)
    strcpy(spath, AVSpath);
  else
    strcpy(spath, "/usr/avs");
  strcat(spath, "/include/image_draw.h");

  AVSload_user_data_types(spath);
}

/**********************************************************/
/* Module Computational Section */
/**********************************************************/
int polyline_compute(input,
                     iv_id,
                     mouseInfo,
                     poly,
                     im_draw,
                     mode,
                     clear,
                     undo )

    AVSfield        *input;      /* input image */
    image_viewer_id *iv_id;      /* image viewer feedback */
    mouse_info      *mouseInfo;  /* mouse status feedback */
    image_draw      **im_draw;   /* draw commands (unused) */
    AVSfield_float  **poly;      /* output polyline field */
    int             mode;        /* set mouse active mode for this module */
    int             clear;       /* clear line list out */
    int             undo;        /* undo the last pick */
{
  char      command[BUFSIZE], label[256];
  CLIbuffer *clibuf;
  int       i, j, data_type, mask, end, npixels, status;
  float     length, min, max;
  char      *in, *out, *line_buffer;
  short     *in_short, *out_short;
  float     *in_float, *out_float;
  int       dims[1];

  /* statics for remembering last line, and polyline */
  static CLIbuffer commandBuffer;
  static int       bufferInited = 0;
  static char      imageName[80];
  static int       begin = 1;
  static int       startX, startY, endX, endY;

  static int       polyline_buf[2][MAX_POLYLINE];
  static int       num_polylines;

  /*
   * Build Output drawing command list
   * not used, but causes upstream events to be registered.
   */
  if (*im_draw == NULL)
    *im_draw = (image_draw *) AVSdata_alloc("struct image_draw", 0);

  if (input->uniform != UNIFORM)
  {
    AVSerror("Incompatible data type: can only process 2D uniform fields");
    return(0);
  }

  /*
   * Initialize CLI command buffer
   * requests are blocked up for efficiency
   */
  clibuf = &commandBuffer;

  if (!bufferInited)
  {
    clibuf->bptr = clibuf->buffer;
    bufferInited = 1;
  }

  /*
   * This module will do nothing unless
   * it has upstream feedback
   */
  if (iv_id == NULL)
  {
    /* not connected to image viewer */
    imageName[0] = '\0';
    return(1);
  }

  /*
   * check buffer size
   */
  if ( num_polylines+1 >= MAX_POLYLINE )
  {
      AVSerror("polyline buffer is full, no more room.");
      return(0);
  }

  /*
   * clear all previous lines from image,
   * erase buffer
   */
  if (clear)
  {  
    /* polyline again, in XOR, to erase */
    for ( i=0; i<num_polylines-1; i++ )
    {
        sprintf(command, CMD_STR,
                 "image_add_xor_line",
                 iv_id->scene_id,
                 imageName,
                 (float) polyline_buf[0][i],
                 (float) polyline_buf[1][i],
                 (float) polyline_buf[0][i+1],
                 (float) polyline_buf[1][i+1]);
         add_command(command, clibuf, 0);
    }
    flush_command_buffer(clibuf);
    num_polylines = 0;
    fill_field ( poly, polyline_buf, num_polylines, MAXY(input) );
    return(1);
  }

  /*
   * Undo the last pick, back up the line 
   */
  if ( undo && num_polylines > 0 )
  {
     /* XOR the last line segment, to erase */
     if ( num_polylines > 1 )
     {
        i = num_polylines-2;
        sprintf(command, CMD_STR,
                 "image_add_xor_line",
                 iv_id->scene_id,
                 imageName,
                 (float) polyline_buf[0][i],
                 (float) polyline_buf[1][i],
                 (float) polyline_buf[0][i+1],
                 (float) polyline_buf[1][i+1]);
         add_command(command, clibuf, 0);
         flush_command_buffer(clibuf);
     }

     /* remove one from the list */
     num_polylines--;

     /* send the revised polyline list out */
     dims[0] = num_polylines;
     fill_field ( poly, polyline_buf, num_polylines, MAXY(input) );
     return(1);
  }

  if (AVSinput_changed("Image Viewer Id", 0) ||
      AVSinput_changed("input", 0))
  {
    sprintf(command,
    "image_wakeup_when_defined -scene_id %d -mesh_id %d -module \"$Module\"",
       iv_id->scene_id, input->mesh_id);
    add_command(command, clibuf, 1);
    num_polylines = 0;
  }

  if (mouseInfo && AVSinput_changed("Mouse Info", 0))
  {
    if (mouseInfo->nEvents == 0)
    {
      if (imageName[0] != '\0')
      {
          /* a new image - stop events for old */
          sprintf(command,
      "%s %s %d %s \"%s\" -module $Module -func_id \"%s\"",
              "image_stop_events",
              "-scene_id",
              iv_id->scene_id,
              "-image_name",
              imageName,
              "polyline");
          add_command(command, clibuf, 1);
          num_polylines = 0;
      }

      /*
       * request pick events from a new image
       * register request for events with the image viewer
       */
      strcpy(imageName, mouseInfo->image_name);
      mask = IMAGE_Button1Mask | IMAGE_PressMask | IMAGE_ReleaseMask |
                                 IMAGE_MotionMask;
      sprintf(command,
      "%s %d %s \"%s\" %s \"polyline\" -mask %d",
          "image_select_events -scene_id",
          iv_id->scene_id,
          "-image_name",
          imageName,
          "-module $Module -func_id",
          mask);
      add_command(command, clibuf, 1);

      sprintf(command, "image_set_pick_mode \"polyline\"");
      add_command(command, clibuf, 1);
    }
    else  /* mouse events in the queue */
    {
      /* got mouse events to deal with */
      end = 0;

      /* loop over all events */
      for (i = 0; i < mouseInfo->nEvents; i++)
      {
        if (((mouseInfo->buttonMask[i] & IMAGE_Button1Mask) &&
           (mouseInfo->buttonMask[i] & IMAGE_PressMask)))
        {
            /* button down defines the start point */
            startX = (int) mouseInfo->image_x[i];
            if (startX < 0)
              startX = 0;
            else if (startX > MAXX(input))
              startX = MAXX(input);

            startY = (int) mouseInfo->image_y[i];
            if (startY < 0)
              startY = 0;
            else if (startY > MAXY(input))
              startY = MAXY(input);

            if ( num_polylines > 0 )
            {
              startX = polyline_buf[0][num_polylines-1];
              startY = polyline_buf[1][num_polylines-1];
            }

            begin = 1;
        }
        else if ((mouseInfo->buttonMask[i] & IMAGE_Button1Mask) &&
                 (mouseInfo->buttonMask[i] & IMAGE_ReleaseMask))
        end = 1;
      }

      /* draw lines and build structures based on the event */
      if (begin)
      {
        begin = 0;
      }
      else  /* Not at the beginning, rubber band mode */
      {
          /* undraw previous line */
          sprintf(command, CMD_STR,
              "image_add_xor_line",
               iv_id->scene_id,
               imageName,
               (float) startX,
               (float) startY,
               (float) endX,
               (float) endY  );
          add_command(command, clibuf, 0);
      }

      /* clamp pick to be inside image */
      endX = (int) mouseInfo->image_x[mouseInfo->nEvents-1];
      if (endX < 0)
          endX = 0;
      else if (endX > MAXX(input))
          endX = MAXX(input);

      endY = (int) mouseInfo->image_y[mouseInfo->nEvents-1];
      if (endY < 0)
          endY = 0;
      else if (endY > MAXY(input))
          endY = MAXY(input);

      /* rubber band mode */
      /* draw new line if no button up */
      sprintf(command, CMD_STR,
              "image_add_xor_line",
              iv_id->scene_id,
              imageName,
              (float) startX,
              (float) startY,
              (float) endX,
              (float) endY);
      add_command(command, clibuf, 0);
      flush_command_buffer(clibuf);

      if (end)  /* process a completed segment */
      {
          length = ((startX - endX) * (startX - endX)) +
                   ((startY - endY) * (startY - endY));
          if (length > 0.00001)
            length = sqrt(length);
          else
            length = 1.0;
          npixels = (int) length + 0.5;

          /*
           * add line to list
           */
          if ( num_polylines == 0 )  /* start at first pick */
          {
              /* initial mouse down */
              polyline_buf[0][num_polylines  ] = startX;
              polyline_buf[1][num_polylines++] = startY;
              /* first let-up */
              polyline_buf[0][num_polylines  ] = endX;
              polyline_buf[1][num_polylines++] = endY;
          }
          else  /* add to existing list */
          {
              /* make last point the first for next time */
              startX = endX;
              startY = endY;
          }
          polyline_buf[0][num_polylines  ] = endX;
          polyline_buf[1][num_polylines++] = endY;

          /*
           * process output scatter field for polyline
           */
          fill_field ( poly, polyline_buf, num_polylines, MAXY(input) );

          return(1);

      } /* end case */
      else
      {
          /* don't fire field port for every rubber-band move */
          AVSmark_output_unchanged("Polyline Output");
      }
    }
  }

  /*
   * Process the attention command button
   */
  if (AVSparameter_changed("set pick mode"))
  {
    if (imageName[0] != '\0')
    {
      sprintf(command, "image_set_pick_mode \"polyline\"");
      add_command(command, clibuf, 1);
    }
  }

  return(1);
}

/**********************************************************/
add_command(command, clibuf, flush)
char        *command;
CLIbuffer *clibuf;
int       flush;
{
  int len;

  len = strlen(command) + 1;
  if ((CLI_BUFFER_SIZE - (clibuf->bptr - clibuf->buffer)) < len)
    flush_command_buffer(clibuf);

  strcpy(clibuf->bptr, command);
  clibuf->bptr += len;
  *(clibuf->bptr - 1) = '\n';

  if (flush)
    flush_command_buffer(clibuf);
} 

/**********************************************************/
flush_command_buffer(clibuf)
CLIbuffer *clibuf;
{
  char *dummy;

  if (clibuf->bptr != clibuf->buffer)
  {
    *(clibuf->bptr) = '\0';
    AVScommand("kernel", clibuf->buffer, &dummy, &dummy);
    clibuf->bptr = clibuf->buffer;
  }
}
/**********************************************************/
fill_field( poly, polyline_buf, num_polylines, y_size )

    AVSfield_float  **poly;      /* output polyline field */
    int       polyline_buf[2][MAX_POLYLINE];
    int       num_polylines;
    int       y_size;
{
    int dims[3];
    int i;

    dims[0] = num_polylines;
    if ( *poly ) AVSfield_free( *poly );
    *poly = (AVSfield_float *) AVSdata_alloc(
            "field 1D 3-space irregular scalar float", dims);

    for ( i=0; i< dims[0]; i++ )
    {
        (*poly)->data[i] = 1.0;  /* ignore data for now */
        (*poly)->points[ 0 * dims[0] + i] = (float) polyline_buf[0][i];
        (*poly)->points[ 1 * dims[0] + i] =
               (float)y_size - (float) polyline_buf[1][i];
        (*poly)->points[ 2 * dims[0] + i] = 0.0;  /* Z=0, really 2D */
    }
}

/**********************************************************/

#ifdef sep_exe
AVSinit_modules()
{
  AVSmodule_from_desc(polyline_desc);
}
#endif


