/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/colormap.h>
/* IAC CODE CHANGE : #include <math.h>  */
#include <avs/avs_math.h>
#include "separate.h"

/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int QUERY_TILE_desc()
{

	int in_port, out_port, param;
	extern int QUERY_TILE_compute();

	AVSset_module_name("QUERY TILE", MODULE_MAPPER);
	AVSset_module_flags(COOPERATIVE);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("input_field", 
		"field uniform float", REQUIRED);

	in_port = AVScreate_input_port("slice axis", "string", REQUIRED);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("geom_output", "geom");

	/* Parameter Specifications */

	param = AVSadd_parameter("X Point", "integer", 1, 1, 256);
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("Y Point", "integer", 1, 1, 256);
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("Z Point", "integer", 1, 1, 256);
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("Query", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");

	param = AVSadd_parameter("Answer", "string_block", NULL, NULL, NULL);
	AVSconnect_widget(param, "textblock");
	AVSadd_parameter_prop(param, "width", "integer", 4);
	AVSadd_parameter_prop(param, "height", "integer", 1);
 
        param = AVSadd_float_parameter("Cursor Red", 1.0, 0.0, 1.0);
        AVSconnect_widget(param, "slider");
 
        param = AVSadd_float_parameter("Cursor Green", 1.0, 0.0, 1.0);
        AVSconnect_widget(param, "slider");
 
        param = AVSadd_float_parameter("Cursor Blue", 1.0, 0.0, 1.0);
        AVSconnect_widget(param, "slider");
 
        param = AVSadd_float_parameter("Cursor Z", 100.0, 0.0, FLOAT_UNBOUND);
        AVSconnect_widget(param, "typein_real");
 
	AVSset_compute_proc(QUERY_TILE_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int QUERY_TILE_compute(input_field, input_slice_axis, geom_output,
	 xpt, ypt, zpt, query, answer, red, green, blue, z)
AVSfield_float *input_field;
char *input_slice_axis;
GEOMedit_list *geom_output;
int xpt;
int ypt;
int query;
char *answer;
float *red;
float *green;
float *blue;
float *z;
{
GEOMobj *obj;
static float verts[6];
static float colors[6];
static char str[64];
static int cursor_visible = 0;
float x0, y0, z0, x1, y1, z1; 
float x2, y2, z2, x3, y3, z3; 
int xmin_index, ymin_index, zmin_index, xmax_index, ymax_index, zmax_index; 
int slice_axis;
register int i, j, index, xcoord_index, ycoord_index, zcoord_index,
	xindex, yindex, zindex;

#define INPUT input_field->data[index]

#define XCOORD_MIN input_field->points[0]
#define XCOORD_MAX input_field->points[1]
#define YCOORD_MIN input_field->points[2]
#define YCOORD_MAX input_field->points[3]
#define ZCOORD_MIN input_field->points[4]
#define ZCOORD_MAX input_field->points[5]

#define NX ((int) (XCOORD_MAX - XCOORD_MIN + 1.0))
#define NY ((int) (YCOORD_MAX - YCOORD_MIN + 1.0)) 
#define NZ ((int) (ZCOORD_MAX - ZCOORD_MIN + 1.0)) 

#define SLICE_XAXIS 1
#define SLICE_YAXIS 2
#define SLICE_ZAXIS 3
 
if ((!query) && (!cursor_visible))
	return(0);

if (query)
	{

 
	if (!strcmp(input_slice_axis, "X"))
		slice_axis = SLICE_XAXIS;
	else if (!strcmp(input_slice_axis, "Y"))
		slice_axis = SLICE_YAXIS;
	else if (!strcmp(input_slice_axis, "Z"))
		slice_axis = SLICE_ZAXIS;
	else
		{
		AVSerror("Slice axis must be X or Y or Z.");
		return(0);
		}
	 
	obj = GEOMcreate_obj(GEOM_POLYTRI, GEOM_NULL);

	xcoord_index = xpt;
	xmin_index = (int) XCOORD_MIN;
	xmax_index = (int) XCOORD_MAX;

	if (xcoord_index < xmin_index)
		xcoord_index = xmin_index;
	else if (xcoord_index > xmax_index)
		xcoord_index = xmax_index;
	xindex = xcoord_index - xmin_index;
	if (NX > 1)
		{
		AVSparameter_visible("X Point", 1);
		AVSmodify_parameter("X Point",
			 AVS_VALUE | AVS_MINVAL | AVS_MAXVAL,
			xcoord_index, xmin_index, xmax_index);
		}
	else
		AVSparameter_visible("X Point", 0);

	ycoord_index = ypt;
	ymin_index = (int) YCOORD_MIN;
	ymax_index = (int) YCOORD_MAX;

	if (ycoord_index < ymin_index)
		ycoord_index = ymin_index;
	else if (ycoord_index > ymax_index)
		ycoord_index = ymax_index;
	yindex = ycoord_index - ymin_index;
	if (NY > 1)
		{
		AVSparameter_visible("Y Point", 1);
		AVSmodify_parameter("Y Point",
			 AVS_VALUE | AVS_MINVAL | AVS_MAXVAL,
			ycoord_index, ymin_index, ymax_index);
		}
	else
		AVSparameter_visible("Y Point", 0);
		
	zcoord_index = zpt;
	zmin_index = (int) ZCOORD_MIN;
	zmax_index = (int) ZCOORD_MAX;

	if (zcoord_index < zmin_index)
		zcoord_index = zmin_index;
	else if (zcoord_index > zmax_index)
		zcoord_index = zmax_index;
	zindex = zcoord_index - zmin_index;
	if (NZ > 1)
		{
		AVSparameter_visible("Z Point", 1);
		AVSmodify_parameter("Z Point",
			 AVS_VALUE | AVS_MINVAL | AVS_MAXVAL,
			zcoord_index, zmin_index, zmax_index);
		}
	else
		AVSparameter_visible("Z Point", 0);
		
	index = xindex + yindex * NX + zindex * NX * NY;

	sprintf(str, "tile(%d,%d,%d) = %g\n",
		 xcoord_index, ycoord_index, zcoord_index, INPUT);
	AVSmodify_parameter("Answer", AVS_VALUE, str, NULL, NULL);
	 
	obj = GEOMcreate_obj(GEOM_POLYTRI, GEOM_NULL);

	colors[0] = colors[3] = *red;
	colors[1] = colors[4] = *green;
	colors[2] = colors[5] = *blue; 

	/* draw cross-hair -- ONE SIDE */

	if (slice_axis == SLICE_ZAXIS)
		{
		x0 = xmin_index - .5;
		x1 = xmax_index + .5;
		y0 = y1 = ycoord_index;

		z0 = z1 = zmax_index + .5;

		x2 = x3 = xcoord_index;
		y2 = ymin_index - .5;
		y3 = ymax_index + .5;

		z2 = z3 = zmax_index + .5;
		}
	else if (slice_axis == SLICE_YAXIS)
		{
		x0 = xmin_index - .5;
		x1 = xmax_index + .5;
		z0 = z1 = zcoord_index;

		y0 = y1 = ymax_index + .5;

		x2 = x3 = xcoord_index;
		z2 = zmin_index - .5;
		z3 = zmax_index + .5;

		y2 = y3 = ymax_index + .5;
		}
	else if (slice_axis == SLICE_XAXIS)
		{
		y0 = ymin_index - .5;
		y1 = ymax_index + .5;
		z0 = z1 = zcoord_index;

		x0 = x1 = xmax_index + .5;

		y2 = y3 = ycoord_index;
		z2 = zmin_index - .5;
		z3 = zmax_index + .5;

		x2 = x3 = xmax_index + .5;
		}
	
	verts[0] = x0;
	verts[1] = y0;
	verts[2] = z0;
	verts[3] = x1;
	verts[4] = y1;
	verts[5] = z1;

	GEOMadd_disjoint_line(obj, verts, colors, 2, GEOM_COPY_DATA);

	verts[0] = x2;
	verts[1] = y2;
	verts[2] = z2;
	verts[3] = x3;
	verts[4] = y3;
	verts[5] = z3;

	GEOMadd_disjoint_line(obj, verts, colors, 2, GEOM_COPY_DATA);

	/* draw cross-hair -- OTHER SIDE */

	if (slice_axis == SLICE_ZAXIS)
		{
		z0 = z1 = zmin_index - .5;
		z2 = z3 = zmin_index - .5;
		}
	else if (slice_axis == SLICE_YAXIS)
		{
		y0 = y1 = ymin_index - .5;
		y2 = y3 = ymin_index - .5;
		}
	else if (slice_axis == SLICE_XAXIS)
		{
		x0 = x1 = xmin_index - .5;
		x2 = x3 = xmin_index - .5;
		}
	
	verts[0] = x0;
	verts[1] = y0;
	verts[2] = z0;
	verts[3] = x1;
	verts[4] = y1;
	verts[5] = z1;

	GEOMadd_disjoint_line(obj, verts, colors, 2, GEOM_COPY_DATA);

	verts[0] = x2;
	verts[1] = y2;
	verts[2] = z2;
	verts[3] = x3;
	verts[4] = y3;
	verts[5] = z3;

	GEOMadd_disjoint_line(obj, verts, colors, 2, GEOM_COPY_DATA);

	*geom_output = GEOMinit_edit_list(*geom_output);
	GEOMedit_geometry(*geom_output, "query_object", obj);
        GEOMedit_visibility(*geom_output, "query_object", 1); 
	cursor_visible = 1;
	GEOMdestroy_obj(obj);
	}
else                    /* delete mesh */
	{
	if (cursor_visible)
		{
        	GEOMedit_visibility(*geom_output, "query_object", -1);
		cursor_visible = 0;
		}
	}
return(1);
}

#ifdef SEPARATE_MODULES

/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
QUERY_TILE_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
AVSinit_from_module_list(mod_list, NMODS);
}

#endif

