/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include "separate.h"
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int RESET_desc()
{

	int in_port, out_port, param, iresult;
	extern int RESET_compute();

	AVSset_module_name("RESET", MODULE_MAPPER);
	AVSset_module_flags(COOPERATIVE);

	/* Parameter Specifications                */
        param = AVSadd_float_parameter("background red", 0.0, 0.0, 1.0);
        AVSconnect_widget(param,"slider");
 
        param = AVSadd_float_parameter("background green", 0.0, 0.0, 1.0);
        AVSconnect_widget(param,"slider");
 
        param = AVSadd_float_parameter("background blue", 0.0, 0.0, 1.0);
        AVSconnect_widget(param,"slider");
 
        param = AVSadd_float_parameter("shrink factor", .85, 0.5, 1.0);
        AVSconnect_widget(param,"dial");
 
	param = AVSadd_parameter("reset now", "oneshot", 1, 0, 1);
	AVSconnect_widget(param, "oneshot");

	AVSset_compute_proc(RESET_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int RESET_compute(red, green, blue, shrink, reset)
float *red;
float *green;
float *blue;
float *shrink;
int reset;
{

char *output_buffer;			/* pointer to AVS output buffer */
char *error_buffer;			/* pointer to AVS error buffer */
static char str[1024];			/* string for AVS CLI commands */
static int firsttime = 1;

float camera_size;

#define CMD AVScommand("kernel", str, &output_buffer, &error_buffer)  

if (firsttime)		 /* don't reset when first instantiated in a network */
	{
	firsttime = 0;
	return(0);
	}
if (
	(AVSparameter_changed("background red")) ||
	(AVSparameter_changed("background green")) ||
	(AVSparameter_changed("background blue")) 
	)
	{
	sprintf(str, "geom_set_background %g %g %g", *red, *green, *blue); CMD;
	return(1);
	}

/* Cameras operate on a 5 point scale, so a camera size of 5.0 means that
the geometry fills the screen (normalized).  A camera size of 4.0 zooms
in and a camera size of 10.0 zooms out for a 50% reduction. 
Here, allow camera sizes between 5 and 10, or shrink factors between
.5 and 1.0 */

camera_size = 5.0 + (1.0 - *shrink) * 10.0; 

if ((reset) || (AVSparameter_changed("shrink factor")))
	{
	sprintf(str,
"geom_reset\ngeom_normalize\ngeom_set_camera_params -wsize %g\ngeom_refresh\n",
		camera_size); CMD;
	return(1);
	}
return(0);
}
 
#ifdef SEPARATE_MODULES 

/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
static int ((*mod_list[])()) = {
	RESET_desc
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}

#endif

