/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/colormap.h>
/* IAC CODE CHANGE : #include <math.h>  */
#include <avs/avs_math.h>
#include "separate.h"

/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int TEXT_TO_GEOM_desc()
{

	int in_port, out_port, param;
	extern int TEXT_TO_GEOM_compute();

	AVSset_module_name("TEXT TO GEOM", MODULE_MAPPER);
	AVSset_module_flags(COOPERATIVE);

	/* Input Port Specifications               */

	in_port = AVScreate_input_port("input_string", "string",
		REQUIRED);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("geom_output", "geom");

	/* Parameter Specifications */

	param = AVSadd_float_parameter("x ref point", 0.0,
		FLOAT_UNBOUND, FLOAT_UNBOUND); 
	AVSconnect_widget(param,"typein_real");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	param = AVSadd_float_parameter("y ref point", 0.0,
		FLOAT_UNBOUND, FLOAT_UNBOUND); 
	AVSconnect_widget(param,"typein_real");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	param = AVSadd_float_parameter("z ref point", 0.0,
		FLOAT_UNBOUND, FLOAT_UNBOUND); 
	AVSconnect_widget(param,"typein_real");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	param = AVSadd_float_parameter("x offset", 0.0,
		FLOAT_UNBOUND, FLOAT_UNBOUND); 
	AVSconnect_widget(param,"typein_real");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	param = AVSadd_float_parameter("y offset", 0.0,
		FLOAT_UNBOUND, FLOAT_UNBOUND); 
	AVSconnect_widget(param,"typein_real");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	param = AVSadd_float_parameter("z offset", 0.0,
		FLOAT_UNBOUND, FLOAT_UNBOUND); 
	AVSconnect_widget(param,"typein_real");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	param = AVSadd_float_parameter("height", 0.07, 0.0, FLOAT_UNBOUND); 
	AVSconnect_widget(param,"typein_real");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	param = AVSadd_float_parameter("red", 1.0, 0.0, 1.0); 
	AVSconnect_widget(param,"slider");

	param = AVSadd_float_parameter("green", 1.0, 0.0, 1.0); 
	AVSconnect_widget(param,"slider");

	param = AVSadd_float_parameter("blue", 1.0, 0.0, 1.0); 
	AVSconnect_widget(param,"slider");

	param = AVSadd_parameter("font", "integer", 1, 0, 21);
	AVSconnect_widget(param, "islider");

	param = AVSadd_parameter("background rectangle", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	AVSadd_parameter_prop(param, "width", "integer", 4);

	param = AVSadd_parameter("title string", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	param = AVSadd_parameter("drop shadow", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	param = AVSadd_parameter("alignment", "choice", 
		"LEFT", "LEFT:CENTER:RIGHT", ":");
	AVSconnect_widget(param, "radio_buttons");
	AVSadd_parameter_prop(param, "width", "integer", 2);

	AVSset_compute_proc(TEXT_TO_GEOM_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int TEXT_TO_GEOM_compute(input_string, geom_output, 
xref, yref, zref, xoffset, yoffset, zoffset, height,
red, green, blue, font, background, title, drop, align)
char *input_string;
GEOMedit_list *geom_output;
float *xref, *yref, *zref;
float *xoffset, *yoffset, *zoffset, *height;
float *red, *green, *blue;
int font, title, background, drop;
char *align;
{

#define stroke 0

GEOMobj *obj;
int label_flags;
int align_output;
static float ref_point[3];
static float offset[3];
static float colors[3];

obj = GEOMcreate_obj(GEOM_LABEL, GEOM_NULL);

if (!strcmp(align, "LEFT"))
	align_output = GEOM_LABEL_LEFT;
else if (!strcmp(align, "CENTER"))
	align_output = GEOM_LABEL_CENTER;
else if (!strcmp(align, "RIGHT"))
	align_output = GEOM_LABEL_RIGHT;

label_flags = GEOMcreate_label_flags(font, title, background, drop,
	align_output, stroke);

ref_point[0] = *xref;
ref_point[1] = *yref;
ref_point[2] = *zref;
offset[0] = *xoffset;
offset[1] = *yoffset;
offset[2] = *zoffset;
colors[0] = *red;
colors[1] = *green;
colors[2] = *blue;
GEOMadd_label(obj, input_string, ref_point, offset, *height,
	colors, label_flags); 
*geom_output = GEOMinit_edit_list(*geom_output);
GEOMedit_geometry(*geom_output, "label_object", obj);
GEOMdestroy_obj(obj);
return(1);
}

#ifdef SEPARATE_MODULES

/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
TEXT_TO_GEOM_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
AVSinit_from_module_list(mod_list, NMODS);
}

#endif

