/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "title" (Mapper) (Subroutine)                            */
/* Author:  Roy Wirthlin                                                 */ 
/* Date Created: Thu May 28 12:49:42 1992                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* input 0 "input float" field OPTIONAL                                  */
/* param 0 "Font Number" islider 0 0 21                                  */
/* param 1 "Drop Shadow" toggle 0 0 1                                    */
/* param 2 "Text Alignment" radio_buttons Center Left:Center:Right :     */
/* param 3 "X Position" slider 0.000000 -1.000000 1.000000               */
/* param 4 "Y Posiiton" slider 0.000000 -1.000000 1.000000               */
/* param 5 "Text Height" slider 0.100000 0.000000 1.000000               */
/* param 6 "Red" slider 0.700000 0.000000 1.000000                       */
/* param 7 "Green" slider 0.700000 0.000000 1.000000                     */
/* param 8 "Blue" dial 0.700000 0.000000 1.000000                        */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/geom.h>
 
/* *****************************************/
/*  Module Specification                   */
/* *****************************************/
int title_spec()
{

	int in_port, out_port, param;
	extern int title_compute();

	AVSset_module_name("Title", MODULE_MAPPER);

	in_port = AVScreate_output_port("Label", "geom", OPTIONAL);

	/* Parameter Specifications                */
	param = AVSadd_float_parameter("Value", 0.000000, FLOAT_UNBOUND, 
		FLOAT_UNBOUND);
	param = AVSadd_parameter("Title String", "string", 0, 0, 0);
	AVSconnect_widget(param, "typein");
	param = AVSadd_parameter("Font Number", "integer", 0, 0, 21);
	AVSconnect_widget(param, "islider");
	param = AVSadd_parameter("Drop Shadow", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Text Alignment", "choice", "Center", 
		"Left:Center:Right", ":");
	AVSconnect_widget(param, "radio_buttons");
	param = AVSadd_float_parameter("X Position", 0.000000, -1.000000, 
		1.000000);
	AVSconnect_widget(param, "slider");
	param = AVSadd_float_parameter("Y Posiiton", 0.000000, -1.000000, 
		1.000000);
	AVSconnect_widget(param, "slider");
	param = AVSadd_float_parameter("Text Height", 0.100000, 0.000000, 
		1.000000);
	AVSconnect_widget(param, "slider");
	param = AVSadd_float_parameter("Red", 0.700000, 0.000000, 1.000000);
	AVSconnect_widget(param, "slider");
	param = AVSadd_float_parameter("Green", 0.700000, 0.000000, 1.000000);
	AVSconnect_widget(param, "slider");
	param = AVSadd_float_parameter("Blue", 0.700000, 0.000000, 1.000000);
	AVSconnect_widget(param, "slider");

	AVSset_compute_proc(title_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/

int title_compute( output_geom, value, Title_String, 
		   Font_Number, Drop_Shadow, Text_Alignment, 
		   X_Position, Y_Posiiton, 
		   Text_Height, Red, Green, Blue)
    GEOMedit_list *output_geom;
    float *value;  
    char *Title_String;
    int Font_Number;
    int Drop_Shadow;
    char *Text_Alignment;
    float *X_Position;
    float *Y_Posiiton;
    float *Text_Height;
    float *Red;
    float *Green;
    float *Blue;
{
    GEOMobj  *label_obj;

    int       float_specified = 0, 
	      label_flags,
	      alignment;

    char     *str_p,
	      str_buf[1024];
    
    float     colors[3], 
	      ref_point[3], 
	      offset[3],
	      extent[6];

    if ( Title_String != (char *)0 )
    {
        /* check for floating point specification in input string */
	str_p = Title_String;
	while ( *str_p && !float_specified)
	{
	   if ( ( *str_p == '%') && *(str_p-1) != '\\')
	       float_specified = 1;
           ++str_p;
	}

	/* create the text string */
	if ( float_specified )
	       sprintf(str_buf, Title_String, *value);
	else
	    strcpy(str_buf, Title_String);

	/* set the colors */
        colors[0] = *Red; 
        colors[1] = *Green; 
        colors[2] = *Blue; 

	/* set the coordinates (in screen coords) */
	offset[0] = 0.;
	offset[1] = 0.;
	offset[2] = 0.;
	extent[0] = -1.;
	extent[1] = -1.;
	extent[2] = -1.;
	extent[3] = 1.;
	extent[4] = 1.;
	extent[5] = 1.;
	ref_point[0] = *X_Position;
	ref_point[1] = *Y_Posiiton;
	ref_point[2] = 0.;

	/* create the label_flags */
	alignment = GEOM_LABEL_CENTER;
	if ( !strcmp(Text_Alignment, "Left") )
	    alignment = GEOM_LABEL_LEFT;
        else if ( !strcmp(Text_Alignment, "Center" ) )
	    alignment = GEOM_LABEL_CENTER;
        else if ( !strcmp(Text_Alignment, "Right" ) )
	    alignment = GEOM_LABEL_RIGHT;
        label_flags = GEOMcreate_label_flags(Font_Number, 1, 0, 
					     Drop_Shadow, alignment, 0);
        /* create label object */
        label_obj = GEOMcreate_label(extent, label_flags);
	GEOMadd_label(label_obj, str_buf, ref_point, offset,
		      *Text_Height, colors, label_flags);
        *output_geom = GEOMinit_edit_list(*output_geom);
	GEOMedit_geometry(*output_geom, "label", label_obj);
    }
    return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/

int ((*filter_mod_list[])()) = {
	title_spec,
};

#define NMODS (sizeof(filter_mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(filter_mod_list, NMODS);
}

