/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <avs/avs.h>
#include <avs/udata.h>
#include <avs/geom.h>
#include "view_share.h"
#include "dtm.h"

int 
Broadcast_Float ( port_id,output_float )
   int port_id;
   float *output_float;
{
   unsigned char msg=FLOAT;

   if ( ( DTMavailWrite ( port_id ) ) && ( ! DTMerrno ) )
   {
#ifdef VERBOSE
printf ( "DTM:\tBroadcast\tfloat\t%f\tportid %d\n", *output_float,port_id );
#endif
      DTMbeginWrite ( port_id,&msg,1 );
      DTMwriteDataset ( port_id,output_float,1,DTM_FLOAT );
      DTMendWrite ( port_id );
      return 0;
   }
   else
   {
      return 1;
   }
}
  
int 
Broadcast_String ( port_id,output_string )
   int port_id;
   char *output_string;
{
   unsigned char msg=STRING;
   int length;

   if ( ( DTMavailWrite ( port_id ) ) && ( ! DTMerrno ) )
   {
      DTMbeginWrite ( port_id,&msg,1 );
      length = strlen ( output_string ) + 1; 
      DTMwriteDataset ( port_id,&length,1,DTM_INT );
      DTMwriteDataset ( port_id,output_string,length,DTM_CHAR );
      DTMendWrite ( port_id );
#ifdef VERBOSE
printf ( "DTM:\tBroadcast\tstring\t\"%s\"\tlength\t%d\tportid %d\n", output_string,length,port_id );
#endif
      return 0;
   }
   else
   {
      return 1;
   }
}

int 
Broadcast_Transform ( port_id, ups_tfx )
   int port_id;
   upstream_transform *ups_tfx ;
{
   unsigned char msg=MATRIX;
   int length;
   char *name;

   if ( ( DTMavailWrite ( port_id ) ) && ( ! DTMerrno ) )
   {
      DTMbeginWrite ( port_id,&msg,1 );
      length = strlen(ups_tfx->object_name) + 2;
      name=(char *)ALLOC_LOCAL(sizeof(char)*length);
      name=(char *)strdup("%");
      strcat(name,ups_tfx->object_name);
      DTMwriteDataset ( port_id,&length,1,DTM_INT );
      DTMwriteDataset ( port_id,name,length,DTM_CHAR );
      DTMwriteDataset ( port_id,(ups_tfx->msxform),16,DTM_FLOAT);
      DTMendWrite ( port_id );
#ifdef VERBOSE
printf ( "DTM:\tBroadcast\tmatrix\t%s\tportid %d\n",name,port_id );
#endif
      FREE_LOCAL(name);
      return 0;
   }
   else
   {
      return 1;
   }

}

int 
Broadcast_Int ( port_id,output_int )
   int port_id;
   int *output_int;
{
   unsigned char msg=INTEGER;

   if ( ( DTMavailWrite ( port_id ) ) && ( ! DTMerrno ) )
   {
#ifdef VERBOSE
printf ( "DTM:\tBroadcast\tinteger\t%d\tportid %d\n", *output_int,port_id );
#endif
      DTMbeginWrite ( port_id,&msg,1 );
      DTMwriteDataset ( port_id,output_int,1,DTM_INT );
      DTMendWrite ( port_id );
      return 0;
   }
   else
   {
      return 1;
   }
}


int 
Broadcast_Geometry ( port_id,output_geom,name )
   int port_id;
   GEOMobj *output_geom;
   char *name;
{
   unsigned char msg=POLYTRIANGLE;
   int length,i,k,total_verts;

   if ( ( DTMavailWrite ( port_id ) ) && ( ! DTMerrno ) )
   {
#ifdef VERBOSE
printf ( "DTM:\tBroadcast\tgeometry\t%s\tportid %d\n",name,port_id );
#endif

      DTMbeginWrite ( port_id,&msg,1 );

      /* Send across object name */
      length=strlen(name) + 1;
      DTMwriteDataset ( port_id,&length,1,DTM_INT );
      DTMwriteDataset ( port_id,name,length,DTM_CHAR );

      /* Send across information description : Normals ? Vertex Colors ? */
      msg=(unsigned char)DATA(output_geom);
      DTMwriteDataset ( port_id,&msg,1,DTM_CHAR );

      /* Indicate number of polytriangle strips */
      DTMwriteDataset ( port_id,&NUM_STRIPS(output_geom),1,DTM_INT );

      /* This info in unnecessary AVS to AVS but is need for AVS to explorer */
      total_verts=0;
      for (k=0; k < NUM_STRIPS(output_geom); k++) 
	 total_verts=total_verts+NUM_VERTS(output_geom);
      DTMwriteDataset ( port_id,&total_verts,1,DTM_INT );

      /* For each strip */
      for (k=0; k < NUM_STRIPS(output_geom); k++)
      {

 	 /* Indicate number of vertices in strip */
	 DTMwriteDataset ( port_id,&NUM_VERTS(output_geom),1,DTM_INT );

	 DTMwriteDataset ( port_id,VERTS(output_geom),
			      3*NUM_VERTS(output_geom),DTM_FLOAT );

         if ( DATA(output_geom) & GEOM_NORMALS )
            DTMwriteDataset ( port_id,NORMALS(output_geom),
			         3*NUM_VERTS(output_geom),DTM_FLOAT );

         if ( DATA(output_geom) & GEOM_VCOLORS )
            DTMwriteDataset ( port_id,COLORS(output_geom),
	 			 3*NUM_VERTS(output_geom),DTM_FLOAT );
      }

/*
      DTMwriteDataset ( port_id,&NUM_PLINES(output_geom),1,DTM_INT );
      for (k=0; k < NUM_PLINES(output_geom); k++)
      {
	 DTMwriteDataset ( port_id,&NUM_PLVERTS(output_geom),1,DTM_INT );

         DTMwriteDataset ( port_id,PLVERTS(output_geom),
		           3*NUM_PLVERTS(output_geom),DTM_FLOAT );

         if ( DATA(output_geom) & GEOM_VCOLORS )
	    DTMwriteDataset ( port_id,PLCOLORS(output_geom),
                              3*NUM_PLVERTS(output_geom),DTM_FLOAT );
      }
*/

      DTMendWrite ( port_id );
      return 0;
   }
   else
   {
      return 1;
   }
}
