/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/

/**********************************************************************
**
**  DEBUG macro routines
**
***********************************************************************/

/*********************************************************************
**
**  $Header: /netdev/dtm/libsrc/RCS/debug.h,v 1.3 1991/08/15 19:10:25 sreedhar Exp $
**
**********************************************************************/

#ifdef RCSLOG

 $Log: debug.h,v $
 * Revision 1.3  1991/08/15  19:10:25  sreedhar
 * Changes for logical portname version
 *
 * Revision 1.2  1991/06/11  15:22:30  sreedhar
 * disclaimer added
 *
 * Revision 1.1  1990/11/08  16:30:41  jefft
 * Initial revision
 *

#endif

#ifdef DEBUGFLOW
#  define	DBGFLOW(s)	fprintf(stderr, s)
#endif

#ifdef DEBUGMSG
#  define	DBGMSG(s)	fprintf(stderr, s)
#  define	DBGINT(s, i)	fprintf(stderr, s, i)
#  define	DBGFLT(s, f)	fprintf(stderr, s, f)
#  define	DBGSTR(s, str)	fprintf(stderr, s, str)
#  define	DBGPTR(s, p)	fprintf(stderr, s, (int)p)
#endif

#ifdef	DEBUG
#  ifndef DEBUGFLOW
#    define	DEBUGFLOW
#    define	DBGFLOW(s)	fprintf(stderr, s)
#  endif
#  ifndef DEBUGMSG
#    define	DEBUGMSG
#    define	DBGMSG(s)	fprintf(stderr, s)
#    define	DBGINT(s, i)	fprintf(stderr, s, i)
#    define	DBGFLT(s, f)	fprintf(stderr, s, f)
#    define	DBGSTR(s, str)	fprintf(stderr, s, str)
#    define	DBGPTR(s, p)	fprintf(stderr, s, (int)p)
#  endif
#endif

#ifndef	DEBUGFLOW
#  define	DBGFLOW(s)
#endif

#ifndef	DEBUGMSG
#  define	DBGMSG(s)
#  define	DBGINT(s, i)
#  define	DBGFLT(s, f)
#  define	DBGSTR(s, str)
#  define	DBGPTR(s, p)
#endif

#define	DTMERR(x)	fprintf( stderr, "%s\n", x )
