/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/

/*************************************************************************
**
**  dtm.h - 
**
*************************************************************************/

/*********************************************************************
**
**  $Header: /netdev/dtm/libsrc/RCS/dtm.h,v 1.12 1991/09/18 15:27:54 jplevyak Exp $
**
**********************************************************************/

#ifdef RCSLOG

 $Log: dtm.h,v $
 * Revision 1.12  1991/09/18  15:27:54  jplevyak
 * Added extern definition for DTMinit()
 *
 * Revision 1.11  91/09/13  17:36:05  sreedhar
 * DTMSYNC, DTMNOSYNC added
 * 
 * Revision 1.10  1991/09/13  15:31:45  jefft
 * fixed DTMHL macro, it should not have taken an arguement.
 *
 * Revision 1.9  1991/09/11  21:09:20  jplevyak
 * Fixed typeo dtm_set_type -> dtm_get_type.
 *
 * Revision 1.8  1991/09/10  15:06:08  jefft
 * cleaned-up message class macros and added standard macros for passing
 * port address (DTMsetAddress and DTMgetAddress).
 *
 * Revision 1.7  1991/08/15  19:10:39  sreedhar
 * Changes for logical portname version
 *
 * Revision 1.5  1991/06/11  15:22:39  sreedhar
 * disclaimer added
 *
 * Revision 1.4  1991/06/07  16:04:51  sreedhar
 * Changes for "Sequence start" message
 *
 * Revision 1.3  1991/05/30  15:43:27  sreedhar
 * recvDataset, sendDataset replaced by readDataset/writeDataset
 *
 * Revision 1.2  1990/11/16  16:04:32  jefft
 * fixed typecast problem with DTMgetType
 *
 * Revision 1.1  90/11/08  16:31:19  jefft
 * Initial revision
 * 

#endif


/* DTM constants */
#define 	DTM_MAX_HEADER			1024


/* standard message classes */
#define		DTMclass			"DTM"
#define 	MSGclass			"MSG"

/* standard tags */
#define 	DTMtitle			"TTL"
#define		DTMtype				"DT"

/* general macros used by other message classes */
#define		dtm_set_class(h, c)	(strcpy((h), (c)), strcat((h), " "))
#define		dtm_compare_class(h, c)		!strncmp((h), (c), strlen(c))
#define		dtm_header_length(h)		(strlen(h)+1)

#define		dtm_set_type(h, t)		dtm_set_int((h), DTMtype, (t))
#define		dtm_get_type(h, t)   ((*(t)=(int)DTM_FLOAT), (dtm_get_int((h), DTMtype,(t))))

#define		dtm_set_title(h, c)		dtm_set_char((h), DTMtitle, (c))
#define		dtm_get_title(h, c, l)		dtm_get_char((h), DTMtitle, (c), (l))

/* DTM class specific macros */
#define		DTMsetClass(h)			dtm_set_class((h), DTMclass)
#define		DTMcompareClass(h)		dtm_compare_class((h), DTMclass)
#define		DTMheaderLength(h)		dtm_header_length
#define		DTMHL				dtm_header_length
#define		DTMsetAddress(h, a)		dtm_set_char((h), "PORT", (a))
#define		DTMgetAddress(h, a, l)		dtm_set_char((h), "PORT", (a), (l))

/* MSG class specific macros */
#define		MSGsetClass(h)			dtm_set_class((h), MSGclass)
#define		MSGcompareClass(h)		dtm_compare_class((h), MSGclass)
#define		MSGheaderLength(h)		dtm_header_length
#define		MSGHL(h)			dtm_header_length


/* standard types supported by DTM */
typedef enum  {
	DTM_CHAR=0,
	DTM_SHORT,
	DTM_INT,
	DTM_FLOAT,
	DTM_DOUBLE,
        DTM_COMPLEX,
        DTM_TRIPLET
	} DTMTYPE;

typedef	enum	{

	WRITEMSG,
	BEGINWRITE,
	WRITEDATASET,
	ENDWRITE

} CALLTYPE ;

typedef	enum	{

	DTMSYNC=0,
	DTMNOSYNC

} DTMqserv ;

struct DTM_TRIPLET {
	int	tag;
	float	x, y, z;
	};



/* commands supported for groups */
typedef enum  {
	DTM_NEW = 1,
	DTM_APPEND,
	DTM_DELETE,
	DTM_DONE
	} DTMCMD;


/* error values, also defined in dtmint.h */
#ifndef	DTMERROR
#  define		DTMERROR	-1

typedef enum  {
	DTMNOERR=0,		/* no error */
	DTMMEM,			/* Out of memory */
	DTMHUH,			/* Unknown port definition */
	DTMNOPORT,		/* No DTM ports available */
	DTMPORTINIT,		/* DTM port not initialized */
	DTMCALL,		/* calling routines in wrong order */
	DTMEOF,			/* EOF error */
	DTMSOCK,		/* Socket error, test errno for more info */
	DTMHOST,		/* That hostname is not found/bad */
	DTMTIMEOUT,		/* Timeout waiting for connection */
	DTMCCONN,		/* DTM cannot connect (network down?) */
        DTMREAD,		/* error returned from system read */
        DTMWRITE,		/* error returned from system write(v) */
        DTMHEADER,		/* Header to long for buffer */

	DTMSDS,			/* SDS error */
	DTMSELECT,		/* Select call error */
	DTMENV			/* Environment not setup */
        } DTMerr;
#endif

typedef	struct	Dtm_set	{

	int	port ;
	int	status ;

} Dtm_set ;

typedef	struct	Sock_set {

	int	sockfd ;
	int	status ;

} Sock_set ;

/* function definitions and extern references */
extern int	DTMmakeInPort();
extern int	DTMmakeOutPort();
extern int	DTMbeginRead();
extern int	DTMbeginWrite();
extern int	DTMreadDataset();
extern int	DTMwriteDataset();
extern int	DTMendRead();
extern int	DTMendWrite();
extern int	DTMdestroyPort();
extern char	*DTMerrmsg();

extern char	*dtm_find_tag();
extern void	dtm_set_char();
extern int	dtm_get_char();
extern void	dtm_set_int();
extern int	dtm_get_int();
extern void	dtm_set_float();
extern int	dtm_get_float();

extern void	DTMsetGroup();
extern int	DTMgetGroup();

extern DTMerr	DTMerrno;
