/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/

/*********************************************************************
**
**  $Header: /netdev/dtm/libsrc/RCS/dtmint.h,v 1.9 1991/09/18 15:28:50 jplevyak Exp $
**
**********************************************************************/

#ifdef RCSLOG

 $Log: dtmint.h,v $
 * Revision 1.9  1991/09/18  15:28:50  jplevyak
 * Added some external definitions for shared functions.
 *
 * Revision 1.8  91/09/13  17:37:37  sreedhar
 * MAX132 instead of MAXBUFSIZE
 * 
 * Revision 1.7  1991/08/15  19:10:53  sreedhar
 * Changes for logical portname version
 *
 * Revision 1.6  1991/06/11  15:22:46  sreedhar
 * disclaimer added
 *
 * Revision 1.5  1991/06/07  16:06:03  sreedhar
 * Changes for sequence start message
 *
 * Revision 1.4  1991/05/30  15:50:58  sreedhar
 * Changes for readMsg/writeMsg internal release
 *
 * Revision 1.3  1991/03/14  23:26:55  jefft
 * removed call to dtm_fatal when errors occur.
 *
 * Revision 1.2  90/11/21  12:35:44  jefft
 * Removed trailing comma from DTM error enum type.
 * 
 * Revision 1.1  90/11/08  16:32:03  jefft
 * Initial revision
 * 

#endif

#define DTM_VERSION	"2.0b9"

#ifndef FALSE
#  define	FALSE	0
#  define	TRUE	!FALSE
#endif

#ifndef	macintosh
#  define	MAX_DTM_PORTS	200
#  define	DISCARDSIZE	16384
#else
#  define	MAX_DTM_PORTS	12
#  define	DISCARDSIZE	4096
#endif

#ifndef	DTMERROR
#  define		DTMERROR	-1

typedef enum  {
	DTMNOERR=0,		/* no error */
	DTMMEM,			/* Out of memory */
	DTMHUH,			/* Unknown port definition */
	DTMNOPORT,		/* No DTM ports available */
	DTMPORTINIT,		/* DTM port not initialized */
	DTMCALL,		/* calling routines in wrong order */
	DTMEOF,			/* EOF error */
	DTMSOCK,		/* Socket error, test errno for more info */
	DTMHOST,		/* That hostname is not found/bad */
	DTMTIMEOUT,		/* Timeout waiting for connection */
	DTMCCONN,		/* DTM cannot connect (network down?) */
	DTMREAD,		/* error returned from system read */
	DTMWRITE,		/* error returned from system write(v) */
	DTMHEADER, 		/* Header to long for buffer */
	DTMSDS,			/* SDS error */
	DTMSELECT,		/* Select call error */
	DTMENV			/* Environment not setup */
        } DTMerr;
#endif

#if defined SGI || defined CRAY
  typedef char *	VOIDPTR;
#else
  typedef void *	VOIDPTR;
#endif

#ifdef  CRAY
#  define       STDINT(x)       (x <<= 32)
#  define       LOCALINT(x)     (x >>= 32)
#else
#  define       STDINT(x)	x = htonl(x)
#  define       LOCALINT(x)	x = ntohl(x)
#endif

#ifndef	NULL
#define	NULL	0
#endif

#define DTMSTD		0
#define DTMLOCAL	1
#define	INPORTTYPE	0	/* input port type 	*/
#define	OUTPORTTYPE	1	/* output port type 	*/
#define	PNAMELEN	64	/* max length of portname	*/
#define	REFNAMELEN	32	/* max length of reference name given by
				   nameserver.
				*/
#define	MAX132	132		/* max space of 132 */
#define	SEP	" "		/* blank as separator */
#define	COLON	":"		/* colon as separator */	


/* Port structures */

typedef	struct sockaddr_in	S_ADDR;

typedef	struct	Port	{

	unsigned long	nethostid ;
	unsigned short	portid ;

} Port ;

typedef	struct	Outport	{

	S_ADDR	sockaddr ;
				/* Socket family, netid/hostid, portid */

	int	connfd ;	/* connection fd */
	int	availwrite ;	/* port availability for write */	
	int	seqstart ;	/* "Sequence start" message sent or not */
	
} Outport ;
	
typedef	struct {

	S_ADDR	sockaddr ;	
				/* Socket family, netid/hostid, portid */
	int	sockfd ;	/* 
					Main socket of port 
					Outport - UDP socket
					Inport  - TCP socket
				*/
	
	char	portname[ PNAMELEN ] ;	/* Logical portname */

	int	porttype ;	/* Input or Output port	*/
	int	qservice ;	/* Quality of service - actually qserv enum */

/*	Input port specific data	*/

	int	connfd ;	/* connection fd */
	int	blocklen ;	/* records no. of bytes read */

/*	Output port specific data	*/

	int	count ;		/* no. of ports associated with this outport */
	Outport *out ;		/* Out port specific structure   */

} DTMPORT ;

extern DTMPORT	*DTMpt[];
extern int	(*DTMconvertRtns[])();
extern DTMerr	DTMerrno;
extern char	*dtm_discard;

extern void	dtm_fatal();

extern int	init_sockaddr( 
				/* S_ADDR *	sockaddr,		*/
				/* char *	portname,		*/
				/* int	*	pfLogicalName 	*/ );

#define	NOT_LOGICAL_NAME	FALSE
#define	LOGICAL_NAME		TRUE

extern int	dtm_socket_init( 
				/* S_ADDR *	sockaddr,		*/
				/* int		porttype,		*/
				/* int		fLogicalName	*/ );

extern	char *	dtm_get_naddr(
				/* S_ADDR *	sockaddr,		*/	
				/* int	*	fd,				*/ );
extern	char * 	dtm_get_refname( /* void */ );
