/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/

/*********************************************************************
**
**  $Header: /netdev/dtm/libsrc/RCS/dtmmisc.c,v 1.4 1991/06/11 15:19:36 sreedhar Exp $
**
**********************************************************************/

#ifdef RCSLOG

 $Log: dtmmisc.c,v $
 * Revision 1.4  1991/06/11  15:19:36  sreedhar
 * disclaimer added
 *
 * Revision 1.3  1991/05/14  14:13:48  jefft
 * modified dtm_set_char to delimit string with "'"
 *
 * Revision 1.2  1991/04/29  16:44:56  jefft
 * increased length of num array in dtm_set_float
 *
 * Revision 1.1  90/11/08  16:32:18  jefft
 * Initial revision
 * 

#endif


#include	<stdio.h>
#include	<string.h>
#include	<sys/types.h>
#include	<netdb.h>
#include	<netinet/in.h>

#include	"debug.h"
#include	"dtm.h"


extern int	atoi();
extern double	atof();

#define		min(a, b)	(((a) <= (b)) ? (a) : (b))


/*************************************************************************
**
**  Header Utilitiy Functions
**
**************************************************************************/

void dtm_set_char(h, tag, s)
  char	*h, *tag, *s;
{

  strcat(h, tag);  strcat(h, " '");
  strcat(h, s);    strcat(h, "' ");
}


void dtm_set_int(h, tag, x)
  char	*h, *tag;
  int	x;
{
  char	num[8];

  strcat(h, tag);  strcat(h, " ");

  sprintf(num, "%d ", x);
  strcat(h, num);
}


void dtm_set_float(h, tag, x)
  char	*h, *tag;
  float	x;
{
  char	num[20];

  strcat(h, tag);  strcat(h, " ");

  sprintf(num, "%f ", x);
  strcat(h, num);
}


char *dtm_find_tag(h, tag)
  char	*h, *tag;
{
  int	len;

  len = strlen(tag);

  while ((h = strchr(h, ' ')) != NULL)  {
    h++;
    if (!strncmp(h, tag, len) && *(h+len) == ' ')
      return h;
    }

  return NULL;
}


int dtm_get_char(h, tag, s, l)
  char	*h, *tag, *s;
  int	l;
{

  /* set NULL string incase tag does not exist */
  *s = '\0';

  /* decrement length to save space for final NUL */
  l -= 1;

  /* no tag return error */
  if ((h = dtm_find_tag(h, tag)) == NULL)
    return DTMERROR;

  /* no field available, return error */
  if ((h = strchr(h, '\'')) == NULL)
    return DTMERROR;
  else
    h += 1;

  if ((tag = strchr(h, '\'')) == NULL)  {
    strncpy(s, h, min(strlen(h)+1, l));
    *(s+min(strlen(h)+1, l)) = '\0';
    }
  else  {
    strncpy(s, h, min(tag-h, l));
    *(s+min(tag-h, l)) = '\0';
    }

  return 0;
}


int dtm_get_int(h, tag, x)
  char	*h, *tag;
  int	*x;
{

  /* no tag return error */
  if ((h = dtm_find_tag(h, tag)) == NULL)
    return DTMERROR;

  /* no field available, return error */
  if ((h = strchr(h, ' ')) == NULL)
    return DTMERROR;
  else
    h += 1;

  *x = atoi(h);

  return 0;
}


int dtm_get_float(h, tag, x)
  char	*h, *tag;
  float	*x;
{

  /* no tag return error */
  if ((h = dtm_find_tag(h, tag)) == NULL)
    return DTMERROR;

  /* no field available, return error */
  if ((h = strchr(h, ' ')) == NULL)
    return DTMERROR;
  else
    h += 1;

  *x = atof(h);

  return 0;
}


#ifdef	NONO
void DTMsetType(h, type)
  char		*h;
  DTMTYPE	type;
{
  char	num[8];

  strcat(h, DTMtype); strcat(h, " ");

  sprintf(num, "%d ", type);
  strcat(h, num);
}


DTMTYPE DTMgetType(h)
  char	*h;
{
  char	*f;

  if ((f = dtm_find_tag(h, DTMtype)) != NULL)
    return (DTMTYPE)atoi(f);
  else
    return DTM_FLOAT;
}


void DTMsetGroup(h, cmd, parent, self)
  char		*h, *parent, *self;
  DTMCMD	cmd;
{
  char		num[12];

  strcat(h, "GRP ");
  sprintf(num, "%d ", (int)cmd);
  strcat(h, num);
  if (parent != NULL)
    strcat(h, parent);
  strcat(h, " ");
  if (self != NULL)
    strcat(h, self);
  strcat(h, " ");
}


int DTMgetGroup(h, cmd, parent, self)
  char		*h, *parent, *self;
  DTMCMD	*cmd;
{
  int		len;

  *self = *parent = '\0';

  if ((h = dtm_find_tag(h, "GRP")) == NULL)
    return DTMERROR;

  h = strchr(h, ' ')+1;

  /* get DTM command */
  *cmd = (DTMCMD)atoi(h);
  h = strchr(h, ' ')+1;

  /* get parent name */
  if (*h != ' ')  {
    len = strchr(h, ' ')-h;
    strncpy(parent, h, len);
    *(parent+len) = '\0';
    }
  else
    *parent = '\0';
  
  h = strchr(h, ' ')+1;

  /* get self name */
  if (*h != ' ')  {
    len = strchr(h, ' ')-h;
    strncpy(self, h, len);
    *(self+len) = '\0';
    }
  else
    *self = '\0';

  return 1;
}
#endif
