/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <avs/avs.h>
#include <avs/geom.h>
#include "dtm.h"
#include "view_share.h"

void Listen (listen_id,local_int,local_float,local_string,output_tfx)
   int *listen_id;
   int *local_int;
   float *local_float;
   char *local_string;
   GEOMedit_list *output_tfx;
{
   int i,length,k,info,num_strips,num_verts,total_verts;
   float *matrix=NULL,*colors=NULL,*verts=NULL,*normals=NULL;
   char *objname;
   GEOMobj *output_object;
   unsigned char token;

   for ( i=0;i<MAX_CONNECTS;i++ ) 
      if ( ( listen_id[i] ) && 
	   ( DTMavailRead ( listen_id[i] ) ) && 
	   ( ! DTMerrno ) )
      {
         DTMbeginRead ( listen_id[i],&token,1);

         switch (token)
         {
            case INTEGER : 
               DTMreadDataset ( listen_id[i],local_int,1,DTM_INT );
               Output(1,0,0,0,local_int,local_float,local_string,output_tfx);
	       MOD_PARAM("Local Integer",*local_int);
#ifdef VERBOSE
printf ( "DTM:\tReceive\t\tinteger\t%d\tportid %d\n", *local_int,listen_id[i] );
#endif
               break;

            case FLOAT  :  
	       DTMreadDataset ( listen_id[i],local_float,1,DTM_FLOAT );
	       Output(0,1,0,0,local_int,local_float,local_string,output_tfx);
	       MOD_FLOAT_PARAM("Local Float",(double)(*local_float));
#ifdef VERBOSE
printf ( "DTM:\tReceive\t\tfloat\t%f\tportid %d\n", *local_float,listen_id[i] );
#endif
               break;

	    case STRING :  
	       DTMreadDataset ( listen_id[i],&length,1,DTM_INT );
	       if (local_string) FREE_LOCAL(local_string);
	       local_string = (char *)ALLOC_LOCAL(sizeof(char)*length);
	       DTMreadDataset ( listen_id[i],local_string,length,DTM_CHAR );
	       Output(0,0,1,0,local_int,local_float,local_string,output_tfx);
	       MOD_PARAM("Local String",local_string);
#ifdef VERBOSE
printf ( "DTM:\tReceive\t\tstring\t\"%s\"\tlength\t%d\tportid %d\n", local_string,length,listen_id[i] );
#endif
               break;

            case MATRIX : 
               DTMreadDataset ( listen_id[i],&length,1,DTM_INT );
	       objname=(char *)ALLOC_LOCAL(sizeof(char)*length);
               DTMreadDataset ( listen_id[i],objname,length,DTM_CHAR );
	       matrix=(float *)ALLOC_LOCAL(16*sizeof(float));
               DTMreadDataset ( listen_id[i],matrix,16,DTM_FLOAT );
               *output_tfx = GEOMinit_edit_list(*output_tfx);
	       GEOMedit_set_matrix(*output_tfx,objname,matrix);
	       Output(0,0,0,1,local_int,local_float,local_string,output_tfx);
#ifdef VERBOSE
printf ( "DTM:\tReceive\t\tmatrix\t%s\tportid %d\n",objname,listen_id[i] );
#endif
	       FREE_LOCAL(objname);
	       FREE_LOCAL(matrix);
               break;

            case POLYTRIANGLE :
	       /* create output object */
	       output_object=(GEOMobj *)GEOMcreate_obj(GEOM_POLYTRI,GEOM_NULL );

	       /* get object name */
               DTMreadDataset ( listen_id[i],&length,1,DTM_INT );
	       objname=(char *)ALLOC_LOCAL(sizeof(char)*length);
               DTMreadDataset ( listen_id[i],objname,length,DTM_CHAR );
	       
	       /* get what info desc */
	       DTMreadDataset ( listen_id[i],&token,1,DTM_CHAR );
	       info=(int)token;

               /* get number of strips */
	       DTMreadDataset ( listen_id[i],&num_strips,1,DTM_INT );

               /* get dummy explorer data */
	       DTMreadDataset ( listen_id[i],&total_verts,1,DTM_INT );

	       /* add each strip */
	       for (k=0; k < num_strips; k ++ )
	       {
		  /* get number of vertices */
		  DTMreadDataset ( listen_id[i],&num_verts,1,DTM_INT );

		  /* get vertices */
		  if (verts) FREE_LOCAL(verts);
		  verts=(float *)ALLOC_LOCAL(num_verts*sizeof(float)*3);
		  DTMreadDataset ( listen_id[i],verts,num_verts*3,DTM_FLOAT );

		  /* get normals */
		  if (info & GEOM_NORMALS )
		  {
		     if (normals) FREE_LOCAL(normals);
		     normals=(float *)ALLOC_LOCAL(num_verts*sizeof(float)*3);
		     DTMreadDataset ( listen_id[i],normals,num_verts*3,DTM_FLOAT );
                  }

		  /* get colors */
		  if (info & GEOM_VCOLORS )
		  {
		     if (normals) FREE_LOCAL(colors);
		     colors=(float *)ALLOC_LOCAL(num_verts*sizeof(float)*3);
		     DTMreadDataset ( listen_id[i],colors,num_verts*3,DTM_FLOAT );
                  }
		  if (info & GEOM_NORMALS)
		     if (info & GEOM_VCOLORS)
		        GEOMadd_polytriangle( output_object,
			   verts,normals,colors,num_verts,GEOM_COPY_DATA );
		     else
			GEOMadd_polytriangle( output_object,
			   verts,normals,GEOM_NULL,num_verts,GEOM_COPY_DATA );
                  else
		     if (info & GEOM_VCOLORS)
			GEOMadd_polytriangle(output_object,
			   verts,GEOM_NULL,colors,num_verts,GEOM_COPY_DATA );
                     else
			GEOMadd_polytriangle( output_object,
			   verts,GEOM_NULL,GEOM_NULL,num_verts,GEOM_COPY_DATA );
               }

/*
	       DTMreadDataset ( listen_id[i],&num_strips,1,DTM_INT);
	       for (k=0; k < num_strips; k++ )
	       {
		  DTMreadDataset ( listen_id[i],&num_verts,1,DTM_INT);

                  if (verts) FREE_LOCAL(verts);
		  verts=(float *)ALLOC_LOCAL(num_verts*sizeof(float));
		  DTMreadDataset ( listen_id[i],verts,num_verts,DTM_FLOAT);

		  if (info & GEOM_VCOLORS)
		  {
                     if (colors) FREE_LOCAL(colors);
		     colors=(float *)ALLOC_LOCAL(num_verts*sizeof(float));
		     DTMreadDataset ( listen_id[i],colors,num_verts,DTM_FLOAT);
		  }     
               }
*/

	       /* initialize output edit list */	
	       *output_tfx = GEOMinit_edit_list(*output_tfx);
	       /* add geometry to edit list */
	       GEOMedit_geometry(*output_tfx,objname,output_object);
	       /* free memory associated with object */
	       GEOMdestroy_obj(output_object);
               /* output new object */
	       Output(0,0,0,1,local_int,local_float,local_string,output_tfx);
#ifdef VERBOSE
printf ( "DTM:\tReceive\t\tgeometry\t%s\tportid %d\n",objname,listen_id[i] );
#endif
	       if (objname) FREE_LOCAL(objname);
	       if (verts)   FREE_LOCAL(verts);
	       if (normals) FREE_LOCAL(normals);
	       if (colors)  FREE_LOCAL(colors);
               break;

            default :
               fprintf (stderr,"DTM: UNKNOWN TOKEN ACROSS SOCKET\t%d\tportid%d\n",token,listen_id[i]);   
               break;
         }

         DTMendRead ( listen_id[i] );
      }
}	
