/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/geom.h>
#include <avs/udata.h>
#include "view_share.h"
#include <string.h>
#include "dtm.h"

int *talk_id,*listen_id;

int main(argc, argv)
	int argc;
	char **argv;
{
   extern int view_share_spec();

   int listen[MAX_CONNECTS],talk[MAX_CONNECTS];
   char *host[MAX_CONNECTS];

   int *float_queue,*int_queue,*string_queue,*tfx_queue,*geom_queue;

   int show_panel;
   char *dummy;
   int i,j,receive,broadcast;
   int local_int,output_int;
   float *local_float,output_float;
   char *local_string,*output_string;
   upstream_transform *ups_tfx,output_transform;
   upstream_geom *ups_geom;

   char portname[20];
   char *errbuf,inbuf[1024],*outbuf;
   GEOMedit_list output_tfx,geom_input;
   GEOMobj *output_geom;
   GEOMedit *edit;
   char *geom_name;

/* --------------- code begins ------------- */

   AVScorout_init(argc,argv,view_share_spec);

   initialize(&talk_id);
   initialize(&listen_id);

   initialize(&float_queue);
   initialize(&geom_queue);
   initialize(&int_queue);
   initialize(&string_queue);
   initialize(&tfx_queue);

   init_local(&local_int,local_float,local_string,&output_tfx);

   credits();

   for (;;)
   {
      AVScorout_input (    &ups_tfx,     &ups_geom,  &geom_input,
			   &show_panel,  &receive,   &broadcast, &dummy,
			   &local_int,   &local_float, &local_string,
   			   &(listen[0]), &(host[0]), &(talk[0]),
   			   &(listen[1]), &(host[1]), &(talk[1]),
			   &(listen[2]), &(host[2]), &(talk[2]),
			   &(listen[3]), &(host[3]), &(talk[3]),
			   &(listen[4]), &(host[4]), &(talk[4]),
			   &(listen[5]), &(host[5]), &(talk[5]),
			   &(listen[6]), &(host[6]), &(talk[6]),
			   &(listen[7]), &(host[7]), &(talk[7]),
			   &(listen[8]), &(host[8]), &(talk[8]) );
      if (NEW_GEO)
      {
	 sprintf ( inbuf,"%%%s",(ups_geom->picked_obj) );
         if (strcmp(inbuf,"%"))
         {
            output_tfx = GEOMinit_edit_list(output_tfx);
            GEOMedit_transform_mode(output_tfx,inbuf,"notify",MODE_FLAGS);
            GEOMedit_selection_mode(output_tfx,inbuf,"notify",MODE_FLAGS);
	    Output(0,0,0,1,&local_int,local_float,local_string,&output_tfx);
         }
      }

      if (NEW_PANEL) 
      {
         if (show_panel)
	 {
            COMMAND("panel \"$Module!Connection List\" -show" )
         }
	 else
	 {
            COMMAND("panel \"$Module!Connection List\" -hide" )
         }
      }

      for ( i=0;i<MAX_CONNECTS;i++ )
      {
	 if ( New_Listen(i,listen[i]) ) 
	    Create_New_Listen (listen_id,i,listen[i]);
	 if ( New_Talk(i,talk[i]) )
	    Create_New_Talk   (talk_id,i,talk[i],host[i]);
      }

      if ( NEW_FLOAT )  
      {
	 output_float= *local_float;
	 for ( i=0; i<MAX_CONNECTS;i++ ) 
	    if (talk_id[i]) float_queue[i]=1;
         Output(0,1,0,0,&local_int,local_float,local_string,&output_tfx);
      }

      if ( NEW_INTEGER )  
      {
	 output_int=local_int;
	 for ( i=0; i<MAX_CONNECTS;i++ ) 
	    if (talk_id[i]) int_queue[i]=1;
         Output(1,0,0,0,&local_int,local_float,local_string,&output_tfx);
      }

      if ( NEW_STRING ) 
      {
	 output_string= strdup(local_string);
	 for ( i=0; i<MAX_CONNECTS;i++ ) 
	    if (talk_id[i]) string_queue[i]=1;
         Output(0,0,1,0,&local_int,local_float,local_string,&output_tfx);
      }

      if ( NEW_TFX )  
      {
	 output_transform= *ups_tfx;
	 for ( i=0; i<MAX_CONNECTS;i++ ) 
	    if (talk_id[i]) tfx_queue[i]=1;
      }

      if ( NEW_GEOM ) 
      {
         j=0;
	 if (output_geom) GEOMdestroy_obj(output_geom);
         if (geom_input) 
	 {
	    output_geom=(GEOMobj *)GEOMcreate_obj(GEOM_POLYTRI,GEOM_NULL );
	    edit=geom_input->l;
	    if (geom_name) FREE_LOCAL(geom_name);
	    geom_name=strdup( edit->name );
            do 
	    {
	       if (! edit->type)
	       {
	          j=j+1;
	          process_geometry ( (edit->data), &output_geom );
               }
               edit=edit->next;
            } while (edit);
         }
	 if (j)
	 {
	    for ( i=0; i<MAX_CONNECTS;i++ ) 
	       if (talk_id[i]) geom_queue[i]= 1;
         }
         else
	 {
	    for ( i=0; i<MAX_CONNECTS;i++ ) 
	       if (talk_id[i]) geom_queue[i]= 0;
         }
      }     

      if ( COMMUNICATE ) 
      {
	 if (broadcast)
	 {
	    for (i=0;i<MAX_CONNECTS;i++)
	    {
               if ( float_queue[i] )  	float_queue[i]=
		  Broadcast_Float ( talk_id[i],&output_float );
               if ( string_queue[i] ) 	string_queue[i]=
		  Broadcast_String ( talk_id[i],output_string );
               if ( int_queue[i] ) 	int_queue[i]=
		  Broadcast_Int ( talk_id[i],&output_int );
               if ( tfx_queue[i] ) 	tfx_queue[i]=
		  Broadcast_Transform ( talk_id[i],&output_transform );
               if ( geom_queue[i] ) 	geom_queue[i]=
		  Broadcast_Geometry ( talk_id[i],output_geom,geom_name );
            }
         }

	 if (receive) Listen (listen_id,&local_int,local_float,local_string,&output_tfx);
      }
      else
      {
         AVScorout_wait();
      }
   }

   /* never exits to this point */

}

initialize(int **array)
{
   int i;

   *array=(int *)ALLOC_LOCAL(MAX_CONNECTS*sizeof(int));
   for (i=0;i<MAX_CONNECTS;i++) (*array)[i]= 0;
}

init_local(local_int,local_float,local_string,output_tfx)
   int *local_int;
   float *local_float;
   char *local_string;
   GEOMedit_list *output_tfx;
{
   *output_tfx = GEOMinit_edit_list(*output_tfx);
   GEOMedit_transform_mode(*output_tfx,"%top","notify",MODE_FLAGS);
   GEOMedit_selection_mode(*output_tfx,"%top","notify",MODE_FLAGS);

   Output(0,0,0,1,local_int,local_float,local_string,output_tfx);
}

credits()
{
   fprintf ( stderr,"\nVIEW SHARE : Module developed at the International AVS Center\n" );
   fprintf ( stderr,"VIEW SHARE :                         North Carolina Supercomputing Center\n" );
   fprintf ( stderr,"VIEW SHARE : Version 1.1 5/12/92 \n\n" );
}
