/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 
 			Copyright (c) 1994 by
 			Kubota Graphics Technology Inc.
 			All Rights Reserved

       module name  : CFD Arrow
       file name    : AllocArea.c
	
*/
#include <stdio.h>
#include <memory.h>
#include <string.h>

/*extern char * malloc();*/

#include <avs/avs.h>
#include <avs/avs_data.h>
#include <avs/field.h>
/*#include <avs/flow.h>*/
#include <avs/geom.h>
#include <avs/colormap.h>

#include "l_vector.h"

GEOMobj * 
create_cone_object(coords, vectors, flags, cones, color_map, value, total, numdiv)
	float          *coords, *vectors, *flags, *cones;
	AVScolormap    *color_map;
	AVSfield_float *value;
	int            total, numdiv;
{
	GEOMobj        *obj;
	float          *verts = NULL, *colors = NULL;
	register float *cr, *cg, *cb, *ch, *cs, *cv, *f, *p, *x, *y, *z, *v1, *v2, *v3;
	int            *plist;
	register int   *ip;
	register int   i, j, k, cindex;

	/*
	 *  set vector coordinate data
	 */
	if ((verts = (float *)malloc(sizeof(float) * total * 3)) == NULL) {
		return(NULL);
	}
#ifdef DEBUG
fprintf(stdout, "verts memory allocate OK\n");
fflush(stdout);
#endif

	for (i = 0, p = verts, 
		 x = coords, y = coords + 1, z = coords + 2,
		 v1 = vectors, v2 = vectors + 1, v3 = vectors + 2;
		 i < total; i++, x += 3, y += 3, z += 3, v1 += 3, v2 += 3, v3 += 3) {
		*(p++) = *x + *v1;
		*(p++) = *y + *v2;
		*(p++) = *z + *v3;
	}

	/*
	 *  set color data
	 */
	if (color_map && value) {
		if ((colors = (float *)malloc(sizeof(float) * total * 3 * (1 + numdiv))) == NULL) {
			FREE(verts);
			return(NULL);
		}
#ifdef DEBUG
fprintf(stdout, " colors memory allocate OK\n");
fflush(stdout);
#endif
		for (i = 0, p = value->data,
			 v1 = (colors + (total * 3)), v2 = (colors + (total * 3) + 1), v3 = (colors + (total * 3) + 2),
			 cr = colors, cg = colors + 1, cb = colors + 2;
			 i < total; i++, p=p+1, cr += 3, cg += 3, cb += 3) {
			cindex = AVScmap_index(color_map, *p);
			ch = (color_map->hue + cindex);
			cs = (color_map->saturation + cindex);
			cv = (color_map->value + cindex);

			hsv_to_rgb(*ch, *cs, *cv, cr, cg, cb);
			for (j = 0; j < numdiv; j++, v1 += 3, v2 += 3, v3 += 3) {
				*v1 = *cr;
				*v2 = *cg;
				*v3 = *cb;
			}
		}
#ifdef DEBUG
fprintf(stdout, " end cone color data set OK\n");
fflush(stdout);
#endif
	}

	/*
	 *  set cone vartex list data
	 */
	if ((plist = (int *)malloc(sizeof(int) * total * numdiv * 4 + 1)) == NULL) {
		FREE(verts);
		FREE(colors);
		return(NULL);
	}
#ifdef DEBUG
fprintf(stdout, "plist memory allocate OK\n");
fflush(stdout);
#endif

	for (i = 0, ip = plist, f = flags; i < total; i++, f++) {
		if (*f > -ESP && *f < ESP) continue;
		for (j = 0; j < numdiv - 1; j++) {
			*(ip++) = NUMPVER;
			for (k = 0; k < NUMPVER - 1; k++) {
				*(ip++) = total + i * numdiv + j + k + 1;
			}
			*(ip++) = i + 1;
		}
		*(ip++) = NUMPVER;
		*(ip++) = total + i * numdiv + (numdiv - 1) + 1;
		*(ip++) = total + i * numdiv + 1;
		*(ip++) = i + 1;
	}
	*ip = 0;
#ifdef DEBUG
{
	register int i, j;
	register float *r, *b, *g;
	for (i = 0; i < total * numdiv; i++) {
		fprintf(stdout, " plist = ");
		for (j = 0; j < 4; j++) {
			fprintf(stdout, " %5d  ", *(plist + (i * 4 + j)));
		}
		fprintf(stdout, "\n");
	}

	if (color_map && value) {
	    for (i = 0, r = colors, g = colors + 1, b = colors + 2;
		     i < total * (numdiv + 1); i++, r += 3, g += 3, b += 3) {
		    fprintf(stdout, "%4d color %f %f %f\n", i, *r, *g, *b);
		}
	}
}
fflush(stdout);
#endif
		
	/*
	 *  create obj & set data for cone
	 */
	obj = GEOMcreate_obj(GEOM_POLYHEDRON, GEOM_NULL);
	GEOMadd_vertices(obj, verts, total, GEOM_COPY_DATA);
	GEOMadd_vertices(obj, cones, total * numdiv, GEOM_COPY_DATA);
	if (color_map && value) {
		GEOMadd_float_colors(obj, colors, total * (numdiv + 1), GEOM_COPY_DATA);
	}
	GEOMadd_polygons(obj, plist, GEOM_CONVEX, GEOM_COPY_DATA);
	GEOMgen_normals(obj, 0);
	GEOMcvt_polyh_to_polytri(obj, GEOM_SURFACE);

	FREE(verts);
	FREE(plist);
	FREE(colors);

	return(obj);
}
