/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 			Copyright (c) 1995 by
 			Kubota Graphics Technology Inc.
 			All Rights Reserved

       module name  : CFD Arrow
       file name    : CrLibObj.c

*/
#include <stdio.h>
#include <memory.h>
#include <string.h>

/*extern char * malloc();*/

#include <avs/avs.h>
#include <avs/avs_data.h>
#include <avs/field.h>
/*#include <avs/flow.h>*/
#include <avs/geom.h>
#include <avs/colormap.h>

#include "l_vector.h"

GEOMobj * 
create_lib_object(coords, vectors, flags, cones, arrow_type, color_map, value, total, numdiv)
	float          *coords, *vectors, *flags, *cones;
	ARROW_TYPE     arrow_type;
	AVScolormap    *color_map;
	AVSfield_float *value;
	int            total, numdiv;
{
	GEOMobj        *obj;
	float          *verts = NULL, *colors = NULL;
	float          r, g, b;
	register float *cr, *cg, *cb, *ch, *cs, *cv, *f, *p, 
				   *xx, *yy, *zz, *x, *y, *z, *v1, *v2, *v3;
	int            numlib, alph = 0;
	register int   i, j, cindex;

	/*
	 *  set vector coordinate data
	 */
	if (arrow_type == middle_lib) {
		alph = 1;
	}

	if ((verts = (float *)malloc(sizeof(float) * total * 3 * 2 * (numdiv + alph))) == NULL) {
		return(NULL);
	}
#ifdef DEBUG
fprintf(stdout, "verts memory allocate OK\n");
fflush(stdout);
#endif

	for (i = numlib = 0, p = verts, f = flags,
		 x = coords, y = coords + 1, z = coords + 2,
		 xx = cones, yy = cones + 1, zz = cones + 2,
		 v1 = vectors, v2 = vectors + 1, v3 = vectors + 2;
		 i < total; i++, f++, x += 3, y += 3, z += 3, v1 += 3, v2 += 3, v3 += 3) {
		if (*f < ESP && *f > -ESP) {
			xx += (numdiv * 3);
			yy += (numdiv * 3);
			zz += (numdiv * 3);
			continue;
		}
		numlib++;

		 for (j = 0; j < numdiv; j++, xx += 3, yy += 3, zz += 3) {
			*(p++) = *x + *v1;
			*(p++) = *y + *v2;
			*(p++) = *z + *v3;
			*(p++) = *xx;
			*(p++) = *yy;
			*(p++) = *zz;
		}

		for (j = 0; j < alph; j++) {
			*(p++) = *(xx - 3);
			*(p++) = *(yy - 3);
			*(p++) = *(zz - 3);
			*(p++) = *(xx - 6);
			*(p++) = *(yy - 6);
			*(p++) = *(zz - 6);
		}
	}

	/*
	 *  set color data
	 */
	if (color_map && value) {
		if ((colors = (float *)malloc(sizeof(float) * total * 3 * 2 * (numdiv + alph))) == NULL) {
			FREE(verts);
			return(NULL);
		}
#ifdef DEBUG
fprintf(stdout, " colors memory allocate OK\n");
fflush(stdout);
#endif
		for (i = 0, p = value->data, f = flags,
			 cr = colors, cg = colors + 1, cb = colors + 2;
			 i < total; i++, p=p+1, f++) {
			if (*f < ESP && *f > -ESP) continue;

			cindex = AVScmap_index(color_map, *p);
			ch = (color_map->hue + cindex);
			cs = (color_map->saturation + cindex);
			cv = (color_map->value + cindex);

			hsv_to_rgb(*ch, *cs, *cv, &r, &g, &b);
			for (j = 0; j < (numdiv + alph) * 2; j++, cr += 3, cg += 3, cb += 3) {
				*cr = r;
				*cg = g;
				*cb = b;
			}
		}
#ifdef DEBUG
fprintf(stdout, " end cone color data set OK\n");
fflush(stdout);
#endif
	}

	/*
	 *  create obj & set data for vector
	 */
	obj = GEOMcreate_obj(GEOM_POLYTRI, GEOM_NULL);
        if (color_map && value) {
           GEOMadd_disjoint_line(obj, verts, colors, numlib * (alph + numdiv) * 2, GEOM_COPY_DATA);
        } else {
           GEOMadd_disjoint_line(obj, verts, GEOM_NULL, numlib * (alph + numdiv) * 2, GEOM_COPY_DATA);
        }

	FREE(verts); 
	FREE(colors);

	return(obj);
}
