/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 
 			Copyright (c) 1994 by
 			Kubota Graphics Technology Inc.
 			All Rights Reserved

       module name  : CFD Arrow
       file name    : HsvToRgb.c

*/
#include <stdio.h>
/* IAC CODE CHANGE : #include   <math.h> */
#include <avs/avs_math.h>

#define ERROR_RETURN  (0)
#define NORMAL_RETURN (!ERROR_RETURN)

int
hsv_to_rgb( h, s, v, r, g, b)
	float	 h, s, v;
	float 	 *r, *g, *b;
{
	int     ii;
	double  ww, hh, ff, mm, nn, kk;

	hh = h * 360.0;

	if( s == 0 ) {
		*r = *g = *b = v;
		return(NORMAL_RETURN);
	} 

	if ( hh == 360.0 ) {
		hh = 0.;
	} else {
		hh = hh / 60.;
	}

	ww = floor(hh);
	ii  = ww;
	ff = hh - ww;
	mm = v * (1.0 - s);
	nn = v * (1.0 - s * ff);
	kk = v * (1.0 - s * (1.0 - ff));

	switch (ii) {
	case 0:
		*r = v; *g = kk; *b = mm;
		break;
		
	case 1:
		*r = nn; *g = v; *b = mm;
		break;

	case 2:
		*r = mm; *g = v; *b = kk;
		break;

	case 3:
		*r = mm; *g = nn; *b = v;
		break;

	case 4:
		*r = kk; *g = mm; *b = v;
		break;

	case 5:
		*r = v; *g = mm; *b = nn;
		break;
			
	default:
		fprintf(stderr, " hsv_to_rgb error 3f10.5\n", h, s, v);
		return(ERROR_RETURN);
	}

	return(NORMAL_RETURN);
}
