/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 
 			Copyright (c) 1995 by
 			Kubota Graphics Technology Inc.
 			All Rights Reserved

       module name  : CFD Arrow
       file name    : SetVectors.c

*/
#include <stdio.h>
#include "l_vector.h"

int
set_vectors(section_type, vectors, data, total, scale)
	SECTION_TYPE section_type;
	float        *vectors, *data;
	int          total;
	float        scale;
{
	register float *p = vectors, *v1 = data, *v2 = data + 1, *v3 = data + 2;
	register int   i;
	int      return_value = NORMAL_RETURN;

	switch (section_type) {
	case threeD:
		for (i = 0; i < total; i++, v1 += 3, v2 += 3, v3 +=3) {
			*(p++) = *v1 * scale;
			*(p++) = *v2 * scale;
			*(p++) = *v3 * scale;
		}
		break;

	case x_y:
		for (i = 0; i < total; i++, v1 += 3, v2 += 3, v3 +=3) {
			*(p++) = *v1 * scale;
			*(p++) = *v2 * scale;
			*(p++) = 0.0;
		}
		break;

	case x_z:
		for (i = 0; i < total; i++, v1 += 3, v2 += 3, v3 +=3) {
			*(p++) = *v1 * scale;
			*(p++) = 0.0;
			*(p++) = *v3 * scale;
		}
		break;

	case y_z:
		for (i = 0; i < total; i++, v1 += 3, v2 += 3, v3 +=3) {
			*(p++) = 0.0;
			*(p++) = *v2 * scale;
			*(p++) = *v3 * scale;
		}
		break;

	default:
		return_value = ERROR_RETURN;
	}

	return(return_value);
}
