/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 
 			Copyright (c) 1995 by
 			Kubota Graphics Technology Inc.
 			All Rights Reserved
 	
       module name  : CFD Arrow
       file name    : cone.c

*/
#include <stdio.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>

#include "l_vector.h"

int 
cone(vectors, points, total, min, max, radiuse, length, numdiv, vertices, flags)
	float *vectors, *points, min, max, radiuse, length;
	int   total, numdiv;
	float *vertices, *flags;
{
	static char  function_name[] = "cone";
	float        vector[3], point[3], delta, angle, prim_cone[3];
	static float matrix[4][4] = {1.0, 0.0, 0.0, 0.0,
								 0.0, 1.0, 0.0, 0.0,
								 0.0, 0.0, 1.0, 0.0,
								 0.0, 0.0, 0.0, 1.0};
	float        workp[3], workx[3], worky[3], workz[3], cone_length, cone_radiuse;
	static float xvector[3] = {1.0, 0.0, 0.0};
	float        *px, *py, *pz, *v1, *v2, *v3, *cx, *cy, *cz, *f;
	float        radian360;
	register int i, j;

#if !defined(VER1) && defined(DEBUG)
	printf("(%s) min %f max %f\n", function_name, min, max);
	fflush(stdout);
#endif

	radian360 = (PI / 180.0) * 360;

	for (i = 0, f = flags,
		 px = points,   py = points + total, pz = points + total * 2,
		 v1 = vectors,  v2 = vectors + 1,      v3 = vectors + 2,
		 cx = vertices, cy = vertices + 1,     cz = vertices + 2;
		 i < total;
		 i++, f++, px++, py++, pz++, v1 += 3, v2 += 3, v3 += 3) {
		point[0] = *px;
		point[1] = *py;
		point[2] = *pz;
		vector[0] = *v1;
		vector[1] = *v2;
		vector[2] = *v3;
		
		if (*f > -ESP && *f < ESP) { /* check cone create flag form parent */
			cx += (numdiv * 3);
			cy += (numdiv * 3);
			cz += (numdiv * 3);
			continue;
		}

		cone_radiuse = radiuse * VABS(vector);
		cone_length  = length * VABS(vector);

		if (cone_radiuse < min) cone_radiuse = min;
		if (cone_radiuse > max) cone_radiuse = max;
		if (cone_length < min) cone_length = min;
		if (cone_length > max) cone_length = max;

		if (cone_length < ESPL || cone_radiuse < ESPL) { 
			*f = 0.0;
			cx += (numdiv * 3);
			cy += (numdiv * 3);
			cz += (numdiv * 3);
			continue;
		}

		/* calcurate point to cone length */
		cone_length  = VABS(vector) - cone_length;

		/*
		 *  JQ49%^%H%j%C%/%9$N@8@.
		 */
		VUNI(vector, workz);

		if (1.0 - fabs((double)VSCL(xvector, workz)) < ESP) {
			workx[0] = 0.0;
			workx[1] = 1.0;
			workx[2] = 0.0;
		} else {
			workx[0] = 1.0;
			workx[1] = 0.0;
			workx[2] = 0.0;
		}

		VPRD(workz, workx, worky);
		VUNI(worky, worky);
		VPRD(worky, workz, workx);
		VUNI(workx, workx);

		for (j = 0; j < 3; j++) {
			matrix[j][0] = workx[j];
			matrix[j][1] = worky[j];
			matrix[j][2] = workz[j];
			matrix[j][3] = point[j];
		}

		for (j = 0, delta = radian360 / numdiv, angle = 0.0;
			 j < numdiv;
			 j++, angle += delta, cx += 3, cy += 3, cz += 3) {
			prim_cone[0] = cone_radiuse * cos((double)angle);
			prim_cone[1] = cone_radiuse * sin((double)angle);
			prim_cone[2] = cone_length;

			MULT_MATRIX(prim_cone, matrix, workp);
			*cx = workp[0];
			*cy = workp[1];
			*cz = workp[2];
		}
	}
}
