/*
 
 			Copyright (c) 1995 by
 			Kubota Graphics Technology Inc.
 			All Rights Reserved
 	
       module name  : CFD Arrow
       file name    : l_vector.h
 
*/
#define NORMAL_RETURN	(1)
#define ERROR_RETURN	(0)
#define CONE_LENGTH     (0.2)
#define CONE_RADIUSE	(CONE_LENGTH / 2.0)
#define NUMPVER			(3)
#define ESP				(0.00000000001)
#define ESPL			(0.000000001)
#define FREE(p)         {\
	if (p) free(p); p = NULL;\
}
#define FREE_PROCESS {\
	FREE(coords); FREE(flags); FREE(works); FREE(cones); FREE(vectors);\
}

#define ERROR_PROCESS(msg) {\
	AVSmessage(__FILE__, AVS_Warning, AVSmodule, function_name, "OK", msg); \
	FREE_PROCESS; \
	return(ERROR_RETURN);\
}

#include <math.h>

#define PI				(3.1415926)
#define VABS(v) 		((float)sqrt((double)((v[0]) * (v[0]) + (v[1]) * (v[1]) + (v[2]) * (v[2]))))
#define VUNI(v1, v2) 	{ \
	float length; \
	length = VABS(v1); \
	v2[0]  = v1[0] / length; \
	v2[1]  = v1[1] / length; \
	v2[2]  = v1[2] / length; \
}
#define VSCL(v1, v2)	(v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2])
#define VPRD(v1, v2, v3) { \
	v3[0] = v1[1] * v2[2] - v1[2] * v2[1]; \
	v3[1] = v1[2] * v2[0] - v1[0] * v2[2]; \
	v3[2] = v1[0] * v2[1] - v1[1] * v2[0]; \
}
#define MULT_MATRIX(p1, matrix, p2) { \
	register int i, j; \
	for (i = 0; i < 3; i++) { \
		for (j = 0, p2[i] = 0.0; j < 3; j++) { \
			p2[i] += p1[j] * matrix[i][j]; \
		} \
		p2[i] += matrix[i][3]; \
	} \
}

typedef enum {
	bar = 1,
	high_cone,
	middle_cone,
	low_cone,
	high_lib,
	middle_lib,
	low_lib,
	mini_lib
} ARROW_TYPE;

typedef enum {
	threeD = 1,
	x_y,
	x_z,
	y_z
} SECTION_TYPE;
